/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.act.atom.GiftAtomService;
import com.tydic.newretail.act.atom.bo.GiftInfoAtomBO;
import com.tydic.newretail.act.atom.bo.GiftInfoAtomPageReqBO;
import com.tydic.newretail.act.atom.bo.GiftInfoAtomReqBO;
import com.tydic.newretail.act.bo.GiftBO;
import com.tydic.newretail.act.bo.GiftReqBO;
import com.tydic.newretail.act.bo.QryGiftPageReqBO;
import com.tydic.newretail.act.busi.GiftBuisService;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspBaseTBO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.toolkit.util.TkCalculatorUtils;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GiftBuisServiceImpl
implements GiftBuisService {
    private static final Logger log = LoggerFactory.getLogger(GiftBuisServiceImpl.class);
    @Autowired
    private GiftAtomService giftAtomService;
    @Autowired
    QryEscapeAtomService qryEscapeAtomService;

    public RspPageBaseBO<GiftBO> listGiftPage(QryGiftPageReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u5206\u9875\u67e5\u8be2\u8d60\u54c1\u5217\u8868\u5165\u53c2:" + reqBO.toString());
        }
        RspPageBaseBO result = new RspPageBaseBO();
        if (reqBO.getCurrent() <= 0 || reqBO.getPageSize() <= 0) {
            log.error("\u5206\u9875\u67e5\u8be2\u8d60\u54c1\u5217\u8868\u63a5\u53e3\u5165\u53c2\u5206\u9875\u53c2\u6570\u4e3a\u7a7a");
            throw new BusinessException("0001", "\u5206\u9875\u53c2\u6570current\u548cpageSize\u5fc5\u586b");
        }
        GiftInfoAtomPageReqBO record = new GiftInfoAtomPageReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)record));
        if (reqBO.getbQryNoPrize() == null) {
            record.setbQryNoPrize(false);
        }
        if (reqBO.getbQryNoPrize() != null && reqBO.getbQryNoPrize().equals("true")) {
            record.setbQryNoPrize(true);
        }
        RspPageBaseBO<GiftInfoAtomBO> rspList = new RspPageBaseBO<GiftInfoAtomBO>();
        try {
            rspList = this.giftAtomService.selectByPage(record);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u8d60\u54c1\u5217\u8868\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        if (CollectionUtils.isEmpty((Collection)rspList.getRows())) {
            result.setRows(new ArrayList());
            result.setRespCode("0002");
            result.setRespDesc("\u672a\u67e5\u8be2\u5230\u7ed3\u679c\u96c6");
        }
        BeanUtils.copyProperties(rspList, (Object)result);
        return result;
    }

    public RspBaseBO addGiftInfo(GiftReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u65b0\u589e\u8d60\u54c1\u5165\u53c2:" + reqBO.toString());
        }
        GiftInfoAtomReqBO reqBOs = new GiftInfoAtomReqBO();
        this.checkParams(reqBO, reqBOs);
        try {
            this.giftAtomService.saveByBatch(reqBOs);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u8d60\u54c1\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseTBO<GiftBO> getGiftDetail(GiftBO reqBO) {
        GiftInfoAtomBO rspPO;
        GiftBO result = new GiftBO();
        if (log.isDebugEnabled()) {
            log.debug("\u8d60\u54c1\u5956\u54c1\u8be6\u60c5\u67e5\u8be2\u5165\u53c2:" + reqBO.toString());
        }
        if (null == reqBO || null == reqBO.getGiftId()) {
            return new RspBaseTBO("0002", "\u8d60\u54c1\u5956\u54c1\u8be6\u60c5\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        try {
            rspPO = this.giftAtomService.getGiftInfoDetail(reqBO.getGiftId());
        }
        catch (Exception e) {
            log.error("\u8d60\u54c1\u5956\u54c1\u8be6\u60c5\u67e5\u8be2\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        if (null == rspPO) {
            return new RspBaseTBO("0002", "\u8d60\u54c1\u5956\u54c1\u8be6\u60c5\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        BeanUtils.copyProperties((Object)rspPO, (Object)result);
        ConvertParamUtils.escaptGiftInfo(result, this.qryEscapeAtomService);
        return new RspBaseTBO("0000", "\u64cd\u4f5c\u6210\u529f", (Object)result);
    }

    public RspBaseBO modifyGift(GiftReqBO reqBO) {
        if (null == reqBO.getGiftId()) {
            log.error("\u8d60\u54c1ID\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u8d60\u54c1ID\u4e3a\u7a7a");
        }
        this.selectGift(reqBO);
        GiftInfoAtomReqBO reqPO = new GiftInfoAtomReqBO();
        this.recombinationParam(reqBO, reqPO);
        try {
            this.giftAtomService.updateBatch(reqPO);
        }
        catch (Exception e) {
            log.error("\u8d60\u54c1\u5956\u54c1\u6839\u636e\u8d60\u54c1id\u66f4\u65b0\u8d60\u54c1\u4fe1\u606f\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private void checkParams(GiftReqBO reqBO, GiftInfoAtomReqBO reqBOs) {
        if (null == reqBO.getmUserId()) {
            log.error("\u672a\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
            TkThrExceptionUtils.thrEmptyExce((String)"\u672a\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
        }
        if (null == reqBO.getmTenantId()) {
            reqBO.setmTenantId(Long.valueOf(0L));
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getGiftOrigin())) {
            log.error("\u8d60\u54c1\u6765\u6e90\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u6765\u6e90\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getGiftType())) {
            log.error("\u8d60\u54c1\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getGiftName())) {
            log.error("\u8d60\u54c1\u540d\u79f0\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getGiftAlias())) {
            log.error("\u8d60\u54c1\u522b\u540d\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u522b\u540d\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getGiftPrice())) {
            reqBO.setGiftPrice(TkCalculatorUtils.transfetL((String)reqBO.getGiftPrice()));
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getObjBelongRegion())) {
            log.error("\u8d60\u54c1\u8303\u56f4\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u8303\u56f4\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getIsValid())) {
            reqBO.setIsValid("1");
        }
        if (reqBO.getTotalCountLimit() != null) {
            reqBO.setAvailableCount(reqBO.getTotalCountLimit());
        }
        reqBO.setLastUpdUid(reqBO.getmUserId());
        reqBO.setLastUpdUsername(reqBO.getmName());
        ArrayList<GiftInfoAtomBO> giftInfoAtomBOList = new ArrayList<GiftInfoAtomBO>();
        GiftInfoAtomBO po = new GiftInfoAtomBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setTenantId(reqBO.getmTenantId());
        giftInfoAtomBOList.add(po);
        reqBOs.setInsertList(giftInfoAtomBOList);
    }

    private void selectGift(GiftReqBO reqBO) {
        HashSet<Long> giftIds = new HashSet<Long>();
        giftIds.add(reqBO.getGiftId());
        List<GiftInfoAtomBO> rspPO = null;
        try {
            rspPO = this.giftAtomService.listGiftById(giftIds);
        }
        catch (Exception e) {
            log.error("\u8d60\u54c1\u5956\u54c1\u6839\u636e\u8d60\u54c1id\u67e5\u8be2\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        if (CollectionUtils.isEmpty(rspPO)) {
            TkThrExceptionUtils.thrQryRspEmptyExce((String)"\u8d60\u54c1\u4e0d\u5b58\u5728");
        }
        int usedCount = rspPO.get(0).getTotalCountLimit() - rspPO.get(0).getAvailableCount();
        if (null != reqBO.getTotalCountLimit()) {
            if (reqBO.getTotalCountLimit() - usedCount >= 0) {
                reqBO.setAvailableCount(Integer.valueOf(reqBO.getTotalCountLimit() - usedCount));
            }
            if (reqBO.getTotalCountLimit() - usedCount < 0) {
                TkThrExceptionUtils.thrUpdExce((String)"\u5df2\u4f7f\u7528\u6570\u91cf\u5df2\u51fa\u603b\u91cf\u9650\u5236\uff0c\u4e0d\u53ef\u4fee\u6539");
            }
        }
    }

    private void recombinationParam(GiftReqBO reqBO, GiftInfoAtomReqBO reqPO) {
        if (null != reqBO) {
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getGiftPrice())) {
                reqBO.setGiftPrice(TkCalculatorUtils.transfetL((String)reqBO.getGiftPrice()));
            }
            ArrayList<GiftInfoAtomBO> giftInfoAtomBOList = new ArrayList<GiftInfoAtomBO>();
            GiftInfoAtomBO giftInfoAtomBO = new GiftInfoAtomBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)giftInfoAtomBO);
            giftInfoAtomBO.setLastUpdUid(reqBO.getmUserId());
            giftInfoAtomBO.setLastUpdUsername(reqBO.getmName());
            giftInfoAtomBOList.add(giftInfoAtomBO);
            reqPO.setInsertList(giftInfoAtomBOList);
        }
    }
}

