/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.GiftAtomService;
import com.tydic.newretail.act.atom.GiftInstanceAtomService;
import com.tydic.newretail.act.atom.bo.GiftInfoAtomBO;
import com.tydic.newretail.act.atom.bo.GiftInstanceAtomBO;
import com.tydic.newretail.act.bo.GiftInstanceBO;
import com.tydic.newretail.act.bo.GiftInstanceReqBO;
import com.tydic.newretail.act.bo.GiftInstanceRspBO;
import com.tydic.newretail.act.busi.GiftInstanceBusiService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GiftInstanceBusiServiceImpl
implements GiftInstanceBusiService {
    private static final Logger log = LoggerFactory.getLogger(GiftInstanceBusiServiceImpl.class);
    @Autowired
    private GiftInstanceAtomService giftInstanceAtomService;
    @Autowired
    private GiftAtomService giftAtomService;

    public RspBaseBO modifyEntityPrizeInfo(GiftInstanceReqBO reqBO) {
        RspBaseBO result = new RspBaseBO();
        this.checkParams(reqBO);
        GiftInstanceAtomBO atomBO = new GiftInstanceAtomBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)atomBO);
        RspBatchBaseBO<GiftInstanceAtomBO> rspList = this.giftInstanceAtomService.selectGiftInstanceByCondition(atomBO);
        if (CollectionUtils.isEmpty((Collection)rspList.getRows())) {
            result.setRespCode("0002");
            result.setRespDesc("\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u672a\u67e5\u8be2\u5230\u7ed3\u679c\u96c6");
        }
        if (rspList.getRows().size() > 1) {
            result.setRespCode("0003");
            result.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u96c6\u6709\u8bef");
        }
        GiftInstanceAtomBO atomRsp = (GiftInstanceAtomBO)rspList.getRows().get(0);
        BeanUtils.copyProperties((Object)reqBO, (Object)atomRsp);
        atomRsp.setParam1(reqBO.getName());
        atomRsp.setParam2(reqBO.getPhone());
        atomRsp.setParam3(reqBO.getAddress());
        this.giftInstanceAtomService.updateBygiftInstanceIdAndtenantId(atomRsp);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public GiftInstanceRspBO saveGiftDistribute(GiftInstanceBO giftInstanceReqBO) {
        GiftInstanceAtomBO giftInstanceAtomReqBO;
        GiftInstanceAtomBO giftInstanceRspBO;
        GiftInstanceRspBO rspBO = new GiftInstanceRspBO();
        this.ckeckReqParam(giftInstanceReqBO);
        GiftInfoAtomBO giftInfoRspPO = this.giftAtomService.getGiftInfoDetail(giftInstanceReqBO.getGiftId());
        if (null == giftInfoRspPO) {
            rspBO.setRespCode("0002");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f");
            return rspBO;
        }
        if (null != giftInfoRspPO.getAvailableCount() && giftInstanceReqBO.getTotalCount() > giftInfoRspPO.getAvailableCount()) {
            rspBO.setRespCode("0012");
            rspBO.setRespDesc("\u8d60\u54c1\u5269\u4f59\u6570\u91cf\u4e0d\u8db3");
            return rspBO;
        }
        if (null != giftInfoRspPO.getUserCountLimit()) {
            int countLimit = this.selectByGiftIdAndUid(giftInfoRspPO, giftInstanceReqBO);
            if (giftInstanceReqBO.getTotalCount() + countLimit > giftInfoRspPO.getUserCountLimit()) {
                rspBO.setRespCode("0013");
                rspBO.setRespDesc("\u8be5\u7528\u6237\u5171\u83b7\u7684\u8d60\u54c1\u6570\u91cf\u5df2\u8d85\u8fc7\u8d60\u54c1\u7528\u6237\u6570\u91cf\u9650\u5236");
                return rspBO;
            }
        }
        if ((giftInstanceRspBO = this.giftInstanceAtomService.insertSelective(giftInstanceAtomReqBO = this.toGiftInstanceAtomBO(giftInfoRspPO, giftInstanceReqBO))).getGiftInstanceId() != null) {
            BeanUtils.copyProperties((Object)giftInstanceRspBO, (Object)rspBO);
        }
        if (null != giftInfoRspPO.getAvailableCount()) {
            this.giftAtomService.updateAvailableCount(giftInstanceReqBO.getGiftId(), giftInstanceAtomReqBO.getTotalCount());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespCode("\u64cd\u4f5c\u6210\u529f");
        return rspBO;
    }

    private void checkParams(GiftInstanceReqBO reqBO) {
        if (null == reqBO) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getGiftInstanceId()) {
            throw new ResourceException("0001", "\u8d60\u54c1\u5b9e\u4f8bid\u4e3a\u7a7a");
        }
        if (null == reqBO.getUid()) {
            throw new ResourceException("0001", "\u7528\u6237id\u4e3a\u7a7a");
        }
        if (null == reqBO.getName()) {
            throw new ResourceException("0001", "\u59d3\u540d\u4e3a\u7a7a");
        }
        if (null == reqBO.getPhone()) {
            throw new ResourceException("0001", "\u8054\u7cfb\u7535\u8bdd\u4e3a\u7a7a");
        }
        if (null == reqBO.getAddress()) {
            throw new ResourceException("0001", "\u5730\u5740\u4e3a\u7a7a");
        }
    }

    private void ckeckReqParam(GiftInstanceBO giftInstanceBO) {
        if (null == giftInstanceBO) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == giftInstanceBO.getGiftId()) {
            throw new ResourceException("0001", "\u8d60\u54c1ID\u4e3a\u7a7a");
        }
        if (null == giftInstanceBO.getTotalCount()) {
            throw new ResourceException("0001", "\u6d3e\u53d1\u6570\u91cf\u4e3a\u7a7a");
        }
        if (null == giftInstanceBO.getUid()) {
            throw new ResourceException("0001", "\u7528\u6237id\u4e3a\u7a7a");
        }
        if (null == giftInstanceBO.getSendChannel()) {
            throw new ResourceException("0001", "\u53d1\u8d27\u6e20\u9053\u4e3a\u7a7a");
        }
    }

    private Integer selectByGiftIdAndUid(GiftInfoAtomBO rspPO, GiftInstanceBO reqBO) {
        int countLimit = 0;
        GiftInstanceAtomBO giftInstanceAtomBO = new GiftInstanceAtomBO();
        giftInstanceAtomBO.setGiftId(rspPO.getGiftId());
        giftInstanceAtomBO.setUid(reqBO.getUid());
        RspBatchBaseBO<GiftInstanceAtomBO> giftInstanceList = this.giftInstanceAtomService.selectGiftInstanceByCondition(giftInstanceAtomBO);
        if (CollectionUtils.isNotEmpty((Collection)giftInstanceList.getRows())) {
            for (GiftInstanceAtomBO bo : giftInstanceList.getRows()) {
                countLimit += bo.getTotalCount().intValue();
            }
        }
        return countLimit;
    }

    private GiftInstanceAtomBO toGiftInstanceAtomBO(GiftInfoAtomBO giftReqPO, GiftInstanceBO giftInstanceReqPO) {
        GiftInstanceAtomBO giftInstanceAtomBO = new GiftInstanceAtomBO();
        giftInstanceAtomBO.setUid(giftInstanceReqPO.getUid());
        giftInstanceAtomBO.setTenantId(giftReqPO.getTenantId());
        giftInstanceAtomBO.setGiftPayPrice(giftInstanceReqPO.getGiftPayPrice());
        giftInstanceAtomBO.setTotalCount(giftInstanceReqPO.getTotalCount());
        giftInstanceAtomBO.setSendCount(giftInstanceReqPO.getSendCount());
        giftInstanceAtomBO.setStatus(giftInstanceReqPO.getStatus());
        giftInstanceAtomBO.setSendChannel(giftInstanceReqPO.getSendChannel());
        giftInstanceAtomBO.setDistributeTime(giftInstanceReqPO.getDistributeTime());
        giftInstanceAtomBO.setActivityId(giftInstanceReqPO.getActivityId());
        giftInstanceAtomBO.setGiftAlias(giftReqPO.getGiftAlias());
        giftInstanceAtomBO.setActivityType(giftInstanceReqPO.getActivityType());
        giftInstanceAtomBO.setGiftId(giftReqPO.getGiftId());
        giftInstanceAtomBO.setGiftPrice(giftReqPO.getGiftPrice());
        giftInstanceAtomBO.setGiftName(giftReqPO.getGiftName());
        giftInstanceAtomBO.setGiftOrigin(giftReqPO.getGiftOrigin());
        giftInstanceAtomBO.setGiftPicUrl(giftReqPO.getGiftPicUrl());
        giftInstanceAtomBO.setGiftType(giftReqPO.getGiftType());
        giftInstanceAtomBO.setObjBelongCode(giftReqPO.getObjBelongCode());
        giftInstanceAtomBO.setObjBelongRegion(giftReqPO.getObjBelongRegion());
        giftInstanceAtomBO.setObjCode(giftReqPO.getObjCode());
        giftInstanceAtomBO.setObjCodeType(giftReqPO.getObjCodeType());
        giftInstanceAtomBO.setIsValid("1");
        return giftInstanceAtomBO;
    }
}

