/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.act.atom.GiftPkgAtomService;
import com.tydic.newretail.act.atom.GiftPkgObjectAtomService;
import com.tydic.newretail.act.atom.PkgComposeAtomService;
import com.tydic.newretail.act.bo.GiftPkgConfigBO;
import com.tydic.newretail.act.bo.GiftPkgInfoBO;
import com.tydic.newretail.act.bo.GiftPkgObjectInfoBO;
import com.tydic.newretail.act.bo.PkgComposeInfoBO;
import com.tydic.newretail.act.busi.GiftPkgConfigBusiService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.util.TkCalculatorUtils;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GiftPkgConfigBusiServiceImpl
implements GiftPkgConfigBusiService {
    private static final Logger log = LoggerFactory.getLogger(GiftPkgConfigBusiServiceImpl.class);
    @Autowired
    private GiftPkgAtomService giftPkgAtomService;
    @Autowired
    private GiftPkgObjectAtomService giftPkgObjectAtomService;
    @Autowired
    private PkgComposeAtomService pkgComposeAtomService;
    private static final String PRICE_PATTERN = "^[0-9]+([.][0-9]+)?$";

    public RspBaseBO saveGiftPkg(GiftPkgConfigBO reqBO) {
        log.debug("\u8d60\u54c1\u5305\u914d\u7f6e\u5165\u53c2" + reqBO.toString());
        this.checkParams(reqBO);
        this.saveGiftPkgMethod(reqBO);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO modifyGiftPkg(GiftPkgConfigBO reqBO) {
        log.debug("\u8d60\u54c1\u5305\u7f16\u8f91\u5165\u53c2" + reqBO.toString());
        if (null == reqBO.getPkgId()) {
            log.error("\u8d60\u54c1\u5305ID\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u8d60\u54c1\u5305ID\u4e3a\u7a7a");
        }
        GiftPkgInfoBO qryGiftReqBO = new GiftPkgInfoBO();
        qryGiftReqBO.setPkgId(reqBO.getPkgId());
        GiftPkgInfoBO giftPkgInfoBO = this.giftPkgAtomService.getGiftPkgInfo(qryGiftReqBO);
        if (null == giftPkgInfoBO) {
            log.error("\u8d60\u54c1\u5305\u4e0d\u5b58\u5728");
            return new RspBaseBO("0002", "\u8d60\u54c1\u5305\u4e0d\u5b58\u5728");
        }
        if (!giftPkgInfoBO.getCreateUser().equals(String.valueOf(reqBO.getmUserId()))) {
            log.error("\u5f53\u524d\u4fee\u6539\u4eba\u3010" + reqBO.getmLoginName() + "\u3011\u4e0d\u80fd\u4fee\u6539\u8be5\u8d60\u54c1\u5305");
            return new RspBaseBO("0010", "\u5f53\u524d\u4fee\u6539\u4eba\u3010" + reqBO.getmLoginName() + "\u3011\u4e0d\u80fd\u4fee\u6539\u8be5\u8d60\u54c1\u5305");
        }
        this.modifyGiftPkgInfo(giftPkgInfoBO, reqBO);
        this.giftPkgObjectAtomService.removeByPkgId(reqBO.getPkgId());
        this.pkgComposeAtomService.removeByPkgId(reqBO.getPkgId());
        if (CollectionUtils.isEmpty((Collection)reqBO.getPkgComposeInfoBOS()) || CollectionUtils.isEmpty((Collection)reqBO.getObjectInfoBOS())) {
            log.error("\u65b0\u589e\u8d60\u54c1\u5305\u9002\u7528\u8303\u56f4\u6216\u8005\u8d60\u54c1\u5305\u6784\u6210\u4e3a\u7a7a");
            TkThrExceptionUtils.thrInsExce((String)"\u65b0\u589e\u8d60\u54c1\u5305\u9002\u7528\u8303\u56f4\u6216\u8005\u8d60\u54c1\u5305\u6784\u6210\u4e3a\u7a7a");
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPkgComposeInfoBOS())) {
            this.savePkgComposeInfo(reqBO, giftPkgInfoBO);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getObjectInfoBOS())) {
            List<GiftPkgObjectInfoBO> objs = this.getObjectInfo(reqBO, giftPkgInfoBO);
            this.giftPkgObjectAtomService.saveByBatch(objs);
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO removeGiftPkg(GiftPkgConfigBO reqBO) {
        log.debug("\u8d60\u54c1\u5305\u5220\u9664\u5165\u53c2" + reqBO.toString());
        if (null == reqBO.getPkgId()) {
            log.error("\u8d60\u54c1\u5305ID\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u8d60\u54c1\u5305\u5220\u9664\u5165\u53c2");
        }
        GiftPkgInfoBO qryGiftReqBO = new GiftPkgInfoBO();
        qryGiftReqBO.setPkgId(reqBO.getPkgId());
        GiftPkgInfoBO giftPkgInfoBO = this.giftPkgAtomService.getGiftPkgInfo(qryGiftReqBO);
        if (null == giftPkgInfoBO) {
            log.error("\u8d60\u54c1\u5305\u4e0d\u5b58\u5728");
            return new RspBaseBO("0002", "\u8d60\u54c1\u5305\u4e0d\u5b58\u5728");
        }
        if (!giftPkgInfoBO.getCreateUser().equals(String.valueOf(reqBO.getmUserId()))) {
            log.error("\u5f53\u524d\u4fee\u6539\u4eba\u3010" + reqBO.getmLoginName() + "\u3011\u4e0d\u80fd\u4fee\u6539\u8be5\u8d60\u54c1\u5305");
            return new RspBaseBO("0010", "\u5f53\u524d\u4fee\u6539\u4eba\u3010" + reqBO.getmLoginName() + "\u3011\u4e0d\u80fd\u4fee\u6539\u8be5\u8d60\u54c1\u5305");
        }
        this.modifyMethod(reqBO);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private void checkParams(GiftPkgConfigBO reqBO) {
        if (null == reqBO.getmUserId()) {
            log.error("\u672a\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
            TkThrExceptionUtils.thrEmptyExce((String)"\u672a\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
        }
        if (null == reqBO.getmTenantId()) {
            reqBO.setmTenantId(Long.valueOf(0L));
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getmOrgId())) {
            log.error("\u672a\u83b7\u7ec4\u7ec7\u673a\u6784\u7f16\u7801");
            TkThrExceptionUtils.thrEmptyExce((String)"\u672a\u83b7\u7ec4\u7ec7\u673a\u6784\u7f16\u7801");
        }
        reqBO.setPkgBelongCode(reqBO.getmOrgId());
        if ("1".equals(reqBO.getmUserLevel())) {
            log.debug("\u603b\u90e8");
            reqBO.setPkgBelongRegion("00");
        } else if ("2".equals(reqBO.getmUserLevel())) {
            log.debug("\u7701\u4efd");
            reqBO.setPkgBelongRegion("01");
        } else if ("3".equals(reqBO.getmUserLevel())) {
            log.debug("\u5730\u5e02");
            reqBO.setPkgBelongRegion("02");
        } else if ("4".equals(reqBO.getmUserLevel())) {
            log.debug("\u533a\u53bf");
            reqBO.setPkgBelongRegion("03");
        } else if ("5".equals(reqBO.getmUserLevel())) {
            log.debug("\u95e8\u5e97");
            reqBO.setPkgBelongRegion("05");
        } else {
            log.error("\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7528\u6237\u6743\u9650\u4e0d\u8db3");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmProvince())) {
            reqBO.setParam1(reqBO.getmProvince());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmCity())) {
            reqBO.setParam2(reqBO.getmCity());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmDistrict())) {
            reqBO.setParam3(reqBO.getmDistrict());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getmShopId())) {
            reqBO.setParam4(reqBO.getmShopId());
        }
    }

    private void saveGiftPkgMethod(GiftPkgConfigBO reqBO) {
        this.setConfigParams(reqBO);
        GiftPkgInfoBO giftPkgInfoBO = new GiftPkgInfoBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)giftPkgInfoBO);
        GiftPkgInfoBO giftPkgInfo = this.giftPkgAtomService.saveGiftPkgInfo(giftPkgInfoBO);
        if (null == giftPkgInfo.getPkgId()) {
            TkThrExceptionUtils.thrInsExce((String)"\u65b0\u589e\u8d60\u54c1\u5305\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u8d60\u54c1\u5305ID");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPkgComposeInfoBOS()) || CollectionUtils.isEmpty((Collection)reqBO.getObjectInfoBOS())) {
            log.error("\u65b0\u589e\u8d60\u54c1\u5305\u9002\u7528\u8303\u56f4\u6216\u8005\u8d60\u54c1\u5305\u6784\u6210\u4e3a\u7a7a");
            TkThrExceptionUtils.thrInsExce((String)"\u65b0\u589e\u8d60\u54c1\u5305\u9002\u7528\u8303\u56f4\u6216\u8005\u8d60\u54c1\u5305\u6784\u6210\u4e3a\u7a7a");
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPkgComposeInfoBOS())) {
            this.savePkgComposeInfo(reqBO, giftPkgInfo);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getObjectInfoBOS())) {
            List<GiftPkgObjectInfoBO> objs = this.getObjectInfo(reqBO, giftPkgInfo);
            this.giftPkgObjectAtomService.saveByBatch(objs);
        }
    }

    private void setConfigParams(GiftPkgConfigBO reqBO) {
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getPkgPrice()) && !Pattern.matches(PRICE_PATTERN, reqBO.getPkgPrice())) {
            log.error("\u4ef7\u683c\u683c\u5f0f\u9519\u8bef");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4ef7\u683c\u683c\u5f0f\u9519\u8bef");
        }
        reqBO.setTenantId(reqBO.getmTenantId());
        reqBO.setPkgCode("ZP" + Sequence.getInstance().nextId());
        reqBO.setCreateUser(String.valueOf(reqBO.getmUserId()));
        if (StringUtils.isNotBlank((CharSequence)reqBO.getmLoginName())) {
            reqBO.setCreateUsername(reqBO.getmLoginName());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPkgName())) {
            reqBO.setPkgAlias(reqBO.getPkgName());
        }
        reqBO.setSendCount(Integer.valueOf(0));
        if (null == reqBO.getTenantId()) {
            log.error("\u79df\u6237ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u79df\u6237ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPkgCode())) {
            log.error("\u8d60\u54c1\u5305\u7f16\u7801\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u5305\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPkgOrigin())) {
            log.error("\u8d60\u54c1\u5305\u6765\u6e90\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u5305\u6765\u6e90\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPkgType())) {
            log.error("\u8d60\u54c1\u5305\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u5305\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPkgName())) {
            log.error("\u8d60\u54c1\u5305\u540d\u79f0\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u5305\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPkgAlias())) {
            log.error("\u8d60\u54c1\u5305\u5c55\u793a\u540d\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8d60\u54c1\u5305\u5c55\u793a\u540d\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPkgBelongCode())) {
            log.error("\u5f52\u5c5e\u673a\u6784\u7f16\u7801\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5f52\u5c5e\u673a\u6784\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPkgBelongRegion())) {
            log.error("\u5f52\u5c5e\u673a\u6784\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5f52\u5c5e\u673a\u6784\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)String.valueOf(reqBO.getmUserId()))) {
            log.error("\u521b\u5efa\u4eba\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u521b\u5efa\u4eba\u4e3a\u7a7a");
        }
    }

    private void savePkgComposeInfo(GiftPkgConfigBO reqBO, GiftPkgInfoBO pkgInfoBO) {
        ArrayList<PkgComposeInfoBO> pkgComposeInfoBOS = new ArrayList<PkgComposeInfoBO>();
        for (PkgComposeInfoBO pkgComposeInfoBO : reqBO.getPkgComposeInfoBOS()) {
            PkgComposeInfoBO bo = new PkgComposeInfoBO();
            if (StringUtils.isBlank((CharSequence)pkgComposeInfoBO.getOptionMark())) {
                log.error("\u9009\u62e9\u65b9\u5f0f\u4e3a\u7a7a");
                TkThrExceptionUtils.thrFormatExce((String)"\u9009\u62e9\u65b9\u5f0f\u4e3a\u7a7a");
            }
            bo.setTenantId(pkgInfoBO.getTenantId());
            bo.setPkgId(pkgInfoBO.getPkgId());
            bo.setPkgCode(pkgInfoBO.getPkgCode());
            bo.setGiftName(pkgComposeInfoBO.getGiftName());
            if (StringUtils.isNotEmpty((CharSequence)pkgComposeInfoBO.getGiftBrand())) {
                bo.setGiftBrand(pkgComposeInfoBO.getGiftBrand());
            }
            if (StringUtils.isNotEmpty((CharSequence)pkgComposeInfoBO.getGiftColor())) {
                bo.setGiftColor(pkgComposeInfoBO.getGiftColor());
            }
            bo.setSingleCount(Integer.valueOf(1));
            if (StringUtils.isNotEmpty((CharSequence)pkgComposeInfoBO.getGiftRealPrice())) {
                bo.setGiftRealPrice(TkCalculatorUtils.transfetL((String)pkgComposeInfoBO.getGiftRealPrice()));
            }
            if (StringUtils.isNotEmpty((CharSequence)pkgComposeInfoBO.getGiftPrice())) {
                if (!Pattern.matches(PRICE_PATTERN, pkgComposeInfoBO.getGiftPrice())) {
                    log.error("\u4ef7\u683c\u683c\u5f0f\u9519\u8bef");
                    TkThrExceptionUtils.thrEmptyExce((String)"\u4ef7\u683c\u683c\u5f0f\u9519\u8bef");
                }
                bo.setGiftPrice(TkCalculatorUtils.transfetL((String)pkgComposeInfoBO.getGiftPrice()));
                bo.setGiftRealPrice(TkCalculatorUtils.transfetL((String)pkgComposeInfoBO.getGiftPrice()));
            }
            if (null != bo.getSingleCount() && !Pattern.matches("^[1-9]\\d*$", String.valueOf(bo.getSingleCount()))) {
                log.error("\u5355\u6b21\u53d1\u653e\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
                TkThrExceptionUtils.thrFormatExce((String)"\u5355\u6b21\u53d1\u653e\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
            }
            bo.setObjectType(pkgComposeInfoBO.getObjectType());
            bo.setObjectCode(pkgComposeInfoBO.getObjectCode());
            bo.setOptionMark(pkgComposeInfoBO.getOptionMark());
            if (null != pkgInfoBO.getTotalCountLimit()) {
                bo.setTotalCountLimit(pkgInfoBO.getTotalCountLimit());
            }
            bo.setSendCount(Integer.valueOf(0));
            if ("02".equals(pkgComposeInfoBO.getObjectType())) {
                if (StringUtils.isBlank((CharSequence)pkgComposeInfoBO.getParam5())) {
                    log.error("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                    TkThrExceptionUtils.thrEmptyExce((String)"\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                }
                bo.setParam5(pkgComposeInfoBO.getParam5());
            }
            if ("01".equals(pkgComposeInfoBO.getObjectType())) {
                if (StringUtils.isBlank((CharSequence)pkgComposeInfoBO.getParam1()) && StringUtils.isBlank((CharSequence)pkgComposeInfoBO.getParam5())) {
                    log.error("\u7701\u4efd\u7f16\u7801\u6216\u8005\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                    TkThrExceptionUtils.thrEmptyExce((String)"\u7701\u4efd\u7f16\u7801\u6216\u8005\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                }
                bo.setParam1(pkgComposeInfoBO.getParam1());
                bo.setParam5(pkgComposeInfoBO.getParam5());
            }
            if ("00".equals(pkgComposeInfoBO.getObjectType())) {
                if (StringUtils.isBlank((CharSequence)pkgComposeInfoBO.getParam1()) && StringUtils.isBlank((CharSequence)pkgComposeInfoBO.getParam5()) && StringUtils.isBlank((CharSequence)pkgComposeInfoBO.getParam4())) {
                    log.error("\u7701\u4efd\u7f16\u7801\u6216\u8005\u95e8\u5e97\u7f16\u7801\u6216\u8005\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                    TkThrExceptionUtils.thrEmptyExce((String)"\u7701\u4efd\u7f16\u7801\u6216\u8005\u95e8\u5e97\u7f16\u7801\u6216\u8005\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                }
                bo.setParam1(pkgComposeInfoBO.getParam1());
                bo.setParam2(pkgComposeInfoBO.getParam2());
                bo.setParam3(pkgComposeInfoBO.getParam3());
                bo.setParam4(pkgComposeInfoBO.getParam4());
                bo.setParam5(pkgComposeInfoBO.getParam5());
            }
            pkgComposeInfoBOS.add(bo);
        }
        this.pkgComposeAtomService.savePkgCompose(pkgComposeInfoBOS);
    }

    private List<GiftPkgObjectInfoBO> getObjectInfo(GiftPkgConfigBO reqBO, GiftPkgInfoBO pkgInfoBO) {
        ArrayList<GiftPkgObjectInfoBO> list = new ArrayList<GiftPkgObjectInfoBO>();
        for (GiftPkgObjectInfoBO giftPkgObjectInfoBO : reqBO.getObjectInfoBOS()) {
            GiftPkgObjectInfoBO bo = new GiftPkgObjectInfoBO();
            bo.setTenantId(pkgInfoBO.getTenantId());
            bo.setPkgId(pkgInfoBO.getPkgId());
            bo.setPkgCode(pkgInfoBO.getPkgCode());
            bo.setMnomonicName(giftPkgObjectInfoBO.getMnomonicName());
            bo.setObjCode(giftPkgObjectInfoBO.getObjCode());
            bo.setObjType(giftPkgObjectInfoBO.getObjType());
            if ("05".equals(giftPkgObjectInfoBO.getObjType())) {
                bo.setParam1(giftPkgObjectInfoBO.getParam1());
                bo.setParam2(giftPkgObjectInfoBO.getParam2());
                bo.setParam3(giftPkgObjectInfoBO.getParam3());
                bo.setParam4(giftPkgObjectInfoBO.getParam4());
            }
            if ("03".equals(giftPkgObjectInfoBO.getObjType())) {
                bo.setParam1(giftPkgObjectInfoBO.getParam1());
                bo.setParam2(giftPkgObjectInfoBO.getParam2());
                bo.setParam3(giftPkgObjectInfoBO.getParam3());
            }
            if ("01".equals(giftPkgObjectInfoBO.getObjType())) {
                bo.setParam1(giftPkgObjectInfoBO.getParam1());
            }
            if ("02".equals(giftPkgObjectInfoBO.getObjType())) {
                bo.setParam1(giftPkgObjectInfoBO.getParam1());
                bo.setParam2(giftPkgObjectInfoBO.getParam2());
            }
            if ("00".equals(giftPkgObjectInfoBO.getObjType())) {
                bo.setObjCode("00");
            }
            list.add(bo);
        }
        return list;
    }

    private void modifyGiftPkgInfo(GiftPkgInfoBO giftPkgInfoBO, GiftPkgConfigBO reqBO) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPkgName())) {
            giftPkgInfoBO.setPkgAlias(reqBO.getPkgName());
            giftPkgInfoBO.setPkgName(reqBO.getPkgName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getPkgPrice())) {
            giftPkgInfoBO.setPkgPrice(TkCalculatorUtils.transfetL((String)reqBO.getPkgPrice()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPkgType())) {
            giftPkgInfoBO.setPkgType(reqBO.getPkgType());
        }
        giftPkgInfoBO.setPkgRemarks(reqBO.getPkgRemarks());
        giftPkgInfoBO.setLastUpdTime(new Date());
        giftPkgInfoBO.setLastUpdUid(reqBO.getmUserId());
        this.giftPkgAtomService.modifyGiftPkg(giftPkgInfoBO, true);
    }

    private void modifyMethod(GiftPkgConfigBO reqBO) {
        GiftPkgInfoBO giftPkgInfoBO = new GiftPkgInfoBO();
        giftPkgInfoBO.setPkgId(reqBO.getPkgId());
        giftPkgInfoBO.setLastUpdTime(new Date());
        giftPkgInfoBO.setLastUpdUid(reqBO.getLastUpdUid());
        giftPkgInfoBO.setLastUpdUsername(reqBO.getmLoginName());
        giftPkgInfoBO.setIsValid("0");
        this.giftPkgAtomService.modifyGiftPkg(giftPkgInfoBO, true);
        HashSet<Long> pkgIds = new HashSet<Long>(1);
        pkgIds.add(reqBO.getPkgId());
        this.giftPkgObjectAtomService.invalidBatchByRuleId(pkgIds);
        this.pkgComposeAtomService.invalidBatchByRuleId(pkgIds);
    }
}

