/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.ActCommAtomService;
import com.tydic.newretail.act.atom.bo.QryActCommReqAtomBO;
import com.tydic.newretail.act.bo.ActivityCommodityBO;
import com.tydic.newretail.act.busi.ModifyActStockBusiService;
import com.tydic.newretail.act.dao.ActivityCommodityDao;
import com.tydic.newretail.toolkit.bo.ReqBatchBaseBO;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModifyActStockBusiServiceImpl
implements ModifyActStockBusiService {
    private static final Logger log = LoggerFactory.getLogger(ModifyActStockBusiServiceImpl.class);
    @Autowired
    private ActCommAtomService actCommAtomService;
    @Autowired
    private ActivityCommodityDao activityCommodityDao;

    public RspBaseBO modifyStock(ReqBatchBaseBO<ActivityCommodityBO> reqBO, String operType) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getReqList())) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        HashMap<String, Integer> skuCounMap = new HashMap<String, Integer>(reqBO.getReqList().size());
        for (ActivityCommodityBO commodityBO : reqBO.getReqList()) {
            this.checkActComm(commodityBO);
            skuCounMap.put(commodityBO.getObjCode(), commodityBO.getSkuCount());
        }
        QryActCommReqAtomBO atomBO = new QryActCommReqAtomBO();
        atomBO.setStockFlag("0");
        atomBO.setActComms(reqBO.getReqList());
        atomBO.setCurrentDate(new Date());
        atomBO.setAdvanceFlag(false);
        List<ActivityCommodityBO> comms = this.actCommAtomService.listCommStockBySkuAndType(atomBO);
        if (CollectionUtils.isEmpty(comms)) {
            log.error("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u5546\u54c1\u4fe1\u606f");
            return new RspBaseBO("0002", "\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u5546\u54c1\u4fe1\u606f");
        }
        for (ActivityCommodityBO comm : comms) {
            int skuCount = (Integer)skuCounMap.get(comm.getObjCode());
            if ("01".equals(operType)) {
                if (comm.getAvailableCount() < skuCount) {
                    log.error("\u6d3b\u52a8\u3010" + comm.getActivityId() + "\u3011\u5546\u54c1\u3010" + comm.getObjCode() + "\u3011\u53ef\u7528\u6570\u91cf\u4e0d\u8db3");
                    throw new ResourceException("0012", "\u6d3b\u52a8\u5546\u54c1\u53ef\u7528\u6570\u91cf\u4e0d\u8db3");
                }
                comm.setAvailableCount(Integer.valueOf(comm.getAvailableCount() - skuCount));
                continue;
            }
            comm.setAvailableCount(Integer.valueOf(comm.getAvailableCount() + skuCount));
        }
        this.actCommAtomService.modifyByBatch(comms);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private void checkActComm(ActivityCommodityBO bo) {
        if (null == bo.getSkuCount()) {
            log.error("\u9500\u552e\u6570\u91cf\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u9500\u552e\u6570\u91cf\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getObjCode())) {
            log.error("skuId\u4e3a\u7a7a");
            throw new ResourceException("0001", "skuId\u4e3a\u7a7a");
        }
        if (null == bo.getActivityId()) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        bo.setObjType("99");
    }
}

