/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.act.atom.ActCommAtomService;
import com.tydic.newretail.act.atom.ActTouchSpotAtomService;
import com.tydic.newretail.act.atom.bo.QryActCommReqAtomBO;
import com.tydic.newretail.act.bo.ActCommApplyScopeBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityCommodityBO;
import com.tydic.newretail.act.bo.ActivityTouchSpotBO;
import com.tydic.newretail.act.bo.ApplyObjBO;
import com.tydic.newretail.act.bo.QryActByPageReqBO;
import com.tydic.newretail.act.busi.QryActByPageBusiService;
import com.tydic.newretail.act.dao.ActivityDao;
import com.tydic.newretail.act.dao.po.ActivityPO;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryActByPageBusiServiceImpl
implements QryActByPageBusiService {
    private static final Logger log = LoggerFactory.getLogger(QryActByPageBusiServiceImpl.class);
    @Autowired
    private ActivityDao activityDao;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;
    @Autowired
    ActCommAtomService actCommAtomService;
    @Autowired
    ActTouchSpotAtomService actTouchSpotAtomService;

    public RspPageBaseBO<ActivityBO> listActInfoByPage(QryActByPageReqBO reqBO) {
        List<ActivityPO> pos;
        log.info("\u67e5\u8be2\u6d3b\u52a8\u5217\u8868\u5165\u53c2\u4e3a\uff1a" + reqBO.toString());
        Page page = new Page(reqBO.getCurrent(), reqBO.getPageSize());
        if (StringUtils.isBlank((CharSequence)reqBO.getActivityStatus()) || "-1".equals(reqBO.getActivityStatus())) {
            reqBO.setActivityStatus(null);
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getActivityType()) || "-1".equals(reqBO.getActivityType())) {
            reqBO.setActivityType(null);
        }
        ActCommApplyScopeBO scopeBO = new ActCommApplyScopeBO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCounty()) || StringUtils.isNotBlank((CharSequence)reqBO.getStoreId()) || StringUtils.isNotBlank((CharSequence)reqBO.getCity()) || StringUtils.isNotBlank((CharSequence)reqBO.getProvince())) {
            if (StringUtils.isNotBlank((CharSequence)reqBO.getProvince())) {
                scopeBO.setParam1(reqBO.getProvince());
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCity())) {
                scopeBO.setParam2(reqBO.getCity());
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCounty())) {
                scopeBO.setParam3(reqBO.getCounty());
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getStoreId())) {
                scopeBO.setParam4(reqBO.getStoreId());
            }
        } else {
            scopeBO.setParam1(reqBO.getmProvince());
            scopeBO.setParam2(reqBO.getmCity());
            scopeBO.setParam3(reqBO.getmDistrict());
            scopeBO.setParam4(reqBO.getmShopId());
        }
        List<ActivityCommodityBO> commodityBOS = null;
        HashSet<Long> activityIds = new HashSet<Long>();
        try {
            commodityBOS = this.actCommAtomService.selectByApplyScope(scopeBO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d3b\u52a8\u9002\u7528\u8303\u56f4\u5931\u8d25\uff1a" + e);
        }
        if (null != commodityBOS && commodityBOS.size() > 0) {
            for (ActivityCommodityBO commodityBO : commodityBOS) {
                activityIds.add(commodityBO.getActivityId());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActIds())) {
            try {
                activityIds.retainAll(reqBO.getActIds());
            }
            catch (Exception e) {
                log.error("\u96c6\u5408\u53d6\u4ea4\u96c6\u5931\u8d25\uff01\uff01");
            }
        }
        if (CollectionUtils.isEmpty(activityIds)) {
            return new RspPageBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", new ArrayList());
        }
        ActivityPO record = ActivityPO.toActivityPO(reqBO);
        record.setActIds(activityIds);
        try {
            pos = this.activityDao.selectByPage((Page<ActivityPO>)page, record);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            return new RspPageBaseBO("0003", "\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return new RspPageBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        QryActCommReqAtomBO atomBO = new QryActCommReqAtomBO();
        HashSet<String> objTypes = new HashSet<String>();
        objTypes.add("00");
        objTypes.add("01");
        objTypes.add("02");
        objTypes.add("03");
        objTypes.add("04");
        objTypes.add("05");
        atomBO.setObjTypes(objTypes);
        atomBO.setActIds(activityIds);
        List<ActivityCommodityBO> commodityBOList = null;
        try {
            commodityBOList = this.actCommAtomService.listCommByActIdAndObjTypes(atomBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u67e5\u8be2\u6d3b\u52a8\u9002\u7528\u516c\u53f8\u5931\u8d25");
            return new RspPageBaseBO("9999", "\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25:\u67e5\u8be2\u6d3b\u52a8\u9002\u7528\u516c\u53f8\u5931\u8d25");
        }
        List<ActivityTouchSpotBO> touchSpotBOList = this.actTouchSpotAtomService.selectByActIds(activityIds);
        ArrayList<ActivityBO> bos = new ArrayList<ActivityBO>(pos.size());
        for (ActivityPO po : pos) {
            ActivityBO bo = po.toActivityBO();
            ConvertParamUtils.escaptAct(bo, this.qryEscapeAtomService, true);
            if (CollectionUtils.isNotEmpty(commodityBOList)) {
                ArrayList<ApplyObjBO> list = new ArrayList<ApplyObjBO>();
                for (ActivityCommodityBO commodityBO : commodityBOList) {
                    if (!bo.getActivityId().equals(commodityBO.getActivityId())) continue;
                    ApplyObjBO applyObjBO = new ApplyObjBO();
                    applyObjBO.setApplyObjCode(commodityBO.getObjCode());
                    applyObjBO.setApplyObjName(commodityBO.getParam5());
                    if (!"00".equals(commodityBO.getObjCode()) && !commodityBO.getObjCode().equals(reqBO.getmProvince()) && !commodityBO.getObjCode().equals(reqBO.getmCity()) && !commodityBO.getObjCode().equals(reqBO.getmDistrict()) && !commodityBO.getObjCode().equals(reqBO.getmShopId()) && !"1".equals(reqBO.getmUserLevel())) continue;
                    bo.setApplyCompanyStr(StringUtils.isBlank((CharSequence)bo.getApplyCompanyStr()) ? commodityBO.getParam5() : bo.getApplyCompanyStr() + "," + commodityBO.getParam5());
                    list.add(applyObjBO);
                }
                bo.setApplyCompany(list);
            }
            if (CollectionUtils.isNotEmpty(touchSpotBOList)) {
                ArrayList<ActivityTouchSpotBO> spotBOS = new ArrayList<ActivityTouchSpotBO>();
                for (ActivityTouchSpotBO spotBO : touchSpotBOList) {
                    if (!bo.getActivityId().equals(spotBO.getActivityId())) continue;
                    ActivityTouchSpotBO activityTouchSpotBO = new ActivityTouchSpotBO();
                    activityTouchSpotBO.setMnomonicName(spotBO.getMnomonicName());
                    activityTouchSpotBO.setTouchSpotId(spotBO.getTouchSpotId());
                    bo.setApplyTouchSpots(StringUtils.isBlank((CharSequence)bo.getApplyTouchSpots()) ? spotBO.getMnomonicName() : bo.getApplyTouchSpots() + "," + spotBO.getMnomonicName());
                    spotBOS.add(activityTouchSpotBO);
                }
                bo.setApplyTouchSpot(spotBOS);
            }
            if (null == reqBO.getmUserId()) {
                log.error("\u767b\u5f55\u4eba\u4e3a\u7a7a\uff01");
                return new RspPageBaseBO("9999", "\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25:\u672a\u68c0\u6d4b\u5230\u767b\u5f55\u4eba");
            }
            if (null != reqBO.getmUserId() && null != bo.getCrtUid()) {
                if (("00".equals(bo.getActivityStatus()) || "01".equals(bo.getActivityStatus())) && bo.getCrtUid().equals(reqBO.getmUserId())) {
                    bo.setIsUpdate("1");
                } else {
                    bo.setIsUpdate("0");
                }
                if (("04".equals(bo.getActivityStatus()) || "03".equals(bo.getActivityStatus())) && bo.getCrtUid().equals(reqBO.getmUserId())) {
                    bo.setIsDelete("1");
                } else {
                    bo.setIsDelete("0");
                }
                if (null != bo.getCrtUid() && bo.getCrtUid().equals(reqBO.getmUserId())) {
                    bo.setIsStop("1");
                } else {
                    bo.setIsStop("0");
                }
            }
            bos.add(bo);
        }
        return new RspPageBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", bos, page.getTotalCount(), page.getTotalPages());
    }
}

