/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.ActCommAtomService;
import com.tydic.newretail.act.atom.bo.QryActCommReqAtomBO;
import com.tydic.newretail.act.bo.ActCommInfoBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityCommodityBO;
import com.tydic.newretail.act.bo.QryActivityReqBO;
import com.tydic.newretail.act.busi.QryActStockBusiService;
import com.tydic.newretail.toolkit.bo.RspBaseTBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QryActStockBusiServiceImpl
implements QryActStockBusiService {
    private static final Logger log = LoggerFactory.getLogger(QryActStockBusiServiceImpl.class);
    @Autowired
    private ActCommAtomService actCommAtomService;

    public RspBaseTBO<Map<Long, List<ActivityBO>>> listActStock(QryActivityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuList())) {
            log.error("\u5546\u54c1\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5546\u54c1\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<ActivityCommodityBO> comms = new ArrayList<ActivityCommodityBO>();
        for (ActCommInfoBO comm : reqBO.getSkuList()) {
            this.checkParamDetails(comm);
            for (ActivityBO act : comm.getActList()) {
                this.checkActParam(act);
                if (!"03".equals(act.getActivityType()) && !"01".equals(act.getActivityType())) continue;
                ActivityCommodityBO actComm = new ActivityCommodityBO();
                actComm.setObjCode(comm.getSkuId().toString());
                actComm.setObjType("99");
                actComm.setActivityType(act.getActivityType());
                actComm.setActivityId(act.getActivityId());
                comms.add(actComm);
            }
        }
        if (CollectionUtils.isEmpty(comms)) {
            return new RspBaseTBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        QryActCommReqAtomBO atomBO = new QryActCommReqAtomBO();
        atomBO.setActComms(comms);
        atomBO.setStockFlag("0");
        atomBO.setAdvanceFlag(false);
        List<ActivityCommodityBO> actComms = this.actCommAtomService.listCommBySkuAndType(atomBO);
        if (CollectionUtils.isEmpty(actComms)) {
            return new RspBaseTBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        HashMap actMap = new HashMap(reqBO.getSkuList().size());
        for (ActivityCommodityBO actComm : actComms) {
            Long skuId = Long.parseLong(actComm.getObjCode());
            List<ActivityBO> acts = actMap.containsKey(skuId) ? (List)actMap.get(skuId) : new ArrayList(1);
            ActivityBO act = new ActivityBO();
            act.setActivityType(actComm.getActivityType());
            act.setActivityId(actComm.getActivityId());
            act.setAvailableCount(actComm.getAvailableCount());
            act.setTotalCount(actComm.getTotalCount());
            acts.add(act);
            actMap.put(skuId, acts);
        }
        return new RspBaseTBO("0000", "\u64cd\u4f5c\u6210\u529f", actMap);
    }

    private void checkActParam(ActivityBO act) {
        if (null == act.getActivityId()) {
            log.error("\u6d3b\u52a8ID\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6d3b\u52a8ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)act.getActivityType())) {
            log.error("\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a");
        }
    }

    private void checkParamDetails(ActCommInfoBO comm) {
        if (null == comm.getSkuId()) {
            log.error("skuId\u4e3a\u7a7a");
            throw new ResourceException("0001", "skuId\u4e3a\u7a7a");
        }
        if (null == comm.getActList()) {
            log.error("\u5546\u54c1\u6240\u9009\u6d3b\u52a8\u96c6\u5408\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5546\u54c1\u6240\u9009\u6d3b\u52a8\u96c6\u5408\u4e3a\u7a7a");
        }
    }
}

