/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.newretail.act.atom.ActCalAtomService;
import com.tydic.newretail.act.atom.ActCommAtomService;
import com.tydic.newretail.act.atom.ActInfoAtomService;
import com.tydic.newretail.act.atom.ActTouchSpotAtomService;
import com.tydic.newretail.act.atom.ActivityBenefitAtomService;
import com.tydic.newretail.act.atom.CheckUserRangeAtomService;
import com.tydic.newretail.act.atom.GiftPkgAtomService;
import com.tydic.newretail.act.atom.PkgComposeAtomService;
import com.tydic.newretail.act.atom.QryMutuallyExclusiveAtomService;
import com.tydic.newretail.act.atom.bo.QryActCommReqAtomBO;
import com.tydic.newretail.act.atom.bo.QryActReqAtomBO;
import com.tydic.newretail.act.bo.ActCalReqBO;
import com.tydic.newretail.act.bo.ActCommInfoBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityBenefitBO;
import com.tydic.newretail.act.bo.ActivityCommodityBO;
import com.tydic.newretail.act.bo.GiftPkgInfoBO;
import com.tydic.newretail.act.bo.PkgComposeInfoBO;
import com.tydic.newretail.act.bo.QryActivityReqBO;
import com.tydic.newretail.act.busi.QryActivityBusiService;
import com.tydic.newretail.act.constant.ActMemConstants;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.QryEscapeBO;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.util.TkCalculatorUtils;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryActivityBusiServiceImpl
implements QryActivityBusiService {
    private static final Logger log = LoggerFactory.getLogger(QryActivityBusiServiceImpl.class);
    private static QryEscapeAtomService qryEscapeAtomService;
    @Autowired
    private ActCommAtomService actCommAtomService;
    @Autowired
    private CheckUserRangeAtomService checkUserRangeAtomService;
    @Autowired
    private ActInfoAtomService actInfoAtomService;
    @Autowired
    private QryMutuallyExclusiveAtomService checkActMutuallyExclusiveAtomService;
    @Autowired
    private ActCalAtomService actCalAtomService;
    @Autowired
    private ActTouchSpotAtomService actTouchSpotAtomService;
    @Autowired
    private ActivityBenefitAtomService activityBenefitAtomService;
    @Autowired
    private GiftPkgAtomService giftPkgAtomService;
    @Autowired
    private PkgComposeAtomService pkgComposeAtomService;
    private Map<Long, List<ActivityCommodityBO>> actCommMap;
    private Map<String, Set<Long>> shopAllowAct;
    private Map<Long, Set<String>> actAllowShopMap;
    private List<ActivityBO> allActList;

    @Resource(name="activityQryEscapeAtomService")
    public void setQryEscapeAtomService(QryEscapeAtomService qryEscapeAtomService) {
        QryActivityBusiServiceImpl.qryEscapeAtomService = qryEscapeAtomService;
    }

    public RspBatchBaseBO<ActCommInfoBO> listActivityBySku(QryActivityReqBO reqBO) {
        if (reqBO != null) {
            log.debug("\u6839\u636e\u5546\u54c1\u96c6\u5408\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u5165\u53c2:" + JSON.toJSONString((Object)reqBO));
        }
        this.checkParams(reqBO);
        Set<String> actTypes = this.getActTypes(reqBO.getActTypeMark());
        Date nowDate = new Date();
        List<ActivityBO> allActs = this.getAllActInfos(nowDate);
        ArrayList<ActivityCommodityBO> actComms = new ArrayList<ActivityCommodityBO>();
        ArrayList<ActivityCommodityBO> qryShopComms = new ArrayList<ActivityCommodityBO>();
        Long oriPrice = 0L;
        this.getQryObjCondition(oriPrice, actComms, qryShopComms, reqBO);
        List<ActivityCommodityBO> objList = this.getEffeActs(actComms, actTypes, nowDate);
        List<ActivityCommodityBO> shopComms = null;
        if (CollectionUtils.isNotEmpty(qryShopComms)) {
            shopComms = this.getEffeActs(qryShopComms, actTypes, nowDate);
        }
        if (CollectionUtils.isEmpty(objList) && CollectionUtils.isEmpty(allActs) && CollectionUtils.isEmpty(shopComms)) {
            log.debug("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8");
            return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        this.initObjMap(shopComms);
        this.allActList = new ArrayList<ActivityBO>();
        Set<Long> actIdSet = this.checkUserRange(reqBO, allActs, objList);
        if (null != reqBO.getMemId() && CollectionUtils.isEmpty(actIdSet)) {
            log.debug("\u5f53\u524d\u7528\u6237\uff0c\u6e20\u9053\uff0c\u9500\u552e\u7c7b\u578b\u4e0d\u80fd\u53c2\u4e0e\u6d3b\u52a8");
            return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        if (CollectionUtils.isNotEmpty(actIdSet)) {
            this.getActAllowShop(actIdSet);
        }
        Map<Long, ActivityBO> actMap = this.getActInfoMap(actIdSet, nowDate);
        if (null != reqBO.getMemId() && MapUtils.isEmpty(actMap)) {
            log.debug("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u4fe1\u606f");
            return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        ArrayList<ActCommInfoBO> commRspList = new ArrayList<ActCommInfoBO>(reqBO.getSkuList().size());
        for (ActCommInfoBO comm : reqBO.getSkuList()) {
            ArrayList<ActivityBO> checkActs = new ArrayList<ActivityBO>();
            List<ActivityBO> actBOs = this.getCommActInfo(comm, actMap, checkActs);
            if (null == comm.getSeckill()) {
                this.getSecKill(comm, nowDate);
            }
            this.pakCommAct(comm, actBOs, reqBO, oriPrice);
            this.checkActMutuallyExclusiveAtomService.checkAct(checkActs, actBOs);
            comm.setActList(actBOs);
            ConvertParamUtils.escapePrice(comm);
            commRspList.add(comm);
        }
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", commRspList);
    }

    private void getActAllowShop(Set<Long> actIds) {
        HashSet<String> objTypes = new HashSet<String>(1);
        objTypes.add("05");
        objTypes.add("02");
        objTypes.add("03");
        objTypes.add("01");
        objTypes.add("00");
        QryActCommReqAtomBO atomBO = new QryActCommReqAtomBO();
        atomBO.setActIds(actIds);
        atomBO.setObjTypes(objTypes);
        List<ActivityCommodityBO> shopComm = this.actCommAtomService.listCommByActIdAndObjTypes(atomBO);
        if (CollectionUtils.isEmpty(shopComm)) {
            return;
        }
        for (ActivityCommodityBO comm : shopComm) {
            HashSet<String> shopSet = this.actAllowShopMap.containsKey(comm.getActivityId()) ? this.actAllowShopMap.get(comm.getActivityId()) : new HashSet<String>(1);
            shopSet.add(comm.getObjCode());
            this.actAllowShopMap.put(comm.getActivityId(), shopSet);
        }
    }

    private void initObjMap(List<ActivityCommodityBO> shopComms) {
        this.actCommMap = new HashMap<Long, List<ActivityCommodityBO>>(16);
        this.actAllowShopMap = new HashMap<Long, Set<String>>(16);
        this.shopAllowAct = new HashMap<String, Set<Long>>(16);
        if (CollectionUtils.isNotEmpty(shopComms)) {
            for (ActivityCommodityBO comm : shopComms) {
                if (!"05".equals(comm.getObjType()) && !"02".equals(comm.getObjType()) && !"03".equals(comm.getObjType()) && !"01".equals(comm.getObjType()) && !"00".equals(comm.getObjType()) || !"1".equals(comm.getSingleTypeFlag())) continue;
                String shopId = comm.getObjCode();
                Set<Object> actSet = this.shopAllowAct.containsKey(shopId) ? this.shopAllowAct.get(shopId) : new HashSet(1);
                actSet.add(comm.getActivityId());
                this.shopAllowAct.put(shopId, actSet);
            }
        }
    }

    private List<ActivityBO> getAllActInfos(Date date) {
        ActivityBO record = new ActivityBO();
        record.setUsefulObjType("00");
        record.setStartTime(date);
        record.setEndTime(date);
        record.setActivityStatus("02");
        return this.actInfoAtomService.listActByCondition(record);
    }

    private void pakCommAct(ActCommInfoBO comm, List<ActivityBO> actBOs, QryActivityReqBO reqBO, Long oriPrice) {
        boolean notMem = null == reqBO.getMemId();
        ArrayList<ActivityBO> actList = new ArrayList<ActivityBO>(actBOs);
        Long memActId = null;
        if (notMem && "601".equals(comm.getPurchaseType())) {
            ActivityBO actReqBO = new ActivityBO();
            actReqBO.setActivityType("02");
            actReqBO.setActivityStatus("02");
            List<ActivityBO> memActs = this.actInfoAtomService.listActByCondition(actReqBO);
            if (CollectionUtils.isNotEmpty(memActs)) {
                memActId = memActs.get(0).getActivityId();
                actList.add(memActs.get(0));
                reqBO.setMemLevel(ActMemConstants.MEM_LEVEL_3);
            }
        }
        if (CollectionUtils.isEmpty(actList)) {
            return;
        }
        Collections.sort(actList, new Comparator<ActivityBO>(){

            @Override
            public int compare(ActivityBO o1, ActivityBO o2) {
                return o1.getPriority().compareTo(o2.getPriority());
            }
        });
        actBOs.clear();
        for (ActivityBO actBO : actList) {
            if (!notMem || !actBO.getActivityId().equals(memActId)) {
                actBOs.add(actBO);
            }
            if ("1".equals(actBO.getShowFlag())) {
                comm.setShowFlag("1");
            }
            ConvertParamUtils.escaptAct(actBO, qryEscapeAtomService, false);
            actBO.setOptionalFlag("1");
            if ("0".equals(actBO.getForceChooseFlag())) {
                actBO.setCheckFlag("0");
                continue;
            }
            actBO.setCheckFlag("1");
            if (!reqBO.getCalPorPriority().booleanValue() || null == comm.getSalePriceL() || null != comm.getDisPrice()) continue;
            ActCalReqBO actCalReqBO = new ActCalReqBO();
            actCalReqBO.setMemType(reqBO.getMemType());
            actCalReqBO.setMemLevel(reqBO.getMemLevel());
            actCalReqBO.setMemId(reqBO.getMemId());
            this.actCalAtomService.calPriceByType(comm, actBO, oriPrice, actCalReqBO);
            comm.setDisActType(actBO.getActivityType());
            try {
                comm.setDisPrice(Double.valueOf(MoneyUtils.Long2BigDecimal((Long)comm.getSkuDisPriceL()).doubleValue()));
            }
            catch (Exception e) {
                log.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            }
            String disName = qryEscapeAtomService.getCodeTitle("ACT_TYPE_DISPLAY_NAME", comm.getDisActType());
            comm.setDisActName(StringUtils.isBlank((CharSequence)disName) ? "\u672a\u5b9a\u4e49" : disName);
        }
        if (notMem && null != reqBO.getMemLevel()) {
            reqBO.setMemLevel(null);
        }
    }

    private List<ActivityBO> getCommActInfo(ActCommInfoBO comm, Map<Long, ActivityBO> actMap, List<ActivityBO> checkActs) {
        ArrayList<ActivityBO> list = new ArrayList<ActivityBO>();
        if (MapUtils.isNotEmpty(actMap)) {
            HashSet<Long> actIdSet = new HashSet<Long>(actMap.size());
            this.getActObjMap(actIdSet, actMap, comm);
            for (Long actId : actIdSet) {
                if (!actMap.containsKey(actId)) continue;
                ActivityBO act = new ActivityBO();
                BeanUtils.copyProperties((Object)actMap.get(actId), (Object)act);
                this.getGiftPkgInfo(act, comm);
                list.add(act);
                if (!"1".equals(act.getForceChooseFlag()) && (!CollectionUtils.isNotEmpty((Collection)comm.getActIds()) || !comm.getActIds().contains(act.getActivityId()))) continue;
                checkActs.add(act);
            }
        }
        if (CollectionUtils.isNotEmpty(this.allActList)) {
            for (ActivityBO act : this.allActList) {
                if ("1".equals(act.getForceChooseFlag()) || CollectionUtils.isNotEmpty((Collection)comm.getActIds()) && comm.getActIds().contains(act.getActivityId())) {
                    checkActs.add(act);
                }
                ActivityBO actBO = new ActivityBO();
                BeanUtils.copyProperties((Object)act, (Object)actBO);
                this.getGiftPkgInfo(actBO, comm);
                list.add(actBO);
            }
        }
        return list;
    }

    private void getGiftPkgInfo(ActivityBO act, ActCommInfoBO comm) {
        if (null == act) {
            return;
        }
        String materialId = null;
        if (!"09".equals(act.getActivityType())) {
            if ("10".equals(act.getActivityType())) {
                materialId = comm.getMaterialId();
            } else {
                return;
            }
        }
        ActivityBenefitBO reqBO = new ActivityBenefitBO();
        reqBO.setActivityId(act.getActivityId());
        reqBO.setBenefitType("02");
        reqBO.setParam2(materialId);
        List<ActivityBenefitBO> benefitBoS = this.activityBenefitAtomService.listBenefitByActId(reqBO);
        if (CollectionUtils.isEmpty(benefitBoS)) {
            return;
        }
        act.setBenefitDetails(benefitBoS);
        for (ActivityBenefitBO benefitBo : benefitBoS) {
            Long pkgId = Long.valueOf(benefitBo.getParam1());
            if (null == pkgId) continue;
            GiftPkgInfoBO giftPkgInfoBO = this.giftPkgAtomService.getGiftPkgInfoById(pkgId);
            benefitBo.setGiftPkgInfoBO(giftPkgInfoBO);
            PkgComposeInfoBO pkgComposeInfoBOReqBo = new PkgComposeInfoBO();
            pkgComposeInfoBOReqBo.setPkgId(giftPkgInfoBO.getPkgId());
            List<PkgComposeInfoBO> PkgComposeInfoBOs = this.pkgComposeAtomService.getPkgComposeInfoList(pkgComposeInfoBOReqBo);
            if (CollectionUtils.isEmpty(benefitBoS)) continue;
            giftPkgInfoBO.setPkgComposeInfoBOs(PkgComposeInfoBOs);
        }
    }

    private void getGradePrice(ActivityCommodityBO actComm, ActCommInfoBO comm) {
        if (StringUtils.isNotBlank((CharSequence)actComm.getParam6())) {
            comm.setGradePriceAL(Long.valueOf(Long.valueOf(actComm.getParam6())));
        }
        if (StringUtils.isNotBlank((CharSequence)actComm.getParam7())) {
            comm.setGradePriceBL(Long.valueOf(Long.valueOf(actComm.getParam7())));
        }
        if (StringUtils.isNotBlank((CharSequence)actComm.getParam8())) {
            comm.setGradePriceCL(Long.valueOf(Long.valueOf(actComm.getParam8())));
        }
        if (StringUtils.isNotBlank((CharSequence)actComm.getParam9())) {
            comm.setGradePriceDL(Long.valueOf(Long.valueOf(actComm.getParam9())));
        }
    }

    private void getActObjMap(Set<Long> actIdSet, Map<Long, ActivityBO> actMap, ActCommInfoBO comm) {
        if (!(!MapUtils.isEmpty(this.actCommMap) || this.shopAllowAct.containsKey(comm.getShopId().toString()) || this.shopAllowAct.containsKey(comm.getCityCode()) || this.shopAllowAct.containsKey(comm.getCountyCode()) || this.shopAllowAct.containsKey(comm.getProvinceCode()) || this.shopAllowAct.containsKey("00"))) {
            return;
        }
        HashSet<Long> tempActSet = new HashSet<Long>(actMap.size());
        if (MapUtils.isNotEmpty(this.actCommMap)) {
            for (Map.Entry<Long, List<ActivityCommodityBO>> map : this.actCommMap.entrySet()) {
                Set<String> shopSet;
                Long actId = map.getKey();
                if (!actMap.containsKey(actId)) continue;
                ActivityBO activityBO = actMap.get(actId);
                Set<String> set = shopSet = this.actAllowShopMap.containsKey(actId) ? this.actAllowShopMap.get(actId) : null;
                if ("01".equals(activityBO.getUsefulObjType()) && null != shopSet && !shopSet.contains(comm.getShopId().toString()) && !shopSet.contains(comm.getCityCode()) && !shopSet.contains(comm.getCountyCode()) && !shopSet.contains(comm.getProvinceCode()) && !shopSet.contains("00")) continue;
                for (ActivityCommodityBO actComm : map.getValue()) {
                    switch (actComm.getObjType()) {
                        case "07": {
                            String prType = actComm.getObjCode();
                            if (!comm.getPurchaseType().equals(prType)) break;
                            tempActSet.add(actComm.getActivityId());
                            break;
                        }
                        case "99": {
                            Long skuId = Long.parseLong(actComm.getObjCode());
                            if (!comm.getSkuId().equals(skuId)) break;
                            tempActSet.add(actComm.getActivityId());
                            if (!"11".equals(activityBO.getActivityType())) break;
                            this.getGradePrice(actComm, comm);
                            break;
                        }
                        case "11": {
                            String materialId = actComm.getObjCode();
                            if (!comm.getMaterialId().equals(materialId)) break;
                            tempActSet.add(actComm.getActivityId());
                            if (!"11".equals(activityBO.getActivityType())) break;
                            this.getGradePrice(actComm, comm);
                            break;
                        }
                        case "12": {
                            String provGoodsId = actComm.getObjCode();
                            if (!comm.getProvGoodsId().equals(provGoodsId)) break;
                            tempActSet.add(actComm.getActivityId());
                            if (!"11".equals(activityBO.getActivityType())) break;
                            this.getGradePrice(actComm, comm);
                            break;
                        }
                        case "08": {
                            Long classTypeId = Long.parseLong(actComm.getObjCode());
                            if (null == comm.getClassTypeId() || !comm.getClassTypeId().equals(classTypeId)) break;
                            tempActSet.add(actComm.getActivityId());
                            break;
                        }
                        case "10": {
                            String brand = actComm.getObjCode();
                            if (!StringUtils.isNotBlank((CharSequence)comm.getBrand()) || !comm.getBrand().equals(brand)) break;
                            tempActSet.add(actComm.getActivityId());
                            break;
                        }
                    }
                }
            }
        }
        if (this.shopAllowAct.containsKey(comm.getShopId().toString())) {
            actIdSet.addAll((Collection<Long>)this.shopAllowAct.get(comm.getShopId().toString()));
        }
        if (this.shopAllowAct.containsKey(comm.getProvinceCode())) {
            actIdSet.addAll((Collection<Long>)this.shopAllowAct.get(comm.getProvinceCode()));
        }
        if (this.shopAllowAct.containsKey(comm.getCityCode())) {
            actIdSet.addAll((Collection<Long>)this.shopAllowAct.get(comm.getCityCode()));
        }
        if (this.shopAllowAct.containsKey(comm.getCountyCode())) {
            actIdSet.addAll((Collection<Long>)this.shopAllowAct.get(comm.getCountyCode()));
        }
        if (this.shopAllowAct.containsKey("00")) {
            actIdSet.addAll((Collection<Long>)this.shopAllowAct.get("00"));
        }
        actIdSet.addAll(tempActSet);
    }

    private Map<Long, ActivityBO> getActInfoMap(Set<Long> actIdSet, Date nowDate) {
        if (CollectionUtils.isEmpty(actIdSet)) {
            return null;
        }
        List<ActivityBO> activityBOS = this.actInfoAtomService.listActivityInfo(actIdSet, nowDate);
        if (CollectionUtils.isEmpty(activityBOS)) {
            return null;
        }
        HashMap<Long, ActivityBO> actMap = new HashMap<Long, ActivityBO>(activityBOS.size());
        for (ActivityBO act : activityBOS) {
            actMap.put(act.getActivityId(), act);
        }
        return actMap;
    }

    private List<ActivityCommodityBO> getEffeActs(List<ActivityCommodityBO> actComms, Set<String> actTypes, Date nowDate) {
        QryActCommReqAtomBO atomReqBO = new QryActCommReqAtomBO();
        atomReqBO.setActComms(actComms);
        atomReqBO.setActTypes(actTypes);
        atomReqBO.setAdvanceFlag(false);
        atomReqBO.setCurrentDate(nowDate);
        atomReqBO.setActStatus("02");
        List<ActivityCommodityBO> objList = this.actCommAtomService.listCommBySkuAndType(atomReqBO);
        return objList;
    }

    private void getQryObjCondition(Long oriPrice, List<ActivityCommodityBO> actComms, List<ActivityCommodityBO> qryShopComms, QryActivityReqBO reqBO) {
        for (ActCommInfoBO comm : reqBO.getSkuList()) {
            this.checkDetailParams(comm);
            oriPrice = oriPrice + comm.getSalePriceL() * (long)comm.getSkuCount().intValue();
            ActivityCommodityBO actCom = new ActivityCommodityBO();
            actCom.setObjCode(comm.getPurchaseType());
            actCom.setObjType("07");
            actComms.add(actCom);
            if (null == comm.getSkuId() && StringUtils.isBlank((CharSequence)comm.getProvGoodsId()) && StringUtils.isBlank((CharSequence)comm.getMaterialId())) {
                log.error("\u5546\u54c1\u96c6\u5408\u5185\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
                throw new ResourceException("0001", "\u5546\u54c1\u96c6\u5408\u4e3a\u7a7a");
            }
            if (null != comm.getSkuId()) {
                actCom = new ActivityCommodityBO();
                actCom.setObjCode(comm.getSkuId().toString());
                actCom.setObjType("99");
                actCom.setAvailableCount(comm.getSkuCount());
                actComms.add(actCom);
            }
            if (StringUtils.isNotBlank((CharSequence)comm.getProvGoodsId())) {
                actCom = new ActivityCommodityBO();
                actCom.setObjCode(comm.getProvGoodsId());
                actCom.setObjType("12");
                actCom.setAvailableCount(comm.getSkuCount());
                actComms.add(actCom);
            }
            if (StringUtils.isNotBlank((CharSequence)comm.getMaterialId())) {
                actCom = new ActivityCommodityBO();
                actCom.setObjCode(comm.getMaterialId());
                actCom.setObjType("11");
                actCom.setAvailableCount(comm.getSkuCount());
                actComms.add(actCom);
            }
            if (null != comm.getClassTypeId()) {
                actCom = new ActivityCommodityBO();
                actCom.setObjCode(comm.getClassTypeId().toString());
                actCom.setObjType("08");
                actComms.add(actCom);
            }
            if (StringUtils.isNotBlank((CharSequence)comm.getBrand())) {
                actCom = new ActivityCommodityBO();
                actCom.setObjCode(comm.getBrand());
                actCom.setObjType("10");
                actComms.add(actCom);
            }
            if (null != comm.getShopId()) {
                actCom = new ActivityCommodityBO();
                actCom.setObjCode(comm.getShopId().toString());
                actCom.setObjType("05");
                qryShopComms.add(actCom);
            }
            if (null != comm.getProvinceCode()) {
                actCom = new ActivityCommodityBO();
                actCom.setObjCode(comm.getProvinceCode());
                actCom.setObjType("01");
                qryShopComms.add(actCom);
            }
            if (null != comm.getCityCode()) {
                actCom = new ActivityCommodityBO();
                actCom.setObjCode(comm.getCityCode());
                actCom.setObjType("02");
                qryShopComms.add(actCom);
            }
            if (null != comm.getCountyCode()) {
                actCom = new ActivityCommodityBO();
                actCom.setObjCode(comm.getCountyCode());
                actCom.setObjType("03");
                qryShopComms.add(actCom);
            }
            actCom = new ActivityCommodityBO();
            actCom.setObjCode("00");
            actCom.setObjType("00");
            qryShopComms.add(actCom);
        }
    }

    private void getSecKill(ActCommInfoBO commRspBO, Date nowDate) {
        HashSet<String> actType = new HashSet<String>(1);
        actType.add("01");
        QryActCommReqAtomBO reqBO = new QryActCommReqAtomBO();
        reqBO.setCurrentDate(nowDate);
        reqBO.setAdvanceFlag(true);
        reqBO.setActTypes(actType);
        ArrayList<ActivityCommodityBO> comms = new ArrayList<ActivityCommodityBO>(1);
        ActivityCommodityBO comm = new ActivityCommodityBO();
        comm.setObjCode(commRspBO.getSkuId().toString());
        comm.setObjType("99");
        comms.add(comm);
        reqBO.setActComms(comms);
        List<ActivityCommodityBO> acts = this.actCommAtomService.listCommBySkuAndType(reqBO);
        if (CollectionUtils.isEmpty(acts)) {
            return;
        }
        ActivityCommodityBO seckillComm = acts.get(0);
        if (null == seckillComm.getAvailableCount() || seckillComm.getAvailableCount() <= 0) {
            return;
        }
        ActivityBO actReqBO = new ActivityBO();
        actReqBO.setActivityId(seckillComm.getActivityId());
        ActivityBO seckill = this.actInfoAtomService.getActivityInfo(actReqBO);
        if (null == seckill) {
            return;
        }
        if (null != seckillComm.getActPrice()) {
            seckill.setActPrice(seckillComm.getActPrice());
            seckill.setActPriceD(TkCalculatorUtils.transferY((long)seckillComm.getActPrice()));
        }
        seckill.setTotalCount(seckillComm.getTotalCount());
        seckill.setAvailableCount(seckillComm.getAvailableCount());
        commRspBO.setSeckill(seckill);
    }

    private Set<Long> checkUserRange(QryActivityReqBO reqBO, List<ActivityBO> allActs, List<ActivityCommodityBO> objList) {
        Set<Long> allowActs;
        HashSet<Long> actIds = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty(objList)) {
            for (ActivityCommodityBO activityCommodityBO : objList) {
                actIds.add(activityCommodityBO.getActivityId());
                ArrayList<ActivityCommodityBO> comms = this.actCommMap.containsKey(activityCommodityBO.getActivityId()) ? this.actCommMap.get(activityCommodityBO.getActivityId()) : new ArrayList<ActivityCommodityBO>(1);
                comms.add(activityCommodityBO);
                this.actCommMap.put(activityCommodityBO.getActivityId(), comms);
            }
        }
        if (MapUtils.isNotEmpty(this.shopAllowAct)) {
            for (Map.Entry entry : this.shopAllowAct.entrySet()) {
                actIds.addAll((Collection)entry.getValue());
            }
        }
        if (CollectionUtils.isNotEmpty(allActs)) {
            for (ActivityBO activityBO : allActs) {
                actIds.add(activityBO.getActivityId());
            }
        }
        if (CollectionUtils.isEmpty(allowActs = this.actTouchSpotAtomService.selectByIdsAndTouch(reqBO.getChannel(), actIds))) {
            log.debug("\u67e5\u8be2\u6e20\u9053\u51fa\u53c2\u4e3a\u7a7a");
            return null;
        }
        allowActs = this.actInfoAtomService.selectByIdsAndSaleType(reqBO.getSaleType(), allowActs);
        if (CollectionUtils.isEmpty(allowActs)) {
            log.debug("\u67e5\u8be2\u9500\u552e\u7c7b\u578b\u51fa\u53c2\u4e3a\u7a7a");
            return null;
        }
        if (CollectionUtils.isEmpty(allowActs = this.checkUserRangeAtomService.checkUser(reqBO, allowActs))) {
            log.debug("\u67e5\u8be2\u7528\u6237\u51fa\u53c2\u4e3a\u7a7a");
            return null;
        }
        if (CollectionUtils.isNotEmpty(allActs)) {
            for (ActivityBO act : allActs) {
                if (!allowActs.contains(act.getActivityId())) continue;
                this.allActList.add(act);
            }
        }
        return allowActs;
    }

    private Set<String> getActTypes(String parentCode) {
        List escapeBOS = qryEscapeAtomService.listEscapeByParentCode(parentCode);
        if (CollectionUtils.isEmpty((Collection)escapeBOS)) {
            return null;
        }
        Set actTypeSet = null;
        for (QryEscapeBO bo : escapeBOS) {
            actTypeSet.add(bo.getEscapeValue());
        }
        return actTypeSet;
    }

    private void checkParams(QryActivityReqBO reqBO) {
        if (null == reqBO) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getSkuList()) {
            log.error("\u5546\u54c1\u96c6\u5408\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5546\u54c1\u96c6\u5408\u4e3a\u7a7a");
        }
        if (null == reqBO.getMemId()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getChannel())) {
            reqBO.setChannel("0001");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSaleType())) {
            reqBO.setSaleType("01");
        }
        if (null == reqBO.getMemLevel() || null == reqBO.getMemType()) {
            log.error("\u4f1a\u5458\u7b49\u7ea7\u6216\u4f1a\u5458\u7c7b\u578b\u4e3a\u7a7a");
            throw new ResourceException("0001", "skuId\u96c6\u5408\u4e3a\u7a7a");
        }
    }

    private void checkDetailParams(ActCommInfoBO comm) {
        if (null == comm.getSalePriceL()) {
            log.error("\u9500\u552e\u4ef7\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u9500\u552e\u4ef7\u4e3a\u7a7a");
        }
        if (null == comm.getSkuCount()) {
            comm.setSkuCount(Integer.valueOf(1));
        }
        if (null == comm.getPurchaseType()) {
            comm.setPurchaseType("0");
        }
    }

    public RspBatchBaseBO<ActivityBO> listActivityByType(ActivityBO reqBO) {
        QryActReqAtomBO qryActReqAtomBO = new QryActReqAtomBO();
        qryActReqAtomBO.setActivityType(reqBO.getActivityType());
        HashSet<String> status = new HashSet<String>();
        status.add("00");
        status.add("01");
        status.add("02");
        qryActReqAtomBO.setActivityStatus(status);
        qryActReqAtomBO.setEndDate(new Date());
        List<ActivityBO> bos = this.actInfoAtomService.listActByType(qryActReqAtomBO);
        if (CollectionUtils.isNotEmpty(bos)) {
            for (ActivityBO bo : bos) {
                ConvertParamUtils.escaptAct(bo, qryEscapeAtomService, true);
            }
        }
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", bos);
    }
}

