/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.ActCommAtomService;
import com.tydic.newretail.act.bo.ActivityCommodityBO;
import com.tydic.newretail.act.bo.ActivityCommodityBySaleTypeRspBO;
import com.tydic.newretail.act.bo.ActivityCommodityReqBO;
import com.tydic.newretail.act.bo.ActivityCommodityRspBO;
import com.tydic.newretail.act.busi.QryActivityCommObjBusiService;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.util.TkCalculatorUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryActivityCommBusiServiceImpl
implements QryActivityCommObjBusiService {
    private static final Logger log = LoggerFactory.getLogger(QryActivityCommBusiServiceImpl.class);
    private static QryEscapeAtomService qryEscapeAtomService;
    @Autowired
    private ActCommAtomService actCommAtomService;

    @Resource(name="activityQryEscapeAtomService")
    public void setQryEscapeAtomService(QryEscapeAtomService qryEscapeAtomService) {
        QryActivityCommBusiServiceImpl.qryEscapeAtomService = qryEscapeAtomService;
    }

    public RspBatchBaseBO<ActivityCommodityRspBO> listActivityCommByActAndObjType(ActivityCommodityReqBO reqBO) {
        this.checkParams(reqBO);
        ActivityCommodityBO bo = new ActivityCommodityBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)bo);
        List<ActivityCommodityBO> list = this.actCommAtomService.selectByActIdAndObjType(bo);
        if (CollectionUtils.isEmpty(list)) {
            log.error("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u5546\u54c1");
            return new RspBatchBaseBO("0002", "\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u5546\u54c1");
        }
        ArrayList<ActivityCommodityRspBO> rspList = new ArrayList<ActivityCommodityRspBO>();
        for (ActivityCommodityBO actCommBO : list) {
            ActivityCommodityRspBO rspComm = new ActivityCommodityRspBO();
            BeanUtils.copyProperties((Object)actCommBO, (Object)rspComm);
            if (null != actCommBO.getActPrice()) {
                rspComm.setActPrice(TkCalculatorUtils.transferY((long)actCommBO.getActPrice()));
            }
            ConvertParamUtils.escaptActCom(actCommBO, rspComm, qryEscapeAtomService);
            rspList.add(rspComm);
        }
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", rspList);
    }

    public RspBatchBaseBO<ActivityCommodityBySaleTypeRspBO> listActivityCommBySaleTypeAndMaterial(ActivityCommodityReqBO reqBO) {
        return null;
    }

    private void checkParams(ActivityCommodityReqBO reqBO) {
        if (null == reqBO) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getObjType())) {
            log.error("objType\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a");
            throw new ResourceException("0001", "objType\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (null == reqBO.getActivityId()) {
            log.error("\u6d3b\u52a8id\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u6d3b\u52a8id\u4e3a\u7a7a");
        }
    }
}

