/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.act.atom.ActCommAtomService;
import com.tydic.newretail.act.atom.ActInfoAtomService;
import com.tydic.newretail.act.atom.ActivityCommodityModelObjAtomService;
import com.tydic.newretail.act.atom.bo.QryActCommReqAtomBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityCommodityBO;
import com.tydic.newretail.act.bo.ActivityCommodityModelObjInfoBO;
import com.tydic.newretail.act.bo.ApplyObjBO;
import com.tydic.newretail.act.bo.CommodityPartInActBO;
import com.tydic.newretail.act.bo.CommodityPartInActReqBO;
import com.tydic.newretail.act.bo.MaterialAndScopeBO;
import com.tydic.newretail.act.bo.QryActByCommodityReqBO;
import com.tydic.newretail.act.bo.QryActByCommodityRspBO;
import com.tydic.newretail.act.busi.QryActByCommodityBusiService;
import com.tydic.newretail.act.busi.QryCommodityPartInActBusiService;
import com.tydic.newretail.act.dao.ActivityDao;
import com.tydic.newretail.act.dao.po.ActivityPO;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryCommodityPartInActBusiServiceImpl
implements QryCommodityPartInActBusiService {
    private static final Logger log = LoggerFactory.getLogger(QryCommodityPartInActBusiServiceImpl.class);
    @Autowired
    QryActByCommodityBusiService qryActByCommodityBusiService;
    @Autowired
    ActCommAtomService actCommAtomService;
    @Autowired
    ActivityCommodityModelObjAtomService activityCommodityModelObjAtomService;
    @Autowired
    ActInfoAtomService actInfoAtomService;
    @Autowired
    ActivityDao activityDao;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RspPageBaseBO<CommodityPartInActBO> qryCommodityPartInAct(CommodityPartInActReqBO reqBO, Boolean isPage) {
        log.info("\u67e5\u8be2\u673a\u578b\u53c2\u4e0e\u6d3b\u52a8\u5165\u53c2\u4e3a\uff1a" + reqBO.toString());
        RspPageBaseBO result = new RspPageBaseBO();
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        this.checkParam(reqBO, isPage);
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getProvinceCode())) {
            ActivityCommodityModelObjInfoBO activityCommodityModelObjInfoBO = new ActivityCommodityModelObjInfoBO();
            activityCommodityModelObjInfoBO.setModelId(reqBO.getModelId());
            activityCommodityModelObjInfoBO.setProvinceCode(reqBO.getProvinceCode());
            List<ActivityCommodityModelObjInfoBO> activityCommodityModelObjInfoBOList = null;
            try {
                activityCommodityModelObjInfoBOList = this.activityCommodityModelObjAtomService.selectListByCondition(activityCommodityModelObjInfoBO);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u673a\u578b\u5173\u8054\u6d3b\u52a8\u524d\u67e5\u8be2\u673a\u578b\u5f02\u5e38");
                return new RspPageBaseBO("9999", "\u7cfb\u7edf\u5f02\u5e38");
            }
            if (CollectionUtils.isEmpty(activityCommodityModelObjInfoBOList)) {
                log.debug("\u67e5\u8be2\u673a\u578b\u5173\u8054\u6d3b\u52a8\u65f6-\u5f53\u524d\u673a\u578b\u4e0d\u5728\u6240\u9009\u7701\u4efd\u8303\u56f4");
                return new RspPageBaseBO("0000", "\u67e5\u8be2\u673a\u578b\u5173\u8054\u6d3b\u52a8\u65f6-\u5f53\u524d\u673a\u578b\u4e0d\u5728\u6240\u9009\u7701\u4efd\u8303\u56f4", new ArrayList());
            }
        }
        QryActByCommodityReqBO qryActByCommodityReqBO = new QryActByCommodityReqBO();
        ArrayList<MaterialAndScopeBO> materialAndScopes = new ArrayList<MaterialAndScopeBO>();
        ArrayList<String> scope = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProvinceCode())) {
            scope.add(reqBO.getProvinceCode());
        } else {
            scope.addAll(reqBO.getProvinceCodes());
        }
        MaterialAndScopeBO materialAndScopeBO = new MaterialAndScopeBO();
        materialAndScopeBO.setMaterial(reqBO.getMaterial());
        materialAndScopeBO.setObjCodes(scope);
        materialAndScopes.add(materialAndScopeBO);
        qryActByCommodityReqBO.setMaterialAndScopes(materialAndScopes);
        qryActByCommodityReqBO.setActSaleType(reqBO.getSaleType());
        RspBatchBaseBO actRspBO = null;
        try {
            actRspBO = this.qryActByCommodityBusiService.qryActByCommodity(qryActByCommodityReqBO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u673a\u578b\u5173\u8054\u6d3b\u52a8\u51fa\u9519");
            return new RspPageBaseBO("9999", "\u7cfb\u7edf\u5f02\u5e38");
        }
        if ("0000".equals(actRspBO.getRespCode())) {
            HashSet<Long> acts = new HashSet<Long>();
            if (!CollectionUtils.isNotEmpty((Collection)actRspBO.getRows())) return result;
            for (QryActByCommodityRspBO bo : actRspBO.getRows()) {
                if (!bo.getMaterial().equals(reqBO.getMaterial())) continue;
                acts.addAll(bo.getActIds());
            }
            if (!CollectionUtils.isNotEmpty(acts)) return new RspPageBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", new ArrayList());
            ArrayList<CommodityPartInActBO> rspList = new ArrayList<CommodityPartInActBO>();
            QryActCommReqAtomBO qryActCommReqAtomBO = new QryActCommReqAtomBO();
            qryActCommReqAtomBO.setActIds(acts);
            HashSet<String> objTypes = new HashSet<String>();
            objTypes.add("00");
            objTypes.add("01");
            objTypes.add("02");
            objTypes.add("03");
            objTypes.add("04");
            objTypes.add("05");
            qryActCommReqAtomBO.setObjTypes(objTypes);
            List<ActivityCommodityBO> commodityBOS = null;
            try {
                commodityBOS = this.actCommAtomService.listCommByActIdAndObjTypes(qryActCommReqAtomBO);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u6d3b\u52a8\u9002\u7528\u516c\u53f8\u51fa\u9519" + e.getMessage());
                throw new ResourceException("0003", "\u67e5\u8be2\u6d3b\u52a8\u9002\u7528\u516c\u53f8\u51fa\u9519");
            }
            if (isPage.booleanValue()) {
                ActivityPO activityPO = new ActivityPO();
                activityPO.setActIds(acts);
                Page page = new Page(reqBO.getCurrent(), reqBO.getPageSize());
                List<ActivityPO> pos = null;
                try {
                    pos = this.activityDao.selectByPage((Page<ActivityPO>)page, activityPO);
                }
                catch (Exception e) {
                    log.error("\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u5217\u8868\u5f02\u5e38" + e.getMessage());
                    return new RspPageBaseBO("9999", "\u7cfb\u7edf\u5f02\u5e38");
                }
                if (CollectionUtils.isNotEmpty(pos)) {
                    for (ActivityPO po : pos) {
                        CommodityPartInActBO bo = new CommodityPartInActBO();
                        BeanUtils.copyProperties((Object)po, (Object)bo);
                        bo.setMaterial(reqBO.getMaterial());
                        if (StringUtils.isNotBlank((CharSequence)reqBO.getProvinceCode())) {
                            bo.setProvinceCode(reqBO.getProvinceCode());
                        } else {
                            bo.setProvinceCodes(reqBO.getProvinceCodes());
                        }
                        bo.setProvinceName(reqBO.getProvinceName());
                        bo.setActivityStatusStr(this.qryEscapeAtomService.getCodeTitle("ACT_STATUS_NAME", bo.getActivityStatus()));
                        bo.setActivityTypeStr(this.qryEscapeAtomService.getCodeTitle("ACT_TYPE_NAME", bo.getActivityType()));
                        bo.setSaleTypeStr(this.qryEscapeAtomService.getCodeTitle("APPLY_SALES_TYPE", bo.getSaleType()));
                        ArrayList<ApplyObjBO> list = new ArrayList<ApplyObjBO>();
                        String applyObjStr = "";
                        for (ActivityCommodityBO commBO : commodityBOS) {
                            ApplyObjBO objBO = new ApplyObjBO();
                            if (!commBO.getActivityId().equals(po.getActivityId())) continue;
                            objBO.setApplyObjCode(commBO.getObjCode());
                            objBO.setApplyObjName(commBO.getParam5());
                            applyObjStr = StringUtils.isBlank((CharSequence)applyObjStr) ? commBO.getParam5() : applyObjStr + "\uff1b" + commBO.getParam5();
                            list.add(objBO);
                        }
                        bo.setApplyObjBOList(list);
                        bo.setApplyObjStr(applyObjStr);
                        rspList.add(bo);
                    }
                    result.setTotal(page.getTotalPages());
                    result.setRecordsTotal(page.getTotalCount());
                }
            } else {
                List<ActivityBO> boList = null;
                try {
                    boList = this.actInfoAtomService.listActivityInfo(acts);
                    if (CollectionUtils.isNotEmpty(boList)) {
                        for (ActivityBO po : boList) {
                            CommodityPartInActBO bo = new CommodityPartInActBO();
                            BeanUtils.copyProperties((Object)po, (Object)bo);
                            bo.setMaterial(reqBO.getMaterial());
                            if (StringUtils.isNotBlank((CharSequence)reqBO.getProvinceCode())) {
                                bo.setProvinceCode(reqBO.getProvinceCode());
                            } else {
                                bo.setProvinceCodes(reqBO.getProvinceCodes());
                            }
                            bo.setProvinceName(reqBO.getProvinceName());
                            bo.setActivityStatusStr(this.qryEscapeAtomService.getCodeTitle("ACT_STATUS_NAME", bo.getActivityStatus()));
                            bo.setActivityTypeStr(this.qryEscapeAtomService.getCodeTitle("ACT_TYPE_NAME", bo.getActivityType()));
                            bo.setSaleTypeStr(this.qryEscapeAtomService.getCodeTitle("APPLY_SALES_TYPE", bo.getSaleType()));
                            if (null != bo.getStartTime()) {
                                bo.setStartTimeStr(TkDateUtils.formatDate((Date)bo.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                            }
                            if (null != bo.getEndTime()) {
                                bo.setEndTimeStr(TkDateUtils.formatDate((Date)bo.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                            }
                            ArrayList<ApplyObjBO> list = new ArrayList<ApplyObjBO>();
                            String applyObjStr = "";
                            for (ActivityCommodityBO commBO : commodityBOS) {
                                ApplyObjBO objBO = new ApplyObjBO();
                                if (!commBO.getActivityId().equals(po.getActivityId())) continue;
                                objBO.setApplyObjCode(commBO.getObjCode());
                                objBO.setApplyObjName(commBO.getParam5());
                                applyObjStr = StringUtils.isBlank((CharSequence)applyObjStr) ? commBO.getParam5() : applyObjStr + "\uff1b" + commBO.getParam5();
                                list.add(objBO);
                            }
                            bo.setApplyObjBOList(list);
                            bo.setApplyObjStr(applyObjStr);
                            rspList.add(bo);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u67e5\u8be2\u6d3b\u52a8\u5217\u8868\u5f02\u5e38" + e.getMessage());
                    return new RspPageBaseBO("9999", "\u7cfb\u7edf\u5f02\u5e38");
                }
            }
            result.setRows(rspList);
            return result;
        }
        log.error("\u67e5\u8be2\u673a\u578b\u5173\u8054\u6d3b\u52a8\u51fa\u9519");
        return new RspPageBaseBO(actRspBO.getRespCode(), actRspBO.getRespDesc());
    }

    private void checkParam(CommodityPartInActReqBO reqBO, Boolean isPage) {
        if (null == reqBO) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (isPage.booleanValue() && (reqBO.getCurrent() == 0 || reqBO.getPageSize() == 0)) {
            log.error("\u5206\u9875\u53c2\u6570\u3010current\u3011\u3001\u3010pageSize\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5206\u9875\u53c2\u6570\u3010current\u3011\u3001\u3010pageSize\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getMaterial())) {
            log.error("\u5165\u53c2\u7269\u6599\u7f16\u7801\u3010material\u3011\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u7269\u6599\u7f16\u7801\u3010material\u3011\u4e3a\u7a7a");
        }
        if (null == reqBO.getModelId()) {
            log.error("\u5165\u53c2\u673a\u578bID\u3010modelId\u3011\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u673a\u578bID\u3010modelId\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getProvinceCode()) && CollectionUtils.isEmpty((Collection)reqBO.getProvinceCodes())) {
            log.error("\u5165\u53c2\u7701\u4efd\u3010provinceCode\u3011\u548c\u9002\u7528\u8303\u56f4\u3010provinceCodes\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u7701\u4efd\u3010provinceCode\u3011\u548c\u9002\u7528\u8303\u56f4\u3010provinceCodes\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getProvinceName())) {
            log.error("\u5165\u53c2\u7701\u4efd\u540d\u79f0\u3010provinceName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u7701\u4efd\u540d\u79f0\u3010provinceName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

