/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.act.atom.CouponAtomService;
import com.tydic.newretail.act.atom.CouponCommAtomService;
import com.tydic.newretail.act.atom.bo.QryCouponCommReqAtomBO;
import com.tydic.newretail.act.bo.ActConfigObjBO;
import com.tydic.newretail.act.bo.ActConfigObjDetailsBO;
import com.tydic.newretail.act.bo.CouponBO;
import com.tydic.newretail.act.bo.CouponCommodityBO;
import com.tydic.newretail.act.bo.CouponConfigDetailsBO;
import com.tydic.newretail.act.bo.QryCouponPageReqBO;
import com.tydic.newretail.act.busi.QryCouponBusiService;
import com.tydic.newretail.act.busi.impl.QryActByPageBusiServiceImpl;
import com.tydic.newretail.act.dao.CouponDao;
import com.tydic.newretail.act.dao.po.CouponPO;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseTBO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryCouponBusiServiceImpl
implements QryCouponBusiService {
    private static final Logger log = LoggerFactory.getLogger(QryActByPageBusiServiceImpl.class);
    @Autowired
    private CouponDao couponDao;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;
    @Autowired
    private CouponAtomService couponAtomService;
    @Autowired
    private CouponCommAtomService couponCommAtomService;

    public RspPageBaseBO<CouponBO> listCouponPage(QryCouponPageReqBO reqBO) {
        List<CouponPO> pos;
        Page page = new Page(reqBO.getCurrent(), reqBO.getPageSize());
        CouponPO record = CouponPO.toCouponPO(reqBO);
        try {
            pos = this.couponDao.selectPage((Page<CouponPO>)page, record);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u7535\u5b50\u5238\u5931\u8d25\uff1a" + e.getMessage());
            return new RspPageBaseBO("0003", "\u5206\u9875\u67e5\u8be2\u7535\u5b50\u5238\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return new RspPageBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        ArrayList<CouponBO> bos = new ArrayList<CouponBO>(pos.size());
        if ("1".equals(reqBO.getIsBlankCouponShow())) {
            CouponBO bo = new CouponBO();
            bo.setCouponName("\u7a7a\u5238");
            bo.setCouponDesc("\u7a7a\u5238");
            bos.add(bo);
        }
        for (CouponPO po : pos) {
            CouponBO bo = po.toCouponBO();
            ConvertParamUtils.escapeCouponInfo(bo, this.qryEscapeAtomService, true);
            bos.add(bo);
        }
        return new RspPageBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", bos, page.getTotalCount(), page.getTotalPages());
    }

    public RspBaseTBO<CouponConfigDetailsBO> getCouponDetail(CouponBO reqBO) {
        if (null == reqBO.getCouponId()) {
            log.error("\u7535\u5b50\u5238ID\u4e3a\u7a7a");
            return new RspBaseTBO("0001", "\u7535\u5b50\u5238ID\u4e3a\u7a7a");
        }
        CouponBO couponBO = this.couponAtomService.qryCouponById(reqBO.getCouponId());
        if (null == couponBO) {
            log.error("\u7535\u5b50\u5238\u4e0d\u5b58\u5728");
            return new RspBaseTBO("0002", "\u7535\u5b50\u5238\u4e0d\u5b58\u5728");
        }
        ConvertParamUtils.escapeCouponInfo(couponBO, this.qryEscapeAtomService, true);
        CouponConfigDetailsBO rspBO = couponBO.toCouponConfigDetailsBO();
        this.getActCommObj(rspBO);
        return new RspBaseTBO("0000", "\u64cd\u4f5c\u6210\u529f", (Object)rspBO);
    }

    private void getActCommObj(CouponConfigDetailsBO rsp) {
        QryCouponCommReqAtomBO atomReqBO = new QryCouponCommReqAtomBO();
        HashSet<Long> couponIds = new HashSet<Long>(1);
        couponIds.add(rsp.getCouponId());
        atomReqBO.setCouponIds(couponIds);
        List<CouponCommodityBO> commodityBOS = this.couponCommAtomService.listByObjTypeAndId(atomReqBO);
        if (CollectionUtils.isEmpty(commodityBOS)) {
            return;
        }
        HashMap<String, Set<String>> commMap = new HashMap<String, Set<String>>(commodityBOS.size());
        ArrayList<ActConfigObjDetailsBO> shops = new ArrayList<ActConfigObjDetailsBO>(commodityBOS.size());
        for (CouponCommodityBO comm : commodityBOS) {
            if ("05".equals(comm.getObjType())) {
                ActConfigObjDetailsBO shop = new ActConfigObjDetailsBO();
                shop.setObjCode(comm.getObjCode());
                shops.add(shop);
                continue;
            }
            Set<String> codes = commMap.containsKey(comm.getObjType()) ? (Set)commMap.get(comm.getObjType()) : new HashSet(1);
            codes.add(comm.getObjCode());
            commMap.put(comm.getObjType(), codes);
        }
        if (MapUtils.isNotEmpty(commMap)) {
            List<ActConfigObjBO> objBOs = this.getObjDetails(commMap);
            rsp.setComms(objBOs);
        }
        if (CollectionUtils.isNotEmpty(shops)) {
            rsp.setShops(shops);
        }
    }

    private List<ActConfigObjBO> getObjDetails(Map<String, Set<String>> objMap) {
        ArrayList<ActConfigObjBO> objBOs = new ArrayList<ActConfigObjBO>(objMap.size());
        for (Map.Entry<String, Set<String>> map : objMap.entrySet()) {
            ActConfigObjBO objBO = new ActConfigObjBO();
            objBO.setObjType(map.getKey());
            ArrayList<ActConfigObjDetailsBO> details = new ArrayList<ActConfigObjDetailsBO>(map.getValue().size());
            for (String code : map.getValue()) {
                ActConfigObjDetailsBO detail = new ActConfigObjDetailsBO();
                detail.setObjCode(code);
                details.add(detail);
            }
            objBO.setDetails(details);
            objBOs.add(objBO);
        }
        return objBOs;
    }
}

