/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.CouponCommAtomService;
import com.tydic.newretail.act.bo.CouponCommodityBO;
import com.tydic.newretail.act.bo.CouponCommodityReqBO;
import com.tydic.newretail.act.bo.CouponCommodityRspBO;
import com.tydic.newretail.act.busi.QryCouponCommObjBusiService;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryCouponCommBusiServiceImpl
implements QryCouponCommObjBusiService {
    private static final Logger log = LoggerFactory.getLogger(QryCouponCommBusiServiceImpl.class);
    private static QryEscapeAtomService qryEscapeAtomService;
    @Autowired
    private CouponCommAtomService couponCommAtomService;

    @Resource(name="activityQryEscapeAtomService")
    public void setQryEscapeAtomService(QryEscapeAtomService qryEscapeAtomService) {
        QryCouponCommBusiServiceImpl.qryEscapeAtomService = qryEscapeAtomService;
    }

    public RspBatchBaseBO<CouponCommodityRspBO> listCuoponCommByCouponIdAndObjType(CouponCommodityReqBO reqBO) {
        this.checkParams(reqBO);
        CouponCommodityBO bo = new CouponCommodityBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)bo);
        List<CouponCommodityBO> list = this.couponCommAtomService.selectByCouponIdAndObjType(bo);
        if (CollectionUtils.isEmpty(list)) {
            log.error("\u672a\u67e5\u8be2\u5230\u4f18\u60e0\u5238\u5546\u54c1");
            return new RspBatchBaseBO("0002", "\u672a\u67e5\u8be2\u5230\u4f18\u60e0\u5238\u5546\u54c1");
        }
        ArrayList<CouponCommodityRspBO> rspList = new ArrayList<CouponCommodityRspBO>();
        for (CouponCommodityBO couponCommBO : list) {
            CouponCommodityRspBO rspComm = new CouponCommodityRspBO();
            BeanUtils.copyProperties((Object)couponCommBO, (Object)rspComm);
            rspList.add(rspComm);
        }
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", rspList);
    }

    private void checkParams(CouponCommodityReqBO reqBO) {
        if (null == reqBO) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getObjType())) {
            log.error("objType\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a");
            throw new ResourceException("0001", "objType\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (null == reqBO.getCouponId()) {
            log.error("\u4f18\u60e0\u5238id\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u4f18\u60e0\u5238id\u4e3a\u7a7a");
        }
    }
}

