/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.act.atom.ActCommAtomService;
import com.tydic.newretail.act.atom.ActInfoAtomService;
import com.tydic.newretail.act.atom.bo.QryActCommReqAtomBO;
import com.tydic.newretail.act.atom.bo.QryActReqAtomBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityCommodityBO;
import com.tydic.newretail.act.bo.QrySeckillRspBO;
import com.tydic.newretail.act.busi.QrySeckillBusiService;
import com.tydic.newretail.act.dao.ActivityDao;
import com.tydic.newretail.act.dao.po.ActivityPO;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseTBO;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QrySeckillBusiServiceImpl
implements QrySeckillBusiService {
    private static final Logger log = LoggerFactory.getLogger(QrySeckillBusiServiceImpl.class);
    @Autowired
    private ActInfoAtomService actInfoAtomService;
    @Resource(name="activityQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;
    @Autowired
    private ActCommAtomService actCommAtomService;
    @Autowired
    private ActivityDao activityDao;

    public RspBatchBaseBO<QrySeckillRspBO> listSeckill() {
        List<ActivityBO> acts = this.getSeckillActList();
        if (CollectionUtils.isEmpty(acts)) {
            return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        ArrayList<QrySeckillRspBO> rspList = new ArrayList<QrySeckillRspBO>(acts.size());
        Integer index = null;
        for (int i = 0; i < acts.size(); ++i) {
            ActivityBO act = acts.get(i);
            if (!"02".equals(act.getActivityStatus()) && !"01".equals(act.getActivityStatus())) continue;
            ConvertParamUtils.escaptAct(act, this.qryEscapeAtomService, false);
            QrySeckillRspBO rspBO = act.toQrySeckillRspBO();
            rspList.add(rspBO);
            if ("02".equals(act.getActivityStatus())) {
                List<ActivityCommodityBO> comms = this.getActComm(act.getActivityId());
                rspBO.setComms(comms);
            }
            index = i;
            break;
        }
        if (null == index) {
            int toindex = acts.size() > 4 ? 5 : acts.size();
            for (ActivityBO act : acts.subList(0, toindex)) {
                ConvertParamUtils.escaptAct(act, this.qryEscapeAtomService, false);
                rspList.add(act.toQrySeckillRspBO());
            }
        } else {
            int fromindex = index < acts.size() ? index + 1 : acts.size();
            int toindex = acts.size() >= fromindex + 2 ? fromindex + 2 : acts.size();
            for (ActivityBO act : acts.subList(fromindex, toindex)) {
                ConvertParamUtils.escaptAct(act, this.qryEscapeAtomService, false);
                rspList.add(act.toQrySeckillRspBO());
            }
            if (rspList.size() != 5) {
                toindex = index;
                fromindex = toindex > 5 - rspList.size() ? toindex - (5 - rspList.size()) : 0;
                for (ActivityBO act : acts.subList(fromindex, toindex)) {
                    ConvertParamUtils.escaptAct(act, this.qryEscapeAtomService, false);
                    rspList.add(act.toQrySeckillRspBO());
                }
            }
        }
        Collections.sort(rspList, new Comparator<QrySeckillRspBO>(){

            @Override
            public int compare(QrySeckillRspBO o1, QrySeckillRspBO o2) {
                return o1.getStartTime().compareTo(o2.getStartTime());
            }
        });
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", rspList);
    }

    public RspBaseTBO<QrySeckillRspBO> getSeckill() {
        QryActReqAtomBO atomBO = new QryActReqAtomBO();
        atomBO.setActivityType("01");
        HashSet<String> status = new HashSet<String>(1);
        status.add("02");
        atomBO.setActivityStatus(status);
        List<ActivityBO> rspList = this.actInfoAtomService.listActByType(atomBO);
        if (CollectionUtils.isEmpty(rspList)) {
            status.clear();
            status.add("01");
            rspList = this.actInfoAtomService.listActByType(atomBO);
        }
        if (CollectionUtils.isEmpty(rspList)) {
            return new RspBaseTBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        ActivityBO act = rspList.get(0);
        ConvertParamUtils.escaptAct(act, this.qryEscapeAtomService, false);
        QrySeckillRspBO rspBO = act.toQrySeckillRspBO();
        rspBO.setComms(this.getActComm(act.getActivityId()));
        return new RspBaseTBO("0000", "\u64cd\u4f5c\u6210\u529f", (Object)rspBO);
    }

    private List<ActivityCommodityBO> getActComm(Long activityId) {
        QryActCommReqAtomBO atomBO = new QryActCommReqAtomBO();
        HashSet<Long> actIds = new HashSet<Long>(1);
        actIds.add(activityId);
        HashSet<String> objTypes = new HashSet<String>(1);
        objTypes.add("99");
        atomBO.setActIds(actIds);
        atomBO.setObjTypes(objTypes);
        List<ActivityCommodityBO> comms = this.actCommAtomService.listCommByActIdAndObjTypes(atomBO);
        return comms;
    }

    private List<ActivityBO> getSeckillActList() {
        List<ActivityPO> pos;
        QryActReqAtomBO atomBO = new QryActReqAtomBO();
        Date startTime = TkDateUtils.getDate((Date)new Date(), (Integer)3);
        Date endTime = TkDateUtils.getDate((Date)new Date(), (Integer)-3);
        atomBO.setStartTime(startTime);
        atomBO.setEndDate(endTime);
        try {
            pos = this.activityDao.selectSeckill(atomBO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u79d2\u6740\u6d3b\u52a8\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u67e5\u8be2\u79d2\u6740\u6d3b\u52a8\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ActivityBO> rspList = new ArrayList<ActivityBO>(pos.size());
        for (ActivityPO po : pos) {
            rspList.add(po.toActivityBO());
        }
        Collections.sort(rspList, new Comparator<ActivityBO>(){

            @Override
            public int compare(ActivityBO o1, ActivityBO o2) {
                return o1.getStartTime().compareTo(o2.getStartTime());
            }
        });
        return rspList;
    }
}

