/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.tydic.newretail.act.ability.CouponInstanceAbilityService;
import com.tydic.newretail.act.atom.ActInfoAtomService;
import com.tydic.newretail.act.atom.ActParticipateAtomService;
import com.tydic.newretail.act.atom.ActivityBenefitAtomService;
import com.tydic.newretail.act.atom.CouponAtomService;
import com.tydic.newretail.act.atom.CouponInstanceAtomService;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityBenefitBO;
import com.tydic.newretail.act.bo.ActivityBenefitDistributeRecordBO;
import com.tydic.newretail.act.bo.ActivityParticipateRecordBO;
import com.tydic.newretail.act.bo.CouponBO;
import com.tydic.newretail.act.bo.CouponInstanceBO;
import com.tydic.newretail.act.bo.DistributeCouponAbilityReqBO;
import com.tydic.newretail.act.bo.DistributeCouponAbilityRspBO;
import com.tydic.newretail.act.bo.ShareCouponDistributeRspBO;
import com.tydic.newretail.act.bo.ShareCouponReqBO;
import com.tydic.newretail.act.bo.ShareCouponRspBO;
import com.tydic.newretail.act.bo.StaffPriceParticipateRecordBO;
import com.tydic.newretail.act.busi.ShareCouponBusiService;
import com.tydic.newretail.act.util.ConvertParamUtils;
import com.tydic.newretail.act.util.SortActUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseTBO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import com.tydic.umc.ability.UmcMemDetailQueryAbilityService;
import com.tydic.umc.ability.bo.UmcMemDetailQueryAbilityReqBO;
import com.tydic.umc.ability.bo.UmcMemDetailQueryAbilityRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShareCouponBusiServiceImpl
implements ShareCouponBusiService {
    private static final Logger log = LoggerFactory.getLogger(ShareCouponBusiServiceImpl.class);
    @Autowired
    QryEscapeAtomService qryEscapeAtomService;
    @Autowired
    UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;
    @Autowired
    CouponAtomService couponAtomService;
    @Autowired
    ActInfoAtomService actInfoAtomService;
    @Autowired
    ActivityBenefitAtomService activityBenefitAtomService;
    @Autowired
    private ActParticipateAtomService actParticipateAtomService;
    @Autowired
    private CouponInstanceAbilityService couponInstanceAbilityService;
    @Autowired
    private CouponInstanceAtomService couponInstanceAtomService;

    public RspBaseTBO<ShareCouponRspBO> queryShareCouponShare(ShareCouponReqBO reqBO) {
        this.checkParam(reqBO);
        ShareCouponRspBO result = new ShareCouponRspBO();
        this.qryUmcByUid(reqBO.getSharingId(), result);
        ActivityBO activityBO = new ActivityBO();
        activityBO.setActivityId(reqBO.getActivityId());
        ActivityBO activityRspBO = this.actInfoAtomService.getActivityInfo(activityBO);
        if (null == activityRspBO) {
            return new RspBaseTBO("0002", "\u6d3b\u52a8\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a-\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        result.setActivityName(activityRspBO.getActivityName());
        result.setAliasName(activityRspBO.getAliasName());
        ActivityBenefitBO activityBenefitBO = new ActivityBenefitBO();
        activityBenefitBO.setActivityId(activityRspBO.getActivityId());
        activityBenefitBO.setParam4("01");
        List<ActivityBenefitBO> activityBenefitBOList = this.activityBenefitAtomService.selectByCondition(activityBenefitBO);
        if (CollectionUtils.isEmpty(activityBenefitBOList)) {
            return new RspBaseTBO("0002", "\u6d3b\u52a8\u6743\u76ca\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a-\u8be5\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
        }
        HashSet<Long> couponIds = new HashSet<Long>();
        for (ActivityBenefitBO activityBenefitBo : activityBenefitBOList) {
            couponIds.add(Long.valueOf(activityBenefitBo.getParam1()));
        }
        List<CouponBO> couponBOList = this.couponAtomService.listCouponById(couponIds);
        if (CollectionUtils.isEmpty(couponBOList)) {
            return new RspBaseTBO("0002", "\u4f18\u60e0\u5238\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a-\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
        }
        for (CouponBO couponBO : couponBOList) {
            ConvertParamUtils.escapeCouponInfo(couponBO, this.qryEscapeAtomService, true);
        }
        result.setCouponBOS(couponBOList);
        return new RspBaseTBO("0000", "\u64cd\u4f5c\u6210\u529f", (Object)result);
    }

    public ShareCouponDistributeRspBO shareCouponReceive(ShareCouponReqBO reqBO) {
        this.checkParam(reqBO);
        if (null == reqBO.getSharedId()) {
            log.error("\u5206\u4eab\u9886\u5238--\u88ab\u5206\u4eab\u4ebaid\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5206\u4eab\u9886\u5238--\u88ab\u5206\u4eab\u4ebaid\u4e3a\u7a7a");
        }
        ActivityBO activityBO = new ActivityBO();
        activityBO.setActivityId(reqBO.getActivityId());
        ActivityBO activityRspBO = this.actInfoAtomService.getActivityInfo(activityBO);
        if (null == activityRspBO) {
            log.error("\u5206\u4eab\u9886\u5238\u9886\u53d6--\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u4fe1\u606f");
            return new ShareCouponDistributeRspBO("0002", "\u5206\u4eab\u9886\u5238\u9886\u53d6--\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u4fe1\u606f");
        }
        if (!"08".equals(activityRspBO.getActivityType())) {
            return new ShareCouponDistributeRspBO("0008", "\u5206\u4eab\u9886\u5238\u9886\u53d6--\u6682\u4e0d\u652f\u6301\u5f53\u524d\u6d3b\u52a8");
        }
        String remark = "\u5206\u4eab\u9886\u5238";
        String channel = "SHARE_CUOPON";
        ActivityBenefitBO activityBenefitBO = new ActivityBenefitBO();
        activityBenefitBO.setActivityId(activityRspBO.getActivityId());
        activityBenefitBO.setParam4("01");
        List<ActivityBenefitBO> activityBenefitBOList = this.activityBenefitAtomService.selectByCondition(activityBenefitBO);
        if (CollectionUtils.isEmpty(activityBenefitBOList)) {
            log.error("\u5206\u4eab\u9886\u5238\u9886\u53d6--\u672a\u67e5\u8be2\u5230\u5238\u9886\u53d6\u4fe1\u606f");
            return new ShareCouponDistributeRspBO("0002", "\u5206\u4eab\u9886\u5238\u9886\u53d6--\u672a\u67e5\u8be2\u5230\u5238\u9886\u53d6\u4fe1\u606f");
        }
        int partCount = this.checkNumOfParti(activityRspBO, reqBO);
        if (partCount != 0) {
            log.error("\u5206\u4eab\u9886\u5238\u9886\u53d6--\u8be5\u5238\u5df2\u9886\u53d6\uff0c\u4e0d\u53ef\u91cd\u590d\u9886\u53d6");
            return new ShareCouponDistributeRspBO("0012", "\u5206\u4eab\u9886\u5238\u9886\u53d6--\u8be5\u5238\u5df2\u9886\u53d6\uff0c\u4e0d\u53ef\u91cd\u590d\u9886\u53d6");
        }
        if (!this.saveActRecords(reqBO, activityRspBO).booleanValue()) {
            return new ShareCouponDistributeRspBO("9999", "\u5206\u4eab\u9886\u5238\u9886\u53d6--\u65b0\u589e\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5f02\u5e38");
        }
        ArrayList<ActivityBenefitBO> modifyBOs = new ArrayList<ActivityBenefitBO>(activityBenefitBOList.size());
        ArrayList<ActivityBenefitDistributeRecordBO> recordBOS = new ArrayList<ActivityBenefitDistributeRecordBO>(1);
        ArrayList<CouponInstanceBO> result = new ArrayList<CouponInstanceBO>();
        boolean successFlag = this.giftBenefit(activityBenefitBOList, recordBOS, modifyBOs, reqBO, channel, remark);
        this.modifyBeneFitRecord(recordBOS, modifyBOs);
        for (ActivityBenefitBO activityBenefitBo : activityBenefitBOList) {
            if (successFlag) {
                if (!"00".equals(activityBenefitBo.getBenefitType())) continue;
                CouponInstanceBO couponinstanceBO = this.getCouponInstance(Long.parseLong(activityBenefitBo.getParam1()), reqBO.getSharedId());
                ConvertParamUtils.escapeCoupon(couponinstanceBO, this.qryEscapeAtomService);
                result.add(couponinstanceBO);
                continue;
            }
            return new ShareCouponDistributeRspBO("9999", "\u9886\u53d6\u4eba" + reqBO.getSharedId() + "\u6b64\u6b21\u9886\u53d6\uff0c\u6d3e\u53d1\u6743\u76ca\u65f6\uff0c\u53d1\u653e\u5931\u8d25");
        }
        return new ShareCouponDistributeRspBO("0000", "\u9886\u53d6\u4eba" + reqBO.getSharedId() + "\u6b64\u6b21\u9886\u53d6\uff0c\u6d3e\u53d1\u6743\u76ca\u65f6\uff0c\u53d1\u653e\u6210\u529f\u67e5\u8be2\u7535\u5b50\u5238\u5b9e\u4f8b\u4fe1\u606f", result);
    }

    public ShareCouponDistributeRspBO shareCouponDistribute(ShareCouponReqBO reqBO) {
        this.checkParam(reqBO);
        ActivityBO activityBO = new ActivityBO();
        activityBO.setActivityId(reqBO.getActivityId());
        ActivityBO activityRspBO = this.actInfoAtomService.getActivityInfo(activityBO);
        if (null == activityRspBO) {
            log.error("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u4fe1\u606f");
            return new ShareCouponDistributeRspBO("0002", "\u5206\u4eab\u9886\u5238\u5206\u4eab--\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u4fe1\u606f");
        }
        if (!"08".equals(activityRspBO.getActivityType())) {
            return new ShareCouponDistributeRspBO("0008", "\u5206\u4eab\u9886\u5238\u5206\u4eab--\u6682\u4e0d\u652f\u6301\u5f53\u524d\u6d3b\u52a8");
        }
        String remark = "\u5206\u4eab\u9886\u5238";
        String channel = "SHARE_CUOPON";
        Date nowDate = new Date();
        if (null != activityRspBO.getStartTime() && nowDate.before(activityRspBO.getStartTime())) {
            log.error("\u6d3b\u52a8\u672a\u5f00\u59cb");
            return new ShareCouponDistributeRspBO("0021", "\u5206\u4eab\u9886\u5238\u5206\u4eab--\u6d3b\u52a8\u672a\u5f00\u59cb");
        }
        if (null != activityRspBO.getEndTime() && nowDate.after(activityRspBO.getEndTime())) {
            log.error("\u6d3b\u52a8\u5df2\u7ed3\u675f");
            return new ShareCouponDistributeRspBO("0022", "\u5206\u4eab\u9886\u5238\u5206\u4eab--\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
        if (!this.saveActRecords(reqBO, activityRspBO).booleanValue()) {
            return new ShareCouponDistributeRspBO("9999", "\u5206\u4eab\u9886\u5238\u5206\u4eab--\u65b0\u589e\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5f02\u5e38");
        }
        int partCount = this.checkNumOfParti(activityRspBO, reqBO);
        ActivityBenefitBO qryBenefitBO = new ActivityBenefitBO();
        qryBenefitBO.setActivityId(activityRspBO.getActivityId());
        qryBenefitBO.setParam4("00");
        qryBenefitBO.setCheckCount(Boolean.valueOf(false));
        List<ActivityBenefitBO> benefitBOS = this.activityBenefitAtomService.listBenefitByActId(qryBenefitBO);
        if (CollectionUtils.isEmpty(benefitBOS)) {
            log.error("\u5206\u4eab\u4eba" + reqBO.getSharingId() + "\u6b64\u6b21\u5206\u4eab\uff0c\u6d3e\u53d1\u6743\u76ca\u65f6\uff0c\u67e5\u8be2\u6743\u76ca\u8fd4\u56de\u4e3anull");
            return new ShareCouponDistributeRspBO("0000", "\u5206\u4eab\u4eba" + reqBO.getSharingId() + "\u6b64\u6b21\u5206\u4eab\uff0c\u6d3e\u53d1\u6743\u76ca\u65f6\uff0c\u67e5\u8be2\u6743\u76ca\u8fd4\u56de\u4e3anull");
        }
        ActivityBenefitBO activityBenefitBo = null;
        SortActUtils.sortActBenefitByPriority(benefitBOS);
        for (ActivityBenefitBO bo : benefitBOS) {
            if (partCount < Integer.valueOf(bo.getParam2())) continue;
            activityBenefitBo = bo;
        }
        if (null == activityBenefitBo) {
            log.error("\u5206\u4eab\u4eba" + reqBO.getSharingId() + "\u6b64\u6b21\u5206\u4eab\uff0c\u6d3e\u53d1\u6743\u76ca\u65f6\uff0c\u8fbe\u6807\u6743\u76ca\u4e3anull");
            return new ShareCouponDistributeRspBO("0000", "\u5206\u4eab\u4eba" + reqBO.getSharingId() + "\u6b64\u6b21\u5206\u4eab\uff0c\u6d3e\u53d1\u6743\u76ca\u65f6\uff0c\u8fbe\u6807\u6743\u76ca\u4e3anull");
        }
        if ("02".equals(activityRspBO.getParam4()) && partCount != Integer.parseInt(activityBenefitBo.getParam2())) {
            return new ShareCouponDistributeRspBO("0000", "\u5206\u4eab\u4eba" + reqBO.getSharingId() + "\u6b64\u6b21\u5206\u4eab\uff0c\u6d3e\u53d1\u6743\u76ca\u65f6\uff0c\u8fbe\u6807\u53d1\u653e\u65f6\uff0c\u4e0d\u7b26\u5408\u8fbe\u6807\u6b21\u6570");
        }
        ArrayList<ActivityBenefitBO> benes = new ArrayList<ActivityBenefitBO>(1);
        benes.add(activityBenefitBo);
        ArrayList<ActivityBenefitBO> modifyBOs = new ArrayList<ActivityBenefitBO>(benefitBOS.size());
        ArrayList<ActivityBenefitDistributeRecordBO> recordBOS = new ArrayList<ActivityBenefitDistributeRecordBO>(1);
        ArrayList<CouponInstanceBO> result = new ArrayList<CouponInstanceBO>();
        boolean successFlag = this.giftBenefit(benes, recordBOS, modifyBOs, reqBO, channel, remark);
        this.modifyBeneFitRecord(recordBOS, modifyBOs);
        if (successFlag) {
            if ("00".equals(activityBenefitBo.getBenefitType())) {
                CouponInstanceBO couponinstanceBO = this.getCouponInstance(Long.parseLong(activityBenefitBo.getParam1()), reqBO.getSharingId());
                ConvertParamUtils.escapeCoupon(couponinstanceBO, this.qryEscapeAtomService);
                result.add(couponinstanceBO);
                return new ShareCouponDistributeRspBO("0000", "\u5206\u4eab\u4eba" + reqBO.getSharingId() + "\u6b64\u6b21\u5206\u4eab\uff0c\u6d3e\u53d1\u6743\u76ca\u65f6\uff0c\u53d1\u653e\u6210\u529f\u7684\u67e5\u8be2\u7535\u5b50\u5238\u5b9e\u4f8b\u4fe1\u606f", result);
            }
        } else {
            return new ShareCouponDistributeRspBO("9999", "\u5206\u4eab\u4eba" + reqBO.getSharingId() + "\u6b64\u6b21\u5206\u4eab\uff0c\u6d3e\u53d1\u6743\u76ca\u65f6\uff0c\u53d1\u653e\u5931\u8d25");
        }
        return new ShareCouponDistributeRspBO("0000", "\u64cd\u4f5c\u6210\u529f", result);
    }

    private void checkParam(ShareCouponReqBO reqBO) {
        if (null == reqBO.getActivityId()) {
            log.error("\u5206\u4eab\u9886\u5238--\u6d3b\u52a8id\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5206\u4eab\u9886\u5238--\u6d3b\u52a8id\u4e3a\u7a7a");
        }
        if (null == reqBO.getSharingId()) {
            log.error("\u5206\u4eab\u9886\u5238--\u5206\u4eab\u4ebaid\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5206\u4eab\u9886\u5238--\u5206\u4eab\u4ebaid\u4e3a\u7a7a");
        }
    }

    private void qryUmcByUid(Long uId, ShareCouponRspBO result) {
        UmcMemDetailQueryAbilityReqBO po = new UmcMemDetailQueryAbilityReqBO();
        po.setMemId(uId);
        UmcMemDetailQueryAbilityRspBO rspPO = this.umcMemDetailQueryAbilityService.memDetailQuery(po);
        if ("0000".equals(rspPO.getRespCode()) && null != rspPO) {
            result.setMemNickName(rspPO.getUmcMemDetailInfoAbilityRspBO().getMemNickName());
            result.setHeadUrl(rspPO.getUmcMemDetailInfoAbilityRspBO().getHeadUrl());
            result.setSex(rspPO.getUmcMemDetailInfoAbilityRspBO().getSex());
            if (null != result.getSex()) {
                result.setSexStr(UmcEnumConstant.Sex.ofCode((Integer)result.getSex()).getName());
            }
        }
    }

    private int checkNumOfParti(ActivityBO activityBO, ShareCouponReqBO shareCouponReqBO) {
        if (StringUtils.isBlank((CharSequence)activityBO.getParam3())) {
            log.error("\u5206\u4eab\u9886\u5238\u6d3b\u52a8\u4fe1\u606f\u67e5\u8be2param3\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5206\u4eab\u9886\u5238--\u5206\u4eab\u4ebaid\u4e3a\u7a7a");
        }
        ActivityParticipateRecordBO reqBO = new ActivityParticipateRecordBO();
        reqBO.setActivityId(activityBO.getActivityId());
        if ("01".equals(activityBO.getParam3())) {
            reqBO.setbToday(Boolean.valueOf(true));
        }
        if ("00".equals(shareCouponReqBO.getParam1())) {
            reqBO.setUid(shareCouponReqBO.getSharingId());
            reqBO.setParam1(shareCouponReqBO.getParam1());
        } else if ("01".equals(shareCouponReqBO.getParam1())) {
            reqBO.setUid(shareCouponReqBO.getSharedId());
            reqBO.setParam2(shareCouponReqBO.getSharingId().toString());
            reqBO.setParam1(shareCouponReqBO.getParam1());
            reqBO.setbToday(Boolean.valueOf(false));
        }
        int partCount = this.actParticipateAtomService.getTotalCountByActIdAndUidAndParam1(reqBO);
        return partCount;
    }

    private Boolean saveActRecords(ShareCouponReqBO reqBO, ActivityBO activityBO) {
        ArrayList<StaffPriceParticipateRecordBO> records = new ArrayList<StaffPriceParticipateRecordBO>(1);
        StaffPriceParticipateRecordBO record = new StaffPriceParticipateRecordBO();
        if ("00".equals(reqBO.getParam1())) {
            record.setUid(reqBO.getSharingId());
        }
        if ("01".equals(reqBO.getParam1())) {
            record.setUid(reqBO.getSharedId());
            record.setParam2(String.valueOf(reqBO.getSharingId()));
        }
        record.setTenantId(activityBO.getTenantId());
        record.setActivityType(activityBO.getActivityType());
        record.setActivityId(activityBO.getActivityId());
        record.setParam1(reqBO.getParam1());
        record.setParticipateTime(new Date());
        records.add(record);
        try {
            this.actParticipateAtomService.saveActParticipateRecord(records);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            return false;
        }
        return true;
    }

    private ActivityBenefitDistributeRecordBO getBenefitRecord(ActivityBenefitBO benefit, Long uid, String remark) {
        ActivityBenefitDistributeRecordBO record = new ActivityBenefitDistributeRecordBO();
        record.setActivityBenefitId(benefit.getActivityBenefitId());
        record.setActivityId(benefit.getActivityId());
        record.setBenefitType(benefit.getBenefitType());
        record.setCrtTime(new Date());
        record.setDistCount(Integer.valueOf(1));
        if ("00".equals(benefit.getBenefitType())) {
            record.setBenefitObjId(Long.valueOf(benefit.getParam1()));
        }
        if ("01".equals(benefit.getBenefitType())) {
            record.setBenefitObjInstanceId(Long.valueOf(benefit.getParam1()));
        }
        record.setLastUpdTime(new Date());
        record.setTenantId(benefit.getTenantId());
        record.setTotalAmount(benefit.getAmountCount());
        record.setUid(uid);
        record.setRemark(remark);
        String status = "00";
        if (null != benefit.getAvailableCount() && benefit.getAvailableCount() < 1) {
            status = "02";
        }
        record.setDistStatus(status);
        return record;
    }

    private Long saveBenefitRecord(ActivityBenefitBO benefit, Long memId, String remark) {
        ArrayList<ActivityBenefitDistributeRecordBO> recordBOS = new ArrayList<ActivityBenefitDistributeRecordBO>(1);
        recordBOS.add(this.getBenefitRecord(benefit, memId, remark));
        List<ActivityBenefitDistributeRecordBO> rspList = null;
        try {
            rspList = this.activityBenefitAtomService.saveRecordBatch(recordBOS);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u6743\u76ca\u7684\u53d1\u653e\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            return null;
        }
        return rspList.get(0).getBenefitDistRecordId();
    }

    private void modifyBeneFitRecord(List<ActivityBenefitDistributeRecordBO> recordBOS, List<ActivityBenefitBO> modifyBOs) {
        if (CollectionUtils.isNotEmpty(modifyBOs)) {
            try {
                this.activityBenefitAtomService.modifyBatch(modifyBOs);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u66f4\u65b0\u6743\u76ca\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        if (CollectionUtils.isNotEmpty(recordBOS)) {
            try {
                this.activityBenefitAtomService.modifyRecordBatch(recordBOS);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u66f4\u65b0\u6743\u76ca\u53d1\u653e\u72b6\u6001\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    private boolean distributeCoupons(Long couponId, Long memId, String instanceId, int count, String channel, Long actId) {
        boolean disFlag = true;
        for (int i = 0; i < count; ++i) {
            ArrayList<Long> uids = new ArrayList<Long>(1);
            uids.add(memId);
            DistributeCouponAbilityReqBO disCouponReqBO = new DistributeCouponAbilityReqBO();
            disCouponReqBO.setCouponId(couponId);
            disCouponReqBO.setUserIds(uids);
            disCouponReqBO.setCouponSrcChannel(channel);
            disCouponReqBO.setCouponSrcInstance(instanceId);
            disCouponReqBO.setActivityId(actId);
            DistributeCouponAbilityRspBO rsp = null;
            try {
                rsp = this.couponInstanceAbilityService.distributeCoupon(disCouponReqBO);
            }
            catch (Exception e) {
                log.error("\u6d3e\u7535\u5b50\u5238\u5238\u5f02\u5e38\uff1a" + e.getMessage());
            }
            if (null != rsp && "0000".equals(rsp.getRespCode()) && !CollectionUtils.isNotEmpty((Collection)rsp.getFailList())) continue;
            disFlag = false;
        }
        return disFlag;
    }

    private boolean giftBenefit(List<ActivityBenefitBO> benefitBOS, List<ActivityBenefitDistributeRecordBO> recordBOS, List<ActivityBenefitBO> modifyBOs, ShareCouponReqBO reqBO, String channel, String remark) {
        boolean successFlag = true;
        for (ActivityBenefitBO benefit : benefitBOS) {
            if (!"00".equals(benefit.getBenefitType()) && !"01".equals(benefit.getBenefitType()) || StringUtils.isBlank((CharSequence)benefit.getParam1())) continue;
            int count = 1;
            if (StringUtils.isNotBlank((CharSequence)benefit.getParam3())) {
                count = Integer.parseInt(benefit.getParam3());
            }
            Long memId = 0L;
            if ("00".equals(reqBO.getParam1())) {
                memId = reqBO.getSharingId();
            }
            if ("01".equals(reqBO.getParam1())) {
                memId = reqBO.getSharedId();
            }
            Long recordId = 0L;
            if (null != benefit.getAvailableCount() && benefit.getAvailableCount() < 1) {
                remark = "\u6d3e\u53d1\u6743\u76ca\u65f6\uff0c\u6743\u76ca\u6570\u91cf\u4e0d\u8db3";
                recordId = this.saveBenefitRecord(benefit, memId, remark);
                continue;
            }
            recordId = this.saveBenefitRecord(benefit, memId, remark);
            if (null == recordId) {
                log.error("\u65b0\u589e\u6743\u76ca\u7684\u53d1\u653e\u8bb0\u5f55\u5931\u8d25");
                continue;
            }
            if ("00".equals(benefit.getBenefitType())) {
                successFlag = this.distributeCoupons(Long.parseLong(benefit.getParam1()), memId, benefit.getParam1(), count, channel, benefit.getActivityId());
            }
            ActivityBenefitDistributeRecordBO record = this.getModifyBenefitRecord(successFlag, recordId, benefit.getBenefitType());
            record.setBenefitObjId(Long.valueOf(Long.parseLong(benefit.getParam1())));
            recordBOS.add(record);
            if (!successFlag || null == benefit.getAvailableCount()) continue;
            benefit.setAvailableCount(Integer.valueOf(benefit.getAvailableCount() - count));
            modifyBOs.add(benefit);
        }
        return successFlag;
    }

    private ActivityBenefitDistributeRecordBO getModifyBenefitRecord(boolean disFlag, Long recordId, String benefitType) {
        ActivityBenefitDistributeRecordBO record = new ActivityBenefitDistributeRecordBO();
        record.setBenefitDistRecordId(recordId);
        record.setDistStatus("02");
        if ("00".equals(benefitType) && disFlag) {
            record.setDistStatus("01");
        }
        record.setLastUpdTime(new Date());
        return record;
    }

    private CouponInstanceBO getCouponInstance(long couponId, Long memId) {
        HashSet<Long> couponIds = new HashSet<Long>(1);
        couponIds.add(couponId);
        List<CouponInstanceBO> instanceBOS = this.couponInstanceAtomService.listInsByCouponIds(memId, couponIds);
        if (CollectionUtils.isEmpty(instanceBOS)) {
            return null;
        }
        return instanceBOS.get(0);
    }
}

