/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.act.bo.CouponUseAmountBO;
import com.tydic.newretail.act.bo.UseCouponBO;
import com.tydic.newretail.act.busi.UseCouponBusiService;
import com.tydic.newretail.act.dao.CouponInstanceDAO;
import com.tydic.newretail.act.dao.CouponUseRecordDAO;
import com.tydic.newretail.act.dao.po.CouponInstancePO;
import com.tydic.newretail.act.dao.po.CouponUseRecordPO;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UseCouponBusiServiceImpl
implements UseCouponBusiService {
    private static final Logger log = LoggerFactory.getLogger(UseCouponBusiServiceImpl.class);
    @Autowired
    private CouponInstanceDAO couponInstanceDAO;
    @Autowired
    private CouponUseRecordDAO couponUseRecordDAO;

    public RspBaseBO changeUseCoupon(List<UseCouponBO> useCouponBOs) {
        RspBaseBO result = new RspBaseBO();
        this.validataParams(useCouponBOs, result);
        if (null != result.getRespCode() && "0001".equals(result.getRespCode())) {
            return result;
        }
        try {
            ArrayList<CouponInstancePO> couponInstanceUpdates = new ArrayList<CouponInstancePO>();
            ArrayList<CouponUseRecordPO> couponUseRecordPOs = new ArrayList<CouponUseRecordPO>();
            for (UseCouponBO useCouponBO : useCouponBOs) {
                CouponInstancePO couponInstancePO = this.couponInstanceDAO.selectByPrimaryKey(useCouponBO.getCouponInstanceId());
                if (null == couponInstancePO) {
                    log.error("\u4f18\u60e0\u5238\u5b9e\u4f8b\u3010" + useCouponBO.getCouponInstanceId() + "\u3011\u4e0d\u5b58\u5728");
                    throw new BusinessException("0002", "\u4f18\u60e0\u5238\u5b9e\u4f8b\u3010" + useCouponBO.getCouponInstanceId() + "\u3011\u4e0d\u5b58\u5728");
                }
                if ("1".equals(couponInstancePO.getUseStatus()) || "3".equals(couponInstancePO.getUseStatus())) {
                    log.error("\u4f18\u60e0\u5238\u5b9e\u4f8b\u3010" + useCouponBO.getCouponInstanceId() + "\u3011\u72b6\u6001\u4e3a\u5df2\u4f7f\u7528\u6216\u5df2\u8fc7\u671f,\u4e0d\u53ef\u4f7f\u7528");
                    throw new BusinessException("0010", "\u4f18\u60e0\u5238\u5b9e\u4f8b\u3010" + useCouponBO.getCouponInstanceId() + "\u3011\u72b6\u6001\u4e3a\u5df2\u4f7f\u7528\u6216\u5df2\u8fc7\u671f,\u4e0d\u53ef\u4f7f\u7528");
                }
                if ("01".equals(couponInstancePO.getCouponType()) && null != couponInstancePO.getTotalAmount() && useCouponBO.getThisAmount() > couponInstancePO.getTotalAmount()) {
                    log.error("\u5f53\u524d\u989d\u5ea6\u5927\u4e8e\u53ef\u7528\u603b\u989d\uff0c\u4e0d\u53ef\u6d88\u52b5");
                    throw new BusinessException("0013", "\u4f18\u60e0\u5238\u5b9e\u4f8b\u3010" + useCouponBO.getCouponInstanceId() + "\u3011\u5f53\u524d\u989d\u5ea6\u5927\u4e8e\u53ef\u7528\u603b\u989d\uff0c\u4e0d\u53ef\u6d88\u52b5");
                }
                CouponInstancePO couponInstanceUpdate = new CouponInstancePO();
                couponInstanceUpdate.setUsedAmount(useCouponBO.getThisAmount());
                couponInstanceUpdate.setUsedTimes(1);
                couponInstanceUpdate.setUseStatus("1");
                couponInstanceUpdate.setLastUseTime(new Date());
                couponInstanceUpdate.setCouponInstanceId(useCouponBO.getCouponInstanceId());
                couponInstanceUpdates.add(couponInstanceUpdate);
                CouponUseRecordPO couponUseRecordPO = new CouponUseRecordPO();
                couponUseRecordPO.setCouponInstanceId(useCouponBO.getCouponInstanceId());
                couponUseRecordPO.setTenantId(couponInstancePO.getTenantId());
                couponUseRecordPO.setUid(couponInstancePO.getUid());
                couponUseRecordPO.setBenefitAmount(useCouponBO.getThisAmount());
                couponUseRecordPO.setUseType("01");
                couponUseRecordPO.setUseTime(new Date());
                couponUseRecordPO.setUseChannel(useCouponBO.getUseChannel());
                couponUseRecordPO.setUseChannelInstance(useCouponBO.getUseChannelInstance());
                couponUseRecordPOs.add(couponUseRecordPO);
            }
            this.couponInstanceDAO.updateComputationsBatch(couponInstanceUpdates);
            this.couponUseRecordDAO.insertBatch(couponUseRecordPOs);
            result.setRespCode("0000");
            result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u4f18\u60e0\u5238\u4f7f\u7528\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        return result;
    }

    private void validataParams(List<UseCouponBO> useCouponBOs, RspBaseBO result) {
        for (UseCouponBO useCouponBO : useCouponBOs) {
            if (null == useCouponBO.getUseChannelInstance()) {
                log.error("\u6d88\u52b5\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u5b9e\u4f8bID\u4e3a\u7a7a");
                result.setRespCode("0001");
                result.setRespDesc("\u5165\u53c2\u4f18\u60e0\u5238\u5b9e\u4f8bID\u4e3a\u7a7a");
                return;
            }
            if (null != useCouponBO.getThisAmount()) continue;
            log.error("\u6d88\u52b5\u670d\u52a1\u5165\u53c2\u989d\u5ea6\u4e3a\u7a7a");
            result.setRespCode("0001");
            result.setRespDesc("\u5165\u53c2\u989d\u5ea6\u4e3a\u7a7a");
            return;
        }
    }

    public RspBaseBO changeReturnUseCoupon(List<UseCouponBO> useCouponBOs) {
        RspBaseBO result = new RspBaseBO();
        this.validataParams(useCouponBOs, result);
        if (null != result.getRespCode() && "0001".equals(result.getRespCode())) {
            return result;
        }
        try {
            ArrayList<CouponInstancePO> couponInstanceUpdates = new ArrayList<CouponInstancePO>();
            ArrayList<CouponUseRecordPO> couponUseRecordPOs = new ArrayList<CouponUseRecordPO>();
            for (UseCouponBO useCouponBO : useCouponBOs) {
                Long totalReturnAmount;
                CouponInstancePO couponInstancePO = this.couponInstanceDAO.selectByPrimaryKey(useCouponBO.getCouponInstanceId());
                if (null == couponInstancePO) {
                    log.error("\u4f18\u60e0\u5238\u5b9e\u4f8b\u3010" + useCouponBO.getCouponInstanceId() + "\u3011\u4e0d\u5b58\u5728");
                    throw new BusinessException("0002", "\u4f18\u60e0\u5238\u5b9e\u4f8b\u3010" + useCouponBO.getCouponInstanceId() + "\u3011\u4e0d\u5b58\u5728");
                }
                if (!"1".equals(couponInstancePO.getUseStatus())) {
                    log.error("\u4f18\u60e0\u5238\u5b9e\u4f8b\u3010" + useCouponBO.getCouponInstanceId() + "\u3011\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u8fd4\u9500");
                    throw new BusinessException("0010", "\u4f18\u60e0\u5238\u5b9e\u4f8b\u3010" + useCouponBO.getCouponInstanceId() + "\u3011\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u8fd4\u9500");
                }
                CouponUseRecordPO amountReqPO = new CouponUseRecordPO();
                amountReqPO.setUseType("01");
                amountReqPO.setCouponInstanceId(useCouponBO.getCouponInstanceId());
                CouponUseAmountBO usedCouponUseAmountBO = this.couponUseRecordDAO.selectAmountByType(amountReqPO);
                Long totalUsedAmount = 0L;
                if (null != usedCouponUseAmountBO) {
                    totalUsedAmount = usedCouponUseAmountBO.getTotalAmount();
                }
                amountReqPO.setUseType("02");
                CouponUseAmountBO usedCouponUseAmountBO1 = this.couponUseRecordDAO.selectAmountByType(amountReqPO);
                Long totalReturnedAmount = 0L;
                if (null != usedCouponUseAmountBO1) {
                    totalReturnedAmount = usedCouponUseAmountBO1.getTotalAmount();
                }
                if ((totalReturnAmount = Long.valueOf(totalReturnedAmount + useCouponBO.getThisAmount())) > totalUsedAmount) {
                    log.error("\u8fd4\u9500\u603b\u989d\u5927\u4e8e\u5df2\u4f7f\u7528\u603b\u989d\uff0c\u4e0d\u53ef\u8fd4\u9500");
                    throw new BusinessException("0013", "\u4f18\u60e0\u5238\u5b9e\u4f8b\u3010" + useCouponBO.getCouponInstanceId() + "\u3011\u8fd4\u9500\u603b\u989d\u5927\u4e8e\u5df2\u4f7f\u7528\u603b\u989d\uff0c\u4e0d\u53ef\u8fd4\u9500");
                }
                CouponInstancePO couponInstanceUpdate = new CouponInstancePO();
                couponInstanceUpdate.setUsedAmount(-useCouponBO.getThisAmount().longValue());
                if (totalReturnAmount.equals(totalUsedAmount)) {
                    couponInstanceUpdate.setUseStatus("0");
                    if (null != couponInstancePO.getEndTime() && couponInstancePO.getEndTime().before(new Date())) {
                        couponInstanceUpdate.setUseStatus("3");
                    }
                }
                couponInstanceUpdate.setCouponInstanceId(useCouponBO.getCouponInstanceId());
                couponInstanceUpdates.add(couponInstanceUpdate);
                CouponUseRecordPO couponUseRecordPO = new CouponUseRecordPO();
                couponUseRecordPO.setCouponInstanceId(useCouponBO.getCouponInstanceId());
                couponUseRecordPO.setTenantId(couponInstancePO.getTenantId());
                couponUseRecordPO.setUid(couponInstancePO.getUid());
                couponUseRecordPO.setBenefitAmount(useCouponBO.getThisAmount());
                couponUseRecordPO.setUseType("02");
                couponUseRecordPO.setUseTime(new Date());
                couponUseRecordPO.setUseChannel(useCouponBO.getUseChannel());
                couponUseRecordPO.setUseChannelInstance(useCouponBO.getUseChannelInstance());
                couponUseRecordPOs.add(couponUseRecordPO);
            }
            this.couponInstanceDAO.updateComputationsBatch(couponInstanceUpdates);
            this.couponUseRecordDAO.insertBatch(couponUseRecordPOs);
            result.setRespCode("0000");
            result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u4f18\u60e0\u5238\u8fd4\u9500\u63a5\u53e3\u51fa\u9519\uff1a", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        return result;
    }
}

