/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.act.atom.ActUserAtomService;
import com.tydic.newretail.act.bo.QryUserSetReqBO;
import com.tydic.newretail.act.bo.UserInstanceBO;
import com.tydic.newretail.act.bo.UserInstanceSetBO;
import com.tydic.newretail.act.bo.UserSetBO;
import com.tydic.newretail.act.bo.UserSetInstanceBO;
import com.tydic.newretail.act.busi.UserSetManageBusiService;
import com.tydic.newretail.act.dao.UserSetDao;
import com.tydic.newretail.act.dao.po.UserSetPO;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserSetManageBusiServiceImpl
implements UserSetManageBusiService {
    private static final Logger log = LoggerFactory.getLogger(UserSetManageBusiServiceImpl.class);
    @Autowired
    private UserSetDao userSetDao;
    @Autowired
    private ActUserAtomService actUserAtomService;

    public RspPageBaseBO<UserSetBO> listUserSetByPage(QryUserSetReqBO reqBO) {
        List<UserSetPO> userSetPOS;
        Page page = new Page(reqBO.getCurrent(), reqBO.getPageSize());
        UserSetPO record = new UserSetPO();
        record.setSetName(reqBO.getSetName());
        try {
            userSetPOS = this.userSetDao.selectByPage((Page<UserSetPO>)page, record);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u7528\u6237\u96c6\u5931\u8d25\uff1a" + e.getMessage());
            return new RspPageBaseBO("0003", "\u67e5\u8be2\u7528\u6237\u96c6\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(userSetPOS)) {
            return new RspPageBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        ArrayList<UserSetBO> userSetBOS = new ArrayList<UserSetBO>(userSetPOS.size());
        for (UserSetPO po : userSetPOS) {
            userSetBOS.add(po.toUserSetBO());
        }
        return new RspPageBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", userSetBOS, page.getTotalCount(), page.getTotalPages());
    }

    public RspBaseBO saveUserSet(UserSetInstanceBO reqBO) {
        if (null == reqBO.getmTenantId()) {
            reqBO.setmTenantId(Long.valueOf(0L));
        }
        reqBO.setTenantId(reqBO.getmTenantId());
        this.actUserAtomService.saveUserSet(reqBO);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO modifyUserSet(UserSetInstanceBO reqBO) {
        if (null == reqBO.getmTenantId()) {
            reqBO.setmTenantId(Long.valueOf(0L));
        }
        reqBO.setTenantId(reqBO.getmTenantId());
        if (null == reqBO.getUserSetId()) {
            log.error("\u7528\u6237\u96c6ID\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u7528\u6237\u96c6ID\u4e3a\u7a7a");
        }
        UserSetBO userSetBO = this.actUserAtomService.getUserSet(reqBO.getUserSetId());
        if (null == userSetBO) {
            log.error("\u7528\u6237\u96c6\u4e0d\u5b58\u5728");
            return new RspBaseBO("0002", "\u7528\u6237\u96c6\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSetName())) {
            userSetBO.setSetName(reqBO.getSetName());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSetType())) {
            userSetBO.setSetType(reqBO.getSetType());
        }
        userSetBO.setSetDesc(reqBO.getSetDesc());
        userSetBO.setRemark(reqBO.getRemark());
        userSetBO.setSource(reqBO.getSource());
        userSetBO.setSourceParamer(reqBO.getSourceParamer());
        this.actUserAtomService.modifyUserSet(userSetBO);
        this.actUserAtomService.removeUserInstance(reqBO.getUserSetId());
        this.actUserAtomService.saveUserInstance(reqBO);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBatchBaseBO<UserInstanceSetBO> listInstanceBySetId(UserInstanceBO reqBO) {
        if (null == reqBO.getUserSetId()) {
            log.error("\u7528\u6237\u96c6ID\u4e3a\u7a7a");
            return new RspBatchBaseBO("0001", "\u7528\u6237\u96c6ID\u4e3a\u7a7a");
        }
        UserSetBO userSetBO = this.actUserAtomService.getUserSet(reqBO.getUserSetId());
        if (null == userSetBO) {
            log.error("\u7528\u6237\u96c6\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
            return new RspBatchBaseBO("0002", "\u7528\u6237\u96c6\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        List<UserInstanceSetBO> list = this.actUserAtomService.listUserInstance(reqBO.getUserSetId());
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", list);
    }

    public RspBaseBO removeUserSet(UserSetInstanceBO reqBO) {
        if (null == reqBO.getUserSetId()) {
            log.error("\u7528\u6237\u96c6ID\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u7528\u6237\u96c6ID\u4e3a\u7a7a");
        }
        UserSetBO userSetBO = new UserSetBO();
        userSetBO.setUserSetId(reqBO.getUserSetId());
        userSetBO.setValidFlag("0");
        this.actUserAtomService.modifyUserSet(userSetBO);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }
}

