/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.consumer;

import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.newretail.act.ability.ActParticipationAbilityService;
import com.tydic.newretail.act.bo.ActParticipationReqBO;
import com.tydic.newretail.toolkit.util.TkJsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ActParticipationConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(ActParticipationConsumer.class);
    @Autowired
    private ActParticipationAbilityService actParticipationAbilityService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        ActParticipationReqBO reqBO;
        if (StringUtils.isBlank((CharSequence)proxyMessage.getContent())) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        try {
            reqBO = (ActParticipationReqBO)TkJsonUtils.jsonStringToObject((String)proxyMessage.getContent(), ActParticipationReqBO.class);
        }
        catch (Exception e) {
            log.error("\u53c2\u6570\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        if ("00".equals(reqBO.getOperType())) {
            try {
                this.actParticipationAbilityService.participeAct(reqBO);
            }
            catch (Exception e) {
                log.error("\u6d3b\u52a8\u53c2\u4e0e\u5f02\u5e38\uff1a" + e.getMessage());
                return ProxyConsumerStatus.RECONSUME_LATER;
            }
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        try {
            this.actParticipationAbilityService.cancelAct(reqBO);
        }
        catch (Exception e) {
            log.error("\u6d3b\u52a8\u53d6\u6d88\u5f02\u5e38\uff1a" + e.getMessage());
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

