/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.util;

import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.newretail.act.bo.ActConfigBO;
import com.tydic.newretail.act.bo.ActConfigCommDetailBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityBenefitBO;
import com.tydic.newretail.act.bo.CouponBO;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CheckParamUtils {
    private static final Logger log = LoggerFactory.getLogger(CheckParamUtils.class);
    private static final String POSITIVE_INTEGER_AND_FLOAT_WITHOUT_ZERO = "([1-9]\\d*(\\.\\d*[0-9])?)|(0\\.\\d*[0-9])";
    private static OrderSequence orderSequence;
    private static Integer instantRebatePri;
    private static Integer noThThresholdPri;
    private static Integer discountPri;

    @Value(value="${COUPON_PRIORITY_INSTANT_REBATE:200}")
    public void setInstantRebatePri(Integer instantRebatePri) {
        CheckParamUtils.instantRebatePri = instantRebatePri;
    }

    @Value(value="${COUPON_PRIORITY_NO_THRESHOLD:100}")
    public void setNoThThresholdPri(Integer noThThresholdPri) {
        CheckParamUtils.noThThresholdPri = noThThresholdPri;
    }

    @Value(value="${COUPON_PRIORITY_DISCOUNT:300}")
    public void setDiscountPri(Integer discountPri) {
        CheckParamUtils.discountPri = discountPri;
    }

    @Resource(name="actCodeSequence")
    public void setOrderSequence(OrderSequence orderSequence) {
        CheckParamUtils.orderSequence = orderSequence;
    }

    public static void checkActParams(ActivityBO activityBO, ActConfigBO configBO) {
        String prefix = "";
        switch (activityBO.getActivityType()) {
            case "00": {
                CheckParamUtils.checkFullReduceParams(activityBO);
                String fullPrice = CheckParamUtils.priceTrans(activityBO.getParam1());
                String discountPrice = CheckParamUtils.priceTrans(activityBO.getParam2());
                activityBO.setParam1(fullPrice);
                activityBO.setParam2(discountPrice);
                prefix = "InstantRebate";
                break;
            }
            case "01": {
                if (StringUtils.isBlank((CharSequence)activityBO.getActivityName())) {
                    activityBO.setActivityName("\u79d2\u6740");
                }
                CheckParamUtils.checkCommParams(configBO, true);
                prefix = "Seckill";
                break;
            }
            case "02": {
                CheckParamUtils.checkMemPriceParams(activityBO);
                activityBO.setParam1("ACTPUR+(ACTSALE-ACTPUR)*" + activityBO.getParam1());
                activityBO.setParam2("ACTPUR+(ACTSALE-ACTPUR)*" + activityBO.getParam2());
                activityBO.setParam3("ACTPUR+(ACTSALE-ACTPUR)*" + activityBO.getParam3());
                prefix = "MemPrice";
                break;
            }
            case "03": {
                CheckParamUtils.checkStaffPriceParams(activityBO);
                CheckParamUtils.checkCommParams(configBO, false);
                activityBO.setParam1("ACTPUR+(ACTSALE-ACTPUR)*" + activityBO.getParam1());
                prefix = "StaffPrice";
                break;
            }
            case "05": {
                prefix = "ScratchCard";
                CheckParamUtils.checkScratchCardParams(activityBO, configBO);
                activityBO.setUsefulObjType("01");
                break;
            }
            case "07": {
                prefix = "07";
                CheckParamUtils.checkScratchCardParams(activityBO, configBO);
                activityBO.setUsefulObjType("01");
                break;
            }
            case "08": {
                prefix = "08";
                CheckParamUtils.checkShareCouponParams(activityBO, configBO);
                activityBO.setUsefulObjType("01");
                break;
            }
            case "06": {
                if (null != activityBO.getParam1() && !Pattern.matches("^[1-9]\\d*$", activityBO.getParam1())) {
                    log.error("\u5355\u6b21\u53d1\u653e\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
                    TkThrExceptionUtils.thrFormatExce((String)"\u5355\u6b21\u53d1\u653e\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
                }
                CheckParamUtils.checkPayGiftParams(activityBO, configBO);
                prefix = "PayGift";
                activityBO.setUsefulObjType("01");
                break;
            }
            case "04": {
                if (null != activityBO.getParam1() && !Pattern.matches("^[1-9]\\d*$", activityBO.getParam1())) {
                    log.error("\u5355\u6b21\u53d1\u653e\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
                    TkThrExceptionUtils.thrFormatExce((String)"\u5355\u6b21\u53d1\u653e\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
                }
                CheckParamUtils.checkActBenefit(configBO);
                prefix = "RegGift";
                activityBO.setUsefulObjType("01");
                break;
            }
            case "09": {
                CheckParamUtils.checkActBenefit(configBO);
                CheckParamUtils.checkFullPresentParams(activityBO);
                String fullPriceBy = CheckParamUtils.priceTrans(activityBO.getParam1());
                activityBO.setParam1(fullPriceBy);
                prefix = "fullPresent";
                activityBO.setUsefulObjType("01");
                break;
            }
            case "10": {
                CheckParamUtils.checkActBenefit(configBO);
                prefix = "presentSaleSingle";
                activityBO.setUsefulObjType("01");
                break;
            }
            case "11": {
                prefix = "globalOpen";
                activityBO.setUsefulObjType("01");
                break;
            }
            case "12": {
                prefix = "reduceSaleSingle";
                activityBO.setUsefulObjType("01");
                break;
            }
        }
        try {
            activityBO.setActivityCode(prefix + orderSequence.nextId());
        }
        catch (SQLException e) {
            log.error("\u83b7\u53d6\u6d3b\u52a8\u7f16\u7801\u5e8f\u5217\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrQryExce((String)"\u83b7\u53d6\u6d3b\u52a8\u7f16\u7801\u5e8f\u5217\u5931\u8d25");
        }
        if (TkDateUtils.isEffectiveDate((Date)new Date(), (Date)activityBO.getStartTime(), (Date)activityBO.getEndTime())) {
            activityBO.setActivityStatus("02");
        } else if (null != activityBO.getAdvanceNoticeTime() && TkDateUtils.isEffectiveDate((Date)new Date(), (Date)activityBO.getAdvanceNoticeTime(), (Date)activityBO.getEndTime())) {
            activityBO.setActivityStatus("01");
        }
    }

    private static void checkPayGiftParams(ActivityBO activityBO, ActConfigBO configBO) {
        if (StringUtils.isNotBlank((CharSequence)activityBO.getParam2()) && !Pattern.matches("^[1-9]\\d*$", activityBO.getParam2())) {
            log.error("\u7528\u6237\u6743\u76ca\u53d1\u653e\u4e0a\u9650\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
            TkThrExceptionUtils.thrFormatExce((String)"\u7528\u6237\u6743\u76ca\u53d1\u653e\u4e0a\u9650\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
        }
        if (StringUtils.isNotBlank((CharSequence)activityBO.getParam1()) && !Pattern.matches("^[1-9]\\d*$", activityBO.getParam1())) {
            log.error("\u5355\u6b21\u6743\u76ca\u53d1\u653e\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
            TkThrExceptionUtils.thrFormatExce((String)"\u5355\u6b21\u6743\u76ca\u53d1\u653e\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
        }
        if (StringUtils.isBlank((CharSequence)activityBO.getActivityName())) {
            activityBO.setActivityName("\u652f\u4ed8\u6709\u793c");
        }
        CheckParamUtils.checkActBenefit(configBO);
    }

    private static void checkActBenefit(ActConfigBO configBO) {
        if (CollectionUtils.isEmpty((Collection)configBO.getBenefitDetails())) {
            log.error("\u6d3b\u52a8\u6743\u76ca\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8\u6743\u76ca\u4e3a\u7a7a");
        }
        block8: for (ActivityBenefitBO details : configBO.getBenefitDetails()) {
            switch (configBO.getActivityType()) {
                case "09": {
                    if (StringUtils.isBlank((CharSequence)details.getParam2())) {
                        // empty if block
                    }
                    if (!StringUtils.isBlank((CharSequence)details.getParam1())) continue block8;
                    TkThrExceptionUtils.thrEmptyExce((String)"\u6743\u76ca\u5bf9\u8c61ID\u4e3a\u7a7a");
                    continue block8;
                }
                case "10": {
                    if (StringUtils.isBlank((CharSequence)details.getParam2())) {
                        TkThrExceptionUtils.thrEmptyExce((String)"\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                    }
                    if (!StringUtils.isBlank((CharSequence)details.getParam1())) break;
                    TkThrExceptionUtils.thrEmptyExce((String)"\u6743\u76ca\u5bf9\u8c61ID\u4e3a\u7a7a");
                }
            }
            if (null != details.getAmountCount() && details.getAmountCount() <= 0) {
                log.error("\u7535\u5b50\u5238\u53d1\u653e\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
                TkThrExceptionUtils.thrFormatExce((String)"\u7535\u5b50\u5238\u53d1\u653e\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
            }
            if (null == details.getParam3()) {
                details.setParam3("1");
            }
            if (null != details.getParam2()) continue;
            details.setParam2("0");
        }
    }

    private static void checkShareCouponParams(ActivityBO activityBO, ActConfigBO configBO) {
        if (StringUtils.isBlank((CharSequence)activityBO.getParam3())) {
            activityBO.setParam3("01");
        }
        if (StringUtils.isBlank((CharSequence)activityBO.getParam4())) {
            activityBO.setParam4("01");
        }
        if (StringUtils.isBlank((CharSequence)activityBO.getParam5())) {
            log.error("\u6d3b\u52a8\u5206\u4eab\u6587\u5b57Param5\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8\u5206\u4eab\u6587\u5b57Param5\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)activityBO.getParam6())) {
            log.error("\u6d3b\u52a8\u5206\u4eab\u56fe\u7247Param6\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8\u5206\u4eab\u56fe\u7247Param6\u4e3a\u7a7a");
        }
        if (CollectionUtils.isNotEmpty((Collection)configBO.getBenefitDetails())) {
            for (ActivityBenefitBO activityBenefitBO : configBO.getBenefitDetails()) {
                if (StringUtils.isBlank((CharSequence)activityBenefitBO.getParam4())) {
                    log.error("\u6d3b\u52a8\u5206\u4eab\u4eba\u7c7b\u578b\u4e3a\u7a7a");
                    TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8\u5206\u4eab\u4eba\u7c7b\u578b\u4e3a\u7a7a");
                }
                if ("00".equals(activityBenefitBO.getParam4())) {
                    if (StringUtils.isBlank((CharSequence)activityBenefitBO.getParam2())) {
                        log.error("\u8fbe\u6807\u6b21\u6570\u4e3a\u7a7a");
                        TkThrExceptionUtils.thrEmptyExce((String)"\u8fbe\u6807\u6b21\u6570\u4e3a\u7a7a");
                    }
                    if (null != activityBenefitBO.getParam2() && !Pattern.matches("^[1-9]\\d*$", activityBenefitBO.getParam2())) {
                        log.error("\u8fbe\u6807\u6b21\u6570\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
                        TkThrExceptionUtils.thrFormatExce((String)"\u8fbe\u6807\u6b21\u6570\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
                    }
                }
                if (StringUtils.isBlank((CharSequence)activityBenefitBO.getParam3())) {
                    activityBenefitBO.setParam3("1");
                }
                if (null != activityBenefitBO.getParam3() && !Pattern.matches("^[1-9]\\d*$", activityBenefitBO.getParam3())) {
                    log.error("\u5355\u6b21\u53d1\u653e\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
                    TkThrExceptionUtils.thrFormatExce((String)"\u5355\u6b21\u53d1\u653e\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
                }
                if (!StringUtils.isBlank((CharSequence)activityBenefitBO.getParam1())) continue;
                log.error("\u4f18\u60e0\u5238id\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u4f18\u60e0\u5238id\u4e3a\u7a7a");
            }
        }
    }

    private static void checkScratchCardParams(ActivityBO activityBO, ActConfigBO configBO) {
        if (CollectionUtils.isEmpty((Collection)configBO.getBenefitDetails())) {
            log.error("\u6d3b\u52a8\u6743\u76ca\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8\u6743\u76ca\u4e3a\u7a7a");
        }
        for (ActivityBenefitBO details : configBO.getBenefitDetails()) {
            if (null != details.getAmountCount() && details.getAmountCount() <= 0) {
                log.error("\u7535\u5b50\u5238\u53d1\u653e\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
                TkThrExceptionUtils.thrFormatExce((String)"\u7535\u5b50\u5238\u53d1\u653e\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
            }
            if (null == details.getWeight()) {
                log.error("\u6743\u91cd\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u6743\u91cd\u4e3a\u7a7a");
            }
            if (null != details.getParam3()) continue;
            details.setParam3("1");
        }
        if (StringUtils.isNotBlank((CharSequence)activityBO.getParam2()) && !Pattern.matches("^[1-9]\\d*$", activityBO.getParam2())) {
            log.error("\u7528\u6237\u6743\u76ca\u53d1\u653e\u4e0a\u9650\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
            TkThrExceptionUtils.thrFormatExce((String)"\u7528\u6237\u6743\u76ca\u53d1\u653e\u4e0a\u9650\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570");
        }
        if (StringUtils.isBlank((CharSequence)activityBO.getActivityName())) {
            activityBO.setActivityName("\u522e\u522e\u5361/\u8f6c\u76d8\u62bd\u5956/\u5206\u4eab\u9886\u5238");
        }
    }

    private static void checkStaffPriceParams(ActivityBO activityBO) {
        CheckParamUtils.checkDiscount("\u5185\u8d2d\u4ef7", activityBO.getParam1());
        if (StringUtils.isBlank((CharSequence)activityBO.getActivityName())) {
            activityBO.setActivityName("\u5185\u8d2d\u4ef7");
        }
    }

    private static void checkMemPriceParams(ActivityBO activityBO) {
        if (StringUtils.isBlank((CharSequence)activityBO.getParam1()) || StringUtils.isBlank((CharSequence)activityBO.getParam2()) || StringUtils.isBlank((CharSequence)activityBO.getParam3())) {
            log.error("\u4f1a\u5458\u4ef7\u4f18\u60e0\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u4f1a\u5458\u4ef7\u4f18\u60e0\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(Pattern.matches("([1-9]\\d*(\\.\\d*[1-9])?)|(0\\.\\d*[1-9])", activityBO.getParam1()) && Pattern.matches("([1-9]\\d*(\\.\\d*[1-9])?)|(0\\.\\d*[1-9])", activityBO.getParam2()) && Pattern.matches("([1-9]\\d*(\\.\\d*[1-9])?)|(0\\.\\d*[1-9])", activityBO.getParam3()))) {
            log.error("\u4f1a\u5458\u4ef7\u4f18\u60e0\u7387\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570\u6216\u6d6e\u70b9\u6570");
            TkThrExceptionUtils.thrFormatExce((String)"\u4f1a\u5458\u4ef7\u4f18\u60e0\u7387\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570\u6216\u6d6e\u70b9\u6570");
        }
        if (StringUtils.isBlank((CharSequence)activityBO.getActivityName())) {
            activityBO.setActivityName("\u4f1a\u5458\u4ef7");
        }
    }

    private static void checkFullReduceParams(ActivityBO activityBO) {
        CheckParamUtils.checkPrice("\u95e8\u69db\u91d1\u989d", activityBO.getParam1());
        CheckParamUtils.checkPrice("\u4f18\u60e0\u91d1\u989d", activityBO.getParam2());
        if (StringUtils.isBlank((CharSequence)activityBO.getActivityName())) {
            activityBO.setActivityName("\u6ee1" + activityBO.getParam1() + "\u51cf" + activityBO.getParam2());
        }
    }

    private static void checkFullPresentParams(ActivityBO activityBO) {
        CheckParamUtils.checkPrice("\u95e8\u69db\u91d1\u989d", activityBO.getParam1());
    }

    private static void checkCommParams(ActConfigBO reqBO, boolean isSeckill) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommDetails())) {
            log.error("\u6d3b\u52a8\u5546\u54c1\u5bf9\u8c61\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8\u5546\u54c1\u5bf9\u8c61\u4e3a\u7a7a");
        }
        for (ActConfigCommDetailBO act : reqBO.getCommDetails()) {
            if (null != act.getShopId() || StringUtils.isNotBlank((CharSequence)act.getPurchaseType()) || null != act.getClassTypeId() || StringUtils.isNotBlank((CharSequence)act.getBrand())) {
                log.error("\u4ec5\u652f\u6301\u914d\u7f6eskuId");
                TkThrExceptionUtils.thrTypeExec((String)"\u4ec5\u652f\u6301\u914d\u7f6eskuId");
            }
            if (null == act.getSkuId()) {
                log.error("skuId\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"skuId\u4e3a\u7a7a");
            }
            if (!isSeckill || null != act.getActPrice()) continue;
            log.error("\u9650\u65f6\u8d2d\u4ef7\u683c\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u9650\u65f6\u8d2d\u4ef7\u683c\u4e3a\u7a7a");
        }
    }

    public static void checkCouponParams(CouponBO couponBO) {
        switch (couponBO.getCouponType()) {
            case "01": {
                CheckParamUtils.checkPrice("\u95e8\u69db\u91d1\u989d", couponBO.getParam1());
                CheckParamUtils.checkPrice("\u4f18\u60e0\u91d1\u989d", couponBO.getParam2());
                couponBO.setParam1(CheckParamUtils.priceTrans(couponBO.getParam1()));
                couponBO.setParam2(CheckParamUtils.priceTrans(couponBO.getParam2()));
                couponBO.setPriority(instantRebatePri);
                break;
            }
            case "00": {
                CheckParamUtils.checkPrice("\u4f18\u60e0\u91d1\u989d", couponBO.getParam2());
                couponBO.setParam2(CheckParamUtils.priceTrans(couponBO.getParam2()));
                couponBO.setPriority(noThThresholdPri);
                break;
            }
            case "02": {
                CheckParamUtils.checkPrice("\u95e8\u69db\u91d1\u989d", couponBO.getParam1());
            }
            case "03": {
                CheckParamUtils.checkDiscount("\u6298\u6263\u5238", couponBO.getParam2());
                if (StringUtils.isNotBlank((CharSequence)couponBO.getParam1())) {
                    CheckParamUtils.checkPriceFormat("\u95e8\u69db\u91d1\u989d", couponBO.getParam1());
                    couponBO.setParam1(CheckParamUtils.priceTrans(couponBO.getParam1()));
                }
                couponBO.setPriority(discountPri);
                break;
            }
            default: {
                log.error("\u7535\u5b50\u5238\u7c7b\u578b\u9519\u8bef");
                TkThrExceptionUtils.thrFormatExce((String)"\u7535\u5b50\u5238\u7c7b\u578b\u9519\u8bef");
            }
        }
    }

    private static void checkPrice(String desc, String price) {
        if (StringUtils.isBlank((CharSequence)price)) {
            log.error(desc + "\u4e0d\u80fd\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)(desc + "\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        CheckParamUtils.checkPriceFormat(desc, price);
    }

    private static void checkPriceFormat(String desc, String price) {
        if (!Pattern.matches(POSITIVE_INTEGER_AND_FLOAT_WITHOUT_ZERO, price)) {
            log.error(desc + "\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570\u6216\u6d6e\u70b9\u6570");
            TkThrExceptionUtils.thrFormatExce((String)(desc + "\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6b63\u6574\u6570\u6216\u6d6e\u70b9\u6570"));
        }
    }

    private static void checkDiscount(String desc, String param1) {
        if (StringUtils.isBlank((CharSequence)param1)) {
            log.error(desc + "\u4f18\u60e0\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)(desc + "\u4f18\u60e0\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (!Pattern.matches("^(?:0\\.\\d+|[01](?:\\.0)?)$", param1)) {
            log.error(desc + "\u4f18\u60e0\u7387\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5c0f\u4e8e\u7b49\u4e8e1\u7684\u6b63\u6570");
            TkThrExceptionUtils.thrFormatExce((String)(desc + "\u4f18\u60e0\u7387\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5c0f\u4e8e\u7b49\u4e8e1\u7684\u6b63\u6570"));
        }
    }

    private static String priceTrans(String priceStr) {
        String price = new BigDecimal(priceStr).multiply(new BigDecimal("10000")).setScale(0, 4).toString();
        return price;
    }

    private static void checkDiscountRate(String discountRate, String desc) {
        if (!discountRate.matches("[0-9]+") && Integer.parseInt(discountRate) > 0 && Integer.parseInt(discountRate) < 100) {
            log.error(desc + "\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u4e14\u5c0f\u4e8e100\u7684\u6574\u6570");
            TkThrExceptionUtils.thrFormatExce((String)(desc + "\u683c\u5f0f\u9519\u8bef\uff1a\u5fc5\u987b\u4e3a\u5927\u4e8e0\u4e14\u5c0f\u4e8e100\u7684\u6574\u6570"));
        }
    }

    public static void checkCommParam(List<ActConfigCommDetailBO> commDetailBOS, String actType) {
        for (ActConfigCommDetailBO bo : commDetailBOS) {
            if ("11".equals(actType) && (StringUtils.isNotBlank((CharSequence)bo.getMaterial()) || StringUtils.isNotBlank((CharSequence)bo.getProvinceCommodity())) && StringUtils.isBlank((CharSequence)bo.getProvinceCode())) {
                if (StringUtils.isBlank((CharSequence)bo.getSilverCard()) || StringUtils.isBlank((CharSequence)bo.getGoldCard()) || StringUtils.isBlank((CharSequence)bo.getPlatinumCard()) || StringUtils.isBlank((CharSequence)bo.getDiamondCard())) {
                    TkThrExceptionUtils.thrEmptyExce((String)"\u5404\u4e2a\u5361\u6863\u673a\u578b\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    CheckParamUtils.checkPriceFormat("\u94f6\u5361\u6863\u673a\u578b\u4ef7\u683c", bo.getSilverCard());
                    bo.setSilverCard(CheckParamUtils.priceTrans(bo.getSilverCard()));
                    CheckParamUtils.checkPriceFormat("\u91d1\u5361\u6863\u673a\u578b\u4ef7\u683c", bo.getGoldCard());
                    bo.setGoldCard(CheckParamUtils.priceTrans(bo.getGoldCard()));
                    CheckParamUtils.checkPriceFormat("\u767d\u91d1\u5361\u6863\u673a\u578b\u4ef7\u683c", bo.getPlatinumCard());
                    bo.setPlatinumCard(CheckParamUtils.priceTrans(bo.getPlatinumCard()));
                    CheckParamUtils.checkPriceFormat("\u94bb\u77f3\u5361\u6863\u673a\u578b\u4ef7\u683c", bo.getDiamondCard());
                    bo.setDiamondCard(CheckParamUtils.priceTrans(bo.getDiamondCard()));
                }
            }
            if (!"12".equals(actType) || !StringUtils.isNotBlank((CharSequence)bo.getMaterial()) && !StringUtils.isNotBlank((CharSequence)bo.getProvinceCommodity()) || !StringUtils.isBlank((CharSequence)bo.getProvinceCode())) continue;
            if (StringUtils.isBlank((CharSequence)bo.getSilverCard()) && StringUtils.isBlank((CharSequence)bo.getGoldCard()) && StringUtils.isBlank((CharSequence)bo.getPlatinumCard())) {
                TkThrExceptionUtils.thrEmptyExce((String)"\u6d3b\u52a8\u4ef7\u3001\u6298\u6263\u7387\u3001\u4f18\u60e0\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getSilverCard())) {
                CheckParamUtils.checkPriceFormat("\u6d3b\u52a8\u4ef7", bo.getSilverCard());
                bo.setSilverCard(CheckParamUtils.priceTrans(bo.getSilverCard()));
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getGoldCard())) {
                CheckParamUtils.checkDiscountRate(bo.getGoldCard(), "\u6298\u6263\u7387");
                bo.setGoldCard(new BigDecimal(Float.parseFloat(bo.getGoldCard()) / 100.0f).setScale(2, 4).toString());
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)bo.getPlatinumCard())) continue;
            CheckParamUtils.checkPriceFormat("\u4f18\u60e0\u91d1\u989d", bo.getPlatinumCard());
            bo.setPlatinumCard(CheckParamUtils.priceTrans(bo.getPlatinumCard()));
        }
    }

    public static void main(String[] args) throws ParseException {
        String s = "0.25";
        System.out.println();
    }
}

