/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.act.util;

import com.tydic.newretail.act.bo.ActCommInfoBO;
import com.tydic.newretail.act.bo.ActivityBO;
import com.tydic.newretail.act.bo.ActivityCombinationInfoBO;
import com.tydic.newretail.act.bo.ActivityCommodityBO;
import com.tydic.newretail.act.bo.ActivityCommodityPoolInfoBO;
import com.tydic.newretail.act.bo.ActivityCommodityRspBO;
import com.tydic.newretail.act.bo.ActivityCostInfoBO;
import com.tydic.newretail.act.bo.ActivityReservoirInfoBO;
import com.tydic.newretail.act.bo.CouponBO;
import com.tydic.newretail.act.bo.CouponInstanceBO;
import com.tydic.newretail.act.bo.CouponPriceDetailBO;
import com.tydic.newretail.act.bo.GiftBO;
import com.tydic.newretail.act.bo.GiftInstanceBO;
import com.tydic.newretail.act.dao.po.ActivityBenefitDistributeRecordPO;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.util.TkCalculatorUtils;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertParamUtils {
    private static final Logger log = LoggerFactory.getLogger(ConvertParamUtils.class);

    public static void setPrice(ActCommInfoBO reqBO, Double disPrice, Double disAmount) {
        reqBO.setSkuDisPrice(Double.valueOf(new BigDecimal(disPrice.toString()).subtract(new BigDecimal(disAmount.toString())).doubleValue()));
        reqBO.setSkuDisPriceL(TkCalculatorUtils.transfetL((double)reqBO.getSkuDisPrice()));
        if (null != reqBO.getSkuDisAmount()) {
            disAmount = TkCalculatorUtils.add((BigDecimal)new BigDecimal(reqBO.getSkuDisAmount().toString()), (BigDecimal)new BigDecimal(disAmount.toString())).doubleValue();
        }
        reqBO.setSkuDisAmount(disAmount);
    }

    public static void setPrice(ActCommInfoBO reqBO, Long disPrice, Long disAmount) {
        double disPriceD = TkCalculatorUtils.transferY((long)disPrice);
        double disAmountD = TkCalculatorUtils.transferY((long)disAmount);
        ConvertParamUtils.setPrice(reqBO, disPriceD, disAmountD);
    }

    public static void escapePrice(ActCommInfoBO comm) {
        try {
            if (null != comm.getSalePrice()) {
                comm.setSalePrice(TkCalculatorUtils.setScale((double)comm.getSalePrice(), (int)2));
                comm.setSalePriceL(TkCalculatorUtils.transfetL((double)comm.getSalePrice()));
            } else if (null != comm.getSalePriceL()) {
                comm.setSalePrice(TkCalculatorUtils.transferY((long)comm.getSalePriceL()));
                comm.setSalePriceL(TkCalculatorUtils.transfetL((double)comm.getSalePrice()));
            }
            if (null != comm.getSkuNewPrice()) {
                comm.setSkuNewPrice(TkCalculatorUtils.setScale((double)comm.getSkuNewPrice(), (int)2));
                comm.setSkuNewPriceL(TkCalculatorUtils.transfetL((double)comm.getSkuNewPrice()));
            } else if (null != comm.getSkuNewPriceL()) {
                comm.setSkuNewPrice(TkCalculatorUtils.transferY((long)comm.getSkuNewPriceL()));
                comm.setSkuNewPriceL(TkCalculatorUtils.transfetL((double)comm.getSkuNewPrice()));
            }
            if (null != comm.getPurchasePrice()) {
                comm.setPurchasePrice(TkCalculatorUtils.setScale((double)comm.getPurchasePrice(), (int)2));
                comm.setPurchasePriceL(TkCalculatorUtils.transfetL((double)comm.getPurchasePrice()));
            } else if (null != comm.getPurchasePriceL()) {
                comm.setPurchasePrice(TkCalculatorUtils.transferY((long)comm.getPurchasePriceL()));
                comm.setPurchasePriceL(TkCalculatorUtils.transfetL((double)comm.getPurchasePrice()));
            }
            if (null != comm.getSkuDisPrice()) {
                comm.setSkuDisPrice(TkCalculatorUtils.setScale((double)comm.getSkuDisPrice(), (int)2));
                comm.setSkuDisPriceL(TkCalculatorUtils.transfetL((double)comm.getSkuDisPrice()));
            } else if (null != comm.getSkuDisPriceL()) {
                comm.setSkuDisPrice(TkCalculatorUtils.transferY((long)comm.getSkuDisPriceL()));
                comm.setSkuDisPriceL(TkCalculatorUtils.transfetL((double)comm.getSkuDisPrice()));
            }
            if (null != comm.getMemPrice()) {
                comm.setMemPrice(TkCalculatorUtils.setScale((double)comm.getMemPrice(), (int)2));
                comm.setMemPriceL(TkCalculatorUtils.transfetL((double)comm.getSkuDisPrice()));
            } else if (null != comm.getMemPriceL()) {
                comm.setMemPrice(TkCalculatorUtils.transferY((long)comm.getMemPriceL()));
                comm.setMemPriceL(TkCalculatorUtils.transfetL((double)comm.getSkuDisPrice()));
            }
            if (null != comm.getSkuDisAmount()) {
                comm.setSkuDisAmount(TkCalculatorUtils.setScale((double)comm.getSkuDisAmount(), (int)2));
                comm.setSkuDisAmountL(TkCalculatorUtils.transfetL((double)comm.getSkuDisAmount()));
            } else if (null != comm.getSkuDisAmountL()) {
                comm.setSkuDisAmount(TkCalculatorUtils.transferY((long)comm.getSkuDisAmountL()));
                comm.setSkuDisAmountL(TkCalculatorUtils.transfetL((double)comm.getSkuDisAmount()));
            }
            if (null != comm.getSkuDisTotalAmount()) {
                comm.setSkuDisTotalAmount(TkCalculatorUtils.setScale((double)comm.getSkuDisTotalAmount(), (int)2));
                comm.setSkuDisTotalAmountL(TkCalculatorUtils.transfetL((double)comm.getSkuDisTotalAmount()));
            } else if (null != comm.getSkuDisTotalAmountL()) {
                comm.setSkuDisTotalAmount(TkCalculatorUtils.transferY((long)comm.getSkuDisTotalAmountL()));
                comm.setSkuDisTotalAmountL(TkCalculatorUtils.transfetL((double)comm.getSkuDisTotalAmount()));
            }
            if (null != comm.getSkuDisTotalPrice()) {
                comm.setSkuDisTotalPrice(TkCalculatorUtils.setScale((double)comm.getSkuDisTotalPrice(), (int)2));
                comm.setSkuDisTotalPriceL(TkCalculatorUtils.transfetL((double)comm.getSkuDisTotalPrice()));
            } else if (null != comm.getSkuDisTotalPriceL()) {
                comm.setSkuDisTotalPrice(TkCalculatorUtils.transferY((long)comm.getSkuDisTotalPriceL()));
                comm.setSkuDisTotalPriceL(TkCalculatorUtils.transfetL((double)comm.getSkuDisTotalPrice()));
            }
            if (null != comm.getGradePriceA()) {
                comm.setGradePriceA(TkCalculatorUtils.setScale((double)comm.getGradePriceA(), (int)2));
                comm.setGradePriceAL(TkCalculatorUtils.transfetL((double)comm.getGradePriceA()));
            } else if (null != comm.getGradePriceAL()) {
                comm.setGradePriceA(TkCalculatorUtils.transferY((long)comm.getGradePriceAL()));
                comm.setGradePriceAL(TkCalculatorUtils.transfetL((double)comm.getGradePriceA()));
            }
            if (null != comm.getGradePriceB()) {
                comm.setGradePriceB(TkCalculatorUtils.setScale((double)comm.getGradePriceB(), (int)2));
                comm.setGradePriceBL(TkCalculatorUtils.transfetL((double)comm.getGradePriceB()));
            } else if (null != comm.getGradePriceBL()) {
                comm.setGradePriceB(TkCalculatorUtils.transferY((long)comm.getGradePriceBL()));
                comm.setGradePriceBL(TkCalculatorUtils.transfetL((double)comm.getGradePriceB()));
            }
            if (null != comm.getGradePriceC()) {
                comm.setGradePriceC(TkCalculatorUtils.setScale((double)comm.getGradePriceC(), (int)2));
                comm.setGradePriceCL(TkCalculatorUtils.transfetL((double)comm.getGradePriceC()));
            } else if (null != comm.getGradePriceCL()) {
                comm.setGradePriceC(TkCalculatorUtils.transferY((long)comm.getGradePriceCL()));
                comm.setGradePriceCL(TkCalculatorUtils.transfetL((double)comm.getGradePriceC()));
            }
            if (null != comm.getGradePriceD()) {
                comm.setGradePriceD(TkCalculatorUtils.setScale((double)comm.getGradePriceD(), (int)2));
                comm.setGradePriceDL(TkCalculatorUtils.transfetL((double)comm.getGradePriceD()));
            } else if (null != comm.getGradePriceDL()) {
                comm.setGradePriceD(TkCalculatorUtils.transferY((long)comm.getGradePriceDL()));
                comm.setGradePriceDL(TkCalculatorUtils.transfetL((double)comm.getGradePriceD()));
            }
            if (CollectionUtils.isEmpty((Collection)comm.getCouponPrices())) {
                return;
            }
            for (CouponPriceDetailBO detailBO : comm.getCouponPrices()) {
                if (null == detailBO.getDisAmount()) continue;
                detailBO.setDisAmount(TkCalculatorUtils.setScale((double)detailBO.getDisAmount(), (int)2));
                detailBO.setDisAmountL(TkCalculatorUtils.transfetL((double)detailBO.getDisAmount()));
            }
        }
        catch (Exception e) {
            log.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static void escapeCoupon(CouponInstanceBO instanceBO, QryEscapeAtomService qryEscapeAtomService) {
        String couponTypeStr;
        if (null != instanceBO.getStartTime()) {
            instanceBO.setStartTimeStr(TkDateUtils.formatDate((Date)instanceBO.getStartTime(), (String)"yyyy-MM-dd"));
        }
        if (null != instanceBO.getEndTime()) {
            instanceBO.setEndTimeStr(TkDateUtils.formatDate((Date)instanceBO.getEndTime(), (String)"yyyy-MM-dd"));
        }
        if (null != instanceBO.getTotalAmountL()) {
            instanceBO.setTotalAmount(new BigDecimal(instanceBO.getTotalAmountL()).divide(new BigDecimal("10000"), 2, 1));
        }
        instanceBO.setCouponTypeStr(StringUtils.isBlank((CharSequence)(couponTypeStr = qryEscapeAtomService.getCodeTitle("COUPON_TYPE_NAME", instanceBO.getCouponType()))) ? "\u672a\u5b9a\u4e49" : couponTypeStr);
        String stateStr = qryEscapeAtomService.getCodeTitle("COUPON_STATE_NAME", instanceBO.getUseStatus());
        instanceBO.setUseStatusStr(StringUtils.isBlank((CharSequence)stateStr) ? "\u672a\u5b9a\u4e49" : stateStr);
        instanceBO.setExpireDay(Integer.valueOf(TkDateUtils.diffDay((Date)instanceBO.getStartTime(), (Date)instanceBO.getEndTime())));
        if (("02".equals(instanceBO.getCouponType()) || "03".equals(instanceBO.getCouponType())) && StringUtils.isNotBlank((CharSequence)instanceBO.getParam2())) {
            instanceBO.setDiscountRate(TkCalculatorUtils.muliti((BigDecimal)new BigDecimal(instanceBO.getParam2()), (BigDecimal)new BigDecimal("100")).setScale(0, 1).toString());
        }
    }

    public static void escapeCouponInfo(CouponBO couponBO, QryEscapeAtomService qryEscapeAtomService, boolean showFlag) {
        String couponTypeStr;
        if (null != couponBO.getStartTime()) {
            couponBO.setStartTimeStr(TkDateUtils.formatDate((Date)couponBO.getStartTime(), (String)"yyyy-MM-dd"));
        }
        if (null != couponBO.getEndTime()) {
            couponBO.setEndTimeStr(TkDateUtils.formatDate((Date)couponBO.getEndTime(), (String)"yyyy-MM-dd"));
        }
        if (null != couponBO.getUsefulStartTime()) {
            couponBO.setUsefulStartTimeStr(TkDateUtils.formatDate((Date)couponBO.getUsefulStartTime(), (String)"yyyy-MM-dd"));
        }
        if (null != couponBO.getUsefulEndTime()) {
            couponBO.setUsefulEndTimeStr(TkDateUtils.formatDate((Date)couponBO.getUsefulEndTime(), (String)"yyyy-MM-dd"));
        }
        if (null != couponBO.getCrtTime()) {
            couponBO.setCrtTimeStr(TkDateUtils.formatDate((Date)couponBO.getCrtTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        couponBO.setCouponTypeStr(StringUtils.isBlank((CharSequence)(couponTypeStr = qryEscapeAtomService.getCodeTitle("COUPON_TYPE_NAME", couponBO.getCouponType()))) ? "\u672a\u5b9a\u4e49" : couponTypeStr);
        String couponStatusStr = qryEscapeAtomService.getCodeTitle("COUPON_STATUS_NAME", couponBO.getCouponStatus());
        couponBO.setCouponStatusStr(StringUtils.isBlank((CharSequence)couponStatusStr) ? "\u672a\u5b9a\u4e49" : couponStatusStr);
        if (!showFlag) {
            return;
        }
        switch (couponBO.getCouponType()) {
            case "01": {
                if (StringUtils.isNotBlank((CharSequence)couponBO.getParam1())) {
                    couponBO.setParam1(TkCalculatorUtils.transferY((String)couponBO.getParam1()));
                }
                if (!StringUtils.isNotBlank((CharSequence)couponBO.getParam2())) break;
                couponBO.setParam2(TkCalculatorUtils.transferY((String)couponBO.getParam2()));
                break;
            }
            case "00": {
                if (!StringUtils.isNotBlank((CharSequence)couponBO.getParam2())) break;
                couponBO.setParam2(TkCalculatorUtils.transferY((String)couponBO.getParam2()));
                break;
            }
            case "02": 
            case "03": {
                if (!StringUtils.isNotBlank((CharSequence)couponBO.getParam1())) break;
                couponBO.setParam1(TkCalculatorUtils.transferY((String)couponBO.getParam1()));
                break;
            }
        }
    }

    public static void escaptAct(ActivityBO act, QryEscapeAtomService qryEscapeAtomService, boolean showFlag) {
        String actTypeStr;
        String format = "MM-dd";
        if (showFlag) {
            format = "yyyy-MM-dd";
        }
        if (null != act.getStartTime()) {
            act.setStartTimeStr(TkDateUtils.formatDate((Date)act.getStartTime(), (String)format));
        }
        if (null != act.getEndTime()) {
            act.setEndTimeStr(TkDateUtils.formatDate((Date)act.getEndTime(), (String)format));
        }
        if (null != act.getAdvanceNoticeTime()) {
            act.setAdvanceNoticeTimeStr(TkDateUtils.formatDate((Date)act.getAdvanceNoticeTime(), (String)format));
        }
        act.setActivityTypeStr(StringUtils.isBlank((CharSequence)(actTypeStr = qryEscapeAtomService.getCodeTitle("ACT_TYPE_NAME", act.getActivityType()))) ? "\u672a\u5b9a\u4e49" : actTypeStr);
        String statusStr = qryEscapeAtomService.getCodeTitle("ACT_STATUS_NAME", act.getActivityStatus());
        act.setActivityStatusStr(StringUtils.isBlank((CharSequence)statusStr) ? "\u672a\u5b9a\u4e49" : statusStr);
        String saleTypeStr = qryEscapeAtomService.getCodeTitle("APPLY_SALES_TYPE", act.getSaleType());
        act.setSaleTypeStr(StringUtils.isBlank((CharSequence)saleTypeStr) ? "\u672a\u5b9a\u4e49" : saleTypeStr);
        String activityInsideTypeStr = qryEscapeAtomService.getCodeTitle("ACT_INSIDE_TYPE_NAME", act.getActivityInsideType());
        act.setActivityInsideTypeStr(StringUtils.isBlank((CharSequence)activityInsideTypeStr) ? "\u672a\u5b9a\u4e49" : activityInsideTypeStr);
        if (!showFlag) {
            return;
        }
        switch (act.getActivityType()) {
            case "00": {
                if (StringUtils.isNotBlank((CharSequence)act.getParam1())) {
                    act.setParam1(TkCalculatorUtils.transferY((String)act.getParam1()));
                }
                if (!StringUtils.isNotBlank((CharSequence)act.getParam2())) break;
                act.setParam2(TkCalculatorUtils.transferY((String)act.getParam2()));
                break;
            }
            case "09": {
                if (StringUtils.isNotBlank((CharSequence)act.getParam1())) {
                    act.setParam1(TkCalculatorUtils.transferY((String)act.getParam1()));
                }
            }
            case "02": {
                if (StringUtils.isNotBlank((CharSequence)act.getParam1())) {
                    act.setParam1(act.getParam1().replace("ACTPUR+(ACTSALE-ACTPUR)*", ""));
                }
                if (StringUtils.isNotBlank((CharSequence)act.getParam2())) {
                    act.setParam2(act.getParam2().replace("ACTPUR+(ACTSALE-ACTPUR)*", ""));
                }
                if (!StringUtils.isNotBlank((CharSequence)act.getParam3())) break;
                act.setParam3(act.getParam3().replace("ACTPUR+(ACTSALE-ACTPUR)*", ""));
                break;
            }
            case "03": {
                if (!StringUtils.isNotBlank((CharSequence)act.getParam1())) break;
                act.setParam1(act.getParam1().replace("ACTPUR+(ACTSALE-ACTPUR)*", ""));
                break;
            }
        }
    }

    public static void escaptActCom(ActivityCommodityBO actComm, ActivityCommodityRspBO rspComm, QryEscapeAtomService qryEscapeAtomService) {
        String actTypeStr;
        String format = "MM-dd";
        if (null != actComm.getStartTime()) {
            rspComm.setStartTimeStr(TkDateUtils.formatDate((Date)actComm.getStartTime(), (String)format));
        }
        if (null != actComm.getEndTime()) {
            rspComm.setEndTimeStr(TkDateUtils.formatDate((Date)actComm.getEndTime(), (String)format));
        }
        if (null != actComm.getAdvanceNoticeTime()) {
            rspComm.setAdvanceNoticeTimeStr(TkDateUtils.formatDate((Date)actComm.getAdvanceNoticeTime(), (String)format));
        }
        rspComm.setActivityTypeStr(StringUtils.isBlank((CharSequence)(actTypeStr = qryEscapeAtomService.getCodeTitle("ACT_TYPE_NAME", actComm.getActivityType()))) ? "\u672a\u5b9a\u4e49" : actTypeStr);
    }

    public static void escaptGiftInfo(GiftBO giftBO, QryEscapeAtomService qryEscapeAtomService) {
        String giftTypeStr;
        String format = "yyyy-MM-dd HH:mm:ss";
        if (null != giftBO.getCrtTime()) {
            giftBO.setCrtTimeStr(TkDateUtils.formatDate((Date)giftBO.getCrtTime(), (String)format));
        }
        if (null != giftBO.getLastUpdTime()) {
            giftBO.setLastUpdTimeStr(TkDateUtils.formatDate((Date)giftBO.getLastUpdTime(), (String)format));
        }
        if (null != giftBO.getGiftPrice()) {
            giftBO.setGiftPrice(TkCalculatorUtils.transferY((String)giftBO.getGiftPrice()));
        }
        giftBO.setGiftTypeStr(StringUtils.isBlank((CharSequence)(giftTypeStr = qryEscapeAtomService.getCodeTitle("GIFT_TYPE_NAME", giftBO.getGiftType()))) ? "\u672a\u5b9a\u4e49" : giftTypeStr);
    }

    public static void escaptGiftInstance(GiftInstanceBO giftInstanceBO, QryEscapeAtomService qryEscapeAtomService) {
        String giftTypeStr;
        String format = "MM-dd";
        if (null != giftInstanceBO.getDistributeTime()) {
            giftInstanceBO.setDistributeTimeStr(TkDateUtils.formatDate((Date)giftInstanceBO.getDistributeTime(), (String)format));
        }
        if (null != giftInstanceBO.getLastUpdTime()) {
            giftInstanceBO.setLastUpdTimeStr(TkDateUtils.formatDate((Date)giftInstanceBO.getLastUpdTime(), (String)format));
        }
        if (null != giftInstanceBO.getGiftPrice()) {
            giftInstanceBO.setGiftPrice(TkCalculatorUtils.transferY((String)giftInstanceBO.getGiftPrice()));
        }
        if (null != giftInstanceBO.getGiftPayPrice()) {
            giftInstanceBO.setGiftPayPrice(TkCalculatorUtils.transferY((String)giftInstanceBO.getGiftPrice()));
        }
        giftInstanceBO.setGiftTypeStr(StringUtils.isBlank((CharSequence)(giftTypeStr = qryEscapeAtomService.getCodeTitle("GIFT_TYPE_NAME", giftInstanceBO.getGiftType()))) ? "\u672a\u5b9a\u4e49" : giftTypeStr);
        String actTypeStr = qryEscapeAtomService.getCodeTitle("ACT_TYPE_NAME", giftInstanceBO.getActivityType());
        giftInstanceBO.setActivityTypeStr(StringUtils.isBlank((CharSequence)actTypeStr) ? "\u672a\u5b9a\u4e49" : actTypeStr);
    }

    public static void escaptBenefitRecordInfo(ActivityBenefitDistributeRecordPO activityBenefitDistributeRecordPO, QryEscapeAtomService qryEscapeAtomService) {
        String benefitTypeStr;
        String format = "yyyy-MM-dd HH:mm:ss";
        if (null != activityBenefitDistributeRecordPO.getCrtTime()) {
            activityBenefitDistributeRecordPO.setCrtTimeStr(TkDateUtils.formatDate((Date)activityBenefitDistributeRecordPO.getCrtTime(), (String)format));
        }
        if (null != activityBenefitDistributeRecordPO.getLastUpdTime()) {
            activityBenefitDistributeRecordPO.setLastUpdTimeStr(TkDateUtils.formatDate((Date)activityBenefitDistributeRecordPO.getLastUpdTime(), (String)format));
        }
        activityBenefitDistributeRecordPO.setBenefitTypeStr(StringUtils.isBlank((CharSequence)(benefitTypeStr = qryEscapeAtomService.getCodeTitle("EQUITY_TYPE_NAME", activityBenefitDistributeRecordPO.getBenefitType()))) ? "\u672a\u5b9a\u4e49" : benefitTypeStr);
    }

    public static void escaptActCost(ActivityCostInfoBO actCostInfo, QryEscapeAtomService qryEscapeAtomService) {
        String format = "yyyy-MM-dd HH:mm:ss";
        if (null != actCostInfo.getCrtTime()) {
            actCostInfo.setCrtTimeStr(TkDateUtils.formatDate((Date)actCostInfo.getCrtTime(), (String)format));
        }
        if (null != actCostInfo.getCostAmount()) {
            actCostInfo.setCostAmountStr(TkCalculatorUtils.transferY((String)String.valueOf(actCostInfo.getCostAmount())));
        }
    }

    public static void escaptActReservoir(ActivityReservoirInfoBO activityReservoirInfoBO, QryEscapeAtomService qryEscapeAtomService) {
        String format = "yyyy-MM";
        if (null != activityReservoirInfoBO.getCrtTime()) {
            activityReservoirInfoBO.setCrtTimeStr(TkDateUtils.formatDate((Date)activityReservoirInfoBO.getCrtTime(), (String)format));
        }
        if (null != activityReservoirInfoBO.getReservoirDate()) {
            activityReservoirInfoBO.setReservoirDateStr(TkDateUtils.formatDate((Date)activityReservoirInfoBO.getReservoirDate(), (String)format));
        }
        if (null != activityReservoirInfoBO.getPresetAmount()) {
            activityReservoirInfoBO.setPresetAmountStr(String.valueOf(TkCalculatorUtils.transferY((long)activityReservoirInfoBO.getPresetAmount())));
        }
        if (null != activityReservoirInfoBO.getCurrentAmount()) {
            activityReservoirInfoBO.setCurrentAmountStr(String.valueOf(TkCalculatorUtils.transferY((long)activityReservoirInfoBO.getCurrentAmount())));
        }
        if (null != activityReservoirInfoBO.getConsumeAmount()) {
            activityReservoirInfoBO.setConsumeAmountStr(String.valueOf(TkCalculatorUtils.transferY((long)activityReservoirInfoBO.getConsumeAmount())));
        }
        if (null != activityReservoirInfoBO.getDistributionAmount()) {
            activityReservoirInfoBO.setDistributionAmountStr(String.valueOf(TkCalculatorUtils.transferY((long)activityReservoirInfoBO.getDistributionAmount())));
        }
        if (null != activityReservoirInfoBO.getSurplusAmount()) {
            activityReservoirInfoBO.setSurplusAmountStr(String.valueOf(TkCalculatorUtils.transferY((long)activityReservoirInfoBO.getSurplusAmount())));
        }
        if (null != activityReservoirInfoBO.getTotalRecoilAmount()) {
            activityReservoirInfoBO.setTotalRecoilAmountStr(String.valueOf(TkCalculatorUtils.transferY((long)activityReservoirInfoBO.getTotalRecoilAmount())));
        }
    }

    public static void escaptActCombination(ActivityCombinationInfoBO activityCombinationInfo, QryEscapeAtomService qryEscapeAtomService) {
        String saleTypeStr;
        String format = "yyyy-MM-dd HH:mm:ss";
        if (null != activityCombinationInfo.getCrtTime()) {
            activityCombinationInfo.setCrtTimeStr(TkDateUtils.formatDate((Date)activityCombinationInfo.getCrtTime(), (String)format));
        }
        if (null != activityCombinationInfo.getLastUpdTime()) {
            activityCombinationInfo.setLastUpdTimeStr(TkDateUtils.formatDate((Date)activityCombinationInfo.getLastUpdTime(), (String)format));
        }
        activityCombinationInfo.setSaleTypeStr(StringUtils.isBlank((CharSequence)(saleTypeStr = qryEscapeAtomService.getCodeTitle("APPLY_SALES_TYPE", activityCombinationInfo.getSaleType()))) ? "\u672a\u5b9a\u4e49" : saleTypeStr);
    }

    public static void escaptActivityCommodityPoolInfo(ActivityCommodityPoolInfoBO activityCommodityPoolInfoBO, QryEscapeAtomService qryEscapeAtomService) {
        String saleTypeStr;
        String format = "yyyy-MM-dd HH:mm:ss";
        if (null != activityCommodityPoolInfoBO.getCrtTime()) {
            activityCommodityPoolInfoBO.setCrtTimeStr(TkDateUtils.formatDate((Date)activityCommodityPoolInfoBO.getCrtTime(), (String)format));
        }
        activityCommodityPoolInfoBO.setSaleTypeStr(StringUtils.isBlank((CharSequence)(saleTypeStr = qryEscapeAtomService.getCodeTitle("APPLY_SALES_TYPE", activityCommodityPoolInfoBO.getSaleType()))) ? "\u672a\u5b9a\u4e49" : saleTypeStr);
        String actTypeStr = qryEscapeAtomService.getCodeTitle("ACT_TYPE_NAME", activityCommodityPoolInfoBO.getActivityType());
        activityCommodityPoolInfoBO.setActivityTypeStr(StringUtils.isBlank((CharSequence)actTypeStr) ? "\u672a\u5b9a\u4e49" : actTypeStr);
        String poolTypeStr = qryEscapeAtomService.getCodeTitle("ACT_MACHINE_POOL_TYPE", activityCommodityPoolInfoBO.getPoolType());
        activityCommodityPoolInfoBO.setPoolTypeStr(StringUtils.isBlank((CharSequence)poolTypeStr) ? "\u672a\u5b9a\u4e49" : poolTypeStr);
    }
}

