/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.UpdateSkuAtomService;
import com.tydic.newretail.bo.RspInfoBO;
import com.tydic.newretail.bo.UpdateSkuAtomReqBO;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateSkuAtomServiceImpl
implements UpdateSkuAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateSkuAtomServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuDAO skuDAO;

    public RspInfoBO updateSku(UpdateSkuAtomReqBO sku) {
        if (this.isDebugEnabled) {
            logger.debug("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u6267\u884c");
        }
        RspInfoBO rspInfoBO = new RspInfoBO();
        try {
            SkuPO newSku = new SkuPO();
            BeanUtils.copyProperties((Object)sku, (Object)newSku);
            if (sku == null) {
                rspInfoBO.setRespCode("9999");
                rspInfoBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
            }
            if (this.skuDAO.updateByEXTSkuIdAndMaterialIdSelective(newSku, sku.getSupplierId()) > 0) {
                rspInfoBO.setRespCode("0000");
                rspInfoBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e);
            rspInfoBO.setRespCode("9999");
            rspInfoBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u5931\u8d25");
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", e);
        }
        return rspInfoBO;
    }

    public RspInfoBO updateSkuNullCommodityId(UpdateSkuAtomReqBO sku) {
        if (this.isDebugEnabled) {
            logger.debug("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u6267\u884c");
        }
        RspInfoBO rspInfoBO = new RspInfoBO();
        try {
            SkuPO newSku = new SkuPO();
            BeanUtils.copyProperties((Object)sku, (Object)newSku);
            if (this.skuDAO.updateSkuNullCommodityId(newSku) > 0) {
                rspInfoBO.setRespCode("0000");
                rspInfoBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e);
            rspInfoBO.setRespCode("9999");
            rspInfoBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u5931\u8d25");
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", e);
        }
        return rspInfoBO;
    }

    public List<UpdateSkuAtomReqBO> selectByCommodityId(Long commodityId) {
        ArrayList<UpdateSkuAtomReqBO> skuBOs = new ArrayList<UpdateSkuAtomReqBO>();
        List<SkuPO> skus = null;
        try {
            skus = this.skuDAO.selectByCommodityId(commodityId);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5355\u54c1\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5355\u54c1\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", e);
        }
        if (CollectionUtils.isNotEmpty(skus)) {
            for (SkuPO sku : skus) {
                UpdateSkuAtomReqBO skuBO = new UpdateSkuAtomReqBO();
                BeanUtils.copyProperties((Object)sku, (Object)skuBO);
                skuBOs.add(skuBO);
            }
        }
        return skuBOs;
    }

    public RspInfoBO updateSku(List<UpdateSkuAtomReqBO> sku) {
        if (this.isDebugEnabled) {
            logger.debug("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u6267\u884c");
        }
        RspInfoBO rspInfoBO = new RspInfoBO();
        try {
            ArrayList<SkuPO> newSku = new ArrayList<SkuPO>();
            SkuPO po = null;
            for (UpdateSkuAtomReqBO bo : sku) {
                po = new SkuPO();
                BeanUtils.copyProperties((Object)bo, (Object)po);
                newSku.add(po);
            }
            if (this.skuDAO.updateByEXTSkuIdAndMaterialIdSelectiveList(newSku) > 0) {
                rspInfoBO.setRespCode("0000");
                rspInfoBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e);
            rspInfoBO.setRespCode("9999");
            rspInfoBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u5931\u8d25");
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", e);
        }
        return rspInfoBO;
    }

    public RspInfoBO updateSkuNullCommodityId(List<UpdateSkuAtomReqBO> sku) {
        if (this.isDebugEnabled) {
            logger.debug("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u6267\u884c");
        }
        RspInfoBO rspInfoBO = new RspInfoBO();
        try {
            ArrayList<SkuPO> poList = new ArrayList<SkuPO>();
            SkuPO newSku = null;
            for (UpdateSkuAtomReqBO bo : sku) {
                newSku = new SkuPO();
                newSku.setSkuId(bo.getSkuId());
                newSku.setSkuStatus(bo.getSkuStatus());
                newSku.setSkuName(bo.getSkuName());
                newSku.setSkuLongName(bo.getSkuLongName());
                newSku.setSkuPriceTagName(bo.getSkuPriceTagName());
                newSku.setExtSkuId(bo.getExtSkuId());
                newSku.setSupplierId(bo.getSupplierId());
                newSku.setMaterialId(bo.getMaterialId());
                poList.add(newSku);
            }
            if (this.skuDAO.updateSkuNullCommodityIdList(poList) > 0) {
                rspInfoBO.setRespCode("0000");
                rspInfoBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e);
            rspInfoBO.setRespCode("9999");
            rspInfoBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u5931\u8d25");
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4fee\u6539\u5355\u54c1\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", e);
        }
        return rspInfoBO;
    }
}

