/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.bo.AddProvGoodsListReqBO;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.BasicListRspBO;
import com.tydic.newretail.bo.BasicRspBO;
import com.tydic.newretail.bo.BatchCreateSkuReqBO;
import com.tydic.newretail.bo.BrandBO;
import com.tydic.newretail.bo.CreateBrandReqBO;
import com.tydic.newretail.bo.CreateSkuReqBO;
import com.tydic.newretail.bo.DPriceSheetBO;
import com.tydic.newretail.bo.DSkuBO;
import com.tydic.newretail.bo.DmaterialBO;
import com.tydic.newretail.bo.ProvAndCityCodeBO;
import com.tydic.newretail.bo.ProvGoodsBO;
import com.tydic.newretail.bo.ProvinceMaterialBO;
import com.tydic.newretail.bo.RuleRespBO;
import com.tydic.newretail.bo.SupplierBO;
import com.tydic.newretail.busi.service.AddGoodsByProvCodeService;
import com.tydic.newretail.busi.service.AddProvGoodsListService;
import com.tydic.newretail.busi.service.BatchCreateSkuService;
import com.tydic.newretail.busi.service.BrandManageService;
import com.tydic.newretail.busi.service.DMaterialManageService;
import com.tydic.newretail.busi.service.DPriceSheetService;
import com.tydic.newretail.busi.service.XlsSkuManageService;
import com.tydic.newretail.constant.SysParamConstant;
import com.tydic.newretail.dao.BrandDAO;
import com.tydic.newretail.dao.MaterialDAO;
import com.tydic.newretail.dao.ProvGoodsDAO;
import com.tydic.newretail.dao.ProvGoodsSupRelationDAO;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.po.BrandPO;
import com.tydic.newretail.dao.po.MaterialPO;
import com.tydic.newretail.dao.po.ProvGoodsAndSupplierPO;
import com.tydic.newretail.dao.po.ProvGoodsPO;
import com.tydic.newretail.dao.po.ProvGoodsSupRelationPO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.util.TKGenericServiceUtils;
import com.tydic.newretail.toolkit.util.TkFtpConfig;
import com.tydic.newretail.toolkit.util.TkFtpUtils;
import com.tydic.newretail.toolkit.util.TkHttpRequestUtils;
import com.tydic.newretail.util.RedisUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.cursor.Cursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.Jedis;

@Service
public class AddGoodsByProvCodeServiceImpl
implements AddGoodsByProvCodeService {
    private static final Logger logger = LoggerFactory.getLogger(AddGoodsByProvCodeServiceImpl.class);
    @Autowired
    private AddProvGoodsListService addProvGoodsListService;
    @Autowired
    private DMaterialManageService dMaterialManageService;
    @Autowired
    private XlsSkuManageService xlsSkuManageService;
    @Autowired
    private BatchCreateSkuService batchCreateSkuService;
    @Autowired
    private DPriceSheetService dPriceSheetService;
    @Autowired
    private BrandManageService brandManageService;
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Autowired
    private ProvGoodsSupRelationDAO provGoodsSupRelationDAO;
    @Autowired
    private SkuDAO xlsSkuMapper;
    @Autowired
    private BrandDAO brandDAO;
    @Autowired
    private MaterialDAO materialDAO;
    @Value(value="${hsf.version}")
    private String hsfVersion;
    @Value(value="${hsf.group}")
    private String hsfGroup;
    @Value(value="${hsf.clientTimeout}")
    private String hsfClientTimeout;
    @Value(value="${getSuppiler}")
    private String suppilerUrl;
    @Value(value="${ftp.host}")
    private String hostname;
    @Value(value="${ftp.port}")
    private String port;
    @Value(value="${ftp.user}")
    private String username;
    @Value(value="${ftp.password}")
    private String password;
    @Value(value="${ftp.file.xls_prov_goods.path}")
    private String ftpPath;
    public static List<String> goodsType = Arrays.asList("01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12");

    public BaseRspBO provCommodityCreation(AddProvGoodsListReqBO reqBO) {
        ProvGoodsBO backBO;
        String checkMaterialsRsp;
        BaseRspBO result = new BaseRspBO();
        HashMap<String, ProvGoodsBO> materialAndProvId = new HashMap<String, ProvGoodsBO>();
        logger.debug("\u8c03\u7528\u7701\u4efd\u5546\u54c1\u7684\u6279\u91cf\u521b\u5efa\uff1a" + reqBO.getReqBO().size());
        logger.debug("\u8c03\u7528\u7701\u4efd\u5546\u54c1\u7684\u6279\u91cf\u521b\u5efa\u5165\u53c2\uff1a" + reqBO);
        if (CollectionUtils.isEmpty((Collection)reqBO.getReqBO())) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        String back = this.check(reqBO);
        if (!StringUtils.isBlank((String)back)) {
            logger.debug("\u5165\u53c2\u4e0d\u5408\u6cd5\uff1a" + back);
            result.setRespCode("8888");
            result.setRespDesc(back);
            return result;
        }
        ArrayList<String> materials = new ArrayList<String>();
        reqBO.getReqBO().stream().forEach(bo -> {
            if (!StringUtils.isBlank((String)bo.getMaterialId()) && "1".equals(reqBO.getAddType())) {
                materials.add(bo.getMaterialId());
            }
            if (!StringUtils.isBlank((String)bo.getBossCode())) {
                bo.setBossCode("," + bo.getBossCode() + ",");
            }
        });
        List<ProvGoodsPO> materialsList = new ArrayList<ProvGoodsPO>();
        if (!CollectionUtils.isEmpty(materials)) {
            materialsList = this.provGoodsDAO.selectByMaterials(materials, ((ProvGoodsBO)reqBO.getReqBO().get(0)).getProvinceCode());
        }
        if (!StringUtils.isBlank((String)(checkMaterialsRsp = this.checkMaterials(materialsList)))) {
            logger.debug("\u5165\u53c2\u4e0d\u5408\u6cd5\uff1a" + checkMaterialsRsp);
            result.setRespCode("8888");
            result.setRespDesc(checkMaterialsRsp);
            return result;
        }
        ArrayList<ProvGoodsPO> record = new ArrayList<ProvGoodsPO>();
        ProvGoodsPO goodsPo = null;
        HashMap<Long, ProvGoodsBO> supMap = new HashMap<Long, ProvGoodsBO>();
        for (ProvGoodsBO bo2 : reqBO.getReqBO()) {
            goodsPo = new ProvGoodsPO();
            if (bo2.getProvGoodsId() == null) {
                bo2.setProvGoodsId(Long.valueOf(Sequence.getInstance().nextId()));
            }
            if (!StringUtils.isBlank((String)bo2.getMaterialId()) && "1".equals(reqBO.getAddType())) {
                ProvGoodsAndSupplierPO query = new ProvGoodsAndSupplierPO();
                query.setMaterialId(bo2.getMaterialId());
                List<ProvGoodsAndSupplierPO> list = this.provGoodsDAO.selectByProvGroup(query);
                bo2.setCgType(CollectionUtils.isEmpty(list) ? bo2.getCgType() : list.get(0).getCgType());
            }
            if (bo2.getInvoiceTaxRate() == null) {
                bo2.setInvoiceTaxRate(SysParamConstant.INVOICE_TAX_RATE_DEFAULT);
            }
            bo2.setReservedField3("601".equals(bo2.getCgType()) ? "0" : "1");
            bo2.setReservedField1("0");
            bo2.setMaterialId(StringUtils.isBlank((String)bo2.getMaterialId()) ? null : bo2.getMaterialId().trim());
            goodsPo.setMaterialId(bo2.getMaterialId());
            goodsPo.setProvinceCode(bo2.getProvinceCode());
            record.add(goodsPo);
            if (supMap.containsKey(bo2.getProvGoodsId())) continue;
            supMap.put(bo2.getProvGoodsId(), bo2);
        }
        List<Object> provGoods = new ArrayList();
        try {
            logger.debug("\u67e5\u5bfb\u540c\u6b65\u5546\u54c1\u662f\u5426\u5b58\u5728");
            provGoods = this.provGoodsDAO.selectByList(record);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u62a5\u9519" + e.getMessage());
        }
        HashMap<String, ProvGoodsPO> provMap = new HashMap<String, ProvGoodsPO>();
        for (ProvGoodsPO provGoodsPO : provGoods) {
            if (provMap.containsKey(provGoodsPO.getProvinceCode() + provGoodsPO.getMaterialId())) continue;
            provMap.put(provGoodsPO.getProvinceCode() + provGoodsPO.getMaterialId(), provGoodsPO);
        }
        ArrayList<ProvGoodsBO> provInsert = new ArrayList<ProvGoodsBO>();
        ArrayList<ProvGoodsBO> arrayList = new ArrayList<ProvGoodsBO>();
        ArrayList<ProvGoodsBO> newTrailUpdate = new ArrayList<ProvGoodsBO>();
        ProvGoodsBO tempBO = null;
        if (CollectionUtils.isEmpty(provMap)) {
            for (ProvGoodsBO bo3 : reqBO.getReqBO()) {
                backBO = new ProvGoodsBO();
                backBO.setProvGoodsId(bo3.getProvGoodsId());
                backBO.setGoodsSource(bo3.getGoodsSource());
                materialAndProvId.put(bo3.getMaterialId(), backBO);
                tempBO = new ProvGoodsBO();
                BeanUtils.copyProperties((Object)bo3, (Object)tempBO);
                tempBO.setCreateTime(new Date());
                tempBO.setIsValid("1");
                tempBO.setHasPrice("0");
                tempBO.setCreateUsername(bo3.getCreateUser());
                tempBO.setGoodsName(bo3.getGoodsLongName());
                tempBO.setCreateUser(bo3.getCreateUser());
                tempBO.setUpdateUser(null);
                tempBO.setIsAppstoreAble(bo3.getIsAppstoreAble());
                provInsert.add(tempBO);
            }
        } else {
            for (ProvGoodsBO bo2 : reqBO.getReqBO()) {
                if (provMap.get(bo2.getProvinceCode() + bo2.getMaterialId()) != null && ((ProvGoodsPO)provMap.get(bo2.getProvinceCode() + bo2.getMaterialId())).getGoodsSource().equals("01")) {
                    backBO = new ProvGoodsBO();
                    backBO.setProvGoodsId(((ProvGoodsPO)provMap.get(bo2.getProvinceCode() + bo2.getMaterialId())).getProvGoodsId());
                    backBO.setGoodsSource(StringUtils.isBlank((String)bo2.getGoodsSource()) ? "01" : bo2.getGoodsSource());
                    backBO.setBrandName(((ProvGoodsPO)provMap.get(bo2.getProvinceCode() + bo2.getMaterialId())).getBrandName());
                    backBO.setColorName(((ProvGoodsPO)provMap.get(bo2.getProvinceCode() + bo2.getMaterialId())).getColorName());
                    backBO.setGoodsType(((ProvGoodsPO)provMap.get(bo2.getProvinceCode() + bo2.getMaterialId())).getGoodsType());
                    backBO.setBrandId(((ProvGoodsPO)provMap.get(bo2.getProvinceCode() + bo2.getMaterialId())).getBrandId());
                    materialAndProvId.put(bo2.getMaterialId(), backBO);
                    tempBO = new ProvGoodsBO();
                    BeanUtils.copyProperties((Object)bo2, (Object)tempBO);
                    tempBO.setMaterialId(bo2.getMaterialId());
                    tempBO.setGoodsSource("01");
                    tempBO.setProvGoodsId(null);
                    tempBO.setUpdateTime(new Date());
                    tempBO.setUpdateUser(StringUtils.isBlank((String)bo2.getCreateUser()) ? bo2.getUpdateUser() : bo2.getCreateUser());
                    tempBO.setCreateUser(null);
                    tempBO.setCgType(null);
                    tempBO.setHasSerialNumber(null);
                    tempBO.setAllowNegativeStock(null);
                    arrayList.add(tempBO);
                } else if (provMap.get(bo2.getProvinceCode() + bo2.getMaterialId()) != null && ((ProvGoodsPO)provMap.get(bo2.getProvinceCode() + bo2.getMaterialId())).getGoodsSource().equals("00")) {
                    backBO = new ProvGoodsBO();
                    backBO.setProvGoodsId(((ProvGoodsPO)provMap.get(bo2.getProvinceCode() + bo2.getMaterialId())).getProvGoodsId());
                    backBO.setGoodsSource(StringUtils.isBlank((String)bo2.getGoodsSource()) ? "00" : bo2.getGoodsSource());
                    materialAndProvId.put(bo2.getMaterialId(), backBO);
                    tempBO = new ProvGoodsBO();
                    BeanUtils.copyProperties((Object)bo2, (Object)tempBO);
                    tempBO.setUpdateTime(new Date());
                    tempBO.setGoodsName(bo2.getGoodsLongName());
                    tempBO.setUpdateUser(StringUtils.isBlank((String)bo2.getCreateUser()) ? bo2.getUpdateUser() : bo2.getCreateUser());
                    tempBO.setProvGoodsId(null);
                    tempBO.setCgType(null);
                    tempBO.setCreateUser(null);
                    tempBO.setHasSerialNumber(null);
                    tempBO.setAllowNegativeStock(null);
                    newTrailUpdate.add(tempBO);
                }
                if (provMap.get(bo2.getProvinceCode() + bo2.getMaterialId()) != null) continue;
                backBO = new ProvGoodsBO();
                backBO.setProvGoodsId(bo2.getProvGoodsId());
                backBO.setGoodsSource(bo2.getGoodsSource());
                materialAndProvId.put(bo2.getMaterialId(), backBO);
                tempBO = new ProvGoodsBO();
                BeanUtils.copyProperties((Object)bo2, (Object)tempBO);
                tempBO.setCreateTime(new Date());
                tempBO.setHasPrice("0");
                tempBO.setIsValid("1");
                tempBO.setGoodsName(bo2.getGoodsLongName());
                tempBO.setUpdateUser(null);
                tempBO.setCreateUsername(bo2.getCreateUser());
                tempBO.setCreateUser(bo2.getCreateUser());
                provInsert.add(tempBO);
            }
        }
        try {
            AddProvGoodsListReqBO bo3;
            if (!(CollectionUtils.isEmpty(provInsert) && CollectionUtils.isEmpty(newTrailUpdate) && CollectionUtils.isEmpty(arrayList))) {
                this.materialAdd(reqBO);
            }
            if (!CollectionUtils.isEmpty(provInsert)) {
                AddProvGoodsListReqBO bo4 = new AddProvGoodsListReqBO();
                bo4.setReqBO(provInsert);
                logger.debug(((ProvGoodsBO)provInsert.get(0)).toString());
                this.addProvGoodsListService.addProvGood(bo4);
                provInsert = null;
            }
            if (!CollectionUtils.isEmpty(arrayList)) {
                bo3 = new AddProvGoodsListReqBO();
                bo3.setReqBO(arrayList);
                logger.debug(((ProvGoodsBO)arrayList.get(0)).toString());
                this.addProvGoodsListService.updataProvGoods(bo3);
                Object var14_19 = null;
            }
            if (!CollectionUtils.isEmpty(newTrailUpdate)) {
                bo3 = new AddProvGoodsListReqBO();
                bo3.setReqBO(newTrailUpdate);
                logger.debug(((ProvGoodsBO)newTrailUpdate.get(0)).toString());
                this.addProvGoodsListService.updataProvGoods(bo3);
                newTrailUpdate = null;
            }
            if (supMap != null) {
                ArrayList<ProvGoodsSupRelationPO> relationPO = new ArrayList<ProvGoodsSupRelationPO>();
                ArrayList<Long> provId = new ArrayList<Long>();
                ProvGoodsSupRelationPO po = null;
                for (Map.Entry map : supMap.entrySet()) {
                    if (provMap.get(((ProvGoodsBO)map.getValue()).getProvinceCode() + ((ProvGoodsBO)map.getValue()).getMaterialId()) != null) {
                        provId.add(((ProvGoodsPO)provMap.get(((ProvGoodsBO)map.getValue()).getProvinceCode() + ((ProvGoodsBO)map.getValue()).getMaterialId())).getProvGoodsId());
                    }
                    if (CollectionUtils.isEmpty((Collection)((ProvGoodsBO)map.getValue()).getSupplierBO())) continue;
                    for (SupplierBO subo : ((ProvGoodsBO)map.getValue()).getSupplierBO()) {
                        po = new ProvGoodsSupRelationPO();
                        if (provMap.get(((ProvGoodsBO)map.getValue()).getProvinceCode() + ((ProvGoodsBO)map.getValue()).getMaterialId()) != null) {
                            po.setProvGoodsId(((ProvGoodsPO)provMap.get(((ProvGoodsBO)map.getValue()).getProvinceCode() + ((ProvGoodsBO)map.getValue()).getMaterialId())).getProvGoodsId());
                        } else {
                            po.setProvGoodsId((Long)map.getKey());
                        }
                        po.setProvinceCode(subo.getProvinceCode());
                        po.setSupplierId(Long.parseLong(subo.getSupplierId()));
                        po.setCreateTime(new Date());
                        po.setSupplierName(subo.getSupplierName());
                        relationPO.add(po);
                    }
                }
                if (!CollectionUtils.isEmpty(provId)) {
                    this.provGoodsSupRelationDAO.deleteByProvId(provId);
                }
                if (!CollectionUtils.isEmpty(relationPO)) {
                    this.provGoodsSupRelationDAO.insertList(relationPO);
                }
            }
            if ("03".equals(((ProvGoodsBO)reqBO.getReqBO().get(0)).getGoodsStatus()) && "1".equals(reqBO.getAddType())) {
                String material = ((ProvGoodsBO)reqBO.getReqBO().get(0)).getMaterialId();
                String provCode = ((ProvGoodsBO)reqBO.getReqBO().get(0)).getProvinceCode();
                ArrayList<String> materialIds = new ArrayList<String>();
                materialIds.add(material);
                ProvinceMaterialBO provinceMaterialBO = new ProvinceMaterialBO();
                provinceMaterialBO.setProvinceCode(provCode);
                provinceMaterialBO.setMaterialId(materialIds);
                Map priceSheet = this.dPriceSheetService.findDPriceSheet(provinceMaterialBO);
                ArrayList<DSkuBO> updateList = new ArrayList<DSkuBO>();
                ArrayList<CreateSkuReqBO> createList = new ArrayList<CreateSkuReqBO>();
                Map<String, ProvAndCityCodeBO> shopIds = this.getProvCode(provCode, reqBO.getmOrgPath());
                Map<String, SkuPO> skuMap = this.getSku(reqBO, shopIds);
                logger.debug("sku\u4fe1\u606f");
                logger.debug("\u95e8\u5e97\u5217\u8868");
                for (Map.Entry<String, ProvAndCityCodeBO> shop : shopIds.entrySet()) {
                    if (!CollectionUtils.isEmpty(skuMap) && skuMap.containsKey(material + shop.getKey().trim())) {
                        DSkuBO update = this.toUpdate((ProvGoodsBO)reqBO.getReqBO().get(0), shop.getValue(), skuMap.get(material + shop.getKey().trim()));
                        updateList.add(update);
                        continue;
                    }
                    CreateSkuReqBO craete = this.toCreate((ProvGoodsBO)reqBO.getReqBO().get(0), shop.getValue(), priceSheet);
                    createList.add(craete);
                }
                BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
                batchCreateSkuReqBO.setCreateSkuReqBOs(createList);
                if (!CollectionUtils.isEmpty(createList)) {
                    this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
                }
                if (!CollectionUtils.isEmpty(updateList)) {
                    this.xlsSkuManageService.batchUpdate(updateList);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u8d27\u4fee\u6539\u62a5\u9519");
            throw new BusinessException("9999", "\u65b0\u589e\u8d27\u4fee\u6539\u62a5\u9519" + e.getMessage());
        }
        result.setMaterialAndProvId(materialAndProvId);
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public String check(AddProvGoodsListReqBO reqBO) {
        String back = "";
        ArrayList<String> brands = new ArrayList<String>();
        for (ProvGoodsBO bo : reqBO.getReqBO()) {
            if (Objects.equals(bo.getProvinceCode(), "240000")) {
                brands.add(bo.getBrandName());
            }
            if (StringUtils.isBlank((String)bo.getMaterialId())) {
                back = "\u7269\u6599\u7f16\u7801\u4e3a\u7a7a";
                return back;
            }
            Pattern pattern = Pattern.compile("[0-9]{1,}");
            String materialId = bo.getMaterialId().replaceAll("\\s*", "");
            Matcher matcher = pattern.matcher(materialId);
            boolean b = matcher.matches();
            if (materialId.length() < 2) {
                logger.debug("\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db316\u4f4d:" + materialId);
                back = "\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db316\u4f4d:" + materialId;
                return back;
            }
            String substring = materialId.substring(0, 2);
            if (b) {
                if (18 != materialId.length() || !"00".equals(substring)) {
                    logger.debug("\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db318\u4f4d:" + materialId);
                    back = "\u7eaf\u6570\u5b57\u7684\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db318\u4f4d\u6216\u4e0d\u662f\u4ee500\u5f00\u5934:" + materialId;
                    return back;
                }
            } else if ("FQ".equals(substring)) {
                if (18 != materialId.length()) {
                    logger.debug("\u4ee5FQ\u5f00\u5934\u5e26\u82f1\u6587\u7684\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db318\u4f4d:" + materialId);
                    back = "\u4ee5FQ\u5f00\u5934\u5e26\u82f1\u6587\u7684\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db318\u4f4d:" + materialId;
                    return back;
                }
            } else if (16 != materialId.length()) {
                logger.debug("\u5e26\u82f1\u6587\u7684\u7269\u6599\u7f16\u7801\u957f\u5ea6\u987b\u4e3a16\u4f4d\uff0c\u8bf7\u68c0\u67e5\u60a8\u8f93\u5165\u7684\u7269\u6599\u7f16\u7801:" + materialId);
                back = "\u5e26\u82f1\u6587\u7684\u7269\u6599\u7f16\u7801\u957f\u5ea6\u987b\u4e3a16\u4f4d\uff0c\u8bf7\u68c0\u67e5\u60a8\u8f93\u5165\u7684\u7269\u6599\u7f16\u7801:" + materialId;
                return back;
            }
            bo.setMaterialId(materialId);
            if (StringUtils.isBlank((String)bo.getProvinceCode())) {
                back = "\u7701\u4efd\u7f16\u7801\u4e3a\u7a7a";
                return back;
            }
            if (StringUtils.isBlank((String)bo.getHasSerialNumber())) {
                back = "\u6709\u65e0\u4e32\u53f7\u4e3a\u7a7a";
                return back;
            }
            if (StringUtils.isBlank((String)bo.getAllowNegativeStock())) {
                back = "\u5141\u8bb8\u8d1f\u5e93\u5b58\u4e3a\u7a7a";
                return back;
            }
            if (StringUtils.isBlank((String)bo.getIsSendScmStock())) {
                back = "\u662f\u5426\u540c\u6b65SCM\u5e93\u5b58\u4e3a\u7a7a";
                return back;
            }
            if (StringUtils.isBlank((String)bo.getIsSendScmSale())) {
                back = "\u662f\u5426\u53d1\u9001SCM\u9500\u5355\u4e3a\u7a7a";
                return back;
            }
            if (StringUtils.isBlank((String)bo.getIsScmDistribute())) {
                back = "\u662f\u5426SCM\u81ea\u52a8\u94fa\u8d27\u4e3a\u7a7a";
                return back;
            }
            if (Objects.equals(bo.getWhetherInvoice(), "1") && bo.getInvoiceTaxRate() == null) {
                back = "\u662f\u5426\u5f00\u53d1\u7968\u4e3a\u662f\u65f6\uff0c\u7a0e\u7387\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5";
                return back;
            }
            if (!StringUtils.isBlank((String)bo.getIsAppstoreAble())) {
                if ("1".equals(bo.getIsAppstoreAble()) || "0".equals(bo.getIsAppstoreAble())) continue;
                back = "\u624b\u673a\u5546\u57ce\u662f\u5426\u53ef\u7528\u4e3a\u7a7a\u5b57\u6bb5\u6709\u8bef";
                return back;
            }
            bo.setIsAppstoreAble("1");
        }
        logger.debug("\u54c1\u724c\u5217\u8868\u957f\u5ea6" + brands.size());
        if (brands.size() > 0) {
            try {
                List<RuleRespBO> rules = this.getRules(brands);
                for (RuleRespBO bo : rules) {
                    if (!bo.getIsExistRule().equals("0")) continue;
                    back = "\u8be5\u5546\u54c1\u54c1\u724c[" + bo.getBrandName() + "]\u6682\u672a\u914d\u7f6e\u8981\u8d27\u5ba1\u6279\u89c4\u5219\uff0c\u8bf7\u5148\u914d\u7f6e\u8981\u8d27\u5ba1\u6279\u89c4\u5219\u6216\u8005\u66f4\u6539\u5546\u54c1\u54c1\u724c";
                    return back;
                }
            }
            catch (Exception e) {
                logger.error("\u914d\u7f6e\u8981\u8d27\u89c4\u5219\u62a5\u9519");
                throw new BusinessException("9999", "\u914d\u7f6e\u8981\u8d27\u89c4\u5219\u62a5\u9519" + e.getMessage());
            }
        }
        return "";
    }

    public List<ProvGoodsBO> newCheck(AddProvGoodsListReqBO reqBO, List<BasicRspBO> basicRspBOS, List<String> materialList) {
        ArrayList<ProvGoodsBO> removeReqBO = new ArrayList<ProvGoodsBO>();
        for (ProvGoodsBO bo2 : reqBO.getReqBO()) {
            if (materialList.contains(bo2.getMaterialId())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u7269\u6599\u7f16\u7801\uff1a" + bo2.getMaterialId() + "\u91cd\u590d");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getMaterialId())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                continue;
            }
            Pattern pattern = Pattern.compile("[0-9]{1,}");
            String materialId = bo2.getMaterialId().replaceAll("\\s*", "");
            Matcher matcher = pattern.matcher(materialId);
            boolean b = matcher.matches();
            if (materialId.length() < 2) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db316\u4f4d:" + materialId);
                continue;
            }
            String substring = materialId.substring(0, 2);
            if (b) {
                if (18 != materialId.length() || !"00".equals(substring)) {
                    this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u7eaf\u6570\u5b57\u7684\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db318\u4f4d\u6216\u4e0d\u662f\u4ee500\u5f00\u5934:" + materialId);
                    continue;
                }
            } else if ("FQ".equals(substring)) {
                if (18 != materialId.length()) {
                    this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u4ee5FQ\u5f00\u5934\u5e26\u82f1\u6587\u7684\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db318\u4f4d:" + materialId);
                    continue;
                }
            } else if (16 != materialId.length()) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u5e26\u82f1\u6587\u7684\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db316\u4f4d:" + materialId);
                continue;
            }
            bo2.setMaterialId(materialId);
            if (StringUtils.isBlank((String)bo2.getGoodsModel())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u5546\u54c1\u578b\u53f7\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getWhetherInvoice())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u662f\u5426\u5f00\u53d1\u7968\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getIsSendScmStock())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u662f\u5426\u540c\u6b65SCM\u5e93\u5b58\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getIsSendScmSale())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u662f\u5426\u53d1\u9001SCM\u9500\u5355\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getIsScmDistribute())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u662f\u5426SCM\u81ea\u52a8\u94fa\u8d27\u4e3a\u7a7a");
                continue;
            }
            if (Objects.equals(bo2.getWhetherInvoice(), "1") && bo2.getInvoiceTaxRate() == null) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u662f\u5426\u5f00\u53d1\u7968\u4e3a \u662f \u65f6\uff0c\u53d1\u7968\u7a0e\u7387\u4e3a\u7a7a");
                continue;
            }
            if (Objects.equals(bo2.getWhetherInvoice(), "1") && ("200000".equals(bo2.getProvinceCode()) || "280000".equals(bo2.getProvinceCode())) && StringUtils.isBlank((String)bo2.getTaxTypeCode())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getAllowNegativeStock())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u5141\u8bb8\u8d1f\u5e93\u5b58\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getBrandName())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u54c1\u724c\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getSupNo())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u4f9b\u5e94\u5546\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getGoodsLongName())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getErpGoodsType())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u5546\u54c1\u5206\u7c7b\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getHasSerialNumber())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u662f\u5426\u6709\u4e32\u53f7\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getPurchaseType())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u91c7\u8d2d\u7c7b\u578b\u4e3a\u7a7a");
                continue;
            }
            if (!goodsType.contains(bo2.getErpGoodsType())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u4e0d\u5b58\u5728\u7684\u5546\u54c1\u5206\u7c7b");
                continue;
            }
            if (!Objects.equals(bo2.getPurchaseType(), "1") && !Objects.equals(bo2.getPurchaseType(), "2")) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u4e0d\u5b58\u5728\u7684\u91c7\u8d2d\u7c7b\u578b");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getProvinceCode())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u7701\u4efd\u7f16\u7801\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getIsSendScmStock())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u662f\u5426\u540c\u6b65SCM\u5e93\u5b58\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getIsSendScmSale())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u662f\u5426\u53d1\u9001SCM\u9500\u5355\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((String)bo2.getIsScmDistribute())) {
                this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u662f\u5426SCM\u81ea\u52a8\u94fa\u8d27\u4e3a\u7a7a");
                continue;
            }
            if (!StringUtils.isBlank((String)bo2.getIsAppstoreAble())) {
                if (!"1".equals(bo2.getIsAppstoreAble()) && !"0".equals(bo2.getIsAppstoreAble())) {
                    this.ErrorCollection(basicRspBOS, removeReqBO, bo2, "\u624b\u673a\u5546\u57ce\u662f\u5426\u53ef\u7528\u4e3a\u7a7a\u5b57\u6bb5\u6709\u8bef");
                    continue;
                }
            } else {
                bo2.setIsAppstoreAble("1");
            }
            materialList.add(bo2.getMaterialId());
            if (!StringUtils.isNotEmpty((String)bo2.getBossCode())) continue;
            bo2.setBossCode("," + bo2.getBossCode() + ",");
        }
        if (Objects.equals(((ProvGoodsBO)reqBO.getReqBO().get(0)).getProvinceCode(), "240000")) {
            HashSet brandSet = new HashSet();
            reqBO.getReqBO().stream().forEach(bo -> brandSet.add(bo.getBrandName()));
            ArrayList<String> brandS = new ArrayList<String>(brandSet);
            logger.debug("\u5c71\u4e1c\u7701--\u5546\u54c1\u54c1\u724c\u5217\u8868\u957f\u5ea6" + brandSet.size());
            if (brandS.size() > 0) {
                try {
                    List<RuleRespBO> rules = this.getRules(brandS);
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (RuleRespBO ruleRespBo : rules) {
                        map.put(ruleRespBo.getBrandName(), ruleRespBo.getIsExistRule());
                        if (!Objects.equals(ruleRespBo.getIsExistRule(), "0")) continue;
                        logger.debug("\u8be5\u5546\u54c1\u6682\u672a\u914d\u7f6e\u8981\u8d27\u89c4\u5219");
                        BasicRspBO basicRspBO = new BasicRspBO();
                        basicRspBO.setRespCode("8888");
                        basicRspBO.setRespDesc("\u8be5\u5546\u54c1\u54c1\u724c[" + ruleRespBo.getBrandName() + "]\u6682\u672a\u914d\u7f6e\u8981\u8d27\u5ba1\u6279\u89c4\u5219\uff0c\u8bf7\u5148\u914d\u7f6e\u8981\u8d27\u5ba1\u6279\u89c4\u5219\u6216\u8005\u66f4\u6539\u5546\u54c1\u54c1\u724c");
                        basicRspBOS.add(basicRspBO);
                    }
                    for (ProvGoodsBO provGoodsBO : reqBO.getReqBO()) {
                        if (!Objects.equals(map.get(provGoodsBO.getBrandName()), "0")) continue;
                        removeReqBO.add(provGoodsBO);
                    }
                }
                catch (Exception e) {
                    logger.error("\u914d\u7f6e\u8981\u8d27\u89c4\u5219\u62a5\u9519");
                    throw new BusinessException("9999", "\u914d\u7f6e\u8981\u8d27\u89c4\u5219\u62a5\u9519" + e.getMessage());
                }
            }
        }
        return removeReqBO;
    }

    public String checkMaterials(List<ProvGoodsPO> materialsList) {
        String back = "";
        if (!CollectionUtils.isEmpty(materialsList)) {
            back = "\u5df2\u5b58\u5728\u5f53\u524d\u7269\u6599\uff1a" + materialsList.get(0).getMaterialId() + ",\u8bf7\u53bb\u9875\u9762\u505a\u66f4\u65b0\u64cd\u4f5c";
            return back;
        }
        return "";
    }

    public String ifMaterials(List<ProvGoodsPO> materialsList, AddProvGoodsListReqBO addProvGoodsListReqBO) {
        String back = "";
        if (!CollectionUtils.isEmpty(materialsList) && Objects.equals(addProvGoodsListReqBO.getAddType(), "1")) {
            back = "\u5df2\u5b58\u5728\u5f53\u524d\u7269\u6599\uff1a" + materialsList.get(0).getMaterialId() + ",\u8bf7\u53bb\u9875\u9762\u505a\u66f4\u65b0\u64cd\u4f5c";
            return back;
        }
        return "";
    }

    public void materialAdd(AddProvGoodsListReqBO reqBO) throws Exception {
        ArrayList<DmaterialBO> dmaterialBOs = new ArrayList<DmaterialBO>();
        DmaterialBO dmaterialBO = null;
        for (ProvGoodsBO bo : reqBO.getReqBO()) {
            dmaterialBO = new DmaterialBO();
            if ("01".equals(bo.getGoodsSource())) {
                dmaterialBO.setBrandName(null);
                dmaterialBO.setColorName(null);
                dmaterialBO.setVersionName(null);
                dmaterialBO.setMaterialDesc(bo.getScmGoodsLongName());
                dmaterialBO.setIsScm("1");
                dmaterialBO.setMarqueName(null);
            } else {
                dmaterialBO.setBrandName(bo.getBrandName());
                dmaterialBO.setColorName(bo.getColorName());
                dmaterialBO.setVersionName(bo.getVersionName());
                dmaterialBO.setMaterialDesc(bo.getGoodsLongName());
                dmaterialBO.setIsScm("0");
                dmaterialBO.setMarqueName(bo.getGoodsModel());
            }
            dmaterialBO.setCreateTime(new Date());
            dmaterialBO.setCreateUser(bo.getCreateUser());
            dmaterialBO.setIsValid("1");
            dmaterialBO.setConfigName(bo.getConfigName());
            dmaterialBO.setMaterialId(bo.getMaterialId());
            dmaterialBO.setProvinceCode(bo.getProvinceCode());
            dmaterialBOs.add(dmaterialBO);
        }
        logger.debug("\u521b\u5efa\u7269\u6599\u5165\u53c2\uff1a" + dmaterialBOs);
        this.dMaterialManageService.insertMaterialRecords(dmaterialBOs);
    }

    public List<RuleRespBO> getRules(List<String> brands) throws Exception {
        ArrayList<RuleRespBO> ruleRespBos = new ArrayList<RuleRespBO>();
        JSONObject param = new JSONObject();
        param.put("provinceCode", (Object)"240000");
        param.fluentPut("list", brands);
        param.put("flag", (Object)false);
        logger.debug(param.toString());
        InvokeInfo invokeInfo = new InvokeInfo("com.tydic.newpurchase.api.approvalRule.service.CheckSkuBrandReviewRulesService", "checkSkuBrandReviewRulesService", "com.tydic.newpurchase.api.approvalRule.bo.CheckSkuBrandReviewRulesReqBO");
        invokeInfo.setVersion(this.hsfVersion);
        invokeInfo.setGroup(this.hsfGroup);
        invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
        invokeInfo.setRegisterType("2");
        JSONObject rule = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString((Object)param), null, (InvokeInfo)invokeInfo);
        logger.debug("\u8fdb\u884c\u6cdb\u5316\u8c03\u7528\u8fd4\u56de\u503c" + rule);
        if (!CollectionUtils.isEmpty((Collection)rule.getJSONArray("brandBOList"))) {
            RuleRespBO bo = null;
            JSONArray brandBOList = rule.getJSONArray("brandBOList");
            logger.debug("\u8981\u8d27\u89c4\u5219\u5546\u54c1\u6570=" + brandBOList.size());
            for (int i = 0; i < brandBOList.size(); ++i) {
                JSONObject item = brandBOList.getJSONObject(i);
                if (!StringUtils.isNotEmpty((String)item.getString("brandName"))) continue;
                bo = new RuleRespBO();
                bo.setBrandCode(item.getString("brandCode"));
                bo.setBrandName(item.getString("brandName"));
                bo.setIsExistRule(item.getString("isExistRule"));
                ruleRespBos.add(bo);
            }
        }
        logger.debug(((RuleRespBO)ruleRespBos.get(0)).toString());
        return ruleRespBos;
    }

    public List<String> getProvCode() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        JSONObject param = new JSONObject();
        param.put("queryType", (Object)1);
        param.put("isCutoverFlag", (Object)1);
        param.put("allStatus", (Object)1);
        logger.debug(param.toString());
        InvokeInfo invokeInfo = new InvokeInfo("com.ohaotian.authority.organisation.service.SelectOrgTreeService", "selectOrgTree", "com.ohaotian.authority.organisation.bo.SelectOrgTreeReqBO");
        invokeInfo.setVersion(this.hsfVersion);
        invokeInfo.setGroup(this.hsfGroup);
        invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
        invokeInfo.setRegisterType("2");
        JSONObject prov = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString((Object)param), null, (InvokeInfo)invokeInfo);
        logger.debug("\u8fdb\u884c\u6cdb\u5316\u8c03\u7528\u8fd4\u56de\u503c" + prov);
        JSONArray orgTreeBOList = prov.getJSONArray("orgTreeBOList");
        for (int i = 0; i < orgTreeBOList.size(); ++i) {
            JSONObject item = orgTreeBOList.getJSONObject(i);
            list.add(item.getString("provinceCode"));
        }
        return list;
    }

    public BaseRspBO insureProvCreation(AddProvGoodsListReqBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        HashMap<Long, List> suppiler = new HashMap<Long, List>();
        ArrayList<ProvGoodsPO> record = new ArrayList<ProvGoodsPO>();
        ProvGoodsPO po = null;
        for (ProvGoodsBO bo : reqBO.getReqBO()) {
            if (!suppiler.containsKey(bo.getProvGoodsId())) {
                suppiler.put(bo.getProvGoodsId(), bo.getSupplierBO());
            }
            po = new ProvGoodsPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setHasSerialNumber("0");
            po.setHasPrice("1");
            po.setAllowNegativeStock("05".equals(bo.getSecurityServicesType()) ? "0" : "1");
            po.setIsScmDistribute("05".equals(bo.getSecurityServicesType()) ? "1" : "0");
            po.setIsSendScmSale("05".equals(bo.getSecurityServicesType()) ? "1" : "0");
            po.setIsSendScmStock("05".equals(bo.getSecurityServicesType()) ? "1" : "0");
            po.setCgType("0");
            po.setGoodsSource("00");
            po.setPurchaseType("1");
            po.setWhetherInvoice("1");
            if (reqBO.getIsInsure().booleanValue()) {
                po.setReservedField1("1");
            } else {
                po.setReservedField1("2");
            }
            po.setIsValid("1");
            record.add(po);
        }
        try {
            this.provGoodsDAO.insertList(record);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u4fdd\u969c\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u65b0\u589e\u4fdd\u969c\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u65b0\u589e\u4f9b\u5e94\u5546");
        ArrayList<ProvGoodsSupRelationPO> relationPO = new ArrayList<ProvGoodsSupRelationPO>();
        ProvGoodsSupRelationPO suPO = null;
        for (Map.Entry map : suppiler.entrySet()) {
            for (SupplierBO supplier : (List)map.getValue()) {
                suPO = new ProvGoodsSupRelationPO();
                suPO.setProvGoodsId((Long)map.getKey());
                suPO.setProvinceCode(supplier.getProvinceCode());
                suPO.setSupplierId(Long.parseLong(supplier.getSupplierId()));
                suPO.setCreateTime(new Date());
                suPO.setSupplierName(supplier.getSupplierName());
                relationPO.add(suPO);
            }
        }
        try {
            this.provGoodsSupRelationDAO.insertList(relationPO);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u4f9b\u5e94\u5546\u62a5\u9519");
            throw new BusinessException("9999", "\u65b0\u589e\u4f9b\u5e94\u5546\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public BaseRspBO updateProv(AddProvGoodsListReqBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        logger.debug("\u8c03\u7528\u4fdd\u969c\u670d\u52a1\u66f4\u65b0\u670d\u52a1" + JSONObject.toJSONString((Object)reqBO));
        ArrayList<ProvGoodsPO> record = new ArrayList<ProvGoodsPO>();
        ProvGoodsPO po = null;
        String materialId = ((ProvGoodsBO)reqBO.getReqBO().get(0)).getMaterialId();
        for (ProvGoodsBO bo : reqBO.getReqBO()) {
            po = new ProvGoodsPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setCreateUser(null);
            po.setCreateUsername(null);
            po.setCreateTime(null);
            po.setUpdateTime(new Date());
            po.setWhetherInvoice("1");
            po.setUpdateUser(bo.getCreateUsername());
            record.add(po);
        }
        try {
            this.provGoodsDAO.updateList(record);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4fdd\u969c\u670d\u52a1\u66f4\u65b0\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u8c03\u7528\u4fdd\u969c\u670d\u52a1\u66f4\u65b0\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u4fee\u6539\u4f9b\u5e94\u5546");
        ArrayList<Long> pro = new ArrayList<Long>();
        String goodsType = "";
        goodsType = reqBO.getIsInsure() != false ? "1" : "2";
        List<ProvGoodsPO> provList = this.provGoodsDAO.selectInsureList(materialId, goodsType, null);
        ArrayList<ProvGoodsSupRelationPO> relationPO = new ArrayList<ProvGoodsSupRelationPO>();
        ProvGoodsSupRelationPO suPO = null;
        for (ProvGoodsPO prov : provList) {
            pro.add(prov.getProvGoodsId());
            for (SupplierBO supplier : ((ProvGoodsBO)reqBO.getReqBO().get(0)).getSupplierBO()) {
                suPO = new ProvGoodsSupRelationPO();
                suPO.setProvGoodsId(prov.getProvGoodsId());
                suPO.setProvinceCode(supplier.getProvinceCode());
                suPO.setSupplierId(Long.parseLong(supplier.getSupplierId()));
                suPO.setCreateTime(new Date());
                suPO.setSupplierName(supplier.getSupplierName());
                relationPO.add(suPO);
            }
        }
        try {
            this.provGoodsSupRelationDAO.deleteByProvId(pro);
            this.provGoodsSupRelationDAO.insertList(relationPO);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4fdd\u969c\u670d\u52a1\u66f4\u65b0\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u8c03\u7528\u4fdd\u969c\u670d\u52a1\u66f4\u65b0\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public Map<String, SkuPO> getSku(AddProvGoodsListReqBO reqBO, Map<String, ProvAndCityCodeBO> shopIds) throws Exception {
        HashMap<String, SkuPO> skuMap = new HashMap<String, SkuPO>();
        String provinceCode = ((ProvGoodsBO)reqBO.getReqBO().get(0)).getProvinceCode();
        List<Object> skus = new ArrayList();
        if (!CollectionUtils.isEmpty(shopIds)) {
            ArrayList<String> materialIds = new ArrayList<String>();
            for (ProvGoodsBO bo : reqBO.getReqBO()) {
                materialIds.add(bo.getMaterialId());
            }
            skus = this.xlsSkuMapper.findSkuByProvinceCodeMeterialIds(provinceCode, materialIds);
        }
        if (!CollectionUtils.isEmpty(skus)) {
            for (SkuPO sk : skus) {
                if (!shopIds.containsKey(sk.getSupplierId().toString())) continue;
                sk.setProvinceCode(shopIds.get(sk.getSupplierId().toString()).getProvinceCode());
                sk.setCityCode(shopIds.get(sk.getSupplierId().toString()).getCityCode());
                if (skuMap.containsKey(sk.getMaterialId() + sk.getSupplierId())) continue;
                skuMap.put(sk.getMaterialId() + sk.getSupplierId(), sk);
            }
        }
        return skuMap;
    }

    public Map<String, ProvAndCityCodeBO> getProvCode(String provinceCode, String orgPath) throws Exception {
        HashMap<String, ProvAndCityCodeBO> map = new HashMap<String, ProvAndCityCodeBO>();
        JSONObject param = new JSONObject();
        param.put("queryType", (Object)4);
        param.fluentPut("orgTreePath", (Object)orgPath);
        param.put("isCutoverFlag", (Object)1);
        param.put("isFilteStoreId", (Object)0);
        param.put("allStatus", (Object)1);
        logger.debug(param.toString());
        InvokeInfo invokeInfo = new InvokeInfo("com.ohaotian.authority.organisation.service.SelectOrgTreeService", "selectOrgTree", "com.ohaotian.authority.organisation.bo.SelectOrgTreeReqBO");
        invokeInfo.setVersion(this.hsfVersion);
        invokeInfo.setGroup(this.hsfGroup);
        invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
        invokeInfo.setRegisterType("2");
        JSONObject prov = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString((Object)param), null, (InvokeInfo)invokeInfo);
        logger.debug("\u8fdb\u884c\u6cdb\u5316\u8c03\u7528\u8fd4\u56de\u503c" + prov);
        if (!CollectionUtils.isEmpty((Collection)prov.getJSONArray("orgTreeBOList"))) {
            ProvAndCityCodeBO bo = null;
            JSONArray orgTreeBOList = prov.getJSONArray("orgTreeBOList");
            logger.debug("\u67e5\u8be2\u95e8\u5e97\u8fd4\u56de\u6761\u6570=" + orgTreeBOList.size());
            for (int i = 0; i < orgTreeBOList.size(); ++i) {
                JSONObject item = orgTreeBOList.getJSONObject(i);
                if (!StringUtils.isNotEmpty((String)item.getString("storeId"))) continue;
                bo = new ProvAndCityCodeBO();
                bo.setCityCode(item.getString("cityCode"));
                bo.setSupplierId(item.getString("storeId"));
                bo.setProvinceCode(item.getString("provinceCode"));
                bo.setShopName(item.getString("orgName"));
                bo.setCountryCode(item.getString("districtCode"));
                map.put(item.getString("storeId"), bo);
            }
        }
        return map;
    }

    public CreateSkuReqBO toCreate(ProvGoodsBO bo, ProvAndCityCodeBO shop, Map<String, DPriceSheetBO> priceSheet) {
        CreateSkuReqBO cr = new CreateSkuReqBO();
        String key = bo.getMaterialId() + shop.getProvinceCode() + shop.getCountryCode();
        DPriceSheetBO price = new DPriceSheetBO();
        if (!CollectionUtils.isEmpty(priceSheet)) {
            DPriceSheetBO dPriceSheetBO = price = priceSheet.get(key.trim()) == null ? priceSheet.get(bo.getMaterialId() + shop.getProvinceCode()) : priceSheet.get(key.trim());
        }
        if (price != null) {
            cr.setSaleSrice(price.getSalePrice());
            cr.setSheetId(price.getSheetId());
            cr.setSheetLevel(price.getSheetLevel());
            cr.setAssessmentPrice(price.getAssessmentPrice());
            cr.setSaleSrice(price.getSalePrice());
            cr.setPurchasePrice("1".equals(price.getSheetLevel()) ? price.getPurchasePrice() : null);
            cr.setAgreementPrice(price.getAgreementPrice());
            cr.setMemberPrice(price.getMemberPrice());
        }
        cr.setBrandId(bo.getBrandId());
        cr.setBrandName(bo.getBrandName());
        cr.setColor(bo.getColorName());
        cr.setBrand(bo.getBrandName());
        cr.setGoodsSource(bo.getGoodsSource());
        cr.setModel(bo.getGoodsModel());
        cr.setCgType(bo.getCgType());
        cr.setExtSkuId(bo.getExtGoodsNo());
        cr.setSkuCode(bo.getGoodsNo());
        cr.setRam(bo.getMemoryName());
        cr.setMeasureId(bo.getMeasureId());
        cr.setMeasureName(bo.getMeasureName());
        cr.setFullName(bo.getGoodsLongName());
        cr.setSupplierId(Long.valueOf(Long.parseLong(shop.getSupplierId())));
        cr.setSupplierName(shop.getShopName());
        cr.setCountyCode(shop.getCountryCode());
        cr.setProvinceCode(shop.getProvinceCode());
        cr.setCityCode(shop.getCityCode());
        cr.setName(bo.getGoodsModel());
        cr.setIsVirtualGood(bo.getAllowNegativeStock());
        cr.setMaterialId(bo.getMaterialId());
        cr.setProvGoodsId(bo.getProvGoodsId());
        cr.setProvinceCode(bo.getProvinceCode());
        String venId = "";
        for (SupplierBO su : bo.getSupplierBO()) {
            venId = venId + su.getSupplierId() + ",";
        }
        cr.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
        cr.setVendorName(bo.getSupNo());
        return cr;
    }

    public DSkuBO toUpdate(ProvGoodsBO bo, ProvAndCityCodeBO shopId, SkuPO sku) {
        DSkuBO skuBO = new DSkuBO();
        skuBO.setBrandId(bo.getBrandId());
        skuBO.setBrandName(bo.getBrandName());
        skuBO.setColor(bo.getColorName());
        skuBO.setBrand(bo.getBrandName());
        skuBO.setGoodsSource(bo.getGoodsSource());
        String venId = "";
        for (SupplierBO su : bo.getSupplierBO()) {
            venId = venId + su.getSupplierId() + ",";
        }
        skuBO.setModel(bo.getGoodsModel());
        skuBO.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
        skuBO.setVendorName(bo.getSupNo());
        skuBO.setSkuId(sku.getSkuId());
        skuBO.setRam(bo.getMemoryName());
        skuBO.setProvinceCode(shopId.getProvinceCode());
        skuBO.setCgType(bo.getCgType());
        skuBO.setCityCode(shopId.getCityCode());
        skuBO.setExtSkuId(bo.getExtGoodsNo());
        skuBO.setCountyCode(shopId.getCountryCode());
        skuBO.setSkuCode(bo.getGoodsNo());
        skuBO.setSkuName(bo.getGoodsLongName());
        skuBO.setSkuLongName(bo.getGoodsLongName());
        skuBO.setErpLongName(bo.getGoodsLongName());
        skuBO.setSkuPriceTagName(bo.getGoodsLongName());
        skuBO.setMfgSku(bo.getGoodsModel());
        skuBO.setIsVirtualGood(bo.getAllowNegativeStock());
        skuBO.setProvGoodsId(bo.getProvGoodsId());
        skuBO.setSupplierId(sku.getSupplierId());
        skuBO.setIsDelete(Integer.valueOf(0));
        return skuBO;
    }

    public Map<String, String> getCgType(List<String> materialList) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<Object> list = new ArrayList();
        if (!CollectionUtils.isEmpty(materialList)) {
            ProvGoodsAndSupplierPO record = new ProvGoodsAndSupplierPO();
            record.setMaterialIds(materialList);
            list = this.provGoodsDAO.selectByProvGroup(record);
        }
        if (!CollectionUtils.isEmpty(list)) {
            for (ProvGoodsAndSupplierPO po : list) {
                map.put(po.getMaterialId(), po.getCgType());
            }
        }
        return map;
    }

    public Map<String, MaterialPO> getScm(List<String> materialIds) {
        HashMap<String, MaterialPO> map = new HashMap<String, MaterialPO>();
        if (!CollectionUtils.isEmpty(materialIds)) {
            List<MaterialPO> poList = this.materialDAO.selectScmMaterials(materialIds);
            for (MaterialPO po : poList) {
                if (map.containsKey(po.getMaterialId())) continue;
                map.put(po.getMaterialId(), po);
            }
        }
        return map;
    }

    public void update(List<ProvGoodsBO> reqBO, Map<String, Long> materialAndProvId, Map<String, SkuPO> skus, Map<String, ProvAndCityCodeBO> suppliers) throws Exception {
        ArrayList<DSkuBO> skuBOS = new ArrayList<DSkuBO>();
        HashMap<String, ProvGoodsBO> prov = new HashMap<String, ProvGoodsBO>();
        for (ProvGoodsBO provGoodsBO : reqBO) {
            if (prov.containsKey(provGoodsBO.getMaterialId())) continue;
            prov.put(provGoodsBO.getMaterialId(), provGoodsBO);
        }
        DSkuBO skuBO = null;
        for (Map.Entry<String, SkuPO> entry : skus.entrySet()) {
            skuBO = new DSkuBO();
            String supplierId = entry.getValue().getSupplierId().toString().trim();
            skuBO.setBrandId(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getBrandId());
            skuBO.setBrandName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getBrandName());
            skuBO.setColor(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getColorName());
            skuBO.setBrand(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getBrandName());
            skuBO.setGoodsSource(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsSource());
            String venId = "";
            for (SupplierBO su : ((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getSupplierBO()) {
                venId = venId + su.getSupplierId() + ",";
            }
            skuBO.setModel(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsModel());
            skuBO.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
            skuBO.setVendorName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getSupNo());
            skuBO.setSkuId(entry.getValue().getSkuId());
            skuBO.setRam(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getMemoryName());
            skuBO.setProvinceCode(entry.getValue().getProvinceCode());
            if (StringUtils.isBlank((String)suppliers.get(supplierId).getCountryCode())) {
                logger.debug("\u672a\u83b7\u53d6\u5230\u533a\u53bf\u7f16\u7801\u7684\u95e8\u5e97\uff1a" + supplierId);
            }
            skuBO.setCountyCode(suppliers.get(supplierId).getCountryCode());
            skuBO.setCityCode(suppliers.get(supplierId).getCityCode());
            skuBO.setExtSkuId(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getExtGoodsNo());
            skuBO.setSkuCode(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsNo());
            skuBO.setSkuName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setSkuLongName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setErpLongName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setSkuPriceTagName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setMfgSku(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsModel());
            skuBO.setIsVirtualGood(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getAllowNegativeStock());
            skuBO.setProvGoodsId(materialAndProvId.get(entry.getValue().getMaterialId()));
            skuBO.setSupplierId(entry.getValue().getSupplierId());
            if (Objects.equals(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsStatus(), "03")) {
                skuBO.setIsDelete(Integer.valueOf(0));
            } else if (Objects.equals(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsStatus(), "04")) {
                skuBO.setIsDelete(Integer.valueOf(1));
            }
            skuBOS.add(skuBO);
        }
        logger.debug("\u5546\u54c1\u66f4\u65b0\u6570\u91cf" + skuBOS.size());
        int n = 2000;
        Integer n2 = skuBOS.size();
        int part = n2 / n;
        int len = n2 % n == 0 ? part : part + 1;
        logger.debug("\u65b0\u589e\u5546\u54c1\u5171" + n2 + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        ExecutorService service = Executors.newFixedThreadPool(9);
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * n;
            int end = start + n;
            if (end > n2) {
                end = n2;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            final List rows = skuBOS.subList(start, end);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    AddGoodsByProvCodeServiceImpl.this.xlsSkuManageService.batchUpdate(rows);
                }
            });
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        service.shutdown();
    }

    public Map<String, SkuPO> getSku(List<String> materialIds, String provinceCode) throws Exception {
        HashMap<String, SkuPO> skuMap = new HashMap<String, SkuPO>();
        List<Object> skus = new ArrayList();
        skus = this.xlsSkuMapper.findSkuByProvinceCodeMeterialIds(provinceCode, materialIds);
        if (!CollectionUtils.isEmpty(skus)) {
            for (SkuPO skuPO : skus) {
                if (skuMap.containsKey(skuPO.getMaterialId() + skuPO.getSupplierId())) continue;
                skuMap.put(skuPO.getMaterialId() + skuPO.getSupplierId(), skuPO);
            }
        }
        return skuMap;
    }

    public Map<String, ProvAndCityCodeBO> getProvCode(String orgPath) throws Exception {
        HashMap<String, ProvAndCityCodeBO> map = new HashMap<String, ProvAndCityCodeBO>();
        JSONObject param = new JSONObject();
        param.put("queryType", (Object)4);
        param.fluentPut("orgTreePath", (Object)orgPath);
        param.put("isCutoverFlag", (Object)1);
        param.put("isFilteStoreId", (Object)0);
        param.put("allStatus", (Object)1);
        logger.debug(param.toString());
        InvokeInfo invokeInfo = new InvokeInfo("com.ohaotian.authority.organisation.service.SelectOrgTreeService", "selectOrgTree", "com.ohaotian.authority.organisation.bo.SelectOrgTreeReqBO");
        invokeInfo.setVersion(this.hsfVersion);
        invokeInfo.setGroup(this.hsfGroup);
        invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
        invokeInfo.setRegisterType("2");
        JSONObject prov = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString((Object)param), null, (InvokeInfo)invokeInfo);
        logger.debug("\u8fdb\u884c\u6cdb\u5316\u8c03\u7528\u8fd4\u56de\u503c" + prov);
        if (!CollectionUtils.isEmpty((Collection)prov.getJSONArray("orgTreeBOList"))) {
            JSONArray orgTreeBOList = prov.getJSONArray("orgTreeBOList");
            logger.debug("\u67e5\u8be2\u95e8\u5e97\u8fd4\u56de\u6761\u6570=" + orgTreeBOList.size());
            for (int i = 0; i < orgTreeBOList.size(); ++i) {
                JSONObject item = orgTreeBOList.getJSONObject(i);
                if (!StringUtils.isNotEmpty((String)item.getString("storeId"))) continue;
                ProvAndCityCodeBO bo = new ProvAndCityCodeBO();
                bo.setCityCode(item.getString("cityCode"));
                bo.setProvinceCode(item.getString("provinceCode"));
                bo.setShopName(item.getString("orgName"));
                if (StringUtils.isBlank((String)item.getString("districtCode"))) {
                    logger.debug("\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u4e2d\uff0c\u672a\u83b7\u53d6\u5230\u533a\u53bf\u7f16\u7801\u7684\u95e8\u5e97\uff1a" + item.getString("storeId"));
                }
                bo.setCountryCode(item.getString("districtCode"));
                map.put(item.getString("storeId").trim(), bo);
            }
        }
        return map;
    }

    public void add(List<ProvGoodsBO> reqBO, Map<String, DPriceSheetBO> priceSheet, Map<String, ProvAndCityCodeBO> shopIds) throws Exception {
        ArrayList<CreateSkuReqBO> reqList = new ArrayList<CreateSkuReqBO>();
        if (!CollectionUtils.isEmpty(shopIds)) {
            for (Map.Entry<String, ProvAndCityCodeBO> shopId : shopIds.entrySet()) {
                for (ProvGoodsBO provPO : reqBO) {
                    CreateSkuReqBO bo = new CreateSkuReqBO();
                    String key = provPO.getMaterialId() + shopId.getValue().getProvinceCode() + shopId.getValue().getCityCode();
                    DPriceSheetBO price = new DPriceSheetBO();
                    if (!CollectionUtils.isEmpty(priceSheet)) {
                        price = priceSheet.get(key.trim()) == null ? priceSheet.get(provPO.getMaterialId() + shopId.getValue().getProvinceCode()) : priceSheet.get(key.trim());
                    }
                    bo = new CreateSkuReqBO();
                    bo.setBrandId(provPO.getBrandId());
                    bo.setBrandName(provPO.getBrandName());
                    bo.setColor(provPO.getColorName());
                    bo.setBrand(provPO.getBrandName());
                    bo.setGoodsSource(provPO.getGoodsSource());
                    bo.setModel(provPO.getGoodsModel());
                    bo.setCgType(provPO.getCgType());
                    bo.setExtSkuId(provPO.getExtGoodsNo());
                    bo.setSkuCode(provPO.getGoodsNo());
                    bo.setMeasureId(provPO.getMeasureId());
                    bo.setMeasureName(provPO.getMeasureName());
                    bo.setFullName(provPO.getGoodsLongName());
                    if (price != null) {
                        bo.setSaleSrice(price.getSalePrice());
                        bo.setSheetId(price.getSheetId());
                        bo.setSheetLevel(price.getSheetLevel());
                        bo.setAssessmentPrice(price.getAssessmentPrice());
                        bo.setSaleSrice(price.getSalePrice());
                        bo.setPurchasePrice("1".equals(price.getSheetLevel()) ? price.getPurchasePrice() : null);
                        bo.setAgreementPrice(price.getAgreementPrice());
                        bo.setMemberPrice(price.getMemberPrice());
                    }
                    bo.setSupplierId(Long.valueOf(Long.parseLong(shopId.getKey())));
                    bo.setSupplierName(shopId.getValue().getShopName());
                    bo.setProvinceCode(shopId.getValue().getProvinceCode());
                    bo.setCountyCode(shopId.getValue().getCountryCode());
                    bo.setCityCode(shopId.getValue().getCityCode());
                    bo.setName(provPO.getGoodsModel());
                    bo.setIsVirtualGood(provPO.getAllowNegativeStock());
                    bo.setMaterialId(provPO.getMaterialId());
                    bo.setProvGoodsId(provPO.getProvGoodsId());
                    bo.setProvinceCode(provPO.getProvinceCode());
                    bo.setRam(provPO.getMemoryName());
                    String venId = "";
                    for (SupplierBO su : provPO.getSupplierBO()) {
                        venId = venId + su.getSupplierId() + ",";
                    }
                    bo.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
                    bo.setVendorName(provPO.getSupNo());
                    reqList.add(bo);
                }
            }
            logger.debug("\u65b0\u589e\u5546\u54c1\u6570\u91cf" + reqList.size());
            int pointsDataLimit = 2000;
            Integer size = reqList.size();
            int part = size / pointsDataLimit;
            int len = size % pointsDataLimit == 0 ? part : part + 1;
            logger.debug("\u65b0\u589e\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
            ExecutorService service = Executors.newFixedThreadPool(9);
            for (int i = 0; i < len; ++i) {
                logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
                int start = i * pointsDataLimit;
                int end = start + pointsDataLimit;
                if (end > size) {
                    end = size;
                }
                logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
                final List rows = reqList.subList(start, end);
                service.execute(new Runnable(){

                    @Override
                    public void run() {
                        BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
                        batchCreateSkuReqBO.setCreateSkuReqBOs(rows);
                        AddGoodsByProvCodeServiceImpl.this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
                    }
                });
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            service.shutdown();
            reqList = null;
        }
    }

    public void addAnother(List<ProvGoodsBO> reqBO, Map<String, ProvAndCityCodeBO> shopIds, Map<String, DPriceSheetBO> priceSheet, Map<String, SkuPO> skuMap, List<ProvGoodsBO> updateList, Map<String, SkuPO> updateMap, Map<String, Long> materialAndProvId) {
        ArrayList<CreateSkuReqBO> crea = new ArrayList<CreateSkuReqBO>();
        for (ProvGoodsBO bo : reqBO) {
            for (Map.Entry<String, ProvAndCityCodeBO> shop : shopIds.entrySet()) {
                String key = bo.getMaterialId() + shop.getValue().getProvinceCode() + shop.getValue().getCityCode();
                DPriceSheetBO price = new DPriceSheetBO();
                if (!CollectionUtils.isEmpty(priceSheet)) {
                    DPriceSheetBO dPriceSheetBO = price = priceSheet.get(key.trim()) == null ? priceSheet.get(bo.getMaterialId() + shop.getValue().getProvinceCode()) : priceSheet.get(key.trim());
                }
                if (skuMap.containsKey(bo.getMaterialId() + shop.getKey().trim())) {
                    updateList.add(bo);
                    updateMap.put(bo.getMaterialId() + shop.getKey().trim(), skuMap.get(bo.getMaterialId() + shop.getKey().trim()));
                    continue;
                }
                CreateSkuReqBO cr = new CreateSkuReqBO();
                cr.setBrandId(bo.getBrandId());
                cr.setBrandName(bo.getBrandName());
                cr.setColor(bo.getColorName());
                if (price != null) {
                    cr.setSaleSrice(price.getSalePrice());
                    cr.setSheetId(price.getSheetId());
                    cr.setSheetLevel(price.getSheetLevel());
                    cr.setAssessmentPrice(price.getAssessmentPrice());
                    cr.setSaleSrice(price.getSalePrice());
                    cr.setPurchasePrice("1".equals(price.getSheetLevel()) ? price.getPurchasePrice() : null);
                    cr.setAgreementPrice(price.getAgreementPrice());
                    cr.setMemberPrice(price.getMemberPrice());
                }
                cr.setBrand(bo.getBrandName());
                cr.setGoodsSource(bo.getGoodsSource());
                cr.setModel(bo.getGoodsModel());
                cr.setCgType(bo.getCgType());
                cr.setExtSkuId(bo.getExtGoodsNo());
                cr.setSkuCode(bo.getGoodsNo());
                cr.setRam(bo.getMemoryName());
                cr.setMeasureId(bo.getMeasureId());
                cr.setMeasureName(bo.getMeasureName());
                cr.setFullName(bo.getGoodsLongName());
                cr.setSupplierId(Long.valueOf(Long.parseLong(shop.getKey())));
                cr.setSupplierName(shop.getValue().getShopName());
                cr.setProvinceCode(shop.getValue().getProvinceCode());
                cr.setCountyCode(shop.getValue().getCountryCode());
                cr.setCityCode(shop.getValue().getCityCode());
                cr.setName(bo.getGoodsModel());
                cr.setIsVirtualGood(bo.getAllowNegativeStock());
                cr.setMaterialId(bo.getMaterialId());
                cr.setProvGoodsId(materialAndProvId.get(bo.getMaterialId()));
                cr.setProvinceCode(bo.getProvinceCode());
                String venId = "";
                for (SupplierBO su : bo.getSupplierBO()) {
                    venId = venId + su.getSupplierId() + ",";
                }
                cr.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
                cr.setVendorName(bo.getSupNo());
                if (Objects.equals(bo.getGoodsStatus(), "03")) {
                    cr.setIsDelete(String.valueOf(0));
                } else if (Objects.equals(bo.getGoodsStatus(), "04")) {
                    cr.setIsDelete(String.valueOf(1));
                }
                crea.add(cr);
            }
        }
        logger.debug("\u65b0\u589e\u5176\u4ed6\u6570\u91cf" + crea.size());
        int pointsDataLimit = 2000;
        Integer size = crea.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u65b0\u589e\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        ExecutorService service = Executors.newFixedThreadPool(9);
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            final List rows = crea.subList(start, end);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
                    batchCreateSkuReqBO.setCreateSkuReqBOs(rows);
                    AddGoodsByProvCodeServiceImpl.this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
                }
            });
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        service.shutdown();
        crea = null;
    }

    public Map<String, SupplierBO> getSupplier(List<SupplierBO> supList, String provCode) throws Exception {
        HashMap<String, SupplierBO> map = new HashMap<String, SupplierBO>();
        JSONObject param = new JSONObject();
        param.put("supplierReqList", supList);
        param.put("provinceCode", (Object)provCode);
        logger.debug(param.toString());
        String comeBack = TkHttpRequestUtils.conn(null, (String)param.toString(), null, (String)this.suppilerUrl, null, null);
        logger.debug(comeBack);
        JSONObject prov = JSONObject.parseObject((String)comeBack);
        if (!CollectionUtils.isEmpty((Collection)prov.getJSONArray("supplierList"))) {
            SupplierBO bo = null;
            JSONArray orgTreeBOList = prov.getJSONArray("supplierList");
            for (int i = 0; i < orgTreeBOList.size(); ++i) {
                JSONObject item = orgTreeBOList.getJSONObject(i);
                if (!StringUtils.isNotEmpty((String)item.getString("supplierId"))) continue;
                bo = new SupplierBO();
                bo.setCityCode(item.getString("cityCode"));
                bo.setProvinceCode(item.getString("provinceCode"));
                bo.setSupplierName(item.getString("supplierName"));
                bo.setSupplierId(item.getString("supplierId"));
                map.put(item.getString("supplierName"), bo);
            }
        }
        return map;
    }

    public void ErrorCollection(List<BasicRspBO> basicRspBOS, List<ProvGoodsBO> removeReqBO, ProvGoodsBO bo, String desc) {
        logger.debug(desc);
        BasicRspBO basicRspBO = new BasicRspBO();
        basicRspBO.setRespCode("8888");
        basicRspBO.setRespDesc(desc);
        basicRspBO.setRowNum(bo.getRowNum());
        basicRspBOS.add(basicRspBO);
        removeReqBO.add(bo);
    }

    @Transactional
    public BaseRspBO provGoodsUpload() {
        BaseRspBO result = new BaseRspBO();
        logger.debug("\u521b\u5efa\u7701\u4efd\u5546\u54c1\u8868\u540c\u6b65\u6587\u4ef6");
        ArrayList<String> prov = new ArrayList<String>();
        prov.add("100000");
        prov.add("110000");
        prov.add("120000");
        prov.add("130000");
        prov.add("140000");
        prov.add("150000");
        prov.add("160000");
        prov.add("170000");
        prov.add("180000");
        prov.add("190000");
        prov.add("200000");
        prov.add("210000");
        prov.add("220000");
        prov.add("230000");
        prov.add("240000");
        prov.add("250000");
        prov.add("260000");
        prov.add("270000");
        prov.add("280000");
        prov.add("290000");
        prov.add("300000");
        prov.add("310000");
        prov.add("320000");
        prov.add("330000");
        prov.add("340000");
        prov.add("350000");
        prov.add("360000");
        prov.add("370000");
        prov.add("380000");
        prov.add("390000");
        prov.add("400000");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : prov) {
            String name = this.getFileName(s);
            String path = "";
            try {
                path = this.createNewFile(this.getFileName(s));
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.debug("\u521b\u5efa\u96c6\u56e2\u987a\u5dee\u6587\u4ef6\u62a5\u9519");
                result.setRespCode("8888");
                result.setRespDesc("\u5931\u8d25");
                return result;
            }
            map.put(name, path);
            logger.debug("\u8bfb\u53d6\u6570\u636e\u5e93\u5e76\u5199\u5165\u7701\u4efd\u5546\u54c1\u6570\u636e");
            try {
                Cursor<ProvGoodsPO> poList = this.provGoodsDAO.selectByProvCursor(s);
                this.writeCsvFile(path, poList);
            }
            catch (Exception e) {
                e.printStackTrace();
                result.setRespCode("8888");
                result.setRespDesc("\u5199\u5165csv\u6587\u4ef6\u5931\u8d25");
                return result;
            }
        }
        TkFtpConfig config = new TkFtpConfig(this.hostname, this.port, this.username, this.password);
        TkFtpUtils tkFtpUtils = new TkFtpUtils(config);
        for (Map.Entry entry : map.entrySet()) {
            logger.debug("\u4e0a\u4f20\u8def\u5f84\uff1a" + this.ftpPath + ";\u6587\u4ef6\u540d\u79f0\uff1a" + (String)entry.getKey() + ";\u6587\u4ef6\u672c\u5730\u5730\u5740\uff1a" + (String)entry.getValue());
            Boolean flag = tkFtpUtils.uploadFile(this.ftpPath, (String)entry.getKey(), (String)entry.getValue());
            if (flag.booleanValue()) continue;
            result.setRespCode("8888");
            result.setRespDesc("\u6587\u4ef6" + (String)entry.getKey() + "\u4e0a\u4f20\u5931\u8d25");
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    private String getFileName(String s) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -1);
        Date time = calendar.getTime();
        String date = sdf.format(time);
        return "XLS_PROV_GOODS_" + s + "_" + date + ".csv";
    }

    private String createNewFile(String fileName) throws IOException {
        String path = this.getTmpPath();
        File file = new File(path + fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        return path + fileName;
    }

    private String getTmpPath() {
        String tmpPath = System.getProperty("java.io.tmpdir");
        String os = System.getProperties().getProperty("os.name");
        if (os.toLowerCase().indexOf("linux") != -1) {
            tmpPath = tmpPath + File.separator;
        }
        return tmpPath;
    }

    public void writeCsvFile(String path, Cursor<ProvGoodsPO> poList) throws Exception {
        BufferedWriter fwriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path, false), StandardCharsets.UTF_8));
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (ProvGoodsPO po : poList) {
                StringBuffer content = new StringBuffer();
                content.append("\"").append(po.getProvGoodsId() == null ? "" : po.getProvGoodsId()).append("\",");
                content.append("\"").append(po.getExtGoodsNo() == null ? "" : po.getExtGoodsNo()).append("\",");
                content.append("\"").append(po.getGoodsNo() == null ? "" : po.getGoodsNo()).append("\",");
                content.append("\"").append(po.getProvinceCode() == null ? "" : po.getProvinceCode()).append("\",");
                content.append("\"").append(po.getGoodsLongName() == null ? "" : po.getGoodsLongName()).append("\",");
                content.append("\"").append(po.getGoodsName() == null ? "" : po.getGoodsName()).append("\",");
                content.append("\"").append(po.getGoodsType() == null ? "" : po.getGoodsType()).append("\",");
                content.append("\"").append(po.getMaterialId() == null ? "" : po.getMaterialId()).append("\",");
                content.append("\"").append(po.getBarCode() == null ? "" : po.getBarCode()).append("\",");
                content.append("\"").append(po.getScmGoodsLongName() == null ? "" : po.getScmGoodsLongName()).append("\",");
                content.append("\"").append(po.getBrandId() == null ? "" : po.getBrandId()).append("\",");
                content.append("\"").append(po.getBrandName() == null ? "" : po.getBrandName()).append("\",");
                content.append("\"").append(po.getGoodsModel() == null ? "" : po.getGoodsModel()).append("\",");
                content.append("\"").append(po.getColorName() == null ? "" : po.getColorName()).append("\",");
                content.append("\"").append(po.getVersionName() == null ? "" : po.getVersionName()).append("\",");
                content.append("\"").append(po.getMemoryName() == null ? "" : po.getMemoryName()).append("\",");
                content.append("\"").append(po.getModelTypeName() == null ? "" : po.getModelTypeName()).append("\",");
                content.append("\"").append(po.getConfigName() == null ? "" : po.getConfigName()).append("\",");
                content.append("\"").append(po.getScreenType() == null ? "" : po.getScreenType()).append("\",");
                content.append("\"").append(po.getGoodsStalls() == null ? "" : po.getGoodsStalls()).append("\",");
                content.append("\"").append(po.getSupNo() == null ? "" : po.getSupNo()).append("\",");
                content.append("\"").append(po.getGoodsAttr() == null ? "" : po.getGoodsAttr()).append("\",");
                content.append("\"").append(po.getHasSerialNumber() == null ? "" : po.getHasSerialNumber()).append("\",");
                content.append("\"").append(po.getSerialNumberLength() == null ? "" : po.getSerialNumberLength()).append("\",");
                content.append("\"").append(po.getPurchaseType() == null ? "" : po.getPurchaseType()).append("\",");
                content.append("\"").append(po.getIsAfterInput() == null ? "" : po.getIsAfterInput()).append("\",");
                content.append("\"").append(po.getHasPrice() == null ? "" : po.getHasPrice()).append("\",");
                content.append("\"").append(po.getAllowNegativeStock() == null ? "" : po.getAllowNegativeStock()).append("\",");
                content.append("\"").append(po.getNetwork() == null ? "" : po.getNetwork()).append("\",");
                content.append("\"").append(po.getOperateSystem() == null ? "" : po.getOperateSystem()).append("\",");
                content.append("\"").append(po.getIsValid() == null ? "" : po.getIsValid()).append("\",");
                content.append("\"").append(po.getMaxStock() == null ? "" : po.getMaxStock()).append("\",");
                content.append("\"").append(po.getMinStock() == null ? "" : po.getMinStock()).append("\",");
                content.append("\"").append(po.getAllowStockAge() == null ? "" : po.getAllowStockAge()).append("\",");
                content.append("\"").append(po.getShelveDate() == null ? "" : sdf.format(po.getShelveDate())).append("\",");
                content.append("\"").append(po.getLastTradeDate() == null ? "" : sdf.format(po.getLastTradeDate())).append("\",");
                content.append("\"").append(po.getStandardSystem() == null ? "" : po.getStandardSystem()).append("\",");
                content.append("\"").append(po.getTaxTypeCode() == null ? "" : po.getTaxTypeCode()).append("\",");
                content.append("\"").append(po.getIsSendScmStock() == null ? "" : po.getIsSendScmStock()).append("\",");
                content.append("\"").append(po.getIsSendScmSale() == null ? "" : po.getIsSendScmSale()).append("\",");
                content.append("\"").append(po.getIsScmDistribute() == null ? "" : po.getIsScmDistribute()).append("\",");
                content.append("\"").append(po.getCgType() == null ? "" : po.getCgType()).append("\",");
                content.append("\"").append(po.getMeasureId() == null ? "" : po.getMeasureId()).append("\",");
                content.append("\"").append(po.getMeasureName() == null ? "" : po.getMeasureName()).append("\",");
                content.append("\"").append(po.getGoodsSource() == null ? "" : po.getGoodsSource()).append("\",");
                content.append("\"").append(po.getRemark() == null ? "" : po.getRemark()).append("\",");
                content.append("\"").append(po.getCreateUser() == null ? "" : po.getCreateUser()).append("\",");
                content.append("\"").append(po.getCreateUsername() == null ? "" : po.getCreateUsername()).append("\",");
                content.append("\"").append(po.getCreateTime() == null ? "" : sdf.format(po.getCreateTime())).append("\",");
                content.append("\"").append(po.getUpdateUser() == null ? "" : po.getUpdateUser()).append("\",");
                content.append("\"").append(po.getUpdateTime() == null ? "" : sdf.format(po.getUpdateTime())).append("\",");
                content.append("\"").append(po.getGoodsStatus() == null ? "" : po.getGoodsStatus()).append("\",");
                content.append("\"").append(po.getErpGoodsType() == null ? "" : po.getErpGoodsType()).append("\",");
                if (StringUtils.isNotEmpty((String)po.getBossCode())) {
                    content.append("\"").append(po.getBossCode().substring(1, po.getBossCode().length() - 1)).append("\",");
                } else {
                    content.append("\"").append("").append("\",");
                }
                content.append("\"").append(po.getBossColor() == null ? "" : po.getBossColor()).append("\",");
                content.append("\"").append(po.getReservedField1() == null ? "" : po.getReservedField1()).append("\",");
                content.append("\"").append(po.getReservedField2() == null ? "" : po.getReservedField2()).append("\",");
                content.append("\"").append(po.getReservedField3() == null ? "" : po.getReservedField3()).append("\",");
                content.append("\"").append(po.getReservedField4() == null ? "" : po.getReservedField4()).append("\",");
                content.append("\"").append(po.getProvDescribe() == null ? "" : po.getProvDescribe()).append("\",");
                content.append("\"").append(po.getWhetherInvoice() == null ? "" : po.getWhetherInvoice()).append("\",");
                content.append("\"").append(po.getIsAppstoreAble() == null ? "" : po.getIsAppstoreAble()).append("\",");
                content.append("\"").append(po.getModelCommonName() == null ? "" : po.getModelCommonName()).append("\",");
                content.append("\"").append(po.getInvoiceTaxRate() == null ? "" : po.getInvoiceTaxRate()).append("\"\r\n");
                content = new StringBuffer(content.toString().replaceAll("\r|\n", ""));
                fwriter.write(content + "\r\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception();
        }
        finally {
            logger.debug("\u672c\u6b21\u6d41\u5f0f\u67e5\u8be2\u6570\u636e\u5df2\u83b7\u53d6" + (poList.getCurrentIndex() + 1) + "\u6761\u6570\u636e");
            try {
                fwriter.flush();
                fwriter.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new IOException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicListRspBO batchProvincCommodityCreation(AddProvGoodsListReqBO addProvGoodsListReqBO) {
        String checkMaterialsRsp;
        BasicListRspBO basicListRspBO = new BasicListRspBO();
        ArrayList<BasicRspBO> basicRspBOS = new ArrayList<BasicRspBO>();
        BasicRspBO result = new BasicRspBO();
        Jedis jedis = RedisUtil.getJedis();
        ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
        HashMap<String, Long> materialAndProvId = new HashMap<String, Long>();
        logger.debug("\u67e5\u770b\u7701\u4efd\u5546\u54c1\u521b\u5efa\u63a5\u53e3\u5165\u53c2\u5927\u5c0f\u4e3a\uff1a" + addProvGoodsListReqBO.getReqBO().size());
        if (CollectionUtils.isEmpty((Collection)addProvGoodsListReqBO.getReqBO())) {
            logger.debug("\u7701\u4efd\u5546\u54c1\u521b\u5efa\u63a5\u53e3\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            logger.debug("\u6ca1\u6709\u8981\u540c\u6b65\u7684\u6570\u636e\uff0c\u6e05\u9664\u7f13\u5b58");
            RedisUtil.del("IMPORT_PROVINCE_GOODS" + addProvGoodsListReqBO.getmProvince());
            RedisUtil.release(jedis);
            basicRspBOS.add(result);
            basicListRspBO.setBasicRspBOS(basicRspBOS);
            return basicListRspBO;
        }
        String key = "IMPORT_PROVINCE_GOODS" + ((ProvGoodsBO)addProvGoodsListReqBO.getReqBO().get(0)).getProvinceCode();
        ArrayList<String> materialList = new ArrayList<String>();
        List<ProvGoodsBO> removeReqBO = this.newCheck(addProvGoodsListReqBO, basicRspBOS, materialList);
        addProvGoodsListReqBO.getReqBO().removeAll(removeReqBO);
        logger.debug("\u7269\u6599\u7f16\u7801\u4e3a\uff1a" + materialList);
        logger.debug("\u9519\u8bef\u7684\u6570\u636e\u5927\u5c0f\u4e3a\uff1a" + removeReqBO.size());
        logger.debug("\u9519\u8bef\u63cf\u8ff0\u4e3a\uff1a" + ((Object)basicRspBOS).toString());
        logger.debug("\u5220\u9664\u9519\u8bef\u6570\u636e\u4e4b\u540e\u7684\u6570\u636e\u5927\u5c0f\u4e3a\uff1a" + addProvGoodsListReqBO.getReqBO().size());
        if (CollectionUtils.isEmpty(materialList)) {
            logger.debug("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            RedisUtil.release(jedis);
            basicListRspBO.setBasicRspBOS(basicRspBOS);
            return basicListRspBO;
        }
        for (ProvGoodsBO bo : addProvGoodsListReqBO.getReqBO()) {
            if (jedis.sismember(key, bo.getMaterialId()).booleanValue()) {
                logger.debug("\u8be5\u6279\u7269\u6599\u6b63\u5728\u540c\u6b65\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                BasicRspBO basicRspBO = new BasicRspBO();
                basicRspBO.setRespCode("8888");
                basicRspBO.setRespDesc("\u8be5\u6279\u7269\u6599\u6b63\u5728\u540c\u6b65\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5!");
                basicRspBOS.add(basicRspBO);
                basicListRspBO.setBasicRspBOS(basicRspBOS);
                RedisUtil.release(jedis);
                service.shutdown();
                return basicListRspBO;
            }
            jedis.sadd(key, new String[]{bo.getMaterialId()});
        }
        List<ProvGoodsPO> materialsList = new ArrayList<ProvGoodsPO>();
        if (!CollectionUtils.isEmpty(materialList)) {
            materialsList = this.provGoodsDAO.selectByMaterials(materialList, ((ProvGoodsBO)addProvGoodsListReqBO.getReqBO().get(0)).getProvinceCode());
        }
        if (!StringUtils.isBlank((String)(checkMaterialsRsp = this.ifMaterials(materialsList, addProvGoodsListReqBO)))) {
            logger.debug("\u9875\u9762\u6dfb\u52a0  \u5b58\u5728\u7269\u6599\uff1a" + checkMaterialsRsp);
            result.setRespCode("8888");
            result.setRespDesc(checkMaterialsRsp);
            basicRspBOS.add(result);
            basicListRspBO.setBasicRspBOS(basicRspBOS);
            RedisUtil.del(key);
            RedisUtil.release(jedis);
            return basicListRspBO;
        }
        HashMap<String, ProvGoodsPO> provMap = new HashMap<String, ProvGoodsPO>();
        if (!CollectionUtils.isEmpty(materialsList)) {
            for (ProvGoodsPO po : materialsList) {
                if (provMap.containsKey(po.getProvinceCode() + po.getMaterialId())) continue;
                provMap.put(po.getProvinceCode() + po.getMaterialId(), po);
            }
        }
        BrandPO record = new BrandPO();
        List<BrandPO> brands = this.brandDAO.selectAll(record);
        TreeMap<String, Long> brandMap = new TreeMap<String, Long>(String.CASE_INSENSITIVE_ORDER);
        for (BrandPO brand : brands) {
            if (brandMap.containsKey(brand.getBrandName().trim())) continue;
            brandMap.put(brand.getBrandName().trim(), brand.getBrandId());
        }
        CreateBrandReqBO brandReq = new CreateBrandReqBO();
        ArrayList<BrandBO> brandBOs = new ArrayList<BrandBO>();
        HashSet<String> brandSet = new HashSet<String>();
        HashMap<Long, ProvGoodsBO> supMap = new HashMap<Long, ProvGoodsBO>();
        Map<String, String> cgTypeMap = this.getCgType(materialList);
        Map<String, MaterialPO> scmMaterialMap = this.getScm(materialList);
        for (ProvGoodsBO BO : addProvGoodsListReqBO.getReqBO()) {
            if (!CollectionUtils.isEmpty(provMap) && provMap.containsKey(BO.getProvinceCode() + BO.getMaterialId())) {
                BO.setProvGoodsId(((ProvGoodsPO)provMap.get(BO.getProvinceCode() + BO.getMaterialId())).getProvGoodsId());
            } else {
                BO.setProvGoodsId(Long.valueOf(Sequence.getInstance().nextId()));
            }
            if (StringUtils.isNotEmpty((String)BO.getBrandName())) {
                brandSet.add(BO.getBrandName().trim());
            }
            BO.setCgType(StringUtils.isBlank((String)cgTypeMap.get(BO.getMaterialId())) ? "0" : cgTypeMap.get(BO.getMaterialId()));
            BO.setReservedField3("601".equals(BO.getCgType()) ? "0" : "1");
            BO.setReservedField1("0");
            if (BO.getInvoiceTaxRate() == null) {
                BO.setInvoiceTaxRate(SysParamConstant.INVOICE_TAX_RATE_DEFAULT);
            }
            BO.setMaterialId(StringUtils.isBlank((String)BO.getMaterialId()) ? null : BO.getMaterialId().trim());
            if (supMap.containsKey(BO.getProvGoodsId())) continue;
            supMap.put(BO.getProvGoodsId(), BO);
        }
        for (String brand : brandSet) {
            if (brandMap.containsKey(brand)) continue;
            BrandBO br = new BrandBO();
            Long brandId = Sequence.getInstance().nextId();
            brandMap.put(brand, brandId);
            br.setBrandId(brandId);
            br.setBrandName(brand.trim());
            brandBOs.add(br);
        }
        brandReq.setBrandBOs(brandBOs);
        if (!CollectionUtils.isEmpty(brandBOs)) {
            service.execute(() -> this.brandManageService.insertBrandList(brandReq));
        }
        ArrayList<ProvGoodsBO> scmUpdate = new ArrayList<ProvGoodsBO>();
        ArrayList<ProvGoodsBO> provUpdate = new ArrayList<ProvGoodsBO>();
        ArrayList<ProvGoodsBO> scmInsert = new ArrayList<ProvGoodsBO>();
        ArrayList<ProvGoodsBO> provInsert = new ArrayList<ProvGoodsBO>();
        for (ProvGoodsBO bo : addProvGoodsListReqBO.getReqBO()) {
            ProvGoodsBO provGoodsBO;
            bo.setBrandId((Long)brandMap.get(bo.getBrandName().trim()));
            if (!CollectionUtils.isEmpty(provMap) && provMap.containsKey(bo.getProvinceCode() + bo.getMaterialId())) {
                if (!CollectionUtils.isEmpty(scmMaterialMap) && scmMaterialMap.containsKey(bo.getMaterialId())) {
                    materialAndProvId.put(bo.getMaterialId(), bo.getProvGoodsId());
                    provGoodsBO = new ProvGoodsBO();
                    BeanUtils.copyProperties((Object)bo, (Object)provGoodsBO);
                    provGoodsBO.setGoodsSource("01");
                    bo.setGoodsSource("01");
                    provGoodsBO.setGoodsModel(StringUtils.isBlank((String)scmMaterialMap.get(bo.getMaterialId()).getMarqueName()) ? bo.getGoodsModel() : scmMaterialMap.get(bo.getMaterialId()).getMarqueName());
                    provGoodsBO.setColorName(StringUtils.isBlank((String)scmMaterialMap.get(bo.getMaterialId()).getColorName()) ? bo.getColorName() : scmMaterialMap.get(bo.getMaterialId()).getColorName());
                    provGoodsBO.setBrandName(StringUtils.isBlank((String)scmMaterialMap.get(bo.getMaterialId()).getBrandName()) ? bo.getBrandName() : scmMaterialMap.get(bo.getMaterialId()).getBrandName());
                    provGoodsBO.setVersionName(StringUtils.isBlank((String)scmMaterialMap.get(bo.getMaterialId()).getVersionName()) ? bo.getVersionName() : scmMaterialMap.get(bo.getMaterialId()).getVersionName());
                    provGoodsBO.setScmGoodsLongName(StringUtils.isBlank((String)scmMaterialMap.get(bo.getMaterialId()).getMaterialDesc()) ? bo.getScmGoodsLongName() : scmMaterialMap.get(bo.getMaterialId()).getMaterialDesc());
                    bo.setScmGoodsLongName(StringUtils.isBlank((String)scmMaterialMap.get(bo.getMaterialId()).getMaterialDesc()) ? bo.getScmGoodsLongName() : scmMaterialMap.get(bo.getMaterialId()).getMaterialDesc());
                    if (scmMaterialMap.containsKey(bo.getMaterialId()) && !StringUtils.isBlank((String)scmMaterialMap.get(bo.getMaterialId()).getGoodsTypeName())) {
                        switch (scmMaterialMap.get(bo.getMaterialId()).getGoodsTypeName()) {
                            case "\u7ec8\u7aef": {
                                provGoodsBO.setGoodsType("01");
                                break;
                            }
                            case "\u914d\u4ef6": {
                                provGoodsBO.setGoodsType("02");
                                break;
                            }
                            case "\u4fc3\u9500\u54c1": {
                                provGoodsBO.setGoodsType("03");
                                break;
                            }
                        }
                    }
                    provGoodsBO.setUpdateTime(new Date());
                    provGoodsBO.setUpdateUser(StringUtils.isBlank((String)bo.getCreateUser()) ? bo.getUpdateUser() : bo.getCreateUser());
                    provGoodsBO.setCreateUser(null);
                    provGoodsBO.setCgType(null);
                    provGoodsBO.setHasSerialNumber(null);
                    provGoodsBO.setAllowNegativeStock(null);
                    provGoodsBO.setProvGoodsId(((ProvGoodsPO)provMap.get(bo.getProvinceCode() + bo.getMaterialId())).getProvGoodsId());
                    provGoodsBO.setGoodsName(bo.getGoodsLongName());
                    provGoodsBO.setGoodsStatus(((ProvGoodsPO)provMap.get(bo.getProvinceCode() + bo.getMaterialId())).getGoodsStatus());
                    scmUpdate.add(provGoodsBO);
                    continue;
                }
                materialAndProvId.put(bo.getMaterialId(), bo.getProvGoodsId());
                provGoodsBO = new ProvGoodsBO();
                BeanUtils.copyProperties((Object)bo, (Object)provGoodsBO);
                provGoodsBO.setGoodsSource("00");
                bo.setGoodsSource("00");
                provGoodsBO.setUpdateTime(new Date());
                provGoodsBO.setUpdateUser(StringUtils.isBlank((String)bo.getCreateUser()) ? bo.getUpdateUser() : bo.getCreateUser());
                provGoodsBO.setCreateUser(null);
                provGoodsBO.setCgType(null);
                provGoodsBO.setHasSerialNumber(null);
                provGoodsBO.setAllowNegativeStock(null);
                provGoodsBO.setProvGoodsId(((ProvGoodsPO)provMap.get(bo.getProvinceCode() + bo.getMaterialId())).getProvGoodsId());
                provGoodsBO.setGoodsName(bo.getGoodsLongName());
                provGoodsBO.setGoodsStatus(((ProvGoodsPO)provMap.get(bo.getProvinceCode() + bo.getMaterialId())).getGoodsStatus());
                provUpdate.add(provGoodsBO);
                continue;
            }
            if (!CollectionUtils.isEmpty(scmMaterialMap) && scmMaterialMap.containsKey(bo.getMaterialId())) {
                materialAndProvId.put(bo.getMaterialId(), bo.getProvGoodsId());
                provGoodsBO = new ProvGoodsBO();
                BeanUtils.copyProperties((Object)bo, (Object)provGoodsBO);
                provGoodsBO.setGoodsSource("01");
                bo.setGoodsSource("01");
                provGoodsBO.setGoodsModel(StringUtils.isBlank((String)scmMaterialMap.get(bo.getMaterialId()).getMarqueName()) ? bo.getGoodsModel() : scmMaterialMap.get(bo.getMaterialId()).getMarqueName());
                provGoodsBO.setColorName(StringUtils.isBlank((String)scmMaterialMap.get(bo.getMaterialId()).getColorName()) ? bo.getColorName() : scmMaterialMap.get(bo.getMaterialId()).getColorName());
                provGoodsBO.setBrandName(StringUtils.isBlank((String)scmMaterialMap.get(bo.getMaterialId()).getBrandName()) ? bo.getBrandName() : scmMaterialMap.get(bo.getMaterialId()).getBrandName());
                provGoodsBO.setVersionName(StringUtils.isBlank((String)scmMaterialMap.get(bo.getMaterialId()).getVersionName()) ? bo.getVersionName() : scmMaterialMap.get(bo.getMaterialId()).getVersionName());
                provGoodsBO.setScmGoodsLongName(StringUtils.isBlank((String)scmMaterialMap.get(bo.getMaterialId()).getMaterialDesc()) ? bo.getScmGoodsLongName() : scmMaterialMap.get(bo.getMaterialId()).getMaterialDesc());
                bo.setScmGoodsLongName(StringUtils.isBlank((String)scmMaterialMap.get(bo.getMaterialId()).getMaterialDesc()) ? bo.getScmGoodsLongName() : scmMaterialMap.get(bo.getMaterialId()).getMaterialDesc());
                if (scmMaterialMap.containsKey(bo.getMaterialId()) && !StringUtils.isBlank((String)scmMaterialMap.get(bo.getMaterialId()).getGoodsTypeName())) {
                    switch (scmMaterialMap.get(bo.getMaterialId()).getGoodsTypeName()) {
                        case "\u7ec8\u7aef": {
                            provGoodsBO.setGoodsType("01");
                            break;
                        }
                        case "\u914d\u4ef6": {
                            provGoodsBO.setGoodsType("02");
                            break;
                        }
                        case "\u4fc3\u9500\u54c1": {
                            provGoodsBO.setGoodsType("03");
                            break;
                        }
                    }
                }
                provGoodsBO.setCreateTime(new Date());
                provGoodsBO.setHasPrice("0");
                provGoodsBO.setIsValid("1");
                provGoodsBO.setGoodsName(bo.getGoodsLongName());
                provGoodsBO.setUpdateUser(null);
                provGoodsBO.setCreateUsername(bo.getCreateUser());
                provGoodsBO.setCreateUser(bo.getCreateUser());
                provGoodsBO.setGoodsStatus("03");
                scmInsert.add(provGoodsBO);
                continue;
            }
            materialAndProvId.put(bo.getMaterialId(), bo.getProvGoodsId());
            provGoodsBO = new ProvGoodsBO();
            BeanUtils.copyProperties((Object)bo, (Object)provGoodsBO);
            provGoodsBO.setGoodsSource("00");
            bo.setGoodsSource("00");
            provGoodsBO.setColorName(bo.getColorName());
            provGoodsBO.setBrandName(bo.getBrandName());
            provGoodsBO.setVersionName(bo.getVersionName());
            provGoodsBO.setGoodsModel(bo.getGoodsModel());
            provGoodsBO.setCreateTime(new Date());
            provGoodsBO.setHasPrice("0");
            provGoodsBO.setIsValid("1");
            provGoodsBO.setGoodsName(bo.getGoodsLongName());
            provGoodsBO.setUpdateUser(null);
            provGoodsBO.setCreateUsername(bo.getCreateUser());
            provGoodsBO.setCreateUser(bo.getCreateUser());
            provGoodsBO.setGoodsStatus("03");
            provInsert.add(provGoodsBO);
        }
        try {
            AddProvGoodsListReqBO bo;
            provInsert.addAll(scmInsert);
            provUpdate.addAll(scmUpdate);
            if (!CollectionUtils.isEmpty(provInsert) || !CollectionUtils.isEmpty(provUpdate)) {
                logger.debug("\u5f00\u59cb\u521b\u5efa\u7269\u6599");
                service.execute(() -> {
                    try {
                        this.materialAdd(addProvGoodsListReqBO);
                    }
                    catch (Exception e) {
                        throw new BusinessException("8888", e.getMessage());
                    }
                });
                logger.debug("\u521b\u5efa\u7269\u6599\u7ed3\u675f");
            }
            if (!CollectionUtils.isEmpty(provInsert)) {
                bo = new AddProvGoodsListReqBO();
                bo.setReqBO(provInsert);
                logger.debug("\u65b0\u589e\u7701\u4efd\u5546\u54c1\u5165\u53c2\u4e3a\uff1a" + provInsert.size() + "\u6761\u6570\u636e");
                logger.debug("\u67e5\u770b\u65b0\u589e\u7701\u4efd\u5546\u54c1\u5165\u53c2\u7b2c\u4e00\u6761\u6570\u636e\uff1a" + ((ProvGoodsBO)provInsert.get(0)).toString());
                service.execute(() -> this.addProvGoodsListService.addProvGood(bo));
            }
            if (!CollectionUtils.isEmpty(provUpdate)) {
                bo = new AddProvGoodsListReqBO();
                bo.setReqBO(provUpdate);
                logger.debug("\u4fee\u6539\u7701\u4efd\u5546\u54c1\u5165\u53c2\u4e3a\uff1a" + provUpdate.size() + "\u6761\u6570\u636e");
                logger.debug("\u67e5\u770b\u4fee\u6539\u7701\u4efd\u5546\u54c1\u5165\u53c2\u7b2c\u4e00\u6761\u6570\u636e\uff1a" + ((ProvGoodsBO)provUpdate.get(0)).toString());
                service.execute(() -> this.addProvGoodsListService.updataProvGoods(bo));
            }
        }
        catch (BusinessException e) {
            logger.error("\u5bf9\u7701\u4efd\u5546\u54c1\u8868\u64cd\u4f5c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u7701\u4efd\u5546\u54c1\u7684\u521b\u5efa\u6216\u66f4\u65b0\u63a5\u53e3");
            result.setRespCode("8888");
            result.setRespDesc(e.getMsgInfo());
            basicRspBOS.add(result);
            basicListRspBO.setBasicRspBOS(basicRspBOS);
            RedisUtil.del(key);
            RedisUtil.release(jedis);
            service.shutdown();
            return basicListRspBO;
        }
        catch (Exception e) {
            logger.error("\u7269\u6599\u5546\u54c1\u65b0\u589e\u9519\u8bef");
            result.setRespCode("8888");
            result.setRespDesc(e.getMessage());
            basicRspBOS.add(result);
            basicListRspBO.setBasicRspBOS(basicRspBOS);
            RedisUtil.del(key);
            RedisUtil.release(jedis);
            service.shutdown();
            return basicListRspBO;
        }
        if (supMap != null) {
            ArrayList<ProvGoodsSupRelationPO> relationPO = new ArrayList<ProvGoodsSupRelationPO>();
            ArrayList<Long> provId = new ArrayList<Long>();
            ProvGoodsSupRelationPO po = null;
            for (Map.Entry map : supMap.entrySet()) {
                if (provMap.get(((ProvGoodsBO)map.getValue()).getProvinceCode() + ((ProvGoodsBO)map.getValue()).getMaterialId()) != null) {
                    provId.add(((ProvGoodsPO)provMap.get(((ProvGoodsBO)map.getValue()).getProvinceCode() + ((ProvGoodsBO)map.getValue()).getMaterialId())).getProvGoodsId());
                }
                if (CollectionUtils.isEmpty((Collection)((ProvGoodsBO)map.getValue()).getSupplierBO())) continue;
                for (SupplierBO subo : ((ProvGoodsBO)map.getValue()).getSupplierBO()) {
                    po = new ProvGoodsSupRelationPO();
                    if (provMap.get(((ProvGoodsBO)map.getValue()).getProvinceCode() + ((ProvGoodsBO)map.getValue()).getMaterialId()) != null) {
                        po.setProvGoodsId(((ProvGoodsPO)provMap.get(((ProvGoodsBO)map.getValue()).getProvinceCode() + ((ProvGoodsBO)map.getValue()).getMaterialId())).getProvGoodsId());
                    } else {
                        po.setProvGoodsId((Long)map.getKey());
                    }
                    po.setProvinceCode(subo.getProvinceCode());
                    po.setSupplierId(Long.parseLong(subo.getSupplierId()));
                    po.setCreateTime(new Date());
                    po.setSupplierName(subo.getSupplierName());
                    relationPO.add(po);
                }
            }
            try {
                if (!CollectionUtils.isEmpty(provId)) {
                    this.provGoodsSupRelationDAO.deleteByProvId(provId);
                }
                if (!CollectionUtils.isEmpty(relationPO)) {
                    this.provGoodsSupRelationDAO.insertList(relationPO);
                }
            }
            catch (Exception e) {
                logger.error("\u7701\u4efd\u5546\u54c1\u4e0e\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868\u63d2\u5165\u6570\u636e\u5931\u8d25\uff01");
                result.setRespCode("8888");
                result.setRespDesc("\u7701\u4efd\u5546\u54c1\u4e0e\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868\u63d2\u5165\u6570\u636e\u5931\u8d25\uff01" + e.getMessage());
                basicRspBOS.add(result);
                basicListRspBO.setBasicRspBOS(basicRspBOS);
                RedisUtil.del(key);
                RedisUtil.release(jedis);
                return basicListRspBO;
            }
        }
        ProvinceMaterialBO provinceMaterialBO = new ProvinceMaterialBO();
        provinceMaterialBO.setProvinceCode(((ProvGoodsBO)addProvGoodsListReqBO.getReqBO().get(0)).getProvinceCode());
        provinceMaterialBO.setMaterialId(materialList);
        Map priceSheet = this.dPriceSheetService.findDPriceSheet(provinceMaterialBO);
        Map<String, ProvAndCityCodeBO> shopIds = null;
        Map<String, SkuPO> skuMap = null;
        try {
            shopIds = this.getProvCode(addProvGoodsListReqBO.getmOrgPath());
            skuMap = this.getSku(materialList, ((ProvGoodsBO)addProvGoodsListReqBO.getReqBO().get(0)).getProvinceCode());
            ArrayList<ProvGoodsBO> updateList = new ArrayList<ProvGoodsBO>();
            HashMap<String, SkuPO> updateMap = new HashMap<String, SkuPO>();
            if (!CollectionUtils.isEmpty(shopIds)) {
                this.addAnother(addProvGoodsListReqBO.getReqBO(), shopIds, priceSheet, skuMap, updateList, updateMap, materialAndProvId, service);
            }
            if (!CollectionUtils.isEmpty(updateList)) {
                this.update(updateList, materialAndProvId, updateMap, shopIds, service);
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0sku\u4fe1\u606f\u9519\u8bef" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5bf9SKU\u76f8\u5173\u66f4\u65b0\u521b\u5efa\u64cd\u4f5c\u5931\u8d25\uff01");
            basicRspBOS.add(result);
            basicListRspBO.setBasicRspBOS(basicRspBOS);
            BasicListRspBO basicListRspBO2 = basicListRspBO;
            return basicListRspBO2;
        }
        finally {
            logger.debug("\u540c\u6b65\u5b8c\u6210,\u6e05\u9664\u7f13\u5b58");
            RedisUtil.del(key);
            RedisUtil.release(jedis);
            service.shutdown();
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        basicRspBOS.add(result);
        basicListRspBO.setBasicRspBOS(basicRspBOS);
        return basicListRspBO;
    }

    public void addAnother(List<ProvGoodsBO> reqBO, Map<String, ProvAndCityCodeBO> shopIds, Map<String, DPriceSheetBO> priceSheet, Map<String, SkuPO> skuMap, List<ProvGoodsBO> updateList, Map<String, SkuPO> updateMap, Map<String, Long> materialAndProvId, ExecutorService service) {
        ArrayList<Object> crea = new ArrayList<CreateSkuReqBO>();
        for (ProvGoodsBO bo : reqBO) {
            for (Map.Entry<String, ProvAndCityCodeBO> shop : shopIds.entrySet()) {
                String key = bo.getMaterialId() + shop.getValue().getProvinceCode() + shop.getValue().getCityCode();
                DPriceSheetBO price = new DPriceSheetBO();
                if (!CollectionUtils.isEmpty(priceSheet)) {
                    DPriceSheetBO dPriceSheetBO = price = priceSheet.get(key.trim()) == null ? priceSheet.get(bo.getMaterialId() + shop.getValue().getProvinceCode()) : priceSheet.get(key.trim());
                }
                if (skuMap.containsKey(bo.getMaterialId() + shop.getKey().trim())) {
                    updateList.add(bo);
                    updateMap.put(bo.getMaterialId() + shop.getKey().trim(), skuMap.get(bo.getMaterialId() + shop.getKey().trim()));
                    continue;
                }
                CreateSkuReqBO cr = new CreateSkuReqBO();
                cr.setBrandId(bo.getBrandId());
                cr.setBrandName(bo.getBrandName());
                cr.setColor(bo.getColorName());
                if (price != null) {
                    cr.setSaleSrice(price.getSalePrice());
                    cr.setSheetId(price.getSheetId());
                    cr.setSheetLevel(price.getSheetLevel());
                    cr.setAssessmentPrice(price.getAssessmentPrice());
                    cr.setSaleSrice(price.getSalePrice());
                    cr.setPurchasePrice("1".equals(price.getSheetLevel()) ? price.getPurchasePrice() : null);
                    cr.setAgreementPrice(price.getAgreementPrice());
                    cr.setMemberPrice(price.getMemberPrice());
                }
                cr.setBrand(bo.getBrandName());
                cr.setGoodsSource(bo.getGoodsSource());
                cr.setModel(bo.getGoodsModel());
                cr.setCgType(bo.getCgType());
                cr.setExtSkuId(bo.getExtGoodsNo());
                cr.setSkuCode(bo.getGoodsNo());
                cr.setRam(bo.getMemoryName());
                cr.setMeasureId(bo.getMeasureId());
                cr.setMeasureName(bo.getMeasureName());
                cr.setFullName(bo.getGoodsLongName());
                cr.setSupplierId(Long.valueOf(Long.parseLong(shop.getKey())));
                cr.setSupplierName(shop.getValue().getShopName());
                cr.setProvinceCode(shop.getValue().getProvinceCode());
                cr.setCountyCode(shop.getValue().getCountryCode());
                cr.setCityCode(shop.getValue().getCityCode());
                cr.setName(bo.getGoodsModel());
                cr.setIsVirtualGood(bo.getAllowNegativeStock());
                cr.setMaterialId(bo.getMaterialId());
                cr.setProvGoodsId(materialAndProvId.get(bo.getMaterialId()));
                cr.setProvinceCode(bo.getProvinceCode());
                String venId = "";
                for (SupplierBO su : bo.getSupplierBO()) {
                    venId = venId + su.getSupplierId() + ",";
                }
                cr.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
                cr.setVendorName(bo.getSupNo());
                if (Objects.equals(bo.getGoodsStatus(), "03")) {
                    cr.setIsDelete(String.valueOf(0));
                } else if (Objects.equals(bo.getGoodsStatus(), "04")) {
                    cr.setIsDelete(String.valueOf(1));
                }
                crea.add(cr);
                if (crea.size() < 36000) continue;
                try {
                    this.createSkuService(crea, service);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    crea = new ArrayList();
                }
                catch (Exception e) {
                    service.shutdown();
                    logger.error("\u521b\u5efasku\u548cskuPrice\u5931\u8d25");
                    throw new BusinessException("9999", "\u521b\u5efasku\u548cskuPrice\u5931\u8d25" + e.getMessage());
                }
            }
        }
        if (!CollectionUtils.isEmpty(crea)) {
            try {
                this.createSkuService(crea, service);
                crea = new ArrayList();
            }
            catch (Exception e) {
                service.shutdown();
                logger.error("\u521b\u5efasku\u548cskuPrice\u5931\u8d25");
                throw new BusinessException("9999", "\u521b\u5efasku\u548cskuPrice\u5931\u8d25" + e.getMessage());
            }
        }
    }

    public void createSkuService(List<CreateSkuReqBO> crea, ExecutorService service) {
        logger.debug("\u65b0\u589e\u5176\u4ed6\u6570\u91cf" + crea.size());
        int pointsDataLimit = 2000;
        Integer size = crea.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u65b0\u589e\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            final List<CreateSkuReqBO> rows = crea.subList(start, end);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
                    batchCreateSkuReqBO.setCreateSkuReqBOs(rows);
                    AddGoodsByProvCodeServiceImpl.this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
                }
            });
        }
    }

    public void update(List<ProvGoodsBO> reqBO, Map<String, Long> materialAndProvId, Map<String, SkuPO> skus, Map<String, ProvAndCityCodeBO> suppliers, ExecutorService service) throws Exception {
        ArrayList<Object> skuBOS = new ArrayList<DSkuBO>();
        HashMap<String, ProvGoodsBO> prov = new HashMap<String, ProvGoodsBO>();
        for (ProvGoodsBO bo : reqBO) {
            if (prov.containsKey(bo.getMaterialId())) continue;
            prov.put(bo.getMaterialId(), bo);
        }
        DSkuBO skuBO = null;
        long startTime = System.currentTimeMillis();
        for (Map.Entry<String, SkuPO> s : skus.entrySet()) {
            skuBO = new DSkuBO();
            String supplierId = s.getValue().getSupplierId().toString().trim();
            skuBO.setBrandId(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getBrandId());
            skuBO.setBrandName(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getBrandName());
            skuBO.setColor(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getColorName());
            skuBO.setBrand(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getBrandName());
            skuBO.setGoodsSource(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getGoodsSource());
            String venId = "";
            for (SupplierBO su : ((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getSupplierBO()) {
                venId = venId + su.getSupplierId() + ",";
            }
            skuBO.setModel(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getGoodsModel());
            skuBO.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
            skuBO.setVendorName(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getSupNo());
            skuBO.setSkuId(s.getValue().getSkuId());
            skuBO.setRam(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getMemoryName());
            skuBO.setProvinceCode(s.getValue().getProvinceCode());
            if (StringUtils.isBlank((String)suppliers.get(supplierId).getCountryCode())) {
                logger.debug("\u672a\u83b7\u53d6\u5230\u533a\u53bf\u7f16\u7801\u7684\u95e8\u5e97\uff1a" + supplierId);
            }
            skuBO.setCountyCode(suppliers.get(supplierId).getCountryCode());
            skuBO.setCityCode(suppliers.get(supplierId).getCityCode());
            skuBO.setExtSkuId(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getExtGoodsNo());
            skuBO.setSkuCode(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getGoodsNo());
            skuBO.setSkuName(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setSkuLongName(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setErpLongName(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setSkuPriceTagName(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setMfgSku(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getGoodsModel());
            skuBO.setIsVirtualGood(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getAllowNegativeStock());
            skuBO.setProvGoodsId(materialAndProvId.get(s.getValue().getMaterialId()));
            skuBO.setSupplierId(s.getValue().getSupplierId());
            if (Objects.equals(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getGoodsStatus(), "03")) {
                skuBO.setIsDelete(Integer.valueOf(0));
            } else if (Objects.equals(((ProvGoodsBO)prov.get(s.getValue().getMaterialId())).getGoodsStatus(), "04")) {
                skuBO.setIsDelete(Integer.valueOf(1));
            }
            skuBOS.add(skuBO);
            if (skuBOS.size() < 36000) continue;
            try {
                this.updateSkuAndSkuprice(skuBOS, service);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                skuBOS = new ArrayList();
            }
            catch (Exception e) {
                service.shutdown();
                logger.error("\u4fee\u6539sku\u548cskuPrice\u5931\u8d25");
                throw new BusinessException("9999", "\u4fee\u6539sku\u548cskuPrice\u5931\u8d25" + e.getMessage());
            }
        }
        if (!CollectionUtils.isEmpty(skuBOS)) {
            try {
                this.updateSkuAndSkuprice(skuBOS, service);
                skuBOS = new ArrayList();
            }
            catch (Exception e) {
                service.shutdown();
                logger.error("\u4fee\u6539sku\u548cskuPrice\u5931\u8d25");
                throw new BusinessException("9999", "\u4fee\u6539sku\u548cskuPrice\u5931\u8d25" + e.getMessage());
            }
        }
    }

    public void updateSkuAndSkuprice(List<DSkuBO> skuBOS, ExecutorService service) {
        logger.debug("\u5546\u54c1\u66f4\u65b0\u6570\u91cf" + skuBOS.size());
        int pointsDataLimit = 2000;
        Integer size = skuBOS.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u65b0\u589e\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            final List<DSkuBO> rows = skuBOS.subList(start, end);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    AddGoodsByProvCodeServiceImpl.this.xlsSkuManageService.batchUpdate(rows);
                }
            });
        }
    }
}

