/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.newretail.bo.AddProvGoodsListReqBO;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.ProvGoodsBO;
import com.tydic.newretail.busi.service.AddProvGoodsListService;
import com.tydic.newretail.dao.ProvGoodsDAO;
import com.tydic.newretail.dao.po.ProvGoodsPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AddProvGoodsListServiceImpl
implements AddProvGoodsListService {
    private static final Logger logger = LoggerFactory.getLogger(AddProvGoodsListServiceImpl.class);
    @Autowired
    private ProvGoodsDAO provGoodsDAO;

    public BaseRspBO addProvGood(AddProvGoodsListReqBO reqBO) {
        logger.debug("\u6279\u91cf\u65b0\u589e\u7701\u4efd\u5546\u54c1\uff1a" + reqBO.getReqBO().size());
        BaseRspBO result = new BaseRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getReqBO())) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        ArrayList<ProvGoodsPO> record = new ArrayList<ProvGoodsPO>();
        ProvGoodsPO po = null;
        for (ProvGoodsBO bo : reqBO.getReqBO()) {
            po = new ProvGoodsPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setProvDescribe(bo.getDescribe());
            logger.debug("addProvGood\u65b9\u6cd5isAppstoreAble\u5b57\u6bb5\u503c\uff1a" + JSON.toJSONString((Object)po.getIsAppstoreAble()));
            record.add(po);
        }
        try {
            this.provGoodsDAO.insertList(record);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u65b0\u589e\u7701\u4efd\u5546\u54c1\u62a5\u9519");
            throw new BusinessException("9999", "\u6279\u91cf\u65b0\u589e\u7701\u4efd\u5546\u54c1\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public BaseRspBO updataProvGoods(AddProvGoodsListReqBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        logger.debug("\u8c03\u7528\u6279\u91cf\u4fee\u6539\uff1a" + reqBO.getReqBO().size());
        if (CollectionUtils.isEmpty((Collection)reqBO.getReqBO())) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        ArrayList<ProvGoodsPO> record = new ArrayList<ProvGoodsPO>();
        ProvGoodsPO po = null;
        for (ProvGoodsBO bo : reqBO.getReqBO()) {
            po = new ProvGoodsPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setProvDescribe(bo.getDescribe());
            record.add(po);
        }
        try {
            this.provGoodsDAO.updateList(record);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u65b0\u589e\u7701\u4efd\u5546\u54c1\u62a5\u9519");
            throw new BusinessException("9999", "\u6279\u91cf\u65b0\u589e\u7701\u4efd\u5546\u54c1\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }
}

