/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.BrandBO;
import com.tydic.newretail.bo.CreateBrandReqBO;
import com.tydic.newretail.bo.RspInfoListBO;
import com.tydic.newretail.busi.service.BrandManageService;
import com.tydic.newretail.dao.BrandDAO;
import com.tydic.newretail.dao.po.BrandPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BrandManageServiceImpl
implements BrandManageService {
    private static final Logger logger = LoggerFactory.getLogger(BrandManageServiceImpl.class);
    @Autowired
    private BrandDAO brandMapper;

    public BaseRspBO insertBrandList(CreateBrandReqBO reqBO) {
        List brandBOs = reqBO.getBrandBOs();
        logger.debug("\u65b0\u589e\u54c1\u724c\u5217\u8868\u5165\u53c2=" + reqBO.getBrandBOs().size());
        BaseRspBO baseRspBO = new BaseRspBO();
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)brandBOs)) {
            logger.debug("\u65b0\u589e\u54c1\u724c\u5217\u8868\u5165\u53c2list\u4e3a\u7a7a");
            return baseRspBO;
        }
        Date now = new Date();
        ArrayList<BrandPO> brandList = new ArrayList<BrandPO>();
        for (BrandBO brandBO : brandBOs) {
            if (!StringUtils.isNotBlank((CharSequence)brandBO.getBrandName())) continue;
            BrandPO brand = new BrandPO();
            if (brandBO.getBrandId() == null) {
                brandBO.setBrandId(Long.valueOf(Sequence.getInstance().nextId()));
            }
            brandBO.setBrandStatus(Integer.valueOf(1));
            brandBO.setEffTime(now);
            brandBO.setExpTime(now);
            brandBO.setCreateTime(now);
            brandBO.setUpdateTime(now);
            brandBO.setIsDelete(Integer.valueOf(0));
            BeanUtils.copyProperties((Object)brandBO, (Object)brand);
            brandList.add(brand);
        }
        try {
            if (CollectionUtils.isEmpty(brandList)) {
                logger.debug("\u65b0\u589e\u54c1\u724c\u5217\u8868\u8c03\u7528\u5165\u53c2list\u4e3a\u7a7a");
                return baseRspBO;
            }
            this.brandMapper.insertBatch(brandList);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u65b0\u589e\u54c1\u724c\u5217\u8868\u6570\u636e\u5e93\u5f02\u5e38" + e.getMessage());
        }
        return baseRspBO;
    }

    public BrandBO selectOneBrand(BrandBO brandBO) {
        BrandBO brandBORsp = new BrandBO();
        BrandPO brand = new BrandPO();
        BeanUtils.copyProperties((Object)brandBO, (Object)brand);
        BrandPO brandRsp = this.brandMapper.selectByMany(brand);
        BeanUtils.copyProperties((Object)brandRsp, (Object)brandBORsp);
        return brandBORsp;
    }

    public RspInfoListBO<BrandBO> selectBrand(BrandBO brandBO) {
        RspInfoListBO result = new RspInfoListBO();
        List<BrandPO> brands = null;
        try {
            BrandPO brand = new BrandPO();
            brand.setBrandName(brandBO.getBrandName());
            brands = this.brandMapper.selectAll(brand);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6839\u636e\u54c1\u724c\u540d\u6a21\u7cca\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
        }
        ArrayList<BrandBO> brandBOs = new ArrayList<BrandBO>();
        if (CollectionUtils.isNotEmpty(brands)) {
            for (BrandPO brand : brands) {
                BrandBO brandBO1 = new BrandBO();
                BeanUtils.copyProperties((Object)brand, (Object)brandBO1);
                brandBOs.add(brandBO1);
            }
        }
        result.setRows(brandBOs);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public BaseRspBO insertBrand(BrandBO brandBO) {
        logger.debug("\u65b0\u589e\u54c1\u724c\u5165\u53c2=" + brandBO.toString());
        BaseRspBO baseRspBO = new BaseRspBO();
        BrandPO brand = new BrandPO();
        brandBO.setBrandId(Long.valueOf(Sequence.getInstance().nextId()));
        brandBO.setBrandStatus(Integer.valueOf(1));
        brandBO.setEffTime(new Date());
        brandBO.setExpTime(new Date());
        brandBO.setCreateTime(new Date());
        brandBO.setUpdateTime(new Date());
        brandBO.setIsDelete(Integer.valueOf(0));
        BeanUtils.copyProperties((Object)brandBO, (Object)brand);
        try {
            this.brandMapper.insertSelective(brand);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u65b0\u589e\u54c1\u724c\u6570\u636e\u5e93\u5f02\u5e38" + e.getMessage());
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return baseRspBO;
    }
}

