/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.CommodityExtSkuIdBO;
import com.tydic.newretail.bo.CommodityExtSkuIdResBO;
import com.tydic.newretail.busi.service.CommodityExtSkuIdService;
import com.tydic.newretail.dao.CommodityExtSkuIdDAO;
import com.tydic.newretail.dao.po.CommodityExtSkuIdPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommodityExtSkuIdServiceImpl
implements CommodityExtSkuIdService {
    private static final Logger logger = LoggerFactory.getLogger(CommodityExtSkuIdServiceImpl.class);
    @Autowired
    private CommodityExtSkuIdDAO commodityExtSkuIdDAO;

    public CommodityExtSkuIdResBO getRelationByExtSkuId(CommodityExtSkuIdBO reqBO) {
        logger.debug("\u8c03\u7528\u5173\u7cfb\u67e5\u8be2\u670d\u52a1" + reqBO.toString());
        CommodityExtSkuIdResBO result = new CommodityExtSkuIdResBO();
        if ("1".equals(reqBO.getmUserLevel())) {
            logger.debug("\u603b\u90e8\u4e0d\u53ef\u7f16\u8f91");
            result.setRespCode("8888");
            result.setRespDesc("\u603b\u90e8\u4e0d\u53ef\u7f16\u8f91\uff0c\u8bf7\u4f7f\u7528\u7701\u4efd\u8d26\u53f7\u64cd\u4f5c");
            return result;
        }
        CommodityExtSkuIdPO record = new CommodityExtSkuIdPO();
        record.setMaterialId(reqBO.getMaterialId());
        record.setProvinceCode(reqBO.getProvinceCode());
        ArrayList<CommodityExtSkuIdBO> boList = new ArrayList<CommodityExtSkuIdBO>();
        try {
            List<CommodityExtSkuIdPO> poList = this.commodityExtSkuIdDAO.selectByExtSkuId(record);
            if (poList.isEmpty()) {
                result.setRespCode("0000");
                result.setRespDesc("\u6210\u529f");
                result.setRows(boList);
                return result;
            }
            for (CommodityExtSkuIdPO po : poList) {
                CommodityExtSkuIdBO bo = new CommodityExtSkuIdBO();
                bo.setCityCode(po.getCityCode());
                bo.setCommodityId(po.getCommodityId());
                bo.setCreateTime(po.getCreateTime());
                bo.setExtSkuId(po.getExtSkuId());
                bo.setIsValid(po.getIsValid());
                bo.setOpreateUserId(po.getOpreateUserId());
                bo.setProvinceCode(po.getProvinceCode());
                bo.setRelationId(po.getRelationId());
                bo.setUpdateTime(po.getUpdateTime());
                bo.setCommodityDimensionJson(po.getCommodityDimensionJson());
                bo.setCommodityPropGrpId(po.getCommodityPropGrpId());
                bo.setMaterialId(po.getMaterialId());
                bo.setSuppilerIdList(po.getSuppilerIdList());
                boList.add(bo);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u51fa\u9519" + e);
            e.printStackTrace();
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(boList);
        return result;
    }

    public BaseRspBO addRelation(CommodityExtSkuIdBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        String entryCheck = this.entryCheck(reqBO);
        if (entryCheck != null) {
            result.setRespCode("8888");
            result.setRespDesc(entryCheck);
            return result;
        }
        CommodityExtSkuIdPO record = new CommodityExtSkuIdPO();
        record.setCityCode(reqBO.getCityCode());
        record.setCommodityId(reqBO.getCommodityId());
        record.setCreateTime(new Date());
        record.setMaterialId(reqBO.getMaterialId());
        record.setSuppilerIdList(reqBO.getSuppilerIdList());
        record.setExtSkuId(reqBO.getExtSkuId());
        record.setIsValid('1');
        record.setCommodityDimensionJson(reqBO.getCommodityDimensionJson());
        record.setCommodityPropGrpId(reqBO.getCommodityPropGrpId());
        record.setOpreateUserId(reqBO.getOpreateUserId());
        record.setProvinceCode(reqBO.getProvinceCode());
        record.setUpdateTime(new Date());
        try {
            int bandResult = this.commodityExtSkuIdDAO.addRelation(record);
            if (bandResult <= 0) {
                result.setRespCode("8888");
                result.setRespDesc("\u5931\u8d25");
                return result;
            }
        }
        catch (Exception e) {
            logger.error("\u7ed1\u5b9a\u5173\u7cfb\u51fa\u9519" + e);
            e.printStackTrace();
            throw new BusinessException("9999", "\u7ed1\u5b9a\u5173\u7cfb\u51fa\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public BaseRspBO updateStatus(CommodityExtSkuIdBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        CommodityExtSkuIdPO record = new CommodityExtSkuIdPO();
        record.setRelationId(reqBO.getRelationId());
        record.setCityCode(reqBO.getCityCode());
        record.setCommodityId(reqBO.getCommodityId());
        record.setCommodityDimensionJson(reqBO.getCommodityDimensionJson());
        record.setCommodityPropGrpId(reqBO.getCommodityPropGrpId());
        record.setExtSkuId(reqBO.getExtSkuId());
        record.setIsValid(reqBO.getIsValid());
        record.setOpreateUserId(reqBO.getOpreateUserId());
        record.setProvinceCode(reqBO.getProvinceCode());
        record.setMaterialId(reqBO.getMaterialId());
        record.setSuppilerIdList(reqBO.getSuppilerIdList());
        record.setUpdateTime(new Date());
        try {
            int updateResult = this.commodityExtSkuIdDAO.updateStatus(record);
            if (updateResult <= 0) {
                result.setRespCode("8888");
                result.setRespDesc("\u5931\u8d25");
                return result;
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u51fa\u9519" + e);
            e.printStackTrace();
            throw new BusinessException("9999", "\u66f4\u65b0\u51fa\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public String entryCheck(CommodityExtSkuIdBO reqBO) {
        if (reqBO.getCommodityId() == null) {
            return "\u5546\u54c1Id\u5fc5\u4f20";
        }
        if (reqBO.getMaterialId() == null || "".equals(reqBO.getMaterialId())) {
            return "\u7269\u6599\u5fc5\u4f20";
        }
        return null;
    }
}

