/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.CreateShareRecordReqBO;
import com.tydic.newretail.bo.DShareRecordBO;
import com.tydic.newretail.busi.service.AddSkuPreferencesService;
import com.tydic.newretail.busi.service.CreateShareRecordService;
import com.tydic.newretail.busi.service.DShareRecordManageService;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.thread.AddSkuPreferencesThread;
import com.tydic.newretail.util.CreateThreadUtils;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateShareRecordServiceImpl
implements CreateShareRecordService {
    @Autowired
    private DShareRecordManageService dShareRecordManageService;
    @Autowired
    private AddSkuPreferencesService addSkuPreferencesService;
    @Autowired
    private SkuDAO skuMapper;
    private static final Logger logger = LoggerFactory.getLogger(CreateShareRecordServiceImpl.class);

    public BaseRspBO createShareRecord(CreateShareRecordReqBO createShareRecordReqBO) {
        BaseRspBO baseRspBO = new BaseRspBO();
        logger.debug("\u521b\u5efa\u5c0f\u7a0b\u5e8f\u5206\u4eab\u8bb0\u5f55\u670d\u52a1\u5165\u53c2=" + createShareRecordReqBO.toString());
        DShareRecordBO dShareRecordBO1 = new DShareRecordBO();
        dShareRecordBO1.setSharer(createShareRecordReqBO.getSharer());
        dShareRecordBO1.setSharee(createShareRecordReqBO.getSharee());
        dShareRecordBO1.setSkuId(createShareRecordReqBO.getSkuId());
        DShareRecordBO dShareRecordBORsp = null;
        try {
            dShareRecordBORsp = this.dShareRecordManageService.selectByManyId(dShareRecordBO1);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            logger.error("\u6839\u636e\u5206\u4eab\u4eba\u3001\u88ab\u5206\u4eab\u4eba\u548cskuId\u67e5\u8be2\u5206\u4eab\u8bb0\u5f55\u62a5\u9519");
        }
        if (dShareRecordBORsp != null && dShareRecordBORsp.getRecordId() != null) {
            logger.debug("\u67e5\u5230\u4e86\u8fd9\u4e2a\u5546\u54c1\u7684\u5206\u4eab\u8bb0\u5f55");
            baseRspBO.setRespCode("0000");
            baseRspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
            return baseRspBO;
        }
        DShareRecordBO dShareRecordBO = new DShareRecordBO();
        dShareRecordBO.setRecordId(Long.valueOf(Sequence.getInstance().nextId()));
        dShareRecordBO.setShareSource(createShareRecordReqBO.getShareSource());
        dShareRecordBO.setShareType(createShareRecordReqBO.getShareType());
        if (createShareRecordReqBO.getCommodityId() != null) {
            dShareRecordBO.setCommodityId(createShareRecordReqBO.getCommodityId());
        } else {
            SkuPO sku = this.skuMapper.selectByPrimaryKey(createShareRecordReqBO.getSkuId());
            dShareRecordBO.setCommodityId(sku.getCommodityId());
        }
        dShareRecordBO.setSkuId(createShareRecordReqBO.getSkuId());
        dShareRecordBO.setSharer(createShareRecordReqBO.getSharer());
        dShareRecordBO.setSharee(createShareRecordReqBO.getSharee());
        dShareRecordBO.setSharerOpenId(createShareRecordReqBO.getSharerOpenId());
        dShareRecordBO.setShareeOpenId(createShareRecordReqBO.getShareeOpenId());
        dShareRecordBO.setIsSuccess(createShareRecordReqBO.getIsSuccess());
        dShareRecordBO.setIsStaffPush(createShareRecordReqBO.getIsStaffPush());
        dShareRecordBO.setSupplierId(createShareRecordReqBO.getSupplierId());
        dShareRecordBO.setProvinceCode(createShareRecordReqBO.getProvinceCode());
        dShareRecordBO.setCreateTime(new Date());
        try {
            this.dShareRecordManageService.insertDShareRecord(dShareRecordBO);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5c0f\u7a0b\u5e8f\u5206\u4eab\u8bb0\u5f55\u62a5\u9519");
            baseRspBO.setRespCode("9999");
            baseRspBO.setRespDesc("\u521b\u5efa\u5c0f\u7a0b\u5e8f\u5206\u4eab\u8bb0\u5f55\u62a5\u9519");
            return baseRspBO;
        }
        if (createShareRecordReqBO.getSharer() != null && createShareRecordReqBO.getSkuId() != null) {
            AddSkuPreferencesThread addSkuPreferencesThread = new AddSkuPreferencesThread(this.addSkuPreferencesService, createShareRecordReqBO.getSkuId(), createShareRecordReqBO.getSharer(), "4");
            ExecutorService singleThreadPool = CreateThreadUtils.createSimpleThreadPool(addSkuPreferencesThread, "addSkuPreferencesThread", 1, 1);
            singleThreadPool.execute(() -> logger.debug(Thread.currentThread().getName()));
            singleThreadPool.shutdown();
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return baseRspBO;
    }
}

