/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.DmaterialBO;
import com.tydic.newretail.bo.RspInfoListBO;
import com.tydic.newretail.busi.service.DMaterialManageService;
import com.tydic.newretail.dao.MaterialDAO;
import com.tydic.newretail.dao.po.MaterialPO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DMaterialManageServiceImpl
implements DMaterialManageService {
    private static final Logger logger = LoggerFactory.getLogger(DMaterialManageServiceImpl.class);
    @Autowired
    private MaterialDAO materialDAO;

    public BaseRspBO insertMaterialRecords(List<DmaterialBO> dmaterialBOs) {
        BaseRspBO baseRspBO = new BaseRspBO();
        if (CollectionUtils.isEmpty(dmaterialBOs)) {
            logger.info("\u5546\u54c1\u4e2d\u5fc3-\u7269\u6599\u5546\u54c1\u65b0\u589e\u539f\u5b50\u670d\u52a1\u63d2\u5165\u6570\u7ec4\u4e3a\u7a7a");
            baseRspBO.setRespCode("0000");
            baseRspBO.setRespDesc("\u6210\u529f");
            return baseRspBO;
        }
        ArrayList<MaterialPO> materialPOS = new ArrayList<MaterialPO>();
        for (DmaterialBO dmaterialBO : dmaterialBOs) {
            MaterialPO materialPO = new MaterialPO();
            BeanUtils.copyProperties((Object)dmaterialBO, (Object)materialPO);
            materialPOS.add(materialPO);
        }
        try {
            this.materialDAO.insertMaterialBatch(materialPOS);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u7269\u6599\u5546\u54c1\u65b0\u589e\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public RspInfoListBO<DmaterialBO> selectByFuzzyMaterial(String material) {
        RspInfoListBO baseRspBO = new RspInfoListBO();
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        ArrayList<DmaterialBO> rows = new ArrayList<DmaterialBO>();
        try {
            List<MaterialPO> poList = this.materialDAO.selectByFuzzyMaterial(material);
            if (CollectionUtils.isEmpty(poList)) {
                logger.info("\u5546\u54c1\u4e2d\u5fc3-\u7269\u6599\u7f16\u7801\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u7ed3\u679c\u96c6\u4e3a\u7a7a");
                return baseRspBO;
            }
            for (MaterialPO po1 : poList) {
                DmaterialBO bo = new DmaterialBO();
                BeanUtils.copyProperties((Object)po1, (Object)bo);
                rows.add(bo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u7269\u6599\u7f16\u7801\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        baseRspBO.setRows(rows);
        return baseRspBO;
    }
}

