/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.DPriceSheetItemBO;
import com.tydic.newretail.busi.service.DPriceSheetItemManageService;
import com.tydic.newretail.dao.PriceSheetItemDAO;
import com.tydic.newretail.dao.po.PriceSheetItemPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DPriceSheetItemManageServiceImpl
implements DPriceSheetItemManageService {
    private static final Logger logger = LoggerFactory.getLogger(DPriceSheetItemManageServiceImpl.class);
    @Autowired
    private PriceSheetItemDAO priceSheetItemDAO;

    public BaseRspBO insertSheetItemBatch(List<DPriceSheetItemBO> reqList) {
        BaseRspBO baseRspBO = new BaseRspBO();
        if (CollectionUtils.isEmpty(reqList)) {
            logger.info("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u65b0\u589e\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
            baseRspBO.setRespCode("7777");
            baseRspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
            throw new BusinessException("9999", "\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u65b0\u589e\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
        }
        logger.debug("\u5165\u53c2\uff1a" + JSONObject.toJSONString(reqList));
        ArrayList<PriceSheetItemPO> list = new ArrayList<PriceSheetItemPO>();
        for (DPriceSheetItemBO bo : reqList) {
            list.add(this.boToItemPo(bo));
        }
        try {
            this.priceSheetItemDAO.insertSheetItemBatch(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u65b0\u589e\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
            throw new BusinessException("9999", "\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u65b0\u589e\u539f\u5b50\u670d\u52a1\u51fa\u9519");
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    private PriceSheetItemPO boToItemPo(DPriceSheetItemBO bo) {
        PriceSheetItemPO po = new PriceSheetItemPO();
        BeanUtils.copyProperties((Object)bo, (Object)po);
        try {
            if (StringUtils.isNotBlank((CharSequence)bo.getPurchaseFloorPrice())) {
                po.setPurchaseFloorPrice(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getPurchaseFloorPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getRetailAgreementPrice())) {
                po.setRetailAgreementPrice(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getRetailAgreementPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getCitiesLockPrice())) {
                po.setCitiesLockPrice(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getCitiesLockPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getTheCostDownPrice())) {
                po.setTheCostDownPrice(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getTheCostDownPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getAssessmentPrice())) {
                po.setAssessmentPrice(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getAssessmentPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getPurchasePrice())) {
                po.setPurchasePrice(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getPurchasePrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getSalePrice())) {
                po.setSalePrice(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getSalePrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getAgreementPrice())) {
                po.setAgreementPrice(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getAgreementPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getProvAgreePrice())) {
                po.setProvAgreePrice(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getProvAgreePrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getMemberPrice())) {
                po.setMemberPrice(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getMemberPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getTradePrice())) {
                po.setTradePrice(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getTradePrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getLastPurchasePrice())) {
                po.setLastPurchasePrice(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getLastPurchasePrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getCostPrice())) {
                po.setCostPrice(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getCostPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getSparePrice2())) {
                po.setSparePrice2(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getSparePrice2())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getSparePrice3())) {
                po.setSparePrice3(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getSparePrice3())).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getSparePrice4())) {
                po.setSparePrice4(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getSparePrice4())).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getSparePrice5())) {
                po.setSparePrice5(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getSparePrice5())).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getMemberLadderPrice1())) {
                po.setMemberLadderPrice1(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getMemberLadderPrice1())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getMemberLadderPrice2())) {
                po.setMemberLadderPrice2(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getMemberLadderPrice2())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getMemberLadderPrice3())) {
                po.setMemberLadderPrice3(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getMemberLadderPrice3())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getMemberLadderPrice4())) {
                po.setMemberLadderPrice4(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getMemberLadderPrice4())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getMemberLadderPrice5())) {
                po.setMemberLadderPrice5(MoneyUtils.BigDecimal2Long(new BigDecimal(bo.getMemberLadderPrice5())));
            }
            po.setCreateTime(new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u65b0\u589e\u539f\u5b50\u670d\u52a1\u91d1\u989d\u8f6c\u6362\u51fa\u9519" + e.getMessage());
        }
        return po;
    }

    public BaseRspBO deleteSheetItemBySheetId(Long sheetId) {
        BaseRspBO baseRspBO = new BaseRspBO();
        if (sheetId == null) {
            logger.info("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u5220\u9664\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
            baseRspBO.setRespCode("7777");
            baseRspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
            return baseRspBO;
        }
        try {
            this.priceSheetItemDAO.deleteBySheetId(sheetId);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u5220\u9664\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }
}

