/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.atom.SysParamsAtomService;
import com.tydic.newretail.bo.DPriceSheetBO;
import com.tydic.newretail.bo.PriceSheetBO;
import com.tydic.newretail.bo.QueryDPriceSheetReqBO;
import com.tydic.newretail.bo.RspPageBO;
import com.tydic.newretail.busi.service.DPriceSheetManageService;
import com.tydic.newretail.dao.PriceSheetDAO;
import com.tydic.newretail.dao.po.PriceSheetPO;
import com.tydic.newretail.dao.po.PriceSheetReqPO;
import com.tydic.newretail.exception.BusinessException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DPriceSheetManageServiceImpl
implements DPriceSheetManageService {
    private static final Logger logger = LoggerFactory.getLogger(DPriceSheetManageServiceImpl.class);
    @Autowired
    private PriceSheetDAO priceSheetDAO;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;

    public List<PriceSheetBO> selectBySheetId(List<Long> sheetId) {
        ArrayList<PriceSheetBO> priceSheetBOS;
        logger.info("\u5546\u54c1\u4e2d\u5fc3-\u6839\u636e\u62a5\u4ef7\u5355id\u67e5\u8be2\u62a5\u4ef7\u5355\u4fe1\u606f \u539f\u5b50\u670d\u52a1\u5165\u53c2" + JSON.toJSONString(sheetId));
        try {
            List<PriceSheetPO> priceSheetPOS = this.priceSheetDAO.selectBySheetId(sheetId);
            logger.error("\u83b7\u53d6\u62a5\u4ef7\u5355\u4fe1\u606f\uff1a" + priceSheetPOS);
            priceSheetBOS = new ArrayList<PriceSheetBO>();
            if (CollectionUtils.isNotEmpty(priceSheetPOS)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                for (PriceSheetPO priceSheetPO : priceSheetPOS) {
                    PriceSheetBO priceSheetBO = new PriceSheetBO();
                    BeanUtils.copyProperties((Object)priceSheetPO, (Object)priceSheetBO);
                    if (priceSheetPO.getEffectTime() == null) {
                        priceSheetBO.setEffectTime(null);
                    } else {
                        priceSheetBO.setEffectTime(sdf.format(priceSheetPO.getEffectTime()));
                    }
                    priceSheetBOS.add(priceSheetBO);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u6839\u636e\u62a5\u4ef7\u5355id\u67e5\u8be2\u62a5\u4ef7\u5355\u4fe1\u606f  \u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
            throw new BusinessException("9999", "\u5546\u54c1\u4e2d\u5fc3-\u6839\u636e\u62a5\u4ef7\u5355id\u67e5\u8be2\u62a5\u4ef7\u5355\u4fe1\u606f  \u539f\u5b50\u670d\u52a1\u51fa\u9519");
        }
        return priceSheetBOS;
    }

    public RspPageBO<DPriceSheetBO> selectPriceSheetPOBySelective(QueryDPriceSheetReqBO reqBO) {
        logger.info("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2" + JSONObject.toJSONString((Object)reqBO));
        RspPageBO rspInfoListBO = new RspPageBO();
        rspInfoListBO.setRespCode("0000");
        rspInfoListBO.setRespDesc("\u6210\u529f");
        ArrayList<DPriceSheetBO> rows = new ArrayList<DPriceSheetBO>();
        PriceSheetReqPO po = new PriceSheetReqPO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSheetLevel())) {
            reqBO.setNotSheetLevel(null);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getNotSheetLevel())) {
            reqBO.setSheetLevel(null);
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setOrgRange(reqBO.getOrgName());
        Page page = new Page();
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getOffset());
        try {
            List<PriceSheetPO> priceSheetPOS = this.priceSheetDAO.selectBySelective(po, (Page<PriceSheetPO>)page);
            if (CollectionUtils.isNotEmpty(priceSheetPOS)) {
                Map levelMap = this.sysParamsAtomService.selectByParentCode("SHEET_LEVEL_STR");
                Map statusMap = this.sysParamsAtomService.selectByParentCode("PRICE_CHECK_STATUS");
                for (PriceSheetPO po1 : priceSheetPOS) {
                    DPriceSheetBO bo = new DPriceSheetBO();
                    BeanUtils.copyProperties((Object)po1, (Object)bo);
                    if (statusMap.containsKey(bo.getCheckStatus())) {
                        bo.setCheckStatusStr((String)statusMap.get(bo.getCheckStatus()));
                    }
                    if (levelMap.containsKey(bo.getSheetLevel())) {
                        bo.setSheetLevelStr((String)levelMap.get(bo.getSheetLevel()));
                    }
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        rspInfoListBO.setTotal(page.getTotalPages());
        rspInfoListBO.setRecordsTotal(page.getTotalCount());
        rspInfoListBO.setRows(rows);
        return rspInfoListBO;
    }
}

