/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.newretail.busi.service.DeleteSkuService;
import com.tydic.newretail.busi.service.InitSkuSpecAtomService;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.SkuPriceDAO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteSkuServiceImpl
implements DeleteSkuService {
    private static final Logger logger = LoggerFactory.getLogger(DeleteSkuServiceImpl.class);
    @Autowired
    private SkuDAO xlsSkuMapper;
    @Autowired
    private InitSkuSpecAtomService initSkuSpecAtomService;
    @Autowired
    private SkuPriceDAO skuPriceMapper;

    public void deleteSKU(List<Long> provGoodsIdS) {
        logger.debug("DeleteSku\u5165\u53c2" + JSON.toJSONString(provGoodsIdS));
        try {
            List<SkuPO> skus = this.xlsSkuMapper.selectSkuByProvGoods(provGoodsIdS);
            if (!CollectionUtils.isEmpty(skus)) {
                ArrayList<Long> skuIds = new ArrayList<Long>();
                skus.stream().forEach(str -> skuIds.add(str.getSkuId()));
                logger.debug("\u67e5\u8be2\u5230\u7684skuID" + JSON.toJSONString(skuIds));
                this.skuPriceMapper.deleteBySkuId(skuIds);
                this.xlsSkuMapper.batchdeleteSkuByProvGoods(provGoodsIdS);
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664sku\u5931\u8d25" + e.getMessage());
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u5220\u9664sku\u5931\u8d25");
        }
    }
}

