/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.tydic.newretail.bo.BuildEsSqlReqBO;
import com.tydic.newretail.bo.QueryEsResultRspBO;
import com.tydic.newretail.bo.QuerySkuBasicDataReqBO;
import com.tydic.newretail.bo.XlsSearchEsRspInfoBO;
import com.tydic.newretail.busi.EsService;
import com.tydic.newretail.dao.po.SearchEsQueryRspPO;
import com.tydic.newretail.dao.po.SearchEsSQLXlsRspPO;
import com.tydic.newretail.util.MoneyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityAggregationBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EsServiceImpl
implements EsService {
    private static final Logger logger = LoggerFactory.getLogger(EsServiceImpl.class);
    @Resource
    private TransportClient client;
    @Value(value="${es.sku.index.name}")
    private String skuIndexName;
    @Value(value="${es.sku.type.name}")
    private String skuTypeName;

    @Override
    public SearchEsSQLXlsRspPO buildEsSql(BuildEsSqlReqBO buildEsSqlReqBO) {
        BoolQueryBuilder boolQueryBuilder1;
        SearchEsSQLXlsRspPO searchEsSQLXlsRspPO = new SearchEsSQLXlsRspPO();
        CollapseBuilder collapseBuilder = new CollapseBuilder("commodity_id");
        InnerHitBuilder innerHit = new InnerHitBuilder("group_by");
        ArrayList<FieldSortBuilder> sorts = new ArrayList<FieldSortBuilder>();
        SortOrder orderSalePrice = SortOrder.ASC;
        FieldSortBuilder fsb = (FieldSortBuilder)SortBuilders.fieldSort((String)"sale_price").order(orderSalePrice);
        sorts.add(fsb);
        innerHit.setSorts(sorts);
        innerHit.setSize(1);
        collapseBuilder.setInnerHits(innerHit);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)2));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"cg_type", (int)601));
        if (buildEsSqlReqBO.getGuideCatalogId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id", (String)(buildEsSqlReqBO.getGuideCatalogId() + "*~~" + "0")));
        }
        BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
        ExistsQueryBuilder existsQueryBuilder = new ExistsQueryBuilder("member_ladder_price2");
        boolQueryBuilder2.must((QueryBuilder)existsQueryBuilder);
        boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2);
        if (StringUtils.isNotBlank((CharSequence)buildEsSqlReqBO.getQueryStr())) {
            boolQueryBuilder1 = QueryBuilders.boolQuery();
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"sku_name", (Object)buildEsSqlReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"sku_long_name", (Object)buildEsSqlReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"commodity_name", (Object)buildEsSqlReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"commodity_long_name", (Object)buildEsSqlReqBO.getQueryStr()));
            boolQueryBuilder.must((QueryBuilder)boolQueryBuilder1);
        }
        if (StringUtils.isNotBlank((CharSequence)buildEsSqlReqBO.getBrandStr())) {
            boolQueryBuilder1 = QueryBuilders.boolQuery();
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"brand_name", (Object)buildEsSqlReqBO.getBrandStr()));
        }
        SortOrder orderType = SortOrder.ASC;
        String sortField = "sale_price";
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
        searchEsSQLXlsRspPO.setCollapseBuilder(collapseBuilder);
        searchEsSQLXlsRspPO.setBoolQueryBuilder(boolQueryBuilder);
        searchEsSQLXlsRspPO.setSortQuery(sortQuery);
        searchEsSQLXlsRspPO.setPageNo(buildEsSqlReqBO.getPageNo());
        searchEsSQLXlsRspPO.setPageSize(buildEsSqlReqBO.getPageSize());
        logger.info("\u62fc\u63a5es\u67e5\u8be2\u6761\u4ef6\u670d\u52a1\u51fa\u53c2=" + searchEsSQLXlsRspPO.toString());
        return searchEsSQLXlsRspPO;
    }

    @Override
    public SearchEsSQLXlsRspPO buildBindEsSql(BuildEsSqlReqBO buildEsSqlReqBO) {
        SearchEsSQLXlsRspPO searchEsSQLXlsRspPO = new SearchEsSQLXlsRspPO();
        CollapseBuilder collapseBuilder = new CollapseBuilder("material_id");
        InnerHitBuilder innerHit = new InnerHitBuilder("group_by");
        innerHit.setSize(1);
        collapseBuilder.setInnerHits(innerHit);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"is_delete", (int)0));
        if (StringUtils.isNotEmpty((CharSequence)buildEsSqlReqBO.getExtSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ext_sku_id", (String)buildEsSqlReqBO.getExtSkuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)buildEsSqlReqBO.getMaterialId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"material_id", (String)buildEsSqlReqBO.getMaterialId()));
        }
        if (StringUtils.isNotBlank((CharSequence)buildEsSqlReqBO.getProvinceCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"province_code", (String)buildEsSqlReqBO.getProvinceCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)buildEsSqlReqBO.getBrandStr())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"brand_name", (Object)buildEsSqlReqBO.getBrandStr()));
        }
        if (StringUtils.isNotBlank((CharSequence)buildEsSqlReqBO.getQueryStr())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"sku_name", (Object)buildEsSqlReqBO.getQueryStr()));
        }
        SortOrder orderType = SortOrder.DESC;
        String sortField = "create_time";
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
        searchEsSQLXlsRspPO.setCollapseBuilder(collapseBuilder);
        searchEsSQLXlsRspPO.setBoolQueryBuilder(boolQueryBuilder);
        searchEsSQLXlsRspPO.setSortQuery(sortQuery);
        searchEsSQLXlsRspPO.setPageNo(buildEsSqlReqBO.getPageNo());
        searchEsSQLXlsRspPO.setPageSize(buildEsSqlReqBO.getPageSize());
        logger.info("\u62fc\u63a5es\u67e5\u8be2\u6761\u4ef6\u670d\u52a1\u51fa\u53c2=" + searchEsSQLXlsRspPO.toString());
        return searchEsSQLXlsRspPO;
    }

    @Override
    public SearchEsSQLXlsRspPO querySkuEsBasic(QuerySkuBasicDataReqBO querySkuBasicDataReqBO) {
        SearchEsSQLXlsRspPO searchEsSQLXlsRspPO = new SearchEsSQLXlsRspPO();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"is_delete", (int)0));
        if (querySkuBasicDataReqBO.getUnsaleNum() == 1) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"unsale_num").gt((Object)0));
        }
        if (StringUtils.isNotEmpty((CharSequence)querySkuBasicDataReqBO.getMaterialId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"material_id", (String)querySkuBasicDataReqBO.getMaterialId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)querySkuBasicDataReqBO.getSkuIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (Collection)querySkuBasicDataReqBO.getSkuIds()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getProvinceCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"province_code", (String)querySkuBasicDataReqBO.getProvinceCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getCityCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"city_code", (String)querySkuBasicDataReqBO.getCityCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getCountyCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"county_code", (String)querySkuBasicDataReqBO.getCountyCode()));
        }
        if (CollectionUtils.isNotEmpty((Collection)querySkuBasicDataReqBO.getMaterialIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"material_id", (Collection)querySkuBasicDataReqBO.getMaterialIds()));
        }
        if (null != querySkuBasicDataReqBO.getShopId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)querySkuBasicDataReqBO.getShopId()));
        }
        if (null != querySkuBasicDataReqBO.getBrandId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)querySkuBasicDataReqBO.getBrandId()));
        }
        if (null != querySkuBasicDataReqBO.getSupplierId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"verdor_id", (Object)querySkuBasicDataReqBO.getSupplierId()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getBrandName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"brand_name", (Object)querySkuBasicDataReqBO.getBrandName()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"sku_name", (Object)querySkuBasicDataReqBO.getSkuName()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getErpGoodsType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"erp_goods_type", (String)querySkuBasicDataReqBO.getErpGoodsType()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getHasSerialNumber())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"has_serial_number", (String)querySkuBasicDataReqBO.getHasSerialNumber()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getReservedField1())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"reserved_field1", (String)querySkuBasicDataReqBO.getReservedField1()));
        }
        HighlightBuilder highlightBuilder = (HighlightBuilder)((HighlightBuilder)new HighlightBuilder().field("sku_name").preTags(new String[]{"<span style=\"color:red\">"})).postTags(new String[]{"</span>"});
        searchEsSQLXlsRspPO.setBoolQueryBuilder(boolQueryBuilder);
        searchEsSQLXlsRspPO.setHighlightBuilder(highlightBuilder);
        searchEsSQLXlsRspPO.setPageNo(querySkuBasicDataReqBO.getCurrent());
        searchEsSQLXlsRspPO.setPageSize(querySkuBasicDataReqBO.getPageSize());
        logger.info("\u62fc\u63a5es\u67e5\u8be2\u6761\u4ef6\u670d\u52a1\u51fa\u53c2=" + searchEsSQLXlsRspPO.toString());
        return searchEsSQLXlsRspPO;
    }

    @Override
    public SearchEsQueryRspPO executeSQLXls(SearchEsSQLXlsRspPO searchEsSQLXlsRspPO) {
        SearchEsQueryRspPO searchBarEsQueryRspVO = null;
        try {
            searchBarEsQueryRspVO = new SearchEsQueryRspPO();
            Integer pageNo = 0;
            Integer pageSize = 10;
            if (searchEsSQLXlsRspPO.getPageNo() != null && searchEsSQLXlsRspPO.getPageNo() > 0) {
                pageNo = searchEsSQLXlsRspPO.getPageNo() - 1;
            }
            if (searchEsSQLXlsRspPO.getPageSize() != null && searchEsSQLXlsRspPO.getPageSize() > 0) {
                pageSize = searchEsSQLXlsRspPO.getPageSize();
            }
            if (searchEsSQLXlsRspPO.getSortQuery() != null) {
                SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.skuIndexName}).setTypes(new String[]{this.skuTypeName}).setQuery((QueryBuilder)searchEsSQLXlsRspPO.getBoolQueryBuilder()).highlighter(searchEsSQLXlsRspPO.getHighlightBuilder()).setCollapse(searchEsSQLXlsRspPO.getCollapseBuilder()).addSort((SortBuilder)searchEsSQLXlsRspPO.getSortQuery()).setFrom(pageNo * pageSize).setSize(pageSize.intValue()).addAggregation((AggregationBuilder)((CardinalityAggregationBuilder)AggregationBuilders.cardinality((String)"count").field("material_id")).precisionThreshold(20000L)).addAggregation((AggregationBuilder)AggregationBuilders.terms((String)"group_by_supplier_id_name").field("supplier_id_name")).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_brand_id_name").field("brand_id_name")).size(2000)).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_l3_category_id_name").field("l3_category_id_name")).size(2000)).get();
                logger.debug(searchResponse.toString());
                searchBarEsQueryRspVO.setSearchResponse(searchResponse);
            } else {
                SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.skuIndexName}).setTypes(new String[]{this.skuTypeName}).setQuery((QueryBuilder)searchEsSQLXlsRspPO.getBoolQueryBuilder()).highlighter(searchEsSQLXlsRspPO.getHighlightBuilder()).setCollapse(searchEsSQLXlsRspPO.getCollapseBuilder()).setFrom(pageNo * pageSize).setSize(pageSize.intValue()).addAggregation((AggregationBuilder)((CardinalityAggregationBuilder)AggregationBuilders.cardinality((String)"count").field("material_id")).precisionThreshold(20000L)).addAggregation((AggregationBuilder)AggregationBuilders.terms((String)"group_by_supplier_id_name").field("supplier_id_name")).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_brand_id_name").field("brand_id_name")).size(2000)).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_l3_category_id_name").field("l3_category_id_name")).size(2000)).get();
                logger.debug(searchResponse.toString());
                searchBarEsQueryRspVO.setSearchResponse(searchResponse);
            }
        }
        catch (Exception var6) {
            var6.printStackTrace();
        }
        return searchBarEsQueryRspVO;
    }

    @Override
    public QueryEsResultRspBO queryEsResult(SearchEsQueryRspPO searchEsQueryRspPO) {
        QueryEsResultRspBO queryEsResultRspBO = new QueryEsResultRspBO();
        ArrayList<XlsSearchEsRspInfoBO> listXlsSearchEsRspInfoBO = new ArrayList<XlsSearchEsRspInfoBO>();
        XlsSearchEsRspInfoBO xlsSearchEsRspInfoBO = null;
        SearchResponse searchResponse = searchEsQueryRspPO.getSearchResponse();
        Cardinality cardinality = (Cardinality)searchResponse.getAggregations().get("count");
        for (SearchHit hit : searchResponse.getHits()) {
            SearchHit sh = ((SearchHits)hit.getInnerHits().get("group_by")).getHits()[0];
            xlsSearchEsRspInfoBO = this.buildXlsSearchEsRspInfoBO(sh);
            listXlsSearchEsRspInfoBO.add(xlsSearchEsRspInfoBO);
        }
        queryEsResultRspBO.setTotalCount(Integer.valueOf((int)cardinality.getValue()));
        queryEsResultRspBO.setResult(listXlsSearchEsRspInfoBO);
        return queryEsResultRspBO;
    }

    @Override
    public QueryEsResultRspBO queryEsSkuResult(SearchEsQueryRspPO searchEsQueryRspPO) {
        ArrayList<XlsSearchEsRspInfoBO> listXlsSearchEsRspInfoBO = new ArrayList<XlsSearchEsRspInfoBO>();
        SearchResponse searchResponse = searchEsQueryRspPO.getSearchResponse();
        logger.debug(searchResponse.toString() + "\u67e5\u8be2\u6761\u4ef6\u5165\u53c2");
        QueryEsResultRspBO queryEsResultRspBO = new QueryEsResultRspBO();
        XlsSearchEsRspInfoBO xlsSearchEsRspInfoBO = null;
        for (SearchHit sh : searchResponse.getHits()) {
            xlsSearchEsRspInfoBO = this.buildXlsSearchEsRspInfoBO(sh);
            listXlsSearchEsRspInfoBO.add(xlsSearchEsRspInfoBO);
        }
        queryEsResultRspBO.setTotalCount(Integer.valueOf((int)searchResponse.getHits().getTotalHits()));
        queryEsResultRspBO.setResult(listXlsSearchEsRspInfoBO);
        return queryEsResultRspBO;
    }

    public XlsSearchEsRspInfoBO buildXlsSearchEsRspInfoBO(SearchHit sh) {
        Map mapHighlightField;
        HighlightField skuNameHighlightField;
        XlsSearchEsRspInfoBO xlsSearchEsRspInfoBO = new XlsSearchEsRspInfoBO();
        if (null != sh.getSourceAsMap().get("sku_id")) {
            xlsSearchEsRspInfoBO.setSkuId(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("sku_id"))));
        }
        if (null != sh.getSourceAsMap().get("commodity_id")) {
            xlsSearchEsRspInfoBO.setCommodityId(Long.valueOf(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("commodity_id")))));
        }
        if (null != sh.getSourceAsMap().get("supplier_id")) {
            xlsSearchEsRspInfoBO.setSupplierId(Long.valueOf(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("supplier_id")))));
        }
        if (null != sh.getSourceAsMap().get("supplier_name")) {
            xlsSearchEsRspInfoBO.setSupplierName(String.valueOf(sh.getSourceAsMap().get("supplier_name")));
        }
        if (null != sh.getSourceAsMap().get("verdor_id")) {
            xlsSearchEsRspInfoBO.setVerdorId(String.valueOf(sh.getSourceAsMap().get("verdor_id")));
        }
        if (null != sh.getSourceAsMap().get("verdor_name")) {
            xlsSearchEsRspInfoBO.setVerdorName(String.valueOf(sh.getSourceAsMap().get("verdor_name")));
        }
        if (null != sh.getSourceAsMap().get("material_id")) {
            xlsSearchEsRspInfoBO.setMaterialId(String.valueOf(sh.getSourceAsMap().get("material_id")));
        }
        if (null != sh.getSourceAsMap().get("ext_sku_id")) {
            xlsSearchEsRspInfoBO.setExtSkuId(String.valueOf(sh.getSourceAsMap().get("ext_sku_id")));
        }
        if (null != sh.getSourceAsMap().get("upc_code")) {
            xlsSearchEsRspInfoBO.setUpcCode(String.valueOf(sh.getSourceAsMap().get("upc_code")));
        }
        if (null != sh.getSourceAsMap().get("type_id")) {
            xlsSearchEsRspInfoBO.setCommodityTypeId(Long.valueOf(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("type_id")))));
        }
        if (null != sh.getSourceAsMap().get("sku_price")) {
            xlsSearchEsRspInfoBO.setSkuPrice(Long.valueOf(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("sku_price")))));
        }
        if (null != sh.getSourceAsMap().get("sku_code")) {
            xlsSearchEsRspInfoBO.setSkuCode(String.valueOf(sh.getSourceAsMap().get("sku_code")));
        }
        if (null != sh.getSourceAsMap().get("sku_location")) {
            xlsSearchEsRspInfoBO.setSkuLocation(Integer.valueOf(String.valueOf(sh.getSourceAsMap().get("sku_location"))));
        }
        if (null != sh.getSourceAsMap().get("sku_name")) {
            xlsSearchEsRspInfoBO.setSkuName(String.valueOf(sh.getSourceAsMap().get("sku_name")));
            xlsSearchEsRspInfoBO.setSkuNameHighLight(String.valueOf(sh.getSourceAsMap().get("sku_name")));
        }
        if ((skuNameHighlightField = (HighlightField)(mapHighlightField = sh.getHighlightFields()).get("sku_name")) != null) {
            Text[] fragments = skuNameHighlightField.fragments();
            String skuName = "";
            for (Text text : fragments) {
                skuName = skuName + text;
            }
            xlsSearchEsRspInfoBO.setSkuNameHighLight(skuName);
        }
        if (null != sh.getSourceAsMap().get("sku_long_name")) {
            xlsSearchEsRspInfoBO.setSkuLongName(String.valueOf(sh.getSourceAsMap().get("sku_long_name")));
        }
        if (null != sh.getSourceAsMap().get("picture_url")) {
            xlsSearchEsRspInfoBO.setSkuMainPicUrl(String.valueOf(sh.getSourceAsMap().get("picture_url")));
        }
        if (null != sh.getSourceAsMap().get("on_shelve_way")) {
            xlsSearchEsRspInfoBO.setOnShelveWay(Integer.valueOf(String.valueOf(sh.getSourceAsMap().get("on_shelve_way"))));
        }
        if (null != sh.getSourceAsMap().get("sku_detail")) {
            xlsSearchEsRspInfoBO.setSkuDetail(String.valueOf(sh.getSourceAsMap().get("sku_detail")));
        }
        if (null != sh.getSourceAsMap().get("pack_param")) {
            xlsSearchEsRspInfoBO.setPackParam(String.valueOf(sh.getSourceAsMap().get("pack_param")));
        }
        if (null != sh.getSourceAsMap().get("sku_detail_url")) {
            xlsSearchEsRspInfoBO.setSkuDetailUrl(String.valueOf(sh.getSourceAsMap().get("sku_detail_url")));
        }
        if (null != sh.getSourceAsMap().get("store_number")) {
            xlsSearchEsRspInfoBO.setStoreNumber(String.valueOf(sh.getSourceAsMap().get("store_number")));
        }
        if (null != sh.getSourceAsMap().get("sku_status")) {
            xlsSearchEsRspInfoBO.setSkuStatus(Integer.valueOf(String.valueOf(sh.getSourceAsMap().get("sku_status"))));
        }
        if (null != sh.getSourceAsMap().get("brand_id") && !"".equals(sh.getSourceAsMap().get("brand_id"))) {
            xlsSearchEsRspInfoBO.setBrandId(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("brand_id"))));
        }
        if (null != sh.getSourceAsMap().get("brand_name")) {
            xlsSearchEsRspInfoBO.setBrandName(String.valueOf(sh.getSourceAsMap().get("brand_name")));
        }
        if (null != sh.getSourceAsMap().get("measure_id")) {
            xlsSearchEsRspInfoBO.setMeasureId(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("measure_id"))));
        }
        if (null != sh.getSourceAsMap().get("measure_name")) {
            xlsSearchEsRspInfoBO.setMeasureName(String.valueOf(sh.getSourceAsMap().get("measure_name")));
        }
        if (null != sh.getSourceAsMap().get("moq")) {
            xlsSearchEsRspInfoBO.setMoq(Integer.valueOf(String.valueOf(sh.getSourceAsMap().get("moq"))));
        }
        if (null != sh.getSourceAsMap().get("mfgsku")) {
            xlsSearchEsRspInfoBO.setMfgSku(String.valueOf(sh.getSourceAsMap().get("mfgsku")));
        }
        if (null != sh.getSourceAsMap().get("create_login_id")) {
            xlsSearchEsRspInfoBO.setCreateLoginId(String.valueOf(sh.getSourceAsMap().get("create_login_id")));
        }
        if (null != sh.getSourceAsMap().get("is_delete")) {
            xlsSearchEsRspInfoBO.setIsDelete(Integer.valueOf(String.valueOf(sh.getSourceAsMap().get("is_delete"))));
        }
        if (null != sh.getSourceAsMap().get("attach_flag")) {
            xlsSearchEsRspInfoBO.setAttachFlag(String.valueOf(sh.getSourceAsMap().get("attach_flag")));
        }
        if (null != sh.getSourceAsMap().get("attach_type")) {
            xlsSearchEsRspInfoBO.setAttachType(String.valueOf(sh.getSourceAsMap().get("attach_type")));
        }
        if (null != sh.getSourceAsMap().get("has_wisdom")) {
            xlsSearchEsRspInfoBO.setHasWisdom(Integer.valueOf(String.valueOf(sh.getSourceAsMap().get("has_wisdom"))));
        }
        if (null != sh.getSourceAsMap().get("has_interactive")) {
            xlsSearchEsRspInfoBO.setHasInteractive(Integer.valueOf(String.valueOf(sh.getSourceAsMap().get("has_interactive"))));
        }
        if (null != sh.getSourceAsMap().get("sku_price_tag_name")) {
            xlsSearchEsRspInfoBO.setSkuPriceTagName(String.valueOf(sh.getSourceAsMap().get("sku_price_tag_name")));
        }
        if (null != sh.getSourceAsMap().get("cg_type")) {
            xlsSearchEsRspInfoBO.setCgType(String.valueOf(sh.getSourceAsMap().get("cg_type")));
        }
        if (null != sh.getSourceAsMap().get("erp_long_name")) {
            xlsSearchEsRspInfoBO.setErpLongName(String.valueOf(sh.getSourceAsMap().get("erp_long_name")));
        }
        if (null != sh.getSourceAsMap().get("is_virtual_good")) {
            xlsSearchEsRspInfoBO.setIsVirtualGood(String.valueOf(sh.getSourceAsMap().get("is_virtual_good")));
        }
        if (null != sh.getSourceAsMap().get("prov_goods_id")) {
            xlsSearchEsRspInfoBO.setProvGoodsId(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("prov_goods_id"))));
        }
        if (null != sh.getSourceAsMap().get("goods_source")) {
            xlsSearchEsRspInfoBO.setGoodsSource(String.valueOf(sh.getSourceAsMap().get("goods_source")));
        }
        if (null != sh.getSourceAsMap().get("province_code")) {
            xlsSearchEsRspInfoBO.setProvincecode(String.valueOf(sh.getSourceAsMap().get("province_code")));
        }
        if (null != sh.getSourceAsMap().get("city_code")) {
            xlsSearchEsRspInfoBO.setCitycode(String.valueOf(sh.getSourceAsMap().get("city_code")));
        }
        if (null != sh.getSourceAsMap().get("county_code")) {
            xlsSearchEsRspInfoBO.setCountycode(String.valueOf(sh.getSourceAsMap().get("county_code")));
        }
        if (null != sh.getSourceAsMap().get("remark")) {
            xlsSearchEsRspInfoBO.setRemark(String.valueOf(sh.getSourceAsMap().get("remark")));
        }
        if (null != sh.getSourceAsMap().get("agreement_price")) {
            xlsSearchEsRspInfoBO.setAgreementPrice(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("agreement_price"))));
        }
        if (null != sh.getSourceAsMap().get("market_price")) {
            xlsSearchEsRspInfoBO.setMarketPrice(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("market_price"))));
        }
        if (null != sh.getSourceAsMap().get("member_price")) {
            xlsSearchEsRspInfoBO.setMemberPrice(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("member_price"))));
        }
        if (null != sh.getSourceAsMap().get("sale_price")) {
            xlsSearchEsRspInfoBO.setSalePrice(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("sale_price"))));
        }
        if (null != sh.getSourceAsMap().get("assessment_price")) {
            xlsSearchEsRspInfoBO.setAgreementPrice(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("assessment_price"))));
        }
        if (null != sh.getSourceAsMap().get("purchase_price")) {
            xlsSearchEsRspInfoBO.setPurchasePrice(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("purchase_price"))));
        }
        if (null != sh.getSourceAsMap().get("spare_price1")) {
            xlsSearchEsRspInfoBO.setSparePrice1(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("spare_price1"))));
        }
        if (null != sh.getSourceAsMap().get("spare_price2")) {
            xlsSearchEsRspInfoBO.setSparePrice2(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("spare_price2"))));
        }
        if (null != sh.getSourceAsMap().get("member_ladder_price1")) {
            xlsSearchEsRspInfoBO.setMemberLadderPrice1(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("member_ladder_price1"))));
        }
        if (null != sh.getSourceAsMap().get("member_ladder_price2")) {
            xlsSearchEsRspInfoBO.setMemberLadderPrice2(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("member_ladder_price2"))));
        }
        if (null != sh.getSourceAsMap().get("member_ladder_price3")) {
            xlsSearchEsRspInfoBO.setMemberLadderPrice3(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("member_ladder_price3"))));
        }
        if (null != sh.getSourceAsMap().get("member_ladder_price4")) {
            xlsSearchEsRspInfoBO.setMemberLadderPrice4(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("member_ladder_price4"))));
        }
        if (null != sh.getSourceAsMap().get("prov_agree_price")) {
            xlsSearchEsRspInfoBO.setProvAgreePrice(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("prov_agree_price"))));
        }
        if (null != sh.getSourceAsMap().get("cost_price")) {
            xlsSearchEsRspInfoBO.setCostPrice(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("cost_price"))));
        }
        if (null != sh.getSourceAsMap().get("sheet_id")) {
            xlsSearchEsRspInfoBO.setSheetId(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("sheet_id"))));
        }
        if (null != sh.getSourceAsMap().get("sheet_level")) {
            xlsSearchEsRspInfoBO.setSheetLevel(String.valueOf(sh.getSourceAsMap().get("sheet_level")));
        }
        if (null != sh.getSourceAsMap().get("has_price_sheet")) {
            xlsSearchEsRspInfoBO.setHasPriceSheet(String.valueOf(sh.getSourceAsMap().get("has_price_sheet")));
        }
        if (null != sh.getSourceAsMap().get("commodity_name")) {
            xlsSearchEsRspInfoBO.setCommodityName(String.valueOf(sh.getSourceAsMap().get("commodity_name")));
        }
        if (null != sh.getSourceAsMap().get("commodity_long_name")) {
            xlsSearchEsRspInfoBO.setCommodityLongName(String.valueOf(sh.getSourceAsMap().get("commodity_long_name")));
        }
        if (null != sh.getSourceAsMap().get("commodity_main_pic")) {
            xlsSearchEsRspInfoBO.setCommodityMainPic(String.valueOf(sh.getSourceAsMap().get("commodity_main_pic")));
        }
        if (null != sh.getSourceAsMap().get("commodity_lowest_price")) {
            xlsSearchEsRspInfoBO.setCommodityLowestPrice(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("commodity_lowest_price"))));
        }
        if (null != sh.getSourceAsMap().get("commodity_highest_price")) {
            xlsSearchEsRspInfoBO.setCommodityHighestPrice(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("commodity_highest_price"))));
        }
        if (null != sh.getSourceAsMap().get("ext_goods_no")) {
            xlsSearchEsRspInfoBO.setExtGoodsNo(String.valueOf(sh.getSourceAsMap().get("ext_goods_no")));
        }
        if (null != sh.getSourceAsMap().get("goods_no")) {
            xlsSearchEsRspInfoBO.setGoodsNo(String.valueOf(sh.getSourceAsMap().get("goods_no")));
        }
        if (null != sh.getSourceAsMap().get("goods_name")) {
            xlsSearchEsRspInfoBO.setGoodsName(String.valueOf(sh.getSourceAsMap().get("goods_name")));
        }
        if (null != sh.getSourceAsMap().get("goods_long_name")) {
            xlsSearchEsRspInfoBO.setGoodsLongName(String.valueOf(sh.getSourceAsMap().get("goods_long_name")));
        }
        if (null != sh.getSourceAsMap().get("goods_type")) {
            xlsSearchEsRspInfoBO.setGoodsType(String.valueOf(sh.getSourceAsMap().get("goods_type")));
        }
        if (null != sh.getSourceAsMap().get("goods_model")) {
            xlsSearchEsRspInfoBO.setGoodsModel(String.valueOf(sh.getSourceAsMap().get("goods_model")));
        }
        if (null != sh.getSourceAsMap().get("color_name")) {
            xlsSearchEsRspInfoBO.setColorName(String.valueOf(sh.getSourceAsMap().get("color_name")));
        }
        if (null != sh.getSourceAsMap().get("version_name")) {
            xlsSearchEsRspInfoBO.setVersionName(String.valueOf(sh.getSourceAsMap().get("version_name")));
        }
        if (null != sh.getSourceAsMap().get("memory_name")) {
            xlsSearchEsRspInfoBO.setMemoryName(String.valueOf(sh.getSourceAsMap().get("memory_name")));
        }
        if (null != sh.getSourceAsMap().get("model_type_name")) {
            xlsSearchEsRspInfoBO.setModelTypeName(String.valueOf(sh.getSourceAsMap().get("model_type_name")));
        }
        if (null != sh.getSourceAsMap().get("config_name")) {
            xlsSearchEsRspInfoBO.setConfigName(String.valueOf(sh.getSourceAsMap().get("config_name")));
        }
        if (null != sh.getSourceAsMap().get("screen_type")) {
            xlsSearchEsRspInfoBO.setScreenType(String.valueOf(sh.getSourceAsMap().get("screen_type")));
        }
        if (null != sh.getSourceAsMap().get("config_name")) {
            xlsSearchEsRspInfoBO.setConfigName(String.valueOf(sh.getSourceAsMap().get("config_name")));
        }
        if (null != sh.getSourceAsMap().get("goods_stalls")) {
            xlsSearchEsRspInfoBO.setGoodsStalls(String.valueOf(sh.getSourceAsMap().get("goods_stalls")));
        }
        if (null != sh.getSourceAsMap().get("goods_attr")) {
            xlsSearchEsRspInfoBO.setGoodsAttr(String.valueOf(sh.getSourceAsMap().get("goods_attr")));
        }
        if (null != sh.getSourceAsMap().get("has_serial_number")) {
            xlsSearchEsRspInfoBO.setHasSerialNumber(String.valueOf(sh.getSourceAsMap().get("has_serial_number")));
        }
        if (null != sh.getSourceAsMap().get("purchase_type")) {
            xlsSearchEsRspInfoBO.setPurchaseType(String.valueOf(sh.getSourceAsMap().get("purchase_type")));
        }
        if (null != sh.getSourceAsMap().get("is_after_input")) {
            xlsSearchEsRspInfoBO.setIsAfterInput(String.valueOf(sh.getSourceAsMap().get("is_after_input")));
        }
        if (null != sh.getSourceAsMap().get("has_price")) {
            xlsSearchEsRspInfoBO.setHasPrice(String.valueOf(sh.getSourceAsMap().get("has_price")));
        }
        if (null != sh.getSourceAsMap().get("allow_negative_stock")) {
            xlsSearchEsRspInfoBO.setAllowNegativeSto(String.valueOf(sh.getSourceAsMap().get("allow_negative_stock")));
        }
        if (null != sh.getSourceAsMap().get("standard_system")) {
            xlsSearchEsRspInfoBO.setStandardSystem(String.valueOf(sh.getSourceAsMap().get("standard_system")));
        }
        if (null != sh.getSourceAsMap().get("is_send_scm_stock")) {
            xlsSearchEsRspInfoBO.setIsSendScmStock(String.valueOf(sh.getSourceAsMap().get("is_send_scm_stock")));
        }
        if (null != sh.getSourceAsMap().get("is_scm_distribute")) {
            xlsSearchEsRspInfoBO.setIsScmDistribute(String.valueOf(sh.getSourceAsMap().get("is_scm_distribute")));
        }
        if (null != sh.getSourceAsMap().get("erp_goods_type")) {
            xlsSearchEsRspInfoBO.setErpGoodsType(String.valueOf(sh.getSourceAsMap().get("erp_goods_type")));
        }
        if (null != sh.getSourceAsMap().get("boss_code")) {
            xlsSearchEsRspInfoBO.setBossCode(String.valueOf(sh.getSourceAsMap().get("boss_code")));
        }
        if (null != sh.getSourceAsMap().get("boss_color")) {
            xlsSearchEsRspInfoBO.setBossColor(String.valueOf(sh.getSourceAsMap().get("boss_color")));
        }
        if (null != sh.getSourceAsMap().get("goods_source")) {
            xlsSearchEsRspInfoBO.setGoodsSource(String.valueOf(sh.getSourceAsMap().get("goods_source")));
        }
        if (null != sh.getSourceAsMap().get("reserved_field1")) {
            xlsSearchEsRspInfoBO.setReservedField1(String.valueOf(sh.getSourceAsMap().get("reserved_field1")));
        }
        if (null != sh.getSourceAsMap().get("reserved_field2")) {
            xlsSearchEsRspInfoBO.setReservedField2(String.valueOf(sh.getSourceAsMap().get("reserved_field2")));
        }
        if (null != sh.getSourceAsMap().get("view_total")) {
            xlsSearchEsRspInfoBO.setViewTotal(Long.valueOf(String.valueOf(sh.getSourceAsMap().get("view_total"))));
        }
        try {
            if (sh.getSourceAsMap().get("sku_price") != null) {
                xlsSearchEsRspInfoBO.setSkuPriceY(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("sku_price")))));
            }
            if (null != sh.getSourceAsMap().get("agreement_price")) {
                xlsSearchEsRspInfoBO.setAgreementPriceY(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("agreement_price")))));
            }
            if (null != sh.getSourceAsMap().get("market_price")) {
                xlsSearchEsRspInfoBO.setMarketPriceY(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("market_price")))));
            }
            if (null != sh.getSourceAsMap().get("member_price")) {
                xlsSearchEsRspInfoBO.setMemberPriceY(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("member_price")))));
            }
            if (null != sh.getSourceAsMap().get("sale_price")) {
                xlsSearchEsRspInfoBO.setSalePriceY(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("sale_price")))));
            }
            if (null != sh.getSourceAsMap().get("assessment_price")) {
                xlsSearchEsRspInfoBO.setAssessmentPriceY(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("assessment_price")))));
            }
            if (null != sh.getSourceAsMap().get("purchase_price")) {
                xlsSearchEsRspInfoBO.setPurchasePriceY(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("purchase_price")))));
            }
            if (null != sh.getSourceAsMap().get("spare_price1")) {
                xlsSearchEsRspInfoBO.setSparePrice1Y(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("spare_price1")))));
            }
            if (null != sh.getSourceAsMap().get("spare_price2")) {
                xlsSearchEsRspInfoBO.setSparePrice2Y(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("spare_price2")))));
            }
            if (null != sh.getSourceAsMap().get("member_ladder_price1")) {
                xlsSearchEsRspInfoBO.setMemberLadderPrice1Y(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("member_ladder_price1")))));
            }
            if (null != sh.getSourceAsMap().get("member_ladder_price2")) {
                xlsSearchEsRspInfoBO.setMemberLadderPrice2Y(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("member_ladder_price2")))));
            }
            if (null != sh.getSourceAsMap().get("member_ladder_price3")) {
                xlsSearchEsRspInfoBO.setMemberLadderPrice3Y(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("member_ladder_price3")))));
            }
            if (null != sh.getSourceAsMap().get("member_ladder_price4")) {
                xlsSearchEsRspInfoBO.setMemberLadderPrice4Y(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("member_ladder_price4")))));
            }
            if (null != sh.getSourceAsMap().get("prov_agree_price")) {
                xlsSearchEsRspInfoBO.setProvAgreePriceY(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("prov_agree_price")))));
            }
            if (null != sh.getSourceAsMap().get("cost_price")) {
                xlsSearchEsRspInfoBO.setCostPriceY(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("cost_price")))));
            }
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u8f6c\u6362\u62a5\u9519");
        }
        try {
            Date date;
            if (null != sh.getSourceAsMap().get("on_shelve_time")) {
                date = new DateTime(sh.getSourceAsMap().get("on_shelve_time")).toDate();
                xlsSearchEsRspInfoBO.setOnShelveTime(date);
            }
            if (null != sh.getSourceAsMap().get("create_time")) {
                date = new DateTime(sh.getSourceAsMap().get("create_time")).toDate();
                xlsSearchEsRspInfoBO.setCreateTime(date);
            }
            if (null != sh.getSourceAsMap().get("update_time")) {
                date = new DateTime(sh.getSourceAsMap().get("update_time")).toDate();
                xlsSearchEsRspInfoBO.setUpdateTime(date);
            }
            if (null != sh.getSourceAsMap().get("last_trade_date")) {
                date = new DateTime(sh.getSourceAsMap().get("last_trade_date")).toDate();
                xlsSearchEsRspInfoBO.setLastTradeDate(date);
            }
        }
        catch (Exception e) {
            logger.error("\u65f6\u95f4\u8f6c\u6362\u62a5\u9519");
        }
        return xlsSearchEsRspInfoBO;
    }
}

