/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.busi.service.GenerateMaterialFileBusiService;
import com.tydic.newretail.dao.MaterialDAO;
import com.tydic.newretail.dao.po.MaterialPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.toolkit.util.TkFtpConfig;
import com.tydic.newretail.toolkit.util.TkFtpUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.ibatis.cursor.Cursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GenerateMaterialFileBusiServiceImpl
implements GenerateMaterialFileBusiService {
    private static final Logger logger = LoggerFactory.getLogger(GenerateMaterialFileBusiServiceImpl.class);
    @Value(value="${ftp.host}")
    private String hostname;
    @Value(value="${ftp.port}")
    private String port;
    @Value(value="${ftp.user}")
    private String username;
    @Value(value="${ftp.password}")
    private String password;
    @Value(value="${ftp.file.xls_material.path}")
    private String ftpPath;
    @Autowired
    MaterialDAO materialDAO;

    @Transactional
    public BaseRspBO generateMaterialFile() {
        logger.debug("\u8c03\u7528\u751f\u6210 \u7269\u6599\u5546\u54c1 \u4e3acsv\u8868\u7a0b\u5e8f\u5f00\u59cb----->");
        BaseRspBO result = new BaseRspBO();
        String path = "";
        String fileName = this.getFileName();
        try {
            path = this.createNewFile(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Cursor<MaterialPO> materialPOS = this.materialDAO.selectAllMaterial();
            this.writeTxtFile(path, materialPOS);
        }
        catch (Exception e) {
            logger.debug("\u5199\u5165csv\u6587\u4ef6\u5931\u8d25\uff01" + e.getMessage());
            throw new BusinessException("8888", "\u5199\u5165csv\u6587\u4ef6\u5931\u8d25\uff01" + e.getMessage());
        }
        TkFtpConfig config = new TkFtpConfig(this.hostname, this.port, this.username, this.password);
        TkFtpUtils tkFtpUtils = new TkFtpUtils(config);
        logger.debug("\u4e0a\u4f20\u8def\u5f84\uff1a" + this.ftpPath + ";\u6587\u4ef6\u540d\u79f0\uff1a" + fileName + ";\u6587\u4ef6\u672c\u5730\u5730\u5740\uff1a" + path);
        Boolean flag = tkFtpUtils.uploadFile(this.ftpPath, fileName, path);
        if (!flag.booleanValue()) {
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25:\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    private String createNewFile(String fileName) throws IOException {
        String path = this.getTmpPath();
        File file = new File(path + fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        return path + fileName;
    }

    private String getTmpPath() {
        String tmpPath = System.getProperty("java.io.tmpdir");
        String os = System.getProperties().getProperty("os.name");
        if (os.toLowerCase().indexOf("linux") != -1) {
            tmpPath = tmpPath + File.separator;
        }
        return tmpPath;
    }

    private String getFileName() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -1);
        Date time = calendar.getTime();
        String date = sdf.format(time);
        return "XLS_MATERIAL_00001_" + date + ".csv";
    }

    public void writeTxtFile(String path, Cursor<MaterialPO> materialPOS) throws Exception {
        BufferedWriter fwriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path, false), StandardCharsets.UTF_8));
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            materialPOS.forEach(dmaterialPO -> {
                StringBuffer content = new StringBuffer();
                content.append("\"").append(dmaterialPO.getId() == null ? "" : dmaterialPO.getId()).append("\",");
                content.append("\"").append(dmaterialPO.getMaterialId() == null ? "" : dmaterialPO.getMaterialId()).append("\",");
                content.append("\"").append(dmaterialPO.getScmMaterialId() == null ? "" : dmaterialPO.getScmMaterialId()).append("\",");
                content.append("\"").append(dmaterialPO.getErpMaterialId() == null ? "" : dmaterialPO.getErpMaterialId()).append("\",");
                content.append("\"").append(dmaterialPO.getIsScm() == null ? "" : dmaterialPO.getIsScm()).append("\",");
                content.append("\"").append(dmaterialPO.getMaterialDesc() == null ? "" : dmaterialPO.getMaterialDesc()).append("\",");
                content.append("\"").append(dmaterialPO.getMaterialGroup() == null ? "" : dmaterialPO.getMaterialGroup()).append("\",");
                content.append("\"").append(dmaterialPO.getProductType() == null ? "" : dmaterialPO.getProductType()).append("\",");
                content.append("\"").append(dmaterialPO.getProductTypeName() == null ? "" : dmaterialPO.getProductTypeName()).append("\",");
                content.append("\"").append(dmaterialPO.getGoodsTypeName() == null ? "" : dmaterialPO.getGoodsTypeName()).append("\",");
                content.append("\"").append(dmaterialPO.getBrandName() == null ? "" : dmaterialPO.getBrandName()).append("\",");
                content.append("\"").append(dmaterialPO.getMarqueName() == null ? "" : dmaterialPO.getMarqueName()).append("\",");
                content.append("\"").append(dmaterialPO.getColorName() == null ? "" : dmaterialPO.getColorName()).append("\",");
                content.append("\"").append(dmaterialPO.getVersionName() == null ? "" : dmaterialPO.getVersionName()).append("\",");
                content.append("\"").append(dmaterialPO.getModelTypeName() == null ? "" : dmaterialPO.getModelTypeName()).append("\",");
                content.append("\"").append(dmaterialPO.getConfigName() == null ? "" : dmaterialPO.getConfigName()).append("\",");
                content.append("\"").append(dmaterialPO.getIsValid() == null ? "" : dmaterialPO.getIsValid()).append("\",");
                content.append("\"").append(dmaterialPO.getProvinceCode() == null ? "" : dmaterialPO.getProvinceCode()).append("\",");
                content.append("\"").append(dmaterialPO.getCreateUser() == null ? "" : dmaterialPO.getCreateUser()).append("\",");
                content.append("\"").append(dmaterialPO.getCreateTime() == null ? "" : sdf.format(dmaterialPO.getCreateTime())).append("\",");
                content.append("\"").append(dmaterialPO.getUpdateUser() == null ? "" : dmaterialPO.getUpdateUser()).append("\",");
                content.append("\"").append(dmaterialPO.getUpdateTime() == null ? "" : sdf.format(dmaterialPO.getUpdateTime())).append("\",");
                content.append("\"").append(dmaterialPO.getSyncTime() == null ? "" : sdf.format(dmaterialPO.getSyncTime())).append("\"\r\n");
                try {
                    fwriter.write(String.valueOf(content));
                }
                catch (IOException e) {
                    try {
                        fwriter.flush();
                        fwriter.close();
                    }
                    catch (IOException ioException) {
                        ioException.printStackTrace();
                    }
                    logger.debug("\u5199\u5165csv\u6587\u4ef6----\u5199\u5165\u64cd\u4f5c\u5931\u8d25\uff01" + e.getMessage());
                    throw new BusinessException("8888", "\u5199\u5165csv\u6587\u4ef6----\u5199\u5165\u64cd\u4f5c\u5931\u8d25\uff01" + e.getMessage());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception();
        }
        finally {
            logger.debug("\u672c\u6b21\u6d41\u5f0f\u67e5\u8be2\u6570\u636e\u5df2\u83b7\u53d6" + (materialPOS.getCurrentIndex() + 1) + "\u6761\u6570\u636e");
            try {
                fwriter.flush();
                fwriter.close();
                materialPOS.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new IOException();
            }
        }
    }
}

