/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.GoodsCategoryQueryBO;
import com.tydic.newretail.bo.GoodsCategoryQueryReqBO;
import com.tydic.newretail.bo.GoodsCategoryQueryResBO;
import com.tydic.newretail.busi.service.GoodsCategoryQueryService;
import com.tydic.newretail.dao.GoodsCategoryQueryDAO;
import com.tydic.newretail.dao.po.GoodsCategoryQueryPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GoodsCategoryQueryServiceImpl
implements GoodsCategoryQueryService {
    @Autowired
    private GoodsCategoryQueryDAO goodsCategoryQueryDAO;
    private static final Logger logger = LoggerFactory.getLogger(GoodsCategoryQueryServiceImpl.class);

    public GoodsCategoryQueryResBO goodsCategoryQuery(GoodsCategoryQueryReqBO reqBO) {
        if (reqBO.getCommodityTypeIdList().isEmpty()) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            GoodsCategoryQueryResBO result = new GoodsCategoryQueryResBO();
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        HashMap<Long, GoodsCategoryQueryBO> map = new HashMap<Long, GoodsCategoryQueryBO>();
        try {
            List<GoodsCategoryQueryPO> poList = this.goodsCategoryQueryDAO.getCategoryByCommidList(reqBO.getCommodityTypeIdList());
            logger.debug("\u67e5\u8be2\u7ed3\u679c" + poList.toString());
            if (poList.isEmpty()) {
                logger.debug("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
                GoodsCategoryQueryResBO result = new GoodsCategoryQueryResBO();
                result.setRespCode("0000");
                result.setRespDesc("\u6210\u529f");
                result.setRows(map);
                return result;
            }
            for (GoodsCategoryQueryPO po : poList) {
                Long commodityTypeId = po.getCommodityTypeId();
                if (map.containsKey(commodityTypeId)) continue;
                GoodsCategoryQueryBO bo = new GoodsCategoryQueryBO();
                bo.setCatalogName(po.getCatalogName());
                bo.setCommodityTypeId(po.getCommodityTypeId());
                bo.setGuideCatalogId(po.getGuideCatalogId());
                bo.setParentCatalogName(po.getParentCatalogName());
                map.put(po.getCommodityTypeId(), bo);
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u670d\u52a1\u62a5\u9519" + e);
            throw new BusinessException("9999", "\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        GoodsCategoryQueryResBO result = new GoodsCategoryQueryResBO();
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(map);
        return result;
    }
}

