/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.BusiQryCommodityCatalogRspBO;
import com.tydic.newretail.bo.HotSearchCommodityReqBO;
import com.tydic.newretail.bo.HotSearchTypeReqBO;
import com.tydic.newretail.bo.QryOthLevelCommodityCatalogRspBO;
import com.tydic.newretail.bo.RspPageBO;
import com.tydic.newretail.busi.service.HotSearchService;
import com.tydic.newretail.dao.CommodityGuideCatalogDAO;
import com.tydic.newretail.dao.HotSearchCommodityDAO;
import com.tydic.newretail.dao.HotSearchTypeDAO;
import com.tydic.newretail.dao.po.CatalogInfoPO;
import com.tydic.newretail.dao.po.HotSearchCommodityPO;
import com.tydic.newretail.dao.po.HotSearchTypePO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.exception.ResourceException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HotSearchServiceImpl
implements HotSearchService {
    private static final Logger logger = LoggerFactory.getLogger(HotSearchServiceImpl.class);
    @Autowired
    HotSearchTypeDAO hotSearchTypeDAO;
    @Autowired
    HotSearchCommodityDAO hotSearchCommodityDAO;
    @Autowired
    private CommodityGuideCatalogDAO commodityGuideCatalogDAO;

    public BaseRspBO addHotSearchType(HotSearchTypeReqBO reqBO) {
        logger.info("\u65b0\u589e\u70ed\u641c\u5206\u7c7b\u5165\u53c2\uff1a" + reqBO.toString());
        BaseRspBO result = new BaseRspBO();
        if (null == reqBO.getCommodityTypeId()) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u5546\u54c1\u7c7b\u578bId\u4e3a\u7a7a");
            return result;
        }
        if (null == reqBO.getHotValue()) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u70ed\u5ea6\u503c\u4e3a\u7a7a");
            return result;
        }
        try {
            HotSearchTypePO po = this.typeReqBoToPO(reqBO);
            this.hotSearchTypeDAO.insertSelective(po);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u70ed\u641c\u5206\u7c7b\u51fa\u9519\uff1a", (Throwable)e);
            throw new ResourceException("\u65b0\u589e\u70ed\u641c\u5206\u7c7b\u51fa\u9519", e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        logger.info("\u65b0\u589e\u70ed\u641c\u5206\u7c7b\u51fa\u53c2\uff1a" + result.toString());
        return result;
    }

    private HotSearchTypePO typeReqBoToPO(HotSearchTypeReqBO bo) {
        HotSearchTypePO po = new HotSearchTypePO();
        po.setCommodityTypeId(bo.getCommodityTypeId());
        po.setHotSearchTypeId(bo.getHotSearchTypeId());
        po.setHotValue(bo.getHotValue());
        return po;
    }

    private HotSearchCommodityPO commodityReqBoToPO(HotSearchCommodityReqBO bo) {
        HotSearchCommodityPO po = new HotSearchCommodityPO();
        po.setCommodityId(bo.getCommodityId());
        po.setCommodityTypeId(bo.getCommodityTypeId());
        po.setHotSearchCommodityId(bo.getHotSearchCommodityId());
        po.setHotValue(bo.getHotValue());
        po.setSkuId(bo.getSkuId());
        return po;
    }

    public BaseRspBO addHotSearchCommodity(HotSearchCommodityReqBO reqBO) {
        logger.info("\u65b0\u589e\u70ed\u641c\u5546\u54c1\u5165\u53c2\uff1a" + reqBO.toString());
        BaseRspBO result = new BaseRspBO();
        if (null == reqBO.getCommodityId()) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u5546\u54c1Id\u4e3a\u7a7a");
            return result;
        }
        if (null == reqBO.getSkuId()) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u5355\u54c1Id\u4e3a\u7a7a");
            return result;
        }
        if (null == reqBO.getCommodityTypeId()) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u5546\u54c1\u5206\u7c7bId\u4e3a\u7a7a");
            return result;
        }
        if (null == reqBO.getHotValue()) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u70ed\u5ea6\u503c\u4e3a\u7a7a");
            return result;
        }
        try {
            HotSearchCommodityPO po = this.commodityReqBoToPO(reqBO);
            this.hotSearchCommodityDAO.insertSelective(po);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u70ed\u641c\u5546\u54c1\u51fa\u9519\uff1a", (Throwable)e);
            throw new ResourceException("\u65b0\u589e\u70ed\u641c\u5546\u54c1\u51fa\u9519", e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        logger.info("\u65b0\u589e\u70ed\u641c\u5546\u54c1\u51fa\u53c2\uff1a" + result.toString());
        return result;
    }

    public BaseRspBO editHotSearchCommodity(HotSearchCommodityReqBO reqBO) {
        logger.info("\u7f16\u8f91\u70ed\u641c\u5546\u54c1\u70ed\u5ea6\u503c\u5165\u53c2\uff1a" + reqBO.toString());
        BaseRspBO result = new BaseRspBO();
        if (null == reqBO.getHotSearchCommodityId()) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u70ed\u641c\u5546\u54c1Id\u4e3a\u7a7a");
            return result;
        }
        if (null == reqBO.getHotValue()) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u70ed\u5ea6\u503c\u4e3a\u7a7a");
            return result;
        }
        try {
            HotSearchCommodityPO po = this.commodityReqBoToPO(reqBO);
            this.hotSearchCommodityDAO.updateByPrimaryKeySelective(po);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u70ed\u641c\u5546\u54c1\u70ed\u5ea6\u503c\u51fa\u9519\uff1a", (Throwable)e);
            throw new ResourceException("\u7f16\u8f91\u70ed\u641c\u5546\u54c1\u70ed\u5ea6\u503c\u51fa\u9519", e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        logger.info("\u7f16\u8f91\u70ed\u641c\u5546\u54c1\u70ed\u5ea6\u503c\u51fa\u53c2\uff1a" + result.toString());
        return result;
    }

    public BaseRspBO editHotSearchType(HotSearchTypeReqBO reqBO) {
        logger.info("\u7f16\u8f91\u70ed\u641c\u5206\u7c7b\u70ed\u5ea6\u503c\u5165\u53c2\uff1a" + reqBO.toString());
        BaseRspBO result = new BaseRspBO();
        if (null == reqBO.getHotSearchTypeId()) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u70ed\u641c\u5206\u7c7bId\u4e3a\u7a7a");
            return result;
        }
        if (null == reqBO.getHotValue()) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u70ed\u5ea6\u503c\u4e3a\u7a7a");
            return result;
        }
        try {
            HotSearchTypePO po = this.typeReqBoToPO(reqBO);
            this.hotSearchTypeDAO.updateByPrimaryKeySelective(po);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u70ed\u641c\u5206\u7c7b\u70ed\u5ea6\u503c\u51fa\u9519\uff1a", (Throwable)e);
            throw new ResourceException("\u7f16\u8f91\u70ed\u641c\u5206\u7c7b\u70ed\u5ea6\u503c\u51fa\u9519", e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        logger.info("\u7f16\u8f91\u70ed\u641c\u5206\u7c7b\u70ed\u5ea6\u503c\u51fa\u53c2\uff1a" + result.toString());
        return result;
    }

    public RspPageBO<QryOthLevelCommodityCatalogRspBO> queryHotSearchType() {
        logger.error("\u67e5\u8be2\u70ed\u641c\u5206\u7c7b\u7c7b\u76ee\u4fe1\u606f\u5f00\u59cb");
        RspPageBO rsp = new RspPageBO();
        try {
            RspPageBO value = new RspPageBO();
            HotSearchTypePO poReq = new HotSearchTypePO();
            poReq.setOrderByStr("hot_value desc");
            List<HotSearchTypePO> poList = this.hotSearchTypeDAO.selectByRecord(poReq);
            logger.info("\u67e5\u8be2\u70ed\u641c\u5206\u7c7b\u6570\u636e\u5e93\u8fd4\u56de\u6761\u6570\uff1a", (Object)poList.size());
            ArrayList<Long> typeIdList = new ArrayList<Long>();
            List<Object> catalogInfos = new ArrayList();
            if (!CollectionUtils.isEmpty(poList)) {
                for (HotSearchTypePO hotSearchTypePO : poList) {
                    typeIdList.add(hotSearchTypePO.getCommodityTypeId());
                }
                catalogInfos = this.commodityGuideCatalogDAO.selectByCatalogIdList(typeIdList);
                logger.info("\u67e5\u8be2\u70ed\u641c\u5206\u7c7b \u5bfc\u8d2d\u7c7b\u76ee\u4fe1\u606f\u6570\u636e\u5e93\u8fd4\u56de\uff1a{}", catalogInfos);
            }
            ArrayList<BusiQryCommodityCatalogRspBO> commodityCatalogRspBOS = new ArrayList<BusiQryCommodityCatalogRspBO>();
            if (catalogInfos.size() > 0) {
                for (CatalogInfoPO catalogInfo : catalogInfos) {
                    BusiQryCommodityCatalogRspBO busiQryCommodityCatalogRspBO = new BusiQryCommodityCatalogRspBO();
                    BeanUtils.copyProperties((Object)catalogInfo, (Object)busiQryCommodityCatalogRspBO);
                    commodityCatalogRspBOS.add(busiQryCommodityCatalogRspBO);
                }
            }
            ArrayList<QryOthLevelCommodityCatalogRspBO> arrayList = new ArrayList<QryOthLevelCommodityCatalogRspBO>();
            QryOthLevelCommodityCatalogRspBO qryOthLevelCommodityCatalogRspBO = new QryOthLevelCommodityCatalogRspBO();
            qryOthLevelCommodityCatalogRspBO.setRows(commodityCatalogRspBOS);
            arrayList.add(qryOthLevelCommodityCatalogRspBO);
            value.setRows(arrayList);
            value.setRespCode("0000");
            value.setRespDesc("\u6210\u529f");
            logger.info("\u67e5\u8be2\u70ed\u641c\u5206\u7c7b\u7c7b\u76ee\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)value);
            rsp = value;
        }
        catch (Exception e) {
            logger.error(" \u67e5\u8be2\u70ed\u641c\u5206\u7c7b\u7c7b\u76ee\u4fe1\u606f\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u70ed\u641c\u5206\u7c7b\u7c7b\u76ee\u4fe1\u606f\u51fa\u9519");
        }
        return rsp;
    }
}

