/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.newretail.bo.DSkuBO;
import com.tydic.newretail.bo.InitSkuRspBO;
import com.tydic.newretail.busi.service.GenerateSkuSeqService;
import com.tydic.newretail.busi.service.InitSkuAtomService;
import com.tydic.newretail.constant.Constant;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitSkuAtomServiceImpl
implements InitSkuAtomService {
    private static final Logger logger = LoggerFactory.getLogger(InitSkuAtomServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private GenerateSkuSeqService generateSkuSeqService;
    @Autowired
    private SkuDAO skuMapper;

    public InitSkuRspBO initSku(DSkuBO sku) {
        if (this.isDebugEnabled) {
            logger.debug("\u521d\u59cb\u5316\u5355\u54c1\u539f\u5b50\u670d\u52a1\u6267\u884c");
        }
        logger.debug("\u5546\u54c1\u5165\u53c2" + JSONObject.toJSONString((Object)sku));
        InitSkuRspBO initSkuRspBO = new InitSkuRspBO();
        try {
            SkuPO newSku = new SkuPO();
            BeanUtils.copyProperties((Object)sku, (Object)newSku);
            newSku.setSkuId(this.generateSkuSeqService.generateSkuSeq().getSkuId());
            newSku.setCreateTime(new Date());
            newSku.setUpdateTime(new Date());
            newSku.setIsDelete(Constant.IS_DELETE);
            newSku.setSkuPriceTagName(sku.getSkuName());
            newSku.setErpLongName(sku.getSkuLongName());
            this.skuMapper.insertSelective(newSku);
            initSkuRspBO.setSkuId(newSku.getSkuId());
            initSkuRspBO.setSupplierId(newSku.getSupplierId());
            initSkuRspBO.setSucess(Boolean.valueOf(true));
            return initSkuRspBO;
        }
        catch (Exception var4) {
            logger.error("\u521d\u59cb\u5316\u5355\u54c1\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + var4);
            initSkuRspBO.setSucess(Boolean.valueOf(false));
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u521d\u59cb\u5316\u5355\u54c1\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", var4);
        }
    }
}

