/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.GenerateSkuPicSeqRspBO;
import com.tydic.newretail.bo.PictureBO;
import com.tydic.newretail.busi.service.GenerateSkuPicSeqService;
import com.tydic.newretail.busi.service.InitSkuPictureAtomService;
import com.tydic.newretail.constant.Constant;
import com.tydic.newretail.dao.SkuPicDAO;
import com.tydic.newretail.dao.po.SkuPicPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier
public class InitSkuPictureAtomServiceImpl
implements InitSkuPictureAtomService {
    private static final Logger logger = LoggerFactory.getLogger(InitSkuPictureAtomServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private GenerateSkuPicSeqService generateSkuPicSeqService;
    @Autowired
    private SkuPicDAO skuPicDAO;

    public boolean initSkuPicture(List<PictureBO> pictureBOList) {
        if (this.isDebugEnabled) {
            logger.debug("\u521d\u59cb\u5316\u5355\u54c1\u56fe\u7247\u539f\u5b50\u670d\u52a1\u6267\u884c");
        }
        boolean success = false;
        try {
            if (!pictureBOList.isEmpty()) {
                ArrayList<SkuPicPO> skuPics = new ArrayList<SkuPicPO>();
                for (PictureBO pictureBO : pictureBOList) {
                    GenerateSkuPicSeqRspBO generateSkuPicSeqRspBO = this.generateSkuPicSeqService.generateSkuPicSeq();
                    SkuPicPO skuPic = new SkuPicPO();
                    BeanUtils.copyProperties((Object)pictureBO, (Object)skuPic);
                    skuPic.setSkuPicId(generateSkuPicSeqRspBO.getSkuPicId());
                    skuPic.setCreateTime(new Date());
                    skuPic.setIsDelete(Constant.IS_DELETE);
                    skuPics.add(skuPic);
                    if (null == skuPic.getPicOrder()) {
                        skuPic.setPicOrder(0);
                    }
                    if (null != skuPic.getIsPrimary()) continue;
                    skuPic.setIsPrimary(0);
                }
                if (skuPics != null) {
                    this.skuPicDAO.insertSkuPicBatch(skuPics);
                    success = true;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u5355\u54c1\u56fe\u7247\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u521d\u59cb\u5316\u5355\u54c1\u56fe\u7247\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", e);
        }
        return success;
    }
}

