/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.PriceBO;
import com.tydic.newretail.busi.service.InitSkuPriceAtomService;
import com.tydic.newretail.constant.Constant;
import com.tydic.newretail.dao.SkuPriceDAO;
import com.tydic.newretail.dao.po.SkuPricePO;
import com.tydic.newretail.exception.BusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier
public class InitSkuPriceAtomServiceImpl
implements InitSkuPriceAtomService {
    private static final Logger logger = LoggerFactory.getLogger(InitSkuPriceAtomServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuPriceDAO skuPriceMapper;

    public Boolean initSkuPrice(PriceBO priceBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u521d\u59cb\u5316\u5355\u54c1\u4ef7\u683c\u539f\u5b50\u670d\u52a1\u6267\u884c");
        }
        boolean success = false;
        try {
            SkuPricePO skuPrice = new SkuPricePO();
            BeanUtils.copyProperties((Object)priceBO, (Object)skuPrice);
            skuPrice.setSkuPriceId(skuPrice.getSkuId());
            if (skuPrice.getCurrencyType() == null) {
                skuPrice.setCurrencyType(Constant.CURRENCY_TYPE_RMB);
            }
            skuPrice.setCreateTime(new Date());
            skuPrice.setIsDelete(Constant.IS_DELETE);
            this.skuPriceMapper.insert(skuPrice);
            success = true;
        }
        catch (Exception var4) {
            logger.error("\u521d\u59cb\u5316\u5355\u54c1\u4ef7\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + var4);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u521d\u59cb\u5316\u5355\u54c1\u4ef7\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", var4);
        }
        return success;
    }
}

