/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.GenerateSkuSpecSeqRspBO;
import com.tydic.newretail.bo.SkuSpecBO;
import com.tydic.newretail.busi.service.GenerateSkuSpecSeqService;
import com.tydic.newretail.busi.service.InitSkuSpecAtomService;
import com.tydic.newretail.constant.Constant;
import com.tydic.newretail.dao.SkuSpecDAO;
import com.tydic.newretail.dao.po.SkuSpecPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitSpecAtomServiceImpl
implements InitSkuSpecAtomService {
    private static final Logger logger = LoggerFactory.getLogger(InitSpecAtomServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private GenerateSkuSpecSeqService generateSkuSpecSeqService;
    @Autowired
    private SkuSpecDAO skuSpecMapper;

    public boolean initSkuSpec(List<SkuSpecBO> specBOList) {
        Boolean success = false;
        try {
            if (!specBOList.isEmpty()) {
                ArrayList<SkuSpecPO> skuSpecs = new ArrayList<SkuSpecPO>();
                for (SkuSpecBO specBO : specBOList) {
                    GenerateSkuSpecSeqRspBO generateSkuSpecRspBo = this.generateSkuSpecSeqService.generateSkuSpecSeq();
                    SkuSpecPO skuSpec = new SkuSpecPO();
                    BeanUtils.copyProperties((Object)specBO, (Object)skuSpec);
                    skuSpec.setSkuSpecId(generateSkuSpecRspBo.getSkuSpecId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    skuSpecs.add(skuSpec);
                }
                if (skuSpecs != null && skuSpecs.size() > 0) {
                    this.skuSpecMapper.insertSkuSpecBatch(skuSpecs);
                    success = true;
                }
            }
        }
        catch (Exception var8) {
            logger.error("\u521d\u59cb\u5316\u5355\u54c1\u89c4\u683c\u539f\u5b50\u670d\u52a1\u5931\u8d25" + var8);
            throw new BusinessException((String)null, "\u521d\u59cb\u5316\u5355\u54c1\u89c4\u683c\u539f\u5b50\u670d\u52a1");
        }
        return success;
    }

    public boolean delSkuSpec(List<Long> skuIdList) {
        Boolean success = false;
        try {
            if (CollectionUtils.isNotEmpty(skuIdList)) {
                this.skuSpecMapper.delBySkuIdList(skuIdList);
                success = true;
            }
        }
        catch (Exception var4) {
            logger.error("\u5220\u9664\u5355\u54c1\u89c4\u683c\u539f\u5b50\u670d\u52a1\u5931\u8d25" + var4);
            throw new BusinessException((String)null, "\u5220\u9664\u5355\u54c1\u89c4\u683c\u539f\u5b50\u670d\u52a1");
        }
        return success;
    }
}

