/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.BatchCreateSkuReqBO;
import com.tydic.newretail.bo.BatchEnableShutdownProvGoodsBO;
import com.tydic.newretail.bo.CreateSkuReqBO;
import com.tydic.newretail.bo.DSkuBO;
import com.tydic.newretail.bo.ProvAndCityCodeBO;
import com.tydic.newretail.busi.service.BatchCreateSkuService;
import com.tydic.newretail.busi.service.ProvGoodsEnableShutdownService;
import com.tydic.newretail.busi.service.XlsSkuManageService;
import com.tydic.newretail.dao.ProvGoodsDAO;
import com.tydic.newretail.dao.ProvGoodsSupRelationDAO;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.po.ProvGoodsPO;
import com.tydic.newretail.dao.po.ProvGoodsSupRelationPO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.util.TKGenericServiceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProvGoodsEnableShutdownServiceImpl
implements ProvGoodsEnableShutdownService {
    private static final Logger logger = LoggerFactory.getLogger(ProvGoodsEnableShutdownServiceImpl.class);
    @Autowired
    private SkuDAO xlsSkuMapper;
    @Autowired
    private BatchCreateSkuService batchCreateSkuService;
    @Autowired
    private XlsSkuManageService xlsSkuManageService;
    @Autowired
    private ProvGoodsSupRelationDAO provGoodsSupRelationDAO;
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Value(value="${hsf.version}")
    private String hsfVersion;
    @Value(value="${hsf.group}")
    private String hsfGroup;
    @Value(value="${hsf.clientTimeout}")
    private String hsfClientTimeout;

    public BaseRspBO batchProvGoodsEnableShutdown(BatchEnableShutdownProvGoodsBO reqBO) {
        logger.debug("\u7701\u4efd\u5546\u54c1\u7684\u542f\u7528\u505c\u7528\u63a5\u53e3\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)reqBO));
        BaseRspBO result = new BaseRspBO();
        try {
            this.requestCheckout(reqBO);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            result.setRespCode("9999");
            result.setRespDesc(e.getMessage());
            return result;
        }
        List<ProvGoodsPO> provGoodsPOS = null;
        try {
            provGoodsPOS = this.provGoodsDAO.selectByProvGoodsIds(reqBO.getProvGoodsIdList());
            logger.debug("\u67e5\u8be2\u5230\u7684\u7701\u4efd\u5546\u54c1\u6570\u636e" + JSON.toJSONString(provGoodsPOS));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u5931\u8d25:" + e.getMessage());
            result.setRespCode("9999");
            result.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            return result;
        }
        if (CollectionUtils.isEmpty(provGoodsPOS)) {
            result.setRespCode("0000");
            result.setRespDesc("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u7701\u4efd\u5546\u54c1");
            return result;
        }
        if (Objects.equals("1", reqBO.getEnableOrDisableType())) {
            reqBO.setEnableOrDisableType("03");
        } else if (Objects.equals("0", reqBO.getEnableOrDisableType())) {
            reqBO.setEnableOrDisableType("04");
        }
        Iterator<ProvGoodsPO> iterator = provGoodsPOS.iterator();
        while (iterator.hasNext()) {
            ProvGoodsPO provGoodsPO = iterator.next();
            if (!reqBO.getEnableOrDisableType().equals(provGoodsPO.getGoodsStatus())) continue;
            iterator.remove();
        }
        if (CollectionUtils.isEmpty(provGoodsPOS)) {
            result.setRespCode("0000");
            result.setRespDesc("\u6210\u529f");
            return result;
        }
        if ("04".equals(reqBO.getEnableOrDisableType())) {
            logger.debug("\u5f00\u59cb\u6267\u884c\u7701\u4efd\u5546\u54c1\u7684\u505c\u7528");
            try {
                this.isRepertoryEmpty(provGoodsPOS);
            }
            catch (Exception e) {
                logger.error("\u5e93\u5b58\u67e5\u8be2" + e.getMessage());
                result.setRespCode("9999");
                result.setRespDesc("\u5e93\u5b58\u67e5\u8be2" + e.getMessage());
                return result;
            }
        }
        try {
            logger.debug("\u505c\u7528\u7701\u4efd\u5546\u54c1\u7684\u4fe1\u606f\uff1a" + JSON.toJSONString(provGoodsPOS));
            logger.debug("\u505c\u7528\u7701\u4efd\u5546\u54c1\u7684\u72b6\u6001\uff1a" + JSON.toJSONString((Object)reqBO.getEnableOrDisableType()));
            this.provGoodsDAO.updateEnableShutdownSelective(provGoodsPOS, reqBO.getEnableOrDisableType());
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u7701\u4efd\u5546\u54c1\u5931\u8d25:" + e.getMessage());
            result.setRespCode("9999");
            result.setRespDesc("\u4fee\u6539\u7701\u4efd\u5546\u54c1\u5931\u8d25:" + e.getMessage());
            return result;
        }
        try {
            ArrayList provGoodsIds = new ArrayList();
            provGoodsPOS.stream().forEach(str -> provGoodsIds.add(str.getProvGoodsId()));
            if ("03".equals(reqBO.getEnableOrDisableType())) {
                this.xlsSkuManageService.batchEnableShutdowmSkuUpdate(provGoodsIds, Integer.valueOf(0));
            } else {
                this.xlsSkuManageService.batchEnableShutdowmSkuUpdate(provGoodsIds, Integer.valueOf(1));
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539SKU\u5f02\u5e38:" + e.getMessage());
            result.setRespCode("9999");
            result.setRespDesc("\u4fee\u6539SKU\u5f02\u5e38:" + e.getMessage());
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public void isRepertoryEmpty(List<ProvGoodsPO> provGoodsPOList) {
        logger.debug("\u67e5\u8be2\u5230\u7701\u4efd\u5546\u54c1\u6570\u636e" + JSON.toJSONString(provGoodsPOList));
        JSONObject resultData = this.selectRepertory(provGoodsPOList);
        JSONArray nums = resultData.getJSONArray("nums");
        if (CollectionUtils.isEmpty((Collection)nums)) {
            return;
        }
        HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
        for (Object e : nums) {
            JSONObject strJsonObject = JSON.parseObject((String)JSON.toJSONString(e));
            if (map.containsKey(strJsonObject.getString("materialCode").trim() + strJsonObject.getString("provId"))) continue;
            map.put(strJsonObject.getString("materialCode").trim() + strJsonObject.getString("provId").trim(), strJsonObject);
        }
        logger.debug("map\u4e2d\u7684\u503c" + JSON.toJSONString(map));
        for (ProvGoodsPO provGoodsPO : provGoodsPOList) {
            JSONObject o = (JSONObject)map.get(provGoodsPO.getMaterialId().trim() + provGoodsPO.getProvinceCode().trim());
            if (o == null) continue;
            Long unsaleNum = o.getLong("unsaleNum");
            Long transNum = o.getLong("transNum");
            Long lockNum = o.getLong("lockNum");
            if (unsaleNum <= 0L && transNum <= 0L && lockNum <= 0L) continue;
            logger.debug("\u7269\u6599\u7f16\u7801\u4e3a\uff1a" + o.getString("materialCode") + "\u7684\u53ef\u552e,\u5728\u9014,\u9501\u5e93 \u4e0d\u4e3a\u7a7a\u4e0d\u80fd\u8fdb\u884c\u505c\u7528");
            throw new BusinessException("9999", "\u7269\u6599\u7f16\u7801\u4e3a\uff1a" + o.getString("materialCode") + "\u7684\u53ef\u552e,\u5728\u9014,\u9501\u5e93 \u4e0d\u4e3a\u7a7a\u4e0d\u80fd\u8fdb\u884c\u505c\u7528");
        }
    }

    private JSONObject selectRepertory(List<ProvGoodsPO> provGoodsPOList) {
        HashMap param = new HashMap();
        ArrayList materialCodes = new ArrayList();
        ArrayList provIds = new ArrayList();
        provGoodsPOList.stream().forEach(str -> {
            materialCodes.add(str.getMaterialId());
            provIds.add(str.getProvinceCode());
        });
        param.put("provIds", provIds);
        param.put("materialCodes", materialCodes);
        JSONObject resultData = new JSONObject();
        try {
            InvokeInfo invokeInfo = new InvokeInfo("com.tydic.smc.api.ability.SmcQryUnSaleCountsAbilityService", "qryUnSaleCountsList", "com.tydic.smc.api.ability.bo.SmcQryUnSaleCountsAbilityReqBO");
            invokeInfo.setVersion(this.hsfVersion);
            invokeInfo.setGroup(this.hsfGroup);
            invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
            invokeInfo.setRegisterType("2");
            resultData = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString(param), null, (InvokeInfo)invokeInfo);
            logger.debug("\u8fdb\u884c\u6cdb\u5316\u8c03\u7528\u8fd4\u56de\u503c" + resultData);
        }
        catch (Exception e) {
            logger.error("\u53ef\u552e,\u5728\u9014,\u9501\u5e93\uff0c\u6570\u91cf\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            throw new BusinessException("9999", "\u53ef\u552e,\u5728\u9014,\u9501\u5e93\uff0c\u6570\u91cf\u67e5\u8be2\u5931\u8d25");
        }
        return resultData;
    }

    public void requestCheckout(BatchEnableShutdownProvGoodsBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getProvGoodsIdList()) || StringUtils.isEmpty((String)reqBO.getEnableOrDisableType())) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new BusinessException("9999", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (!"0".equals(reqBO.getEnableOrDisableType()) && !"1".equals(reqBO.getEnableOrDisableType())) {
            logger.error("\u5546\u54c1\u7684\u72b6\u6001\u9519\u8bef");
            throw new BusinessException("9999", "\u5546\u54c1\u7684\u72b6\u6001\u9519\u8bef");
        }
    }

    private JSONObject reqBOresultData(ProvGoodsPO provPO) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("provId", provPO.getProvinceCode());
        param.put("materialCode", provPO.getMaterialId());
        JSONObject resultData = new JSONObject();
        try {
            InvokeInfo invokeInfo = new InvokeInfo("com.tydic.smc.api.ability.SmcQryUnSaleCountsAbilityService", "qryUnSaleCounts", "com.tydic.smc.api.ability.bo.SmcQryUnSaleCountsAbilityReqBO");
            invokeInfo.setVersion(this.hsfVersion);
            invokeInfo.setGroup(this.hsfGroup);
            invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
            invokeInfo.setRegisterType("2");
            resultData = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString(param), null, (InvokeInfo)invokeInfo);
            logger.debug("\u8fdb\u884c\u6cdb\u5316\u8c03\u7528" + resultData);
        }
        catch (Exception e) {
            logger.error("\u53ef\u552e\u548c\u5728\u9014\u6570\u91cf\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            throw new BusinessException("9999", "\u53ef\u552e\u548c\u5728\u9014\u6570\u91cf\u67e5\u8be2\u5931\u8d25");
        }
        return resultData;
    }

    public List<DSkuBO> getSkuBOS(ProvGoodsPO prov, String status, List<ProvGoodsSupRelationPO> relation, String orgPath) throws Exception {
        ArrayList<DSkuBO> skuBOS = new ArrayList<DSkuBO>();
        List<SkuPO> skus = this.getSku(prov.getProvinceCode(), prov.getMaterialId(), orgPath);
        String vendorId = this.getId(relation);
        String vendorName = this.getName(relation);
        logger.debug("\u4f9b\u5e94\u5546id" + vendorId);
        logger.debug("\u4f9b\u5e94\u5546\u540d\u79f0" + vendorName);
        DSkuBO skuBO = null;
        for (SkuPO s : skus) {
            skuBO = new DSkuBO();
            skuBO.setBrandId(prov.getBrandId());
            skuBO.setBrandName(prov.getBrandName());
            skuBO.setVendorId(StringUtils.isBlank((String)vendorId) ? null : vendorId.substring(0, vendorId.length() - 1));
            skuBO.setVendorName(StringUtils.isBlank((String)vendorName) ? null : vendorName.substring(0, vendorName.length() - 1));
            skuBO.setSkuId(s.getSkuId());
            skuBO.setProvinceCode(prov.getProvinceCode());
            skuBO.setCityCode(s.getCityCode());
            skuBO.setCgType(prov.getCgType());
            skuBO.setSkuCode(prov.getGoodsNo());
            skuBO.setIsVirtualGood(prov.getAllowNegativeStock());
            skuBO.setProvGoodsId(prov.getProvGoodsId());
            skuBO.setColor(prov.getColorName());
            skuBO.setRam(prov.getMemoryName());
            skuBO.setBrand(prov.getBrandName());
            skuBO.setModel(prov.getGoodsModel());
            skuBO.setSkuName(prov.getGoodsLongName());
            skuBO.setSkuLongName(prov.getGoodsLongName());
            skuBO.setErpLongName(prov.getGoodsLongName());
            skuBO.setSkuPriceTagName(prov.getGoodsLongName());
            skuBO.setMfgSku(prov.getGoodsModel());
            skuBO.setSupplierId(s.getSupplierId());
            if ("03".equals(status)) {
                skuBO.setIsDelete(Integer.valueOf(0));
            } else if ("04".equals(status)) {
                skuBO.setIsDelete(Integer.valueOf(1));
            }
            skuBOS.add(skuBO);
        }
        return skuBOS;
    }

    public List<SkuPO> getSku(String provCode, String materialId, String orgPath) throws Exception {
        Map<String, ProvAndCityCodeBO> shopIds = this.getProvCode(orgPath);
        List<SkuPO> skus = new ArrayList<SkuPO>();
        if (!CollectionUtils.isEmpty(shopIds)) {
            ArrayList<String> materialIds = new ArrayList<String>();
            materialIds.add(materialId);
            ArrayList<Long> supplierIds = new ArrayList<Long>();
            for (Map.Entry<String, ProvAndCityCodeBO> shop : shopIds.entrySet()) {
                supplierIds.add(Long.parseLong(shop.getKey()));
            }
            skus = this.xlsSkuMapper.queryXlsSkuByMaterialsAndShopListAll(supplierIds, materialIds);
        }
        for (SkuPO sk : skus) {
            sk.setProvinceCode(shopIds.get(sk.getSupplierId().toString()).getProvinceCode());
            sk.setCityCode(shopIds.get(sk.getSupplierId().toString()).getCityCode());
        }
        return skus;
    }

    public void add(ProvGoodsPO provPO, List<ProvGoodsSupRelationPO> relation, String orgPath) throws Exception {
        Map<String, ProvAndCityCodeBO> shopIds = this.getProvCode(orgPath);
        BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
        ArrayList<CreateSkuReqBO> reqList = new ArrayList<CreateSkuReqBO>();
        String vendorId = this.getId(relation);
        String vendorName = this.getName(relation);
        logger.debug("\u4f9b\u5e94\u5546id" + vendorId);
        logger.debug("\u4f9b\u5e94\u5546\u540d\u79f0" + vendorName);
        CreateSkuReqBO bo = null;
        if (!CollectionUtils.isEmpty(shopIds)) {
            for (Map.Entry<String, ProvAndCityCodeBO> shopId : shopIds.entrySet()) {
                bo = new CreateSkuReqBO();
                bo.setCgType(provPO.getCgType());
                bo.setGoodsSource(provPO.getGoodsSource());
                bo.setColor(provPO.getColorName());
                bo.setBrand(provPO.getBrandName());
                bo.setMeasureId(provPO.getMeasureId());
                bo.setMeasureName(provPO.getMeasureName());
                bo.setRam(provPO.getMemoryName());
                bo.setModel(provPO.getGoodsModel());
                bo.setFullName(provPO.getGoodsLongName());
                bo.setSupplierId(Long.valueOf(Long.parseLong(shopId.getKey())));
                bo.setSupplierName(shopId.getValue().getShopName());
                bo.setCityCode(shopId.getValue().getCityCode());
                bo.setProvinceCode(shopId.getValue().getProvinceCode());
                bo.setCountyCode(shopId.getValue().getCountryCode());
                bo.setName(provPO.getGoodsModel());
                bo.setIsVirtualGood(provPO.getAllowNegativeStock());
                bo.setMaterialId(provPO.getMaterialId());
                bo.setProvGoodsId(provPO.getProvGoodsId());
                bo.setSkuCode(provPO.getGoodsNo());
                bo.setProvinceCode(provPO.getProvinceCode());
                bo.setVendorId(StringUtils.isBlank((String)vendorId) ? null : vendorId.substring(0, vendorId.length() - 1));
                bo.setVendorName(StringUtils.isBlank((String)vendorName) ? null : vendorName.substring(0, vendorName.length() - 1));
                bo.setBrandId(provPO.getBrandId());
                bo.setBrandName(provPO.getBrandName());
                bo.setModel(provPO.getGoodsModel());
                reqList.add(bo);
            }
            batchCreateSkuReqBO.setCreateSkuReqBOs(reqList);
            this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
        }
    }

    public Map<String, ProvAndCityCodeBO> getProvCode(String provinceCode) throws Exception {
        HashMap<String, ProvAndCityCodeBO> map = new HashMap<String, ProvAndCityCodeBO>();
        JSONObject param = new JSONObject();
        param.put("queryType", (Object)4);
        param.fluentPut("orgTreePath", (Object)provinceCode);
        param.put("isCutoverFlag", (Object)1);
        param.put("isFilteStoreId", (Object)0);
        InvokeInfo invokeInfo = new InvokeInfo("com.ohaotian.authority.organisation.service.SelectOrgTreeService", "selectOrgTree", "com.ohaotian.authority.organisation.bo.SelectOrgTreeReqBO");
        invokeInfo.setVersion(this.hsfVersion);
        invokeInfo.setGroup(this.hsfGroup);
        invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
        invokeInfo.setRegisterType("2");
        JSONObject prov = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString((Object)param), null, (InvokeInfo)invokeInfo);
        logger.debug("\u8fdb\u884c\u6cdb\u5316\u8c03\u7528\u8fd4\u56de\u503c" + prov);
        if (!CollectionUtils.isEmpty((Collection)prov.getJSONArray("orgTreeBOList"))) {
            ProvAndCityCodeBO bo = null;
            JSONArray orgTreeBOList = prov.getJSONArray("orgTreeBOList");
            for (int i = 0; i < orgTreeBOList.size(); ++i) {
                JSONObject item = orgTreeBOList.getJSONObject(i);
                if (!StringUtils.isNotEmpty((String)item.getString("storeId"))) continue;
                bo = new ProvAndCityCodeBO();
                bo.setCityCode(item.getString("cityCode"));
                bo.setProvinceCode(item.getString("provinceCode"));
                bo.setShopName(item.getString("orgName"));
                bo.setCountryCode(item.getString("districtCode"));
                map.put(item.getString("storeId"), bo);
            }
        }
        return map;
    }

    public String getId(List<ProvGoodsSupRelationPO> relation) {
        String id = "";
        if (!CollectionUtils.isEmpty(relation)) {
            for (ProvGoodsSupRelationPO po : relation) {
                id = id + po.getSupplierId() + ",";
            }
        }
        return id;
    }

    public String getName(List<ProvGoodsSupRelationPO> relation) {
        String name = "";
        if (!CollectionUtils.isEmpty(relation)) {
            for (ProvGoodsSupRelationPO po : relation) {
                name = name + po.getSupplierName() + ",";
            }
        }
        return name;
    }
}

