/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.atom.SysParamsAtomService;
import com.tydic.newretail.bo.AddProvGoodsListReqBO;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.BatchCreateSkuReqBO;
import com.tydic.newretail.bo.CreateSkuReqBO;
import com.tydic.newretail.bo.DSkuBO;
import com.tydic.newretail.bo.PriceBO;
import com.tydic.newretail.bo.ProvAndCityCodeBO;
import com.tydic.newretail.bo.ProvGoodsBO;
import com.tydic.newretail.bo.ProvGoodsInsureBO;
import com.tydic.newretail.bo.ProvGoodsInsureByProductCodeSupNoBO;
import com.tydic.newretail.bo.ProvGoodsInsureByProductCodeSupNoRspBO;
import com.tydic.newretail.bo.ProvGoodsInsureResBO;
import com.tydic.newretail.bo.RspInfoListBO;
import com.tydic.newretail.bo.RspPageBO;
import com.tydic.newretail.bo.SelectSkuAndSupListRspBO;
import com.tydic.newretail.bo.SupplierBO;
import com.tydic.newretail.bo.SysParamTransBusiBO;
import com.tydic.newretail.busi.service.AddGoodsByProvCodeService;
import com.tydic.newretail.busi.service.BatchCreateSkuService;
import com.tydic.newretail.busi.service.ProvGoodsInsureService;
import com.tydic.newretail.busi.service.SysParamTransferBusiService;
import com.tydic.newretail.busi.service.XlsSkuManageService;
import com.tydic.newretail.busi.service.XlsSkuPriceManageService;
import com.tydic.newretail.dao.DmodelGroupMaterialDAO;
import com.tydic.newretail.dao.ProvGoodsDAO;
import com.tydic.newretail.dao.ProvGoodsInsureServiceDAO;
import com.tydic.newretail.dao.ProvGoodsSupRelationDAO;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.po.DmodelGroupMaterialPO;
import com.tydic.newretail.dao.po.ProvGoodsAndSupplierPO;
import com.tydic.newretail.dao.po.ProvGoodsInsureServicePO;
import com.tydic.newretail.dao.po.ProvGoodsSupRelationPO;
import com.tydic.newretail.dao.po.SkuAndProvPO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.thread.CreateStockThread;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.util.TKGenericServiceUtils;
import com.tydic.newretail.util.MoneyUtils;
import com.tydic.newretail.util.RedisUtil;
import com.tydic.newretail.util.SerializationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.Jedis;

@Service
public class ProvGoodsInsureServiceImpl
implements ProvGoodsInsureService {
    private static final Logger logger = LoggerFactory.getLogger(ProvGoodsInsureServiceImpl.class);
    @Value(value="${hsf.version}")
    private String hsfVersion;
    @Value(value="${hsf.group}")
    private String hsfGroup;
    @Value(value="${hsf.clientTimeout}")
    private String hsfClientTimeout;
    @Autowired
    private ProvGoodsInsureServiceDAO provGoodsInsureServiceDAO;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    @Autowired
    private AddGoodsByProvCodeService addGoodsByProvCodeService;
    @Autowired
    private BatchCreateSkuService batchCreateSkuService;
    @Autowired
    private ProvGoodsSupRelationDAO provGoodsSupRelationDAO;
    @Autowired
    private XlsSkuManageService xlsSkuManageService;
    @Autowired
    private XlsSkuPriceManageService xlsSkuPriceManageService;
    @Autowired
    private SysParamTransferBusiService sysParamTransferBusiService;
    @Autowired
    private SkuDAO xlsSkuMapper;
    @Autowired
    private DmodelGroupMaterialDAO dmodelGroupMaterialDAO;
    @Autowired
    private ProvGoodsDAO provGoodsDAO;

    public RspPageBO<ProvGoodsInsureBO> queryInsureByPage(ProvGoodsInsureBO reqBO) {
        logger.debug("\u8c03\u7528\u4fdd\u969c\u670d\u52a1\u5206\u9875\u67e5\u8be2");
        RspPageBO result = new RspPageBO();
        ArrayList<ProvGoodsInsureBO> rows = new ArrayList<ProvGoodsInsureBO>();
        ProvGoodsInsureServicePO record = new ProvGoodsInsureServicePO();
        reqBO.setProvinceCode(StringUtils.isBlank((String)reqBO.getProvinceCode()) ? reqBO.getmProvince() : reqBO.getProvinceCode());
        logger.debug("\u7528\u6237\u7684\u7701\u4efd" + reqBO.getProvinceCode());
        if ("1".equals(reqBO.getmUserLevel())) {
            record.setModelGroupType("0");
        }
        record.setSecurityServicesType(reqBO.getSecurityServicesType());
        record.setSecurityServicesStatus(reqBO.getSecurityServicesStatus());
        record.setPurchaseType(reqBO.getPurchaseType());
        record.setProvinceCode(reqBO.getProvinceCode());
        record.setSupNo(reqBO.getSupNo());
        record.setQualityOfSpare(reqBO.getQualityOfSpare());
        record.setProductClients(reqBO.getProductClients());
        Page page = new Page();
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getOffset());
        List<Object> poList = new ArrayList();
        try {
            poList = this.provGoodsInsureServiceDAO.selectSelective(record, (Page<ProvGoodsInsureServicePO>)page);
            if (!CollectionUtils.isEmpty(poList)) {
                Map<String, Map<String, String>> escaMap = this.getEscape();
                ProvGoodsInsureBO bo = null;
                for (ProvGoodsInsureServicePO provGoodsInsureServicePO : poList) {
                    bo = new ProvGoodsInsureBO();
                    BeanUtils.copyProperties((Object)provGoodsInsureServicePO, (Object)bo);
                    String provinceName = "";
                    if (StringUtils.isNotEmpty((String)provGoodsInsureServicePO.getApplyProvince())) {
                        provinceName = this.getProvinceName(provGoodsInsureServicePO.getApplyProvince());
                    }
                    bo.setApplyProvinceStr(provinceName);
                    bo.setPurchaseTypeStr(escaMap.get("PURCHASE_TYPE").get(provGoodsInsureServicePO.getPurchaseType()));
                    bo.setHasSerialNumberStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(provGoodsInsureServicePO.getHasSerialNumber()));
                    bo.setIsSaleOnlineStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(provGoodsInsureServicePO.getHasSerialNumber()));
                    bo.setModelGroupTypeStr(escaMap.get("MODEL_GROUP_TYPE").get(provGoodsInsureServicePO.getModelGroupType()));
                    if (provGoodsInsureServicePO.getProductClients().equals("01") || provGoodsInsureServicePO.getProductClients().equals("02")) {
                        bo.setProductClientsStr(escaMap.get("PRODUCT_CLIENTS").get(provGoodsInsureServicePO.getProductClients()));
                    } else {
                        bo.setProductClientsStr(escaMap.get("PRODUCT_CLIENTS_NEW").get(provGoodsInsureServicePO.getProductClients()));
                    }
                    bo.setQualityOfSpareStr(escaMap.get("QUALITY_OF_SPARE").get(provGoodsInsureServicePO.getQualityOfSpare()));
                    bo.setScreenTypeStr(escaMap.get("SCREEN_TYPE").get(provGoodsInsureServicePO.getScreenType()));
                    bo.setSecurityServicesStatusStr(escaMap.get("SECURITY_SERVICES_STATUS").get(provGoodsInsureServicePO.getSecurityServicesStatus()));
                    bo.setSecurityServicesTypeStr(escaMap.get("BUSINESS_TYPE").get(provGoodsInsureServicePO.getSecurityServicesType()));
                    if (provGoodsInsureServicePO.getTermOfValidity().equals("01") || provGoodsInsureServicePO.getTermOfValidity().equals("02")) {
                        bo.setTermOfValidityStr(escaMap.get("TERM_OF_VALIDITY").get(provGoodsInsureServicePO.getTermOfValidity()));
                    } else {
                        bo.setTermOfValidityStr(escaMap.get("TERM_OF_VALIDITY_NEW").get(provGoodsInsureServicePO.getTermOfValidity()));
                    }
                    bo.setPurchasePriceStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getPurchasePrice()));
                    bo.setActivityPriceStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getActivityPrice()));
                    bo.setPriceHighStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getPriceHigh()));
                    bo.setPriceLowStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getPriceLow()));
                    bo.setSalePriceStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getSalePrice()));
                    bo.setLimitPriceStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getLimitPrice()));
                    bo.setRealityPriceStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getRealityPrice()));
                    bo.setInvoiceTaxRate(provGoodsInsureServicePO.getInvoiceTaxRate());
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4fdd\u969c\u670d\u52a1\u5206\u9875\u67e5\u8be2\u63a5\u53e3\u62a5\u9519");
            throw new BusinessException("9999", "\u8c03\u7528\u4fdd\u969c\u670d\u52a1\u5206\u9875\u67e5\u8be2\u63a5\u53e3\u62a5\u9519" + e.getMessage());
        }
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public BaseRspBO addInsure(ProvGoodsInsureBO reqBO) {
        String materialId;
        BaseRspBO result = new BaseRspBO();
        ArrayList<ProvGoodsBO> provGoods = new ArrayList<ProvGoodsBO>();
        ArrayList<ProvGoodsInsureServicePO> insureList = new ArrayList<ProvGoodsInsureServicePO>();
        ArrayList<CreateSkuReqBO> skuList = new ArrayList<CreateSkuReqBO>();
        ProvGoodsBO provBo = null;
        ProvGoodsInsureServicePO insure = null;
        ArrayList<ProvGoodsBO> upProv = new ArrayList<ProvGoodsBO>();
        ArrayList<ProvGoodsInsureServicePO> update = new ArrayList<ProvGoodsInsureServicePO>();
        String string = materialId = "05".equals(reqBO.getSecurityServicesType()) ? reqBO.getMaterialId() : "INSURE" + Sequence.getInstance().nextId();
        if ("1".equals(reqBO.getmUserLevel())) {
            ProvGoodsInsureServicePO record = new ProvGoodsInsureServicePO();
            record.setMaterialId(materialId);
            List<ProvGoodsInsureServicePO> prov = this.provGoodsInsureServiceDAO.selectSelectiveAll(record);
            if (!CollectionUtils.isEmpty(prov)) {
                result.setRespCode("9999");
                result.setRespDesc("\u8be5\u4fdd\u9669\u5df2\u5b58\u5728");
                return result;
            }
            logger.debug("\u603b\u90e8\u65b0\u589e");
            logger.debug("\u9002\u7528\u7701\u4efd" + reqBO.getApplyProvince());
            List<String> provList = Arrays.asList(reqBO.getApplyProvince().split(","));
            for (int i = 0; i <= provList.size(); ++i) {
                if (i != provList.size() && StringUtils.isBlank((String)provList.get(i))) continue;
                if (i != provList.size()) {
                    ProvGoodsInsureServicePO recordpo = new ProvGoodsInsureServicePO();
                    recordpo.setMaterialId(materialId);
                    recordpo.setProvinceCode(provList.get(i));
                    List<ProvGoodsInsureServicePO> provIn = this.provGoodsInsureServiceDAO.selectSelective(recordpo);
                    if (!CollectionUtils.isEmpty(provIn)) {
                        logger.debug("\u603b\u90e8\u65b0\u589e \u4f46\u662f\u7701\u4efd\u5df2\u7ecf\u5b58\u5728\u6240\u4ee5\u66f4\u65b0");
                        ProvGoodsBO provGood = new ProvGoodsBO();
                        ProvGoodsInsureServicePO provGoodsInsureServicePO = new ProvGoodsInsureServicePO();
                        provGood = this.insure2Prov(reqBO, false, provList.get(i), false, null, false);
                        provGood.setSupplierBO(reqBO.getSupplierBO());
                        ProvGoodsInsureServicePO provGoodsInsureServicePO2 = this.bo2po(reqBO, false, provList.get(i), provIn.get(0).getProvGoodsId(), false);
                        update.add(provGoodsInsureServicePO2);
                        upProv.add(provGood);
                        continue;
                    }
                }
                insure = new ProvGoodsInsureServicePO();
                BeanUtils.copyProperties((Object)reqBO, (Object)insure);
                Long provGoodsId = Sequence.getInstance().nextId();
                insure.setProvGoodsId(provGoodsId);
                try {
                    insure.setPurchasePrice(MoneyUtils.BigDecimal2Long(reqBO.getPurchasePriceStr()));
                    insure.setPriceHigh(MoneyUtils.BigDecimal2Long(reqBO.getPriceHighStr()));
                    insure.setPriceLow(MoneyUtils.BigDecimal2Long(reqBO.getPriceLowStr()));
                    insure.setSalePrice(MoneyUtils.BigDecimal2Long(reqBO.getSalePriceStr()));
                    insure.setLimitPrice(MoneyUtils.BigDecimal2Long(reqBO.getLimitPriceStr()));
                    insure.setRealityPrice(MoneyUtils.BigDecimal2Long(reqBO.getRealityPriceStr()));
                }
                catch (Exception e) {
                    logger.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25");
                    throw new BusinessException("9999", "\u4ef7\u683c\u8f6c\u6362\u5931\u8d25" + e.getMessage());
                }
                provBo = new ProvGoodsBO();
                if (i == provList.size()) {
                    insure.setApplyProvince(reqBO.getApplyProvince());
                    insure.setModelGroupType("0");
                    insure.setSecurityServicesStatus("01");
                    provBo.setProvinceCode(null);
                } else {
                    insure.setApplyProvince(provList.get(i));
                    insure.setModelGroupType("2");
                    insure.setSecurityServicesStatus("02");
                    provBo.setProvinceCode(provList.get(i));
                    if (reqBO.getInvoiceTaxRate() == null) {
                        if (provBo.getProvinceCode().equals("330000")) {
                            provBo.setInvoiceTaxRate(Double.valueOf(0.06));
                        } else {
                            provBo.setInvoiceTaxRate(Double.valueOf(0.13));
                        }
                    } else {
                        provBo.setInvoiceTaxRate(reqBO.getInvoiceTaxRate());
                    }
                }
                provBo.setProvGoodsId(provGoodsId);
                provBo.setGoodsLongName(reqBO.getGoodsLongName());
                provBo.setGoodsName(reqBO.getGoodsLongName());
                provBo.setMaterialId(materialId);
                provBo.setScreenType(reqBO.getScreenType());
                provBo.setSupNo(reqBO.getSupNo());
                provBo.setCreateTime(new Date());
                provBo.setCreateUser(reqBO.getmName());
                provBo.setCreateUsername(reqBO.getmName());
                provBo.setIsValid("1");
                provBo.setSupplierBO(reqBO.getSupplierBO());
                provBo.setSecurityServicesType(reqBO.getSecurityServicesType());
                provGoods.add(provBo);
                insureList.add(insure);
            }
        } else {
            ProvGoodsInsureServicePO recordpo = new ProvGoodsInsureServicePO();
            recordpo.setMaterialId(materialId);
            recordpo.setProvinceCode(reqBO.getApplyProvince());
            List<ProvGoodsInsureServicePO> provIn = this.provGoodsInsureServiceDAO.selectSelective(recordpo);
            if (!CollectionUtils.isEmpty(provIn)) {
                result.setRespCode("9999");
                result.setRespDesc("\u8be5\u4fdd\u9669\u5df2\u5b58\u5728");
                return result;
            }
            Long provGoodsId = Sequence.getInstance().nextId();
            String vendorName = "";
            String vendorId = "";
            for (Object su : reqBO.getSupplierBO()) {
                vendorId = vendorId + su.getSupplierId() + ",";
                vendorName = vendorName + su.getSupplierName() + ",";
            }
            provBo = new ProvGoodsBO();
            insure = new ProvGoodsInsureServicePO();
            logger.debug("\u7701\u4efd");
            provBo.setProvinceCode(reqBO.getApplyProvince());
            provBo.setProvGoodsId(provGoodsId);
            provBo.setGoodsLongName(reqBO.getGoodsLongName());
            provBo.setGoodsName(reqBO.getGoodsLongName());
            provBo.setMaterialId(materialId);
            provBo.setScreenType(reqBO.getScreenType());
            provBo.setSupNo(reqBO.getSupNo());
            provBo.setCreateTime(new Date());
            provBo.setCreateUser(reqBO.getmName());
            provBo.setCreateUsername(reqBO.getmName());
            provBo.setSupplierBO(reqBO.getSupplierBO());
            provBo.setIsValid("1");
            provBo.setSecurityServicesType(reqBO.getSecurityServicesStatus());
            if (reqBO.getInvoiceTaxRate() == null) {
                if (provBo.getProvinceCode().equals("330000")) {
                    provBo.setInvoiceTaxRate(Double.valueOf(0.06));
                } else {
                    provBo.setInvoiceTaxRate(Double.valueOf(0.13));
                }
            } else {
                provBo.setInvoiceTaxRate(reqBO.getInvoiceTaxRate());
            }
            provGoods.add(provBo);
            BeanUtils.copyProperties((Object)reqBO, (Object)insure);
            try {
                insure.setProvGoodsId(provGoodsId);
                insure.setPurchasePrice(MoneyUtils.BigDecimal2Long(reqBO.getPurchasePriceStr()));
                insure.setPriceHigh(MoneyUtils.BigDecimal2Long(reqBO.getPriceHighStr()));
                insure.setPriceLow(MoneyUtils.BigDecimal2Long(reqBO.getPriceLowStr()));
                insure.setActivityPrice(MoneyUtils.BigDecimal2Long(reqBO.getActivityPriceStr()));
                insure.setSalePrice(MoneyUtils.BigDecimal2Long(reqBO.getSalePriceStr()));
                insure.setLimitPrice(MoneyUtils.BigDecimal2Long(reqBO.getLimitPriceStr()));
                insure.setRealityPrice(MoneyUtils.BigDecimal2Long(reqBO.getRealityPriceStr() == null ? reqBO.getSalePriceStr() : reqBO.getRealityPriceStr()));
            }
            catch (Exception e) {
                logger.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25");
                throw new BusinessException("9999", "\u4ef7\u683c\u8f6c\u6362\u5931\u8d25" + e.getMessage());
            }
            insure.setApplyProvince(reqBO.getApplyProvince());
            insure.setModelGroupType("1");
            insure.setSecurityServicesStatus("01");
            Map<Object, Object> shopMap = new HashMap();
            try {
                shopMap = this.getProvCode(reqBO.getApplyProvince(), reqBO.getmOrgPath());
                for (Map.Entry entry : shopMap.entrySet()) {
                    CreateSkuReqBO bo = new CreateSkuReqBO();
                    Long skuId = Sequence.getInstance().nextId();
                    bo.setSkuId(skuId);
                    bo.setIsVirtualGood("05".equals(reqBO.getSecurityServicesType()) ? "0" : "1");
                    bo.setAssessmentPrice(MoneyUtils.BigDecimal2Long(reqBO.getLimitPriceStr()));
                    bo.setSparePrice1(MoneyUtils.BigDecimal2Long(reqBO.getPurchasePriceStr()));
                    bo.setMemberPrice(MoneyUtils.BigDecimal2Long(reqBO.getActivityPriceStr()));
                    bo.setSaleSrice(MoneyUtils.BigDecimal2Long(reqBO.getRealityPriceStr() == null ? reqBO.getSalePriceStr() : reqBO.getRealityPriceStr()));
                    bo.setSparePrice2(MoneyUtils.BigDecimal2Long(reqBO.getSalePriceStr()));
                    bo.setFullName(reqBO.getGoodsLongName());
                    bo.setProvinceCode(((ProvAndCityCodeBO)entry.getValue()).getProvinceCode());
                    bo.setProvGoodsId(provGoodsId);
                    bo.setCityCode(((ProvAndCityCodeBO)entry.getValue()).getCityCode());
                    bo.setCountyCode(((ProvAndCityCodeBO)entry.getValue()).getCountryCode());
                    bo.setSupplierId(Long.valueOf(Long.parseLong((String)entry.getKey())));
                    bo.setSupplierName(((ProvAndCityCodeBO)entry.getValue()).getShopName());
                    bo.setMaterialId(materialId);
                    bo.setVendorName(StringUtils.isBlank((String)vendorName) ? null : vendorName.substring(0, vendorName.length() - 1));
                    bo.setVendorId(StringUtils.isBlank((String)vendorId) ? null : vendorId.substring(0, vendorId.length() - 1));
                    bo.setName(reqBO.getGoodsLongName());
                    skuList.add(bo);
                }
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5272\u63a5\u95e8\u5e97\u62a5\u9519\u62a5\u9519");
                throw new BusinessException("9999", "\u67e5\u8be2\u5272\u63a5\u95e8\u5e97\u62a5\u9519" + e.getMessage());
            }
            insureList.add(insure);
        }
        AddProvGoodsListReqBO req = new AddProvGoodsListReqBO();
        req.setReqBO(provGoods);
        req.setIsInsure(Boolean.valueOf(true));
        try {
            this.addGoodsByProvCodeService.insureProvCreation(req);
            this.provGoodsInsureServiceDAO.insertList(insureList);
            if (!CollectionUtils.isEmpty(skuList)) {
                this.addSku(skuList);
                try {
                    if (!"05".equals(reqBO.getSecurityServicesType())) {
                        this.createStock(skuList, provBo);
                    }
                }
                catch (Exception e) {
                    logger.debug("\u4fdd\u9669\u5546\u54c1\u5e93\u5b58\u540c\u6b65\u5931\u8d25");
                    logger.debug(e.getMessage());
                }
            }
            if (!CollectionUtils.isEmpty(upProv)) {
                AddProvGoodsListReqBO reqB = new AddProvGoodsListReqBO();
                req.setReqBO(upProv);
                req.setIsInsure(Boolean.valueOf(true));
                this.addGoodsByProvCodeService.updateProv(reqB);
            }
            if (!CollectionUtils.isEmpty(update)) {
                this.provGoodsInsureServiceDAO.updateList(update);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u7701\u4efd\u5546\u54c1\u53ca\u4f9b\u5e94\u5546\u62a5\u9519");
            throw new BusinessException("9999", "\u521b\u5efa\u7701\u4efd\u5546\u54c1\u53ca\u4f9b\u5e94\u5546\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public void addSku(List<CreateSkuReqBO> add) throws Exception {
        int pointsDataLimit = 2000;
        Integer size = add.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u65b0\u589e\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6761\u6267\u884c");
        ExecutorService service = Executors.newFixedThreadPool(9);
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            List<CreateSkuReqBO> rows = add.subList(start, end);
            service.execute(() -> {
                BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
                batchCreateSkuReqBO.setCreateSkuReqBOs(rows);
                this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
            });
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public BaseRspBO updateInsure(ProvGoodsInsureBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        ArrayList<ProvGoodsBO> upProv = new ArrayList<ProvGoodsBO>();
        ArrayList<ProvGoodsBO> insert = new ArrayList<ProvGoodsBO>();
        ArrayList<ProvGoodsInsureServicePO> update = new ArrayList<ProvGoodsInsureServicePO>();
        ArrayList<ProvGoodsInsureServicePO> updateProv = new ArrayList<ProvGoodsInsureServicePO>();
        ArrayList<ProvGoodsInsureServicePO> insertInsure = new ArrayList<ProvGoodsInsureServicePO>();
        ArrayList<String> provCodes = new ArrayList<String>();
        String materialId = reqBO.getMaterialId();
        String vendorName = "";
        String vendorId = "";
        for (SupplierBO su : reqBO.getSupplierBO()) {
            vendorId = vendorId + su.getSupplierId() + ",";
            vendorName = vendorName + su.getSupplierName() + ",";
        }
        if ("1".equals(reqBO.getmUserLevel())) {
            HashMap<String, Long> provGoodsIdMap = new HashMap<String, Long>();
            ProvGoodsInsureServicePO record = new ProvGoodsInsureServicePO();
            record.setMaterialId(reqBO.getMaterialId());
            List<ProvGoodsInsureServicePO> prov = this.provGoodsInsureServiceDAO.selectSelectiveAll(record);
            for (ProvGoodsInsureServicePO insure : prov) {
                if ("0".equals(insure.getModelGroupType())) {
                    logger.debug("\u539f\u9002\u7528\u7701\u4efd" + insure.getApplyProvince());
                    continue;
                }
                provGoodsIdMap.put(insure.getApplyProvince(), insure.getProvGoodsId());
                provCodes.add(insure.getApplyProvince());
            }
            logger.debug("provGoodsIdMap=" + JSONObject.toJSONString(provGoodsIdMap));
            logger.debug("\u603b\u90e8\u4fee\u6539");
            ProvGoodsBO provBo = this.insure2Prov(reqBO, true, null, false, null, false);
            upProv.add(provBo);
            ProvGoodsInsureServicePO insurePO = this.bo2po(reqBO, true, null, null, false);
            update.add(insurePO);
            List<String> willBind = Arrays.asList(reqBO.getApplyProvince().split(","));
            if (CollectionUtils.isEmpty(willBind)) {
                logger.debug("\u5220\u9664\u7701\u4efd=" + provGoodsIdMap);
                if (null != provGoodsIdMap) {
                    provGoodsIdMap.forEach((key, value) -> {
                        ProvGoodsBO provBo1 = this.insure2Prov(reqBO, false, (String)key, false, null, true);
                        upProv.add(provBo1);
                        ProvGoodsInsureServicePO insurePO1 = this.bo2po(reqBO, false, (String)key, (Long)value, true);
                        update.add(insurePO1);
                    });
                }
            } else {
                for (String provinceCode : willBind) {
                    if (provGoodsIdMap.containsKey(provinceCode)) {
                        logger.debug("\u4fee\u6539\u524d\u540e\u90fd\u6709\u7701\u4efd=" + provinceCode);
                        ProvGoodsBO provBo1 = this.insure2Prov(reqBO, false, provinceCode, false, null, false);
                        upProv.add(provBo1);
                        ProvGoodsInsureServicePO insurePO1 = this.bo2po(reqBO, false, provinceCode, (Long)provGoodsIdMap.get(provinceCode), false);
                        insurePO1.setSecurityServicesType(reqBO.getSecurityServicesType());
                        update.add(insurePO1);
                        provGoodsIdMap.remove(provinceCode);
                        continue;
                    }
                    logger.debug("\u65b0\u589e\u7701\u4efd=" + provinceCode);
                    Long provGoodsId = Sequence.getInstance().nextId();
                    ProvGoodsBO provBo1 = this.insure2Prov(reqBO, false, provinceCode, true, provGoodsId, false);
                    provBo1.setSecurityServicesType(reqBO.getSecurityServicesStatus());
                    insert.add(provBo1);
                    ProvGoodsInsureServicePO insurePO1 = this.bo2po(reqBO, false, provinceCode, provGoodsId, false);
                    insurePO1.setSecurityServicesStatus("02");
                    insertInsure.add(insurePO1);
                }
                logger.debug("\u5220\u9664\u7701\u4efd=" + provGoodsIdMap);
                if (null != provGoodsIdMap) {
                    provGoodsIdMap.forEach((key, value) -> {
                        ProvGoodsBO provBo1 = this.insure2Prov(reqBO, false, (String)key, false, null, true);
                        upProv.add(provBo1);
                        ProvGoodsInsureServicePO insurePO1 = this.bo2po(reqBO, false, (String)key, (Long)value, true);
                        update.add(insurePO1);
                    });
                }
            }
        } else {
            logger.debug("\u7701\u4efd\u7f16\u8f91");
            ProvGoodsBO provBo = new ProvGoodsBO();
            ProvGoodsInsureServicePO insurePO = new ProvGoodsInsureServicePO();
            insurePO = this.bo2po(reqBO, false, reqBO.getApplyProvince(), reqBO.getProvGoodsId(), false);
            try {
                insurePO.setRealityPrice(reqBO.getRealityPriceStr() == null ? MoneyUtils.BigDecimal2Long(reqBO.getSalePriceStr()) : MoneyUtils.BigDecimal2Long(reqBO.getRealityPriceStr()));
            }
            catch (Exception e) {
                logger.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25");
                throw new BusinessException("9999", "\u4ef7\u683c\u8f6c\u6362\u5931\u8d25" + e.getMessage());
            }
            provCodes.add(reqBO.getApplyProvince());
            insurePO.setModelGroupType(reqBO.getModelGroupType());
            insurePO.setSecurityServicesStatus(reqBO.getSecurityServicesStatus());
            provBo = this.insure2Prov(reqBO, false, reqBO.getApplyProvince(), false, null, false);
            if (reqBO.getInvoiceTaxRate() == null) {
                if (reqBO.getApplyProvince().equals("330000")) {
                    provBo.setInvoiceTaxRate(Double.valueOf(0.06));
                } else {
                    provBo.setInvoiceTaxRate(Double.valueOf(0.13));
                }
            } else {
                provBo.setInvoiceTaxRate(reqBO.getInvoiceTaxRate());
            }
            updateProv.add(insurePO);
            upProv.add(provBo);
            try {
                this.createSku(reqBO);
            }
            catch (Exception e) {
                logger.debug("\u4fee\u6539\u521b\u5efasku\u5931\u8d25" + e.getMessage());
            }
        }
        try {
            logger.debug("\u4fee\u6539\u5546\u54c1\u4fe1\u606f\u53ca\u4ef7\u683c");
            List<SkuPO> skus = this.xlsSkuMapper.queryXlsSkuByProvCodes(provCodes, materialId);
            ArrayList<PriceBO> priceBOList = new ArrayList<PriceBO>();
            ArrayList skuBOS = new ArrayList();
            for (SkuPO sku : skus) {
                PriceBO price = new PriceBO();
                price.setSkuId(sku.getSkuId());
                if ("2".equals(reqBO.getModelGroupType()) || "0".equals(reqBO.getModelGroupType())) {
                    price.setPurchasePrice(MoneyUtils.BigDecimal2Long(reqBO.getPurchasePriceStr()));
                } else {
                    price.setSparePrice1(MoneyUtils.BigDecimal2Long(reqBO.getPurchasePriceStr()));
                }
                price.setProvinceCode((String)provCodes.get(0));
                price.setMemberPrice(MoneyUtils.BigDecimal2Long(reqBO.getActivityPriceStr()));
                price.setAssessmentPrice(MoneyUtils.BigDecimal2Long(reqBO.getLimitPriceStr()));
                price.setSalePrice(MoneyUtils.BigDecimal2Long(reqBO.getRealityPriceStr()));
                price.setSparePrice2(MoneyUtils.BigDecimal2Long(reqBO.getSalePriceStr()));
                price.setProvinceCode((String)provCodes.get(0));
                priceBOList.add(price);
            }
            DSkuBO skubo = new DSkuBO();
            skubo.setSkuName(reqBO.getGoodsLongName());
            skubo.setSkuPrice(MoneyUtils.BigDecimal2Long(reqBO.getRealityPriceStr()));
            skubo.setVendorName(StringUtils.isBlank((String)vendorName) ? null : vendorName.substring(0, vendorName.length() - 1));
            skubo.setVendorId(StringUtils.isBlank((String)vendorId) ? null : vendorId.substring(0, vendorId.length() - 1));
            skubo.setSkuLongName(reqBO.getGoodsLongName());
            skubo.setMaterialId(materialId);
            skubo.setProvinceCode((String)provCodes.get(0));
            if (skubo != null) {
                long start1 = System.currentTimeMillis();
                this.xlsSkuManageService.batchUpdateSku(skubo);
                long l = System.currentTimeMillis();
            }
            if (!CollectionUtils.isEmpty(priceBOList)) {
                long start = System.currentTimeMillis();
                this.xlsSkuPriceManageService.batchUpdateSkuPrice(priceBOList);
                long l = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539sku\u62a5\u9519");
            throw new BusinessException("9999", "\u4fee\u6539sku\u62a5\u9519" + e.getMessage());
        }
        try {
            AddProvGoodsListReqBO req;
            if (!CollectionUtils.isEmpty(insert)) {
                req = new AddProvGoodsListReqBO();
                req.setIsInsure(Boolean.valueOf(true));
                req.setReqBO(insert);
                this.addGoodsByProvCodeService.insureProvCreation(req);
            }
            if (!CollectionUtils.isEmpty(upProv)) {
                req = new AddProvGoodsListReqBO();
                req.setReqBO(upProv);
                req.setIsInsure(Boolean.valueOf(true));
                this.addGoodsByProvCodeService.updateProv(req);
            }
            if (!CollectionUtils.isEmpty(update)) {
                this.provGoodsInsureServiceDAO.updateList(update);
            }
            if (!CollectionUtils.isEmpty(updateProv)) {
                this.provGoodsInsureServiceDAO.updateProv(updateProv);
            }
            if (!CollectionUtils.isEmpty(insertInsure)) {
                this.provGoodsInsureServiceDAO.insertList(insertInsure);
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u7701\u4efd\u5546\u54c1\u53ca\u4f9b\u5e94\u5546\u62a5\u9519");
            throw new BusinessException("9999", "\u4fee\u6539\u7701\u4efd\u5546\u54c1\u53ca\u4f9b\u5e94\u5546\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public ProvGoodsInsureResBO queryDetail(ProvGoodsInsureBO reqBO) {
        ProvGoodsInsureResBO result = new ProvGoodsInsureResBO();
        ProvGoodsInsureServicePO record = new ProvGoodsInsureServicePO();
        record.setProvGoodsId(reqBO.getProvGoodsId());
        if ("1".equals(reqBO.getmUserLevel())) {
            record.setModelGroupType("0");
        }
        logger.debug("\u67e5\u8be2\u8be6\u60c5");
        List<ProvGoodsInsureServicePO> poList = this.provGoodsInsureServiceDAO.selectSelective(record);
        logger.debug("\u67e5\u8be2\u4f9b\u5e94\u5546");
        List<ProvGoodsSupRelationPO> sup = this.provGoodsSupRelationDAO.selectByProvGoodsId(reqBO.getProvGoodsId());
        if (CollectionUtils.isEmpty(sup) || CollectionUtils.isEmpty(poList)) {
            result.setRespCode("9999");
            result.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            return result;
        }
        if ("1".equals(reqBO.getmUserLevel())) {
            poList.get(0).setInvoiceTaxRate(0.0);
        }
        BeanUtils.copyProperties((Object)poList.get(0), (Object)result);
        Map<String, Map<String, String>> escaMap = this.getEscape();
        String provinceName = "";
        if (StringUtils.isNotEmpty((String)poList.get(0).getApplyProvince())) {
            provinceName = this.getProvinceName(poList.get(0).getApplyProvince());
        }
        result.setApplyProvinceStr(provinceName);
        result.setPurchaseTypeStr(escaMap.get("PURCHASE_TYPE").get(poList.get(0).getPurchaseType()));
        result.setHasSerialNumberStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(poList.get(0).getHasSerialNumber()));
        result.setIsSaleOnlineStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(poList.get(0).getHasSerialNumber()));
        result.setModelGroupTypeStr(escaMap.get("MODEL_GROUP_TYPE").get(poList.get(0).getModelGroupType()));
        if (poList.get(0).getProductClients().equals("01") || poList.get(0).getProductClients().equals("02")) {
            result.setProductClientsStr(escaMap.get("PRODUCT_CLIENTS").get(poList.get(0).getProductClients()));
        } else {
            result.setProductClientsStr(escaMap.get("PRODUCT_CLIENTS_NEW").get(poList.get(0).getProductClients()));
        }
        result.setQualityOfSpareStr(escaMap.get("QUALITY_OF_SPARE").get(poList.get(0).getQualityOfSpare()));
        result.setScreenTypeStr(escaMap.get("SCREEN_TYPE").get(poList.get(0).getScreenType()));
        result.setSecurityServicesStatusStr(escaMap.get("SECURITY_SERVICES_STATUS").get(poList.get(0).getSecurityServicesStatus()));
        result.setSecurityServicesTypeStr(escaMap.get("BUSINESS_TYPE").get(poList.get(0).getSecurityServicesType()));
        if (poList.get(0).getTermOfValidity().equals("01") || poList.get(0).getTermOfValidity().equals("02")) {
            result.setTermOfValidityStr(escaMap.get("TERM_OF_VALIDITY").get(poList.get(0).getTermOfValidity()));
        } else {
            result.setTermOfValidityStr(escaMap.get("TERM_OF_VALIDITY_NEW").get(poList.get(0).getTermOfValidity()));
        }
        try {
            result.setActivityPriceStr(MoneyUtils.Long2BigDecimal(poList.get(0).getActivityPrice()));
            result.setPurchasePriceStr(MoneyUtils.Long2BigDecimal(poList.get(0).getPurchasePrice()));
            result.setPriceHighStr(MoneyUtils.Long2BigDecimal(poList.get(0).getPriceHigh()));
            result.setPriceLowStr(MoneyUtils.Long2BigDecimal(poList.get(0).getPriceLow()));
            result.setSalePriceStr(MoneyUtils.Long2BigDecimal(poList.get(0).getSalePrice()));
            result.setLimitPriceStr(MoneyUtils.Long2BigDecimal(poList.get(0).getLimitPrice()));
            result.setRealityPriceStr(MoneyUtils.Long2BigDecimal(poList.get(0).getRealityPrice()));
        }
        catch (Exception e) {
            logger.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25");
            throw new BusinessException("9999", "\u4ef7\u683c\u8f6c\u6362\u5931\u8d25" + e.getMessage());
        }
        ArrayList<SupplierBO> supplierBO = new ArrayList<SupplierBO>();
        SupplierBO subo = null;
        for (ProvGoodsSupRelationPO su : sup) {
            subo = new SupplierBO();
            subo.setProvinceCode(su.getProvinceCode());
            subo.setSupplierId(su.getSupplierId().toString());
            subo.setSupplierName(su.getSupplierName());
            supplierBO.add(subo);
        }
        result.setSupplierBO(supplierBO);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseRspBO insureGoodsEnableShutDown(ProvGoodsInsureBO reqBO) {
        List<ProvGoodsInsureServicePO> prov;
        ProvGoodsInsureServicePO record;
        BaseRspBO result = new BaseRspBO();
        ArrayList<ProvGoodsInsureServicePO> update = new ArrayList<ProvGoodsInsureServicePO>();
        ArrayList<String> provinceCodes = new ArrayList<String>();
        boolean isHeadUp = false;
        if ("1".equals(reqBO.getmUserLevel())) {
            isHeadUp = true;
            record = new ProvGoodsInsureServicePO();
            record.setMaterialId(reqBO.getMaterialId());
            prov = this.provGoodsInsureServiceDAO.selectSelectiveAll(record);
            if ("02".equals(reqBO.getSecurityServicesStatus())) {
                for (ProvGoodsInsureServicePO insure : prov) {
                    ProvGoodsInsureServicePO po = new ProvGoodsInsureServicePO();
                    po.setSecurityServicesStatus(reqBO.getSecurityServicesStatus());
                    po.setProvGoodsId(insure.getProvGoodsId());
                    update.add(po);
                    if ("0".equals(insure.getModelGroupType())) continue;
                    provinceCodes.add(insure.getProvinceCode());
                }
            } else {
                ProvGoodsInsureServicePO po = new ProvGoodsInsureServicePO();
                po.setSecurityServicesStatus(reqBO.getSecurityServicesStatus());
                po.setProvGoodsId(reqBO.getProvGoodsId());
                update.add(po);
            }
        } else {
            logger.debug("\u7701\u4efd\u542f\u7528\u505c\u7528");
            record = new ProvGoodsInsureServicePO();
            record.setMaterialId(reqBO.getMaterialId());
            record.setModelGroupType("0");
            prov = this.provGoodsInsureServiceDAO.selectSelectiveAllStatus(record);
            if ("01".equals(reqBO.getSecurityServicesStatus())) {
                ProvGoodsInsureServicePO recordpo = new ProvGoodsInsureServicePO();
                recordpo.setMaterialId(reqBO.getMaterialId());
                recordpo.setProvinceCode(reqBO.getmProvince());
                List<ProvGoodsInsureServicePO> provIn = this.provGoodsInsureServiceDAO.selectSelectiveAllStatus(recordpo);
                if (!CollectionUtils.isEmpty(prov) && !"01".equals(prov.get(0).getSecurityServicesStatus())) {
                    isHeadUp = true;
                    result.setRespCode("9999");
                    result.setRespDesc("\u8be5\u4fdd\u9669\u603b\u90e8\u5df2\u505c\u7528");
                    return result;
                }
                ProvGoodsInsureServicePO po = new ProvGoodsInsureServicePO();
                provinceCodes.add(reqBO.getmProvince());
                po.setProvGoodsId(reqBO.getProvGoodsId());
                if (provIn.get(0).getRealityPrice() == null) {
                    po.setRealityPrice(provIn.get(0).getSalePrice());
                }
                po.setSecurityServicesStatus(reqBO.getSecurityServicesStatus());
                update.add(po);
                if (!CollectionUtils.isEmpty(provIn)) {
                    try {
                        this.createSkuShut(reqBO.getmProvince(), provIn, reqBO.getmName(), reqBO.getmOrgPath());
                    }
                    catch (Exception e) {
                        logger.error("\u542f\u7528\u521b\u5efa\u5355\u54c1\u5931\u8d25");
                        throw new BusinessException("9999", "\u542f\u7528\u521b\u5efa\u5355\u54c1\u5931\u8d25" + e.getMessage());
                    }
                }
            } else {
                provinceCodes.add(reqBO.getmProvince());
                ProvGoodsInsureServicePO po = new ProvGoodsInsureServicePO();
                po.setProvGoodsId(reqBO.getProvGoodsId());
                po.setSecurityServicesStatus(reqBO.getSecurityServicesStatus());
                update.add(po);
            }
        }
        SkuPO sku = null;
        if ("02".equals(reqBO.getSecurityServicesStatus())) {
            sku = new SkuPO();
            sku.setProvinceCodes(provinceCodes);
            sku.setMaterialId(reqBO.getMaterialId());
            sku.setIsDelete(Integer.parseInt("1"));
        } else if (!isHeadUp) {
            sku = new SkuPO();
            sku.setProvinceCodes(provinceCodes);
            sku.setMaterialId(reqBO.getMaterialId());
            sku.setIsDelete(Integer.parseInt("0"));
        }
        try {
            if (sku != null) {
                this.xlsSkuMapper.updatePriceByProvAndMAaterial(sku);
            }
            this.provGoodsInsureServiceDAO.updateStatus(update);
        }
        catch (Exception e) {
            logger.error("\u542f\u7528\u505c\u7528\u5931\u8d25");
            throw new BusinessException("9999", "\u542f\u7528\u505c\u7528\u5931\u8d25" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public Map<String, Map<String, String>> getEscape() {
        List escaList = this.sysParamsAtomService.selectAll();
        HashMap<String, Map<String, String>> escaMap = new HashMap<String, Map<String, String>>();
        if (!CollectionUtils.isEmpty((Collection)escaList)) {
            for (SysParamTransBusiBO es : escaList) {
                if (escaMap.containsKey(es.getParentCode())) {
                    ((Map)escaMap.get(es.getParentCode())).put(es.getCode(), es.getCodeTitle());
                    continue;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(es.getCode(), es.getCodeTitle());
                escaMap.put(es.getParentCode(), map);
            }
        }
        return escaMap;
    }

    public void createSkuShut(String provCode, List<ProvGoodsInsureServicePO> provIn, String userName, String orgPath) throws Exception {
        ArrayList<String> provs = new ArrayList<String>();
        provs.add(provCode);
        List<SkuPO> skus = this.xlsSkuMapper.queryXlsSkuByProvCodes(provs, provIn.get(0).getMaterialId());
        HashMap<String, Long> skuMap = new HashMap<String, Long>();
        if (!CollectionUtils.isEmpty(skus)) {
            for (SkuPO sku : skus) {
                if (skuMap.containsKey(sku.getSupplierId() + sku.getMaterialId())) continue;
                skuMap.put(sku.getSupplierId() + sku.getMaterialId(), sku.getSkuId());
            }
        }
        ProvGoodsAndSupplierPO record = new ProvGoodsAndSupplierPO();
        record.setMaterialId(provIn.get(0).getMaterialId());
        record.setProvinceCode(provCode);
        List<ProvGoodsAndSupplierPO> provList = this.provGoodsDAO.queryProvInsureGroup(record);
        ArrayList<DSkuBO> skuBOS = new ArrayList<DSkuBO>();
        ArrayList<CreateSkuReqBO> skuList = new ArrayList<CreateSkuReqBO>();
        Map<Object, Object> shopMap = new HashMap();
        shopMap = this.getProvCode(provCode, orgPath);
        for (Map.Entry<Object, Object> shopId : shopMap.entrySet()) {
            if (skuMap.containsKey((String)shopId.getKey() + provIn.get(0).getMaterialId())) {
                DSkuBO sku = new DSkuBO();
                sku.setSkuId((Long)skuMap.get((String)shopId.getKey() + provIn.get(0).getMaterialId()));
                sku.setProvGoodsId(provList.get(0).getProvGoodsId());
                sku.setIsDelete(Integer.valueOf(Integer.parseInt("0")));
                sku.setSupplierId(Long.valueOf(Long.parseLong((String)shopId.getKey())));
                skuBOS.add(sku);
                continue;
            }
            CreateSkuReqBO bo = new CreateSkuReqBO();
            bo.setSkuId(Long.valueOf(Sequence.getInstance().nextId()));
            bo.setAssessmentPrice(provIn.get(0).getLimitPrice());
            bo.setSparePrice1(provIn.get(0).getPurchasePrice());
            bo.setMemberPrice(provIn.get(0).getActivityPrice());
            bo.setIsVirtualGood("05".equals(provIn.get(0).getSecurityServicesType()) ? "0" : "1");
            bo.setSaleSrice(provIn.get(0).getRealityPrice() == null ? provIn.get(0).getSalePrice() : provIn.get(0).getRealityPrice());
            bo.setSparePrice2(provIn.get(0).getSalePrice());
            bo.setFullName(provIn.get(0).getGoodsLongName());
            bo.setProvinceCode(((ProvAndCityCodeBO)shopId.getValue()).getProvinceCode());
            bo.setProvGoodsId(provList.get(0).getProvGoodsId());
            bo.setCityCode(((ProvAndCityCodeBO)shopId.getValue()).getCityCode());
            bo.setCountyCode(((ProvAndCityCodeBO)shopId.getValue()).getCountryCode());
            bo.setSupplierId(Long.valueOf(Long.parseLong((String)shopId.getKey())));
            bo.setSupplierName(((ProvAndCityCodeBO)shopId.getValue()).getShopName());
            bo.setMaterialId(provIn.get(0).getMaterialId());
            bo.setVendorName(provList.get(0).getSupplierName());
            bo.setVendorId(provList.get(0).getSupplierIds());
            bo.setName(provIn.get(0).getGoodsLongName());
            skuList.add(bo);
        }
        if (!CollectionUtils.isEmpty(skuBOS)) {
            logger.debug("\u4fee\u6539" + skuBOS.size());
            this.xlsSkuManageService.batchUpdate(skuBOS);
        }
        if (!CollectionUtils.isEmpty(skuList)) {
            BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
            batchCreateSkuReqBO.setCreateSkuReqBOs(skuList);
            this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
            try {
                ProvGoodsBO bo = new ProvGoodsBO();
                bo.setProvinceCode(provCode);
                bo.setCreateUser(userName);
                bo.setCreateUsername(userName);
                bo.setMaterialId(provIn.get(0).getMaterialId());
                bo.setGoodsLongName(provIn.get(0).getGoodsLongName());
                ArrayList<SupplierBO> supplierList = new ArrayList<SupplierBO>();
                SupplierBO suppiler = new SupplierBO();
                suppiler.setSupplierId(provList.get(0).getSupplierIds());
                suppiler.setSupplierName(provList.get(0).getSupplierName());
                supplierList.add(suppiler);
                bo.setSupplierBO(supplierList);
                if (!"05".equals(provIn.get(0).getSecurityServicesType())) {
                    this.createStock(skuList, bo);
                }
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
                logger.debug("\u5e93\u5b58\u521b\u5efa\u5931\u8d25");
            }
        }
    }

    public String getProvinceName(String provinceCode) {
        List<String> prov = Arrays.asList(provinceCode.split(","));
        String proName = "";
        for (String str : prov) {
            String key = "AUTHORITY_TYPE_area_code_" + str;
            logger.debug("key" + key);
            Jedis jedis = RedisUtil.getJedis();
            byte[] value = jedis.get(key.getBytes());
            Object provStr = SerializationUtils.deserializeSlightly(value);
            RedisUtil.release(jedis);
            logger.debug("value" + provStr);
            if (provStr == null) continue;
            proName = proName + provStr.toString() + ",";
        }
        return StringUtils.isBlank((String)proName) ? "" : proName.substring(0, proName.length() - 1);
    }

    public Map<String, ProvAndCityCodeBO> getProvCode(String provinceCode, String orgPath) throws Exception {
        HashMap<String, ProvAndCityCodeBO> map = new HashMap<String, ProvAndCityCodeBO>();
        JSONObject param = new JSONObject();
        param.put("queryType", (Object)4);
        param.fluentPut("orgTreePath", (Object)orgPath);
        param.put("isCutoverFlag", (Object)1);
        param.put("isFilteStoreId", (Object)0);
        param.put("allStatus", (Object)1);
        logger.debug(param.toString());
        InvokeInfo invokeInfo = new InvokeInfo("com.ohaotian.authority.organisation.service.SelectOrgTreeService", "selectOrgTree", "com.ohaotian.authority.organisation.bo.SelectOrgTreeReqBO");
        invokeInfo.setVersion(this.hsfVersion);
        invokeInfo.setGroup(this.hsfGroup);
        invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
        invokeInfo.setRegisterType("2");
        JSONObject prov = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString((Object)param), null, (InvokeInfo)invokeInfo);
        logger.debug("\u8fdb\u884c\u6cdb\u5316\u8c03\u7528\u8fd4\u56de\u503c" + prov.size());
        if (!CollectionUtils.isEmpty((Collection)prov.getJSONArray("orgTreeBOList"))) {
            ProvAndCityCodeBO bo = null;
            JSONArray orgTreeBOList = prov.getJSONArray("orgTreeBOList");
            logger.debug("\u67e5\u8be2\u95e8\u5e97\u8fd4\u56de\u6761\u6570=" + orgTreeBOList.size());
            for (int i = 0; i < orgTreeBOList.size(); ++i) {
                JSONObject item = orgTreeBOList.getJSONObject(i);
                if (!StringUtils.isNotEmpty((String)item.getString("storeId"))) continue;
                bo = new ProvAndCityCodeBO();
                bo.setCityCode(item.getString("cityCode"));
                bo.setProvinceCode(item.getString("provinceCode"));
                bo.setShopName(item.getString("orgName"));
                bo.setCountryCode(item.getString("districtCode"));
                map.put(item.getString("storeId"), bo);
            }
        }
        return map;
    }

    public ProvGoodsInsureServicePO bo2po(ProvGoodsInsureBO reqBO, boolean isAll, String provinceCode, Long provGoodsId, boolean isDelete) {
        ProvGoodsInsureServicePO insure = new ProvGoodsInsureServicePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)insure);
        try {
            insure.setSalePrice(reqBO.getSalePriceStr() == null ? null : MoneyUtils.BigDecimal2Long(reqBO.getSalePriceStr()));
            insure.setPurchasePrice(reqBO.getPurchasePriceStr() == null ? null : MoneyUtils.BigDecimal2Long(reqBO.getPurchasePriceStr()));
            insure.setActivityPrice(reqBO.getActivityPriceStr() == null ? null : MoneyUtils.BigDecimal2Long(reqBO.getActivityPriceStr()));
            insure.setPriceHigh(reqBO.getPriceHighStr() == null ? null : MoneyUtils.BigDecimal2Long(reqBO.getPriceHighStr()));
            insure.setPriceLow(reqBO.getPriceLowStr() == null ? null : MoneyUtils.BigDecimal2Long(reqBO.getPriceLowStr()));
            insure.setLimitPrice(reqBO.getLimitPriceStr() == null ? null : MoneyUtils.BigDecimal2Long(reqBO.getLimitPriceStr()));
        }
        catch (Exception e) {
            logger.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25");
            throw new BusinessException("9999", "\u4ef7\u683c\u8f6c\u6362\u5931\u8d25" + e.getMessage());
        }
        if (isAll) {
            insure.setProvGoodsId(reqBO.getProvGoodsId());
            insure.setModelGroupType("0");
            insure.setApplyProvince(reqBO.getApplyProvince());
        } else {
            insure.setProvGoodsId(provGoodsId);
            insure.setModelGroupType("2");
            insure.setApplyProvince(provinceCode);
        }
        if (isDelete) {
            insure.setIsValid("0");
        }
        insure.setSecurityServicesStatus(null);
        insure.setSecurityServicesType(reqBO.getSecurityServicesType());
        return insure;
    }

    public ProvGoodsBO insure2Prov(ProvGoodsInsureBO reqBO, boolean isAll, String provinceCode, boolean addFlag, Long provGoodsId, boolean isDelete) {
        ProvGoodsBO provBo = new ProvGoodsBO();
        if (isAll) {
            provBo.setProvinceCode(null);
            provBo.setProvGoodsId(reqBO.getProvGoodsId());
        } else {
            provBo.setProvinceCode(provinceCode);
            if (addFlag) {
                provBo.setProvGoodsId(provGoodsId);
            } else {
                provBo.setProvGoodsId(null);
            }
        }
        if (isDelete) {
            provBo.setIsValid("0");
        } else {
            provBo.setIsValid("1");
        }
        provBo.setGoodsLongName(reqBO.getGoodsLongName());
        provBo.setGoodsName(reqBO.getGoodsLongName());
        provBo.setMaterialId(reqBO.getMaterialId());
        provBo.setScreenType(reqBO.getScreenType());
        provBo.setSupNo(reqBO.getSupNo());
        provBo.setCreateTime(new Date());
        provBo.setCreateUser(reqBO.getmName());
        provBo.setCreateUsername(reqBO.getmName());
        provBo.setSupplierBO(reqBO.getSupplierBO());
        return provBo;
    }

    public void createSku(ProvGoodsInsureBO reqBO) throws Exception {
        ArrayList<String> provCode = new ArrayList<String>();
        String materialId = reqBO.getMaterialId();
        provCode.add(reqBO.getmProvince());
        List<SkuPO> skus = this.xlsSkuMapper.queryXlsSkuByProvCodes(provCode, materialId);
        HashMap<String, SkuPO> skuMap = new HashMap<String, SkuPO>();
        if (!CollectionUtils.isEmpty(skus)) {
            for (SkuPO sku : skus) {
                if (skuMap.containsKey(sku.getMaterialId() + sku.getSupplierId())) continue;
                skuMap.put(sku.getMaterialId() + sku.getSupplierId(), sku);
            }
        }
        String vendorName = "";
        String vendorId = "";
        for (SupplierBO su : reqBO.getSupplierBO()) {
            vendorId = vendorId + su.getSupplierId() + ",";
            vendorName = vendorName + su.getSupplierName() + ",";
        }
        Map<String, ProvAndCityCodeBO> getShop = this.getProvCode(reqBO.getmProvince(), reqBO.getmOrgPath());
        ArrayList<CreateSkuReqBO> skuList = new ArrayList<CreateSkuReqBO>();
        if (!CollectionUtils.isEmpty(getShop)) {
            for (Map.Entry<String, ProvAndCityCodeBO> shop : getShop.entrySet()) {
                if (skuMap.containsKey(materialId + shop.getKey())) continue;
                CreateSkuReqBO bo = new CreateSkuReqBO();
                bo.setSkuId(Long.valueOf(Sequence.getInstance().nextId()));
                bo.setAssessmentPrice(MoneyUtils.BigDecimal2Long(reqBO.getLimitPriceStr()));
                bo.setSparePrice1(MoneyUtils.BigDecimal2Long(reqBO.getPurchasePriceStr()));
                bo.setMemberPrice(MoneyUtils.BigDecimal2Long(reqBO.getActivityPriceStr()));
                bo.setSparePrice2(MoneyUtils.BigDecimal2Long(reqBO.getSalePriceStr()));
                bo.setSaleSrice(MoneyUtils.BigDecimal2Long(reqBO.getRealityPriceStr()));
                bo.setFullName(reqBO.getGoodsLongName());
                bo.setProvinceCode(shop.getValue().getProvinceCode());
                bo.setProvGoodsId(reqBO.getProvGoodsId());
                bo.setCityCode(shop.getValue().getCityCode());
                bo.setCountyCode(shop.getValue().getCountryCode());
                bo.setSupplierId(Long.valueOf(Long.parseLong(shop.getKey())));
                if ("02".equals(reqBO.getSecurityServicesStatus())) {
                    bo.setIsDelete("1");
                } else {
                    bo.setIsDelete("0");
                }
                bo.setSupplierName(shop.getValue().getShopName());
                bo.setIsVirtualGood("05".equals(reqBO.getSecurityServicesType()) ? "0" : "1");
                bo.setMaterialId(materialId);
                bo.setVendorName(StringUtils.isBlank((String)vendorName) ? null : vendorName.substring(0, vendorName.length() - 1));
                bo.setVendorId(StringUtils.isBlank((String)vendorId) ? null : vendorId.substring(0, vendorId.length() - 1));
                bo.setName(reqBO.getGoodsLongName());
                skuList.add(bo);
            }
        }
        if (!CollectionUtils.isEmpty(skuList)) {
            BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
            logger.debug("\u65b0\u589esku\u6761\u6570" + skuList.size());
            batchCreateSkuReqBO.setCreateSkuReqBOs(skuList);
            this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
            ProvGoodsBO bo = new ProvGoodsBO();
            if (!"05".equals(reqBO.getSecurityServicesType())) {
                bo.setCreateUser(reqBO.getmName());
                bo.setMaterialId(reqBO.getMaterialId());
                bo.setGoodsLongName(reqBO.getGoodsLongName());
                bo.setProvinceCode(reqBO.getmProvince());
                bo.setSupplierBO(reqBO.getSupplierBO());
                try {
                    this.createStock(skuList, bo);
                }
                catch (Exception e) {
                    logger.debug("\u5e93\u5b58\u521b\u5efa\u5931\u8d25" + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    public RspPageBO<ProvGoodsInsureBO> queryInsureHead(ProvGoodsInsureBO reqBO) {
        logger.debug("\u8c03\u7528\u603b\u90e8\u67e5\u8be2\u8be6\u60c5\u67e5\u8be2");
        RspPageBO result = new RspPageBO();
        ArrayList<ProvGoodsInsureBO> rows = new ArrayList<ProvGoodsInsureBO>();
        ProvGoodsInsureServicePO record = new ProvGoodsInsureServicePO();
        record.setModelGroupType(reqBO.getModelGroupType());
        record.setMaterialId(reqBO.getMaterialId());
        Page page = new Page();
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getOffset());
        List<Object> poList = new ArrayList();
        try {
            poList = this.provGoodsInsureServiceDAO.selectSelective(record, (Page<ProvGoodsInsureServicePO>)page);
            if (!CollectionUtils.isEmpty(poList)) {
                Map<String, Map<String, String>> escaMap = this.getEscape();
                ProvGoodsInsureBO bo = null;
                for (ProvGoodsInsureServicePO provGoodsInsureServicePO : poList) {
                    bo = new ProvGoodsInsureBO();
                    BeanUtils.copyProperties((Object)provGoodsInsureServicePO, (Object)bo);
                    String provinceName = "";
                    if (StringUtils.isNotEmpty((String)provGoodsInsureServicePO.getApplyProvince())) {
                        provinceName = this.getProvinceName(provGoodsInsureServicePO.getApplyProvince());
                    }
                    bo.setApplyProvinceStr(provinceName);
                    bo.setPurchaseTypeStr(escaMap.get("PURCHASE_TYPE").get(provGoodsInsureServicePO.getPurchaseType()));
                    bo.setHasSerialNumberStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(provGoodsInsureServicePO.getHasSerialNumber()));
                    bo.setIsSaleOnlineStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(provGoodsInsureServicePO.getHasSerialNumber()));
                    bo.setModelGroupTypeStr(escaMap.get("MODEL_GROUP_TYPE").get(provGoodsInsureServicePO.getModelGroupType()));
                    if (provGoodsInsureServicePO.getProductClients().equals("01") || provGoodsInsureServicePO.getProductClients().equals("02")) {
                        bo.setProductClientsStr(escaMap.get("PRODUCT_CLIENTS").get(provGoodsInsureServicePO.getProductClients()));
                    } else {
                        bo.setProductClientsStr(escaMap.get("PRODUCT_CLIENTS_NEW").get(provGoodsInsureServicePO.getProductClients()));
                    }
                    bo.setQualityOfSpareStr(escaMap.get("QUALITY_OF_SPARE").get(provGoodsInsureServicePO.getQualityOfSpare()));
                    bo.setScreenTypeStr(escaMap.get("SCREEN_TYPE").get(provGoodsInsureServicePO.getScreenType()));
                    bo.setSecurityServicesStatusStr(escaMap.get("SECURITY_SERVICES_STATUS").get(provGoodsInsureServicePO.getSecurityServicesStatus()));
                    bo.setSecurityServicesTypeStr(escaMap.get("BUSINESS_TYPE").get(provGoodsInsureServicePO.getSecurityServicesType()));
                    if (provGoodsInsureServicePO.getTermOfValidity().equals("01") || provGoodsInsureServicePO.getTermOfValidity().equals("02")) {
                        bo.setTermOfValidityStr(escaMap.get("TERM_OF_VALIDITY").get(provGoodsInsureServicePO.getTermOfValidity()));
                    } else {
                        bo.setTermOfValidityStr(escaMap.get("TERM_OF_VALIDITY_NEW").get(provGoodsInsureServicePO.getTermOfValidity()));
                    }
                    bo.setPurchasePriceStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getPurchasePrice()));
                    bo.setActivityPriceStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getActivityPrice()));
                    bo.setPriceHighStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getPriceHigh()));
                    bo.setPriceLowStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getPriceLow()));
                    bo.setSalePriceStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getSalePrice()));
                    bo.setLimitPriceStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getLimitPrice()));
                    bo.setRealityPriceStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getRealityPrice()));
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("9999", "\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        result.setTotal(page.getTotalPages());
        result.setRecordsTotal(page.getTotalCount());
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public RspPageBO<SelectSkuAndSupListRspBO> queryDetailProv(ProvGoodsInsureBO reqBO) {
        RspPageBO result = new RspPageBO();
        ArrayList<SelectSkuAndSupListRspBO> rows = new ArrayList<SelectSkuAndSupListRspBO>();
        logger.debug("\u673a\u578b\u7ec4\u67e5\u7269\u6599");
        DmodelGroupMaterialPO modelRecord = new DmodelGroupMaterialPO();
        modelRecord.setModelGroupId(reqBO.getModelGroupId());
        List<Object> list = new ArrayList();
        if (reqBO.getModelGroupId() != null) {
            list = this.dmodelGroupMaterialDAO.selectGroupMateria(modelRecord);
        }
        ArrayList<String> materialId = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(list)) {
            for (DmodelGroupMaterialPO dmodelGroupMaterialPO : list) {
                materialId.add(dmodelGroupMaterialPO.getMaterialId());
            }
        }
        SkuPO skuRecord = new SkuPO();
        skuRecord.setMaterialIds(materialId);
        skuRecord.setBrandName("\u82f9\u679c");
        skuRecord.setScreenType(reqBO.getScreenType());
        skuRecord.setProvinceCode(reqBO.getmProvince());
        skuRecord.setHasSerialNumber("1");
        try {
            skuRecord.setPriceHigh(reqBO.getPriceHighStr() == null ? null : MoneyUtils.BigDecimalToLong(reqBO.getPriceHighStr()));
            skuRecord.setPriceLow(reqBO.getPriceLowStr() == null ? null : MoneyUtils.BigDecimalToLong(reqBO.getPriceLowStr()));
        }
        catch (Exception exception) {
            logger.debug("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25");
        }
        Page page = new Page();
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getOffset());
        List<Object> skuList = new ArrayList();
        skuList = "01".equals(reqBO.getProductClients()) ? this.xlsSkuMapper.selectSkuByModelIphone(skuRecord, (Page<SkuPO>)page) : this.xlsSkuMapper.selectSkuByModelNotIphone(skuRecord, (Page<SkuPO>)page);
        if (!CollectionUtils.isEmpty(skuList)) {
            for (SkuAndProvPO skuAndProvPO : skuList) {
                SelectSkuAndSupListRspBO bo = new SelectSkuAndSupListRspBO();
                BeanUtils.copyProperties((Object)skuAndProvPO, (Object)bo);
                try {
                    bo.setSkuPriceStr(MoneyUtils.Long2BigDecimal(skuAndProvPO.getSkuPrice()));
                }
                catch (Exception e) {
                    logger.debug("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25");
                }
                rows.add(bo);
            }
        }
        result.setRows(rows);
        result.setTotal(page.getTotalPages());
        result.setRecordsTotal(page.getTotalCount());
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public RspInfoListBO<ProvGoodsInsureByProductCodeSupNoRspBO> queryDetailByProductCodeSupNo(ProvGoodsInsureByProductCodeSupNoBO reqBO) {
        List<ProvGoodsInsureByProductCodeSupNoRspBO> provGoodsInsureByProductCodeSupNoRspBOS;
        RspInfoListBO result = new RspInfoListBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getProductCodeList())) {
            result.setRespCode("8888");
            result.setRespDesc("\u5165\u53c2 \u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a\uff01");
            return result;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSupplierIdList())) {
            result.setRespCode("8888");
            result.setRespDesc("\u5165\u53c2 \u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a\uff01");
            return result;
        }
        Map newMapTermOfValidity = this.sysParamTransferBusiService.sysParamTransferByParentCode("TERM_OF_VALIDITY_NEW");
        try {
            provGoodsInsureByProductCodeSupNoRspBOS = this.provGoodsInsureServiceDAO.selectDetailByProductCodeSupNo(reqBO);
            if (!CollectionUtils.isEmpty(provGoodsInsureByProductCodeSupNoRspBOS)) {
                provGoodsInsureByProductCodeSupNoRspBOS.stream().forEach(provGoodsInsureByProductCodeSupNoRspBO -> provGoodsInsureByProductCodeSupNoRspBO.setTermOfValidityStr((String)newMapTermOfValidity.get(provGoodsInsureByProductCodeSupNoRspBO.getTermOfValidity())));
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u4ea7\u54c1\u7f16\u7801\u548c\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u4fdd\u969c\u670d\u52a1\u8be6\u7ec6  \u67e5\u8be2\u5931\u8d25\uff01");
            throw new BusinessException("\u6839\u636e\u4ea7\u54c1\u7f16\u7801\u548c\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u4fdd\u969c\u670d\u52a1\u8be6\u7ec6  \u67e5\u8be2\u5931\u8d25:", e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(provGoodsInsureByProductCodeSupNoRspBOS);
        return result;
    }

    public RspInfoListBO<ProvGoodsInsureBO> queryInsure(ProvGoodsInsureBO reqBO) {
        RspInfoListBO result = new RspInfoListBO();
        ArrayList<ProvGoodsInsureBO> rows = new ArrayList<ProvGoodsInsureBO>();
        ProvGoodsInsureServicePO record = new ProvGoodsInsureServicePO();
        record.setProvinceCode(StringUtils.isBlank((String)reqBO.getProvinceCode()) ? reqBO.getmProvince() : reqBO.getProvinceCode());
        record.setModelGroupType(reqBO.getModelGroupType());
        record.setSecurityServicesType(reqBO.getSecurityServicesType());
        record.setSecurityServicesStatus(reqBO.getSecurityServicesStatus());
        record.setPurchaseType(reqBO.getPurchaseType());
        record.setSupNo(reqBO.getSupNo());
        record.setQualityOfSpare(reqBO.getQualityOfSpare());
        record.setProductClients(reqBO.getProductClients());
        List<Object> poList = new ArrayList();
        try {
            poList = this.provGoodsInsureServiceDAO.selectSelective(record);
            if (!CollectionUtils.isEmpty(poList)) {
                Map<String, Map<String, String>> escaMap = this.getEscape();
                ProvGoodsInsureBO bo = null;
                for (ProvGoodsInsureServicePO provGoodsInsureServicePO : poList) {
                    bo = new ProvGoodsInsureBO();
                    BeanUtils.copyProperties((Object)provGoodsInsureServicePO, (Object)bo);
                    String provinceName = "";
                    if (StringUtils.isNotEmpty((String)provGoodsInsureServicePO.getApplyProvince())) {
                        provinceName = this.getProvinceName(provGoodsInsureServicePO.getApplyProvince());
                    }
                    bo.setApplyProvinceStr(provinceName);
                    bo.setPurchaseTypeStr(escaMap.get("PURCHASE_TYPE").get(provGoodsInsureServicePO.getPurchaseType()));
                    bo.setHasSerialNumberStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(provGoodsInsureServicePO.getHasSerialNumber()));
                    bo.setIsSaleOnlineStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(provGoodsInsureServicePO.getHasSerialNumber()));
                    bo.setModelGroupTypeStr(escaMap.get("MODEL_GROUP_TYPE").get(provGoodsInsureServicePO.getModelGroupType()));
                    if (provGoodsInsureServicePO.getProductClients().equals("01") || provGoodsInsureServicePO.getProductClients().equals("02")) {
                        bo.setProductClientsStr(escaMap.get("PRODUCT_CLIENTS").get(provGoodsInsureServicePO.getProductClients()));
                    } else {
                        bo.setProductClientsStr(escaMap.get("PRODUCT_CLIENTS_NEW").get(provGoodsInsureServicePO.getProductClients()));
                    }
                    bo.setQualityOfSpareStr(escaMap.get("QUALITY_OF_SPARE").get(provGoodsInsureServicePO.getQualityOfSpare()));
                    bo.setScreenTypeStr(escaMap.get("SCREEN_TYPE").get(provGoodsInsureServicePO.getScreenType()));
                    bo.setSecurityServicesStatusStr(escaMap.get("SECURITY_SERVICES_STATUS").get(provGoodsInsureServicePO.getSecurityServicesStatus()));
                    bo.setSecurityServicesTypeStr(escaMap.get("BUSINESS_TYPE").get(provGoodsInsureServicePO.getSecurityServicesType()));
                    if (provGoodsInsureServicePO.getTermOfValidity().equals("01") || provGoodsInsureServicePO.getTermOfValidity().equals("02")) {
                        bo.setTermOfValidityStr(escaMap.get("TERM_OF_VALIDITY").get(provGoodsInsureServicePO.getTermOfValidity()));
                    } else {
                        bo.setTermOfValidityStr(escaMap.get("TERM_OF_VALIDITY_NEW").get(provGoodsInsureServicePO.getTermOfValidity()));
                    }
                    bo.setPurchasePriceStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getPurchasePrice()));
                    bo.setActivityPriceStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getActivityPrice()));
                    bo.setPriceRange(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getPriceLow()) + "-" + MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getPriceHigh()));
                    bo.setPriceHighStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getPriceHigh()));
                    bo.setPriceLowStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getPriceLow()));
                    bo.setSalePriceStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getSalePrice()));
                    bo.setLimitPriceStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getLimitPrice()));
                    bo.setRealityPriceStr(MoneyUtils.Long2BigDecimal(provGoodsInsureServicePO.getRealityPrice()));
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4fdd\u969c\u670d\u52a1\u67e5\u8be2\u63a5\u53e3\u62a5\u9519");
            throw new BusinessException("9999", "\u8c03\u7528\u4fdd\u969c\u670d\u52a1\u67e5\u8be2\u63a5\u53e3\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public void createStock(List<CreateSkuReqBO> skuList, ProvGoodsBO prov) throws Exception {
        JSONObject smcCreateSkuStockAbilityReqBO = new JSONObject();
        smcCreateSkuStockAbilityReqBO.put("mName", (Object)prov.getCreateUser());
        JSONObject smcProvGoodsInfoBO = new JSONObject();
        smcProvGoodsInfoBO.put("materialCode", (Object)prov.getMaterialId());
        smcProvGoodsInfoBO.put("provId", (Object)prov.getProvinceCode());
        smcProvGoodsInfoBO.put("imsiFlag", (Object)"0");
        smcProvGoodsInfoBO.put("negativeFlag", (Object)"1");
        smcProvGoodsInfoBO.put("state", (Object)"1");
        smcProvGoodsInfoBO.put("goodsName", (Object)prov.getGoodsLongName());
        smcProvGoodsInfoBO.put("reserve1", (Object)((SupplierBO)prov.getSupplierBO().get(0)).getSupplierId());
        smcProvGoodsInfoBO.put("reserve2", (Object)((SupplierBO)prov.getSupplierBO().get(0)).getSupplierName());
        JSONArray skuShopList = new JSONArray();
        for (CreateSkuReqBO sku : skuList) {
            JSONObject stock = new JSONObject();
            stock.put("skuId", (Object)sku.getSkuId().toString());
            stock.put("shopId", (Object)sku.getSupplierId().toString());
            skuShopList.add((Object)stock);
        }
        smcCreateSkuStockAbilityReqBO.put("smcProvGoodsInfoBO", (Object)smcProvGoodsInfoBO);
        smcCreateSkuStockAbilityReqBO.put("skuShopList", (Object)skuShopList);
        ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
        CreateStockThread createStockThread = new CreateStockThread(smcCreateSkuStockAbilityReqBO, this.hsfVersion, this.hsfGroup, this.hsfClientTimeout);
        logger.debug("\u5f00\u542f\u5f02\u6b65\u7ebf\u7a0b");
        cachedThreadPool.execute(createStockThread);
        cachedThreadPool.shutdown();
    }
}

