/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.atom.SysParamsAtomService;
import com.tydic.newretail.bo.AddProvGoodsListReqBO;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.DSkuBO;
import com.tydic.newretail.bo.PriceBO;
import com.tydic.newretail.bo.ProvGoodsBO;
import com.tydic.newretail.bo.ProvGoodsInterestsBO;
import com.tydic.newretail.bo.RspInfoListBO;
import com.tydic.newretail.bo.RspPageBO;
import com.tydic.newretail.bo.SupplierBO;
import com.tydic.newretail.busi.service.AddGoodsByProvCodeService;
import com.tydic.newretail.busi.service.BatchCreateSkuService;
import com.tydic.newretail.busi.service.ProvGoodsInterestsService;
import com.tydic.newretail.busi.service.XlsSkuManageService;
import com.tydic.newretail.busi.service.XlsSkuPriceManageService;
import com.tydic.newretail.dao.ProvDoodsInterestsDAO;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.po.ProvDoodsInterestsPO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.thread.InterestsSkuCreateThread;
import com.tydic.newretail.toolkit.util.TkHttpRequestUtils;
import com.tydic.newretail.util.MoneyUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProvGoodsInterestsServiceImpl
implements ProvGoodsInterestsService {
    private static final Logger logger = LoggerFactory.getLogger(ProvGoodsInterestsServiceImpl.class);
    @Autowired
    private AddGoodsByProvCodeService addGoodsByProvCodeService;
    @Autowired
    private ProvDoodsInterestsDAO provDoodsInterestsDAO;
    @Autowired
    private BatchCreateSkuService batchCreateSkuService;
    @Autowired
    private SkuDAO xlsSkuMapper;
    @Autowired
    private XlsSkuManageService xlsSkuManageService;
    @Autowired
    private XlsSkuPriceManageService xlsSkuPriceManageService;
    @Autowired
    SysParamsAtomService sysParamsAtomService;
    @Value(value="${hsf.version}")
    private String hsfVersion;
    @Value(value="${hsf.group}")
    private String hsfGroup;
    @Value(value="${hsf.clientTimeout}")
    private String hsfClientTimeout;
    @Value(value="${INTERESTS_STORE}")
    private String storesDetail;
    @Value(value="${synchronization}")
    private String synchronizationUrl;

    public BaseRspBO interestsGoodsAdd(ProvGoodsInterestsBO reqBO) {
        List<String> stores = Arrays.asList(this.storesDetail.split(","));
        reqBO.setmProvince(stores.get(0));
        logger.debug("\u8c03\u7528\u6743\u76ca\u5546\u54c1\u521b\u5efa\u63a5\u53e3");
        BaseRspBO result = new BaseRspBO();
        String back = this.checkParam(reqBO);
        if (!StringUtils.isBlank((String)back)) {
            result.setRespCode("9999");
            result.setRespDesc(back);
            return result;
        }
        String materialId = "INTERESTS" + Sequence.getInstance().nextId();
        Long provGoodsId = Sequence.getInstance().nextId();
        reqBO.setMaterialId(materialId);
        reqBO.setProvGoodsId(provGoodsId);
        try {
            logger.debug("\u521b\u5efa\u7701\u4efd\u5546\u54c1\u53ca\u4f9b\u5e94\u5546");
            this.createAndUpdateProvGoods(reqBO, true);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new BusinessException("9999", "\u521b\u5efa\u7701\u4efd\u5546\u54c1\u53ca\u4f9b\u5e94\u5546\u62a5\u9519" + e.getMessage());
        }
        try {
            this.createUpdateInterests(reqBO, true);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new BusinessException("9999", "\u521b\u5efa\u6743\u76ca\u5546\u54c1" + e.getMessage());
        }
        try {
            this.synchronization(reqBO, 1);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new BusinessException("9999", "\u540c\u6b65\u5230ECSS\u5546\u54c1\u5931\u8d25" + e.getMessage());
        }
        try {
            this.createSku(reqBO);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new BusinessException("9999", "\u521b\u5efasku\u5931\u8d25" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public BaseRspBO interestsGoodsUpdate(ProvGoodsInterestsBO reqBO) {
        List<String> stores = Arrays.asList(this.storesDetail.split(","));
        reqBO.setmProvince(stores.get(0));
        BaseRspBO result = new BaseRspBO();
        logger.debug("\u66f4\u65b0\u7701\u4efd\u5546\u54c1");
        String back = this.checkParam(reqBO);
        if (!StringUtils.isBlank((String)back)) {
            result.setRespCode("9999");
            result.setRespDesc(back);
            return result;
        }
        try {
            logger.debug("\u4fee\u6539\u7701\u4efd\u5546\u54c1\u53ca\u4f9b\u5e94\u5546");
            this.createAndUpdateProvGoods(reqBO, false);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new BusinessException("9999", "\u4fee\u6539\u7701\u4efd\u5546\u54c1\u53ca\u4f9b\u5e94\u5546\u62a5\u9519" + e.getMessage());
        }
        try {
            this.createUpdateInterests(reqBO, false);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new BusinessException("9999", "\u4fee\u6539\u6743\u76ca\u5546\u54c1" + e.getMessage());
        }
        try {
            this.synchronization(reqBO, 2);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new BusinessException("9999", "\u540c\u6b65\u5230ECSS\u5546\u54c1\u5931\u8d25" + e.getMessage());
        }
        try {
            this.updateSkuDetail(reqBO);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new BusinessException("9999", "\u4fee\u6539sku\u5546\u54c1\u5931\u8d25" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public RspPageBO<ProvGoodsInterestsBO> getInterestsByPage(ProvGoodsInterestsBO reqBO) {
        RspPageBO result = new RspPageBO();
        List<String> stores = Arrays.asList(this.storesDetail.split(","));
        ArrayList<ProvGoodsInterestsBO> rows = new ArrayList<ProvGoodsInterestsBO>();
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getCurrent());
        ProvDoodsInterestsPO record = new ProvDoodsInterestsPO();
        record.setGoodsLongName(reqBO.getGoodsName());
        record.setProvinceCode(stores.get(0));
        record.setInterestsStatus(reqBO.getInterestsStatus());
        record.setProvGoodsId(reqBO.getProvGoodsId());
        record.setInterestsType(reqBO.getInterestsType());
        List<Object> poList = new ArrayList();
        try {
            poList = this.provDoodsInterestsDAO.selectByCondition(record, (Page<ProvDoodsInterestsPO>)page);
            Map interestsStatusMap = this.sysParamsAtomService.selectByParentCode("INTERESTS_STATUS");
            if (!CollectionUtils.isEmpty(poList)) {
                ProvGoodsInterestsBO bo = null;
                for (ProvDoodsInterestsPO provDoodsInterestsPO : poList) {
                    bo = new ProvGoodsInterestsBO();
                    BeanUtils.copyProperties((Object)provDoodsInterestsPO, (Object)bo);
                    bo.setGoodsName(provDoodsInterestsPO.getGoodsLongName());
                    bo.setLimitPriceStr(MoneyUtils.Long2BigDecimal(provDoodsInterestsPO.getLimitPrice()));
                    bo.setPurchasePriceStr(MoneyUtils.Long2BigDecimal(provDoodsInterestsPO.getPurchasePrice()));
                    bo.setRealityPriceStr(MoneyUtils.Long2BigDecimal(provDoodsInterestsPO.getRealityPrice()));
                    bo.setInterestsStatusStr((String)interestsStatusMap.get(bo.getInterestsStatus()));
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new BusinessException("9999", "\u6761\u4ef6\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public RspInfoListBO<DSkuBO> queryInterestsSku(ProvGoodsInterestsBO reqBO) {
        logger.debug("\u67e5\u8be2\u63a5\u53e3\u8c03\u7528");
        List<String> stores = Arrays.asList(this.storesDetail.split(","));
        reqBO.setmProvince(stores.get(0));
        logger.debug("\u7701\u4efd\u7f16\u7801\uff1a" + stores.get(0));
        RspInfoListBO result = new RspInfoListBO();
        ArrayList<DSkuBO> rows = new ArrayList<DSkuBO>();
        if (CollectionUtils.isEmpty((Collection)reqBO.getSupplierIds()) || CollectionUtils.isEmpty((Collection)reqBO.getProductCodes())) {
            result.setRespCode("9999");
            result.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            result.setRows(rows);
            return result;
        }
        List<ProvDoodsInterestsPO> interList = this.provDoodsInterestsDAO.selectByProductCode(reqBO.getProductCodes());
        if (CollectionUtils.isEmpty(interList)) {
            result.setRespCode("9999");
            result.setRespDesc("\u67e5\u8be2\u4e3a\u7a7a");
            result.setRows(rows);
            return result;
        }
        HashMap<Long, String> provIdAndProductCode = new HashMap<Long, String>();
        for (ProvDoodsInterestsPO provDoodsInterestsPO : interList) {
            provIdAndProductCode.put(provDoodsInterestsPO.getProvGoodsId(), provDoodsInterestsPO.getProductCode());
        }
        ArrayList<Long> provGoodsIds = new ArrayList<Long>();
        for (ProvDoodsInterestsPO in : interList) {
            provGoodsIds.add(in.getProvGoodsId());
        }
        List<SkuPO> list = this.xlsSkuMapper.selectSkuByProvGoodsAndSuppiler(provGoodsIds, reqBO.getSupplierIds());
        if (!CollectionUtils.isEmpty(list)) {
            DSkuBO bo = null;
            for (SkuPO sku : list) {
                bo = new DSkuBO();
                BeanUtils.copyProperties((Object)sku, (Object)bo);
                bo.setProductCode((String)provIdAndProductCode.get(sku.getProvGoodsId()));
                rows.add(bo);
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public BaseRspBO interestsShown(ProvGoodsInterestsBO reqBO) {
        List<String> stores = Arrays.asList(this.storesDetail.split(","));
        reqBO.setmProvince(stores.get(0));
        BaseRspBO result = new BaseRspBO();
        Boolean flag = true;
        if ("01".equals(reqBO.getInterestsStatus())) {
            flag = false;
        }
        try {
            logger.debug("\u4fee\u6539\u72b6\u6001");
            this.createUpdateInterests(reqBO, false);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new BusinessException("9999", "\u4fee\u6539\u72b6\u6001\u5931\u8d25" + e.getMessage());
        }
        try {
            logger.debug("\u540c\u6b65\u5546\u54c1\u4fe1\u606f");
            if (flag.booleanValue()) {
                this.synchronization(reqBO, 3);
            } else {
                this.synchronization(reqBO, 1);
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new BusinessException("9999", "\u540c\u6b65\u5546\u54c1\u4fe1\u606f\u5931\u8d25" + e.getMessage());
        }
        try {
            logger.debug("\u4fee\u6539\u5546\u54c1\u72b6\u6001");
            this.updateSkuStatus(reqBO.getProvGoodsId(), flag);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new BusinessException("9999", "\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public void updateSkuDetail(ProvGoodsInterestsBO reqBO) throws Exception {
        logger.debug("\u4fee\u6539\u5546\u54c1\u4fe1\u606f\u53ca\u4ef7\u683c");
        ArrayList<String> provCodes = new ArrayList<String>();
        provCodes.add(reqBO.getmProvince());
        List<SkuPO> skus = this.xlsSkuMapper.queryXlsSkuByProvCodes(provCodes, reqBO.getMaterialId());
        ArrayList<PriceBO> priceBOList = new ArrayList<PriceBO>();
        ArrayList<DSkuBO> skuBOS = new ArrayList<DSkuBO>();
        String vendorName = "";
        String vendorId = "";
        for (SupplierBO su : reqBO.getSupplierBO()) {
            vendorId = vendorId + su.getSupplierId() + ",";
            vendorName = vendorName + su.getSupplierName() + ",";
        }
        for (SkuPO sku : skus) {
            DSkuBO skubo = new DSkuBO();
            PriceBO price = new PriceBO();
            price.setSkuId(sku.getSkuId());
            price.setPurchasePrice(MoneyUtils.BigDecimal2Long(reqBO.getPurchasePriceStr()));
            price.setAssessmentPrice(MoneyUtils.BigDecimal2Long(reqBO.getLimitPriceStr()));
            price.setSalePrice(MoneyUtils.BigDecimal2Long(reqBO.getRealityPriceStr()));
            price.setProvinceCode((String)provCodes.get(0));
            skubo.setSkuName(reqBO.getGoodsName());
            skubo.setSkuPrice(MoneyUtils.BigDecimal2Long(reqBO.getRealityPriceStr()));
            skubo.setVendorName(StringUtils.isBlank((String)vendorName) ? null : vendorName.substring(0, vendorName.length() - 1));
            skubo.setVendorId(StringUtils.isBlank((String)vendorId) ? null : vendorId.substring(0, vendorId.length() - 1));
            skubo.setSkuLongName(reqBO.getGoodsName());
            skubo.setSkuId(sku.getSkuId());
            skubo.setSupplierId(sku.getSupplierId());
            skubo.setProvinceCode(reqBO.getmProvince());
            priceBOList.add(price);
            skuBOS.add(skubo);
        }
        if (!CollectionUtils.isEmpty(skuBOS)) {
            this.xlsSkuManageService.batchUpdate(skuBOS);
        }
        if (!CollectionUtils.isEmpty(priceBOList)) {
            this.xlsSkuPriceManageService.batchUpdateSkuPrice(priceBOList);
        }
    }

    public void updateSkuStatus(Long provGoodsId, Boolean isDown) throws Exception {
        SkuPO sku = new SkuPO();
        sku.setProvGoodsId(provGoodsId);
        if (isDown.booleanValue()) {
            sku.setIsDelete(Integer.parseInt("1"));
        } else {
            sku.setIsDelete(Integer.parseInt("0"));
        }
        this.xlsSkuMapper.updatePriceByProvAndMAaterial(sku);
    }

    public void createUpdateInterests(ProvGoodsInterestsBO reqBO, Boolean flag) throws Exception {
        ProvDoodsInterestsPO record = new ProvDoodsInterestsPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setPurchasePrice(MoneyUtils.BigDecimal2Long(reqBO.getPurchasePriceStr()));
        record.setRealityPrice(MoneyUtils.BigDecimal2Long(reqBO.getRealityPriceStr()));
        record.setLimitPrice(MoneyUtils.BigDecimal2Long(reqBO.getLimitPriceStr()));
        if (flag.booleanValue()) {
            record.setCreateTime(new Date());
            this.provDoodsInterestsDAO.insertSelective(record);
        } else {
            record.setUpdateTime(new Date());
            this.provDoodsInterestsDAO.updateByProvGoodsId(record);
        }
    }

    public void createAndUpdateProvGoods(ProvGoodsInterestsBO reqBO, Boolean flag) throws Exception {
        ArrayList<ProvGoodsBO> provGoods = new ArrayList<ProvGoodsBO>();
        List<String> stores = Arrays.asList(this.storesDetail.split(","));
        ProvGoodsBO provBo = new ProvGoodsBO();
        logger.debug("\u7701\u4efd");
        provBo.setProvinceCode(stores.get(0));
        provBo.setProvGoodsId(reqBO.getProvGoodsId());
        provBo.setGoodsLongName(reqBO.getGoodsName());
        provBo.setGoodsName(reqBO.getGoodsName());
        provBo.setMaterialId(reqBO.getMaterialId());
        String supNo = "";
        for (SupplierBO supplier : reqBO.getSupplierBO()) {
            supNo = supplier.getSupplierName() + ",";
        }
        provBo.setSupNo(supNo.substring(0, supNo.length() - 1));
        provBo.setCreateTime(new Date());
        provBo.setCreateUser(reqBO.getmName());
        provBo.setCreateUsername(reqBO.getmName());
        provBo.setSupplierBO(reqBO.getSupplierBO());
        provBo.setIsValid("1");
        provGoods.add(provBo);
        AddProvGoodsListReqBO req = new AddProvGoodsListReqBO();
        req.setReqBO(provGoods);
        req.setIsInsure(Boolean.valueOf(false));
        if (flag.booleanValue()) {
            this.addGoodsByProvCodeService.insureProvCreation(req);
        } else {
            this.addGoodsByProvCodeService.updateProv(req);
        }
    }

    public String checkParam(ProvGoodsInterestsBO reqBO) {
        String back = null;
        if (CollectionUtils.isEmpty((Collection)reqBO.getSupplierBO())) {
            return "\u4f9b\u5e94\u5546\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)reqBO.getInterestsType())) {
            return "\u6743\u76ca\u7c7b\u578b\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)reqBO.getRelatedCommodityCode())) {
            return "\u5173\u8054\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)reqBO.getProductCode())) {
            return "\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a";
        }
        if (reqBO.getLimitPriceStr() == null) {
            return "\u6700\u4f4e\u9650\u4ef7\u4e3a\u7a7a";
        }
        if (reqBO.getRealityPriceStr() == null) {
            return "\u5efa\u8bae\u96f6\u552e\u4ef7\u552e\u683c\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)reqBO.getGoodsName())) {
            return "\u4ea7\u54c1\u540d\u79f0\u4e3a\u7a7a";
        }
        return back;
    }

    public void createSku(ProvGoodsInterestsBO reqBO) throws Exception {
        List<String> stores = Arrays.asList(this.storesDetail.split(","));
        reqBO.setmProvince(stores.get(0));
        logger.debug(stores.toString());
        JSONObject store = new JSONObject();
        store.put("provinceCode", (Object)stores.get(0));
        store.put("cityCode", (Object)stores.get(1));
        store.put("districtCode", (Object)stores.get(2));
        store.put("orgName", (Object)stores.get(4));
        store.put("storeId", (Object)stores.get(3));
        JSONArray orgTreeBOList = new JSONArray();
        orgTreeBOList.add((Object)store);
        logger.debug("\u67e5\u8be2\u95e8\u5e97\u8fd4\u56de\u6761\u6570=" + orgTreeBOList.size());
        ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
        InterestsSkuCreateThread InterestsSkuCreateThread2 = new InterestsSkuCreateThread(orgTreeBOList, reqBO, this.batchCreateSkuService, this.hsfVersion, this.hsfGroup, this.hsfClientTimeout);
        logger.debug("\u5f00\u542f\u5f02\u6b65\u7ebf\u7a0b");
        cachedThreadPool.execute(InterestsSkuCreateThread2);
        cachedThreadPool.shutdown();
    }

    public void synchronization(ProvGoodsInterestsBO reqBO, Integer cgType) throws Exception {
        JSONObject param = new JSONObject();
        JSONObject spInfo = new JSONObject();
        spInfo.put("goodsId", (Object)reqBO.getProductCode());
        spInfo.put("goodsTitle", (Object)reqBO.getGoodsName());
        spInfo.put("corGoodsId", (Object)reqBO.getRelatedCommodityCode());
        if (StringUtils.isNotEmpty((String)reqBO.getSupNo())) {
            spInfo.put("supplier", (Object)reqBO.getSupNo());
        } else {
            String supplier = "";
            for (SupplierBO su : reqBO.getSupplierBO()) {
                supplier = supplier + su.getSupplierName() + ",";
            }
            spInfo.put("supplier", (Object)supplier.substring(0, supplier.length() - 1));
        }
        switch (reqBO.getInterestsType()) {
            case "01": {
                spInfo.put("type", (Object)"0");
                break;
            }
            case "02": {
                spInfo.put("type", (Object)"2");
                break;
            }
            case "03": {
                spInfo.put("type", (Object)"1");
            }
        }
        spInfo.put("retailPrice", (Object)MoneyUtils.BigDecimal2Long(reqBO.getRealityPriceStr()));
        spInfo.put("purchasePrice", (Object)MoneyUtils.BigDecimal2Long(reqBO.getPurchasePriceStr()));
        spInfo.put("bottomPprice", (Object)MoneyUtils.BigDecimal2Long(reqBO.getLimitPriceStr()));
        param.put("operID", (Object)Sequence.getInstance().nextId());
        param.put("czType", (Object)cgType);
        param.put("spInfo", (Object)spInfo);
        logger.debug("\u5165\u53c2" + param);
        String comeBack = TkHttpRequestUtils.conn(null, (String)param.toString(), null, (String)this.synchronizationUrl, null, null);
        ProvDoodsInterestsPO record = new ProvDoodsInterestsPO();
        record.setProvGoodsId(reqBO.getProvGoodsId());
        record.setSynchronizationResult(comeBack);
        this.provDoodsInterestsDAO.updateByProvGoodsId(record);
        logger.debug("\u540c\u6b65\u6743\u76ca\u5546\u54c1\u4fe1\u606f\u8fd4\u56de\uff1a" + comeBack);
    }
}

