/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.DSkuBO;
import com.tydic.newretail.bo.ProvGoodsBO;
import com.tydic.newretail.bo.SupplierBO;
import com.tydic.newretail.busi.service.ProvUpdateService;
import com.tydic.newretail.busi.service.XlsSkuManageService;
import com.tydic.newretail.constant.SysParamConstant;
import com.tydic.newretail.dao.ProvGoodsDAO;
import com.tydic.newretail.dao.ProvGoodsSupRelationDAO;
import com.tydic.newretail.dao.po.ProvGoodsPO;
import com.tydic.newretail.dao.po.ProvGoodsSupRelationPO;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProvUpdateServiceImpl
implements ProvUpdateService {
    private static final Logger logger = LoggerFactory.getLogger(ProvUpdateServiceImpl.class);
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Autowired
    private XlsSkuManageService xlsSkuManageService;
    @Autowired
    private ProvGoodsSupRelationDAO provGoodsSupRelationDAO;

    public BaseRspBO newProvUpdate(ProvGoodsBO reqBO) {
        ProvGoodsPO provPO;
        BaseRspBO result = new BaseRspBO();
        if (reqBO.getProvGoodsId() == null) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        logger.debug("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u72b6\u6001");
        try {
            provPO = this.provGoodsDAO.selectByPrimaryKey(reqBO.getProvGoodsId());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u72b6\u6001\u62a5\u9519" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        logger.debug("\u66f4\u65b0\u7701\u4efd\u5546\u54c1" + JSON.toJSONString((Object)reqBO));
        try {
            ProvGoodsPO record = new ProvGoodsPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)record);
            record.setProvDescribe(reqBO.getDescribe());
            if ("01".equals(provPO.getGoodsSource())) {
                record.setMaterialId(null);
                record.setVersionName(null);
                record.setGoodsType(null);
                record.setGoodsSource(null);
                record.setUpdateTime(new Date());
            }
            record.setUpdateTime(new Date());
            if (StringUtils.isNotEmpty((String)reqBO.getBossCode())) {
                record.setBossCode("," + reqBO.getBossCode() + ",");
            }
            if (record.getInvoiceTaxRate() == null) {
                record.setInvoiceTaxRate(SysParamConstant.INVOICE_TAX_RATE_DEFAULT);
            }
            this.provGoodsDAO.updateByprovGoodsId(record);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u7701\u4efd\u5546\u54c1\u62a5\u9519" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        try {
            final DSkuBO updateSku = this.toUpdateSku(reqBO);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ProvUpdateServiceImpl.this.xlsSkuManageService.batchUpdateSku(updateSku);
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0sku\u62a5\u9519---\u7701\u4efd\u7f16\u7801\u4e3a\u7a7a\u6216\u7269\u6599\u7f16\u7801\u4e3a\u7a7a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        ArrayList<Long> provId = new ArrayList<Long>();
        provId.add(reqBO.getProvGoodsId());
        try {
            ArrayList<ProvGoodsSupRelationPO> relationPO = new ArrayList<ProvGoodsSupRelationPO>();
            for (SupplierBO subo : reqBO.getSupplierBO()) {
                ProvGoodsSupRelationPO po = new ProvGoodsSupRelationPO();
                po.setProvGoodsId(reqBO.getProvGoodsId());
                po.setProvinceCode(subo.getProvinceCode());
                po.setSupplierId(Long.parseLong(subo.getSupplierId()));
                po.setCreateTime(new Date());
                po.setSupplierName(subo.getSupplierName());
                relationPO.add(po);
            }
            this.provGoodsSupRelationDAO.deleteByProvId(provId);
            if (CollectionUtils.isEmpty(relationPO)) {
                logger.error("\u521b\u5efa\u7701\u4efd\u5546\u54c1\u4e0e\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868  \u5165\u53c2\u4e3a\u7a7a");
                result.setRespCode("8888");
                result.setRespDesc("\u521b\u5efa\u7701\u4efd\u5546\u54c1\u4e0e\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868  \u5165\u53c2\u4e3a\u7a7a");
                return result;
            }
            this.provGoodsSupRelationDAO.insertList(relationPO);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u7701\u4efd\u5546\u54c1\u4e0e\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868\u62a5\u9519" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u66f4\u65b0\u7701\u4efd\u5546\u54c1\u6210\u529f");
        return result;
    }

    public DSkuBO toUpdateSku(ProvGoodsBO bo) {
        DSkuBO skuBO = new DSkuBO();
        skuBO.setBrandId(bo.getBrandId());
        skuBO.setBrandName(bo.getBrandName());
        skuBO.setColor(bo.getColorName());
        skuBO.setBrand(bo.getBrandName());
        skuBO.setGoodsSource(bo.getGoodsSource());
        String venId = "";
        for (SupplierBO su : bo.getSupplierBO()) {
            venId = venId + su.getSupplierId() + ",";
        }
        skuBO.setModel(bo.getGoodsModel());
        skuBO.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
        skuBO.setVendorName(bo.getSupNo());
        skuBO.setRam(bo.getMemoryName());
        skuBO.setProvinceCode(bo.getProvinceCode());
        skuBO.setCgType(bo.getCgType());
        skuBO.setCityCode(null);
        skuBO.setExtSkuId(bo.getExtGoodsNo());
        skuBO.setSkuCode(bo.getGoodsNo());
        skuBO.setSkuName(bo.getGoodsLongName());
        skuBO.setSkuLongName(bo.getGoodsLongName());
        skuBO.setErpLongName(bo.getGoodsLongName());
        skuBO.setSkuPriceTagName(bo.getGoodsLongName());
        skuBO.setCountyCode(null);
        skuBO.setMfgSku(bo.getGoodsModel());
        skuBO.setIsVirtualGood(bo.getAllowNegativeStock());
        skuBO.setProvGoodsId(null);
        if ("03".equals(bo.getGoodsStatus())) {
            skuBO.setIsDelete(Integer.valueOf(0));
        } else if ("04".equals(bo.getGoodsStatus())) {
            skuBO.setIsDelete(Integer.valueOf(1));
        }
        skuBO.setMaterialId(bo.getMaterialId());
        return skuBO;
    }
}

