/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.bo.BusiQryCommodityCatalogReqBO;
import com.tydic.newretail.bo.BusiQryCommodityCatalogRspBO;
import com.tydic.newretail.bo.RspPageBO;
import com.tydic.newretail.busi.service.QryBusiCommodityCatalogService;
import com.tydic.newretail.dao.CommodityGuideCatalogDAO;
import com.tydic.newretail.dao.po.CommodityGuideCatalogPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryBusiCommodityCatalogServiceImpl
implements QryBusiCommodityCatalogService {
    private static final Logger logger = LoggerFactory.getLogger(QryBusiCommodityCatalogServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private CommodityGuideCatalogDAO commodityGuideCatalogDAO;

    public RspPageBO<BusiQryCommodityCatalogRspBO> qryBusiCommodityCatalog(BusiQryCommodityCatalogReqBO busiQryCommodityCatalogReqBO) {
        if (this.isDebugEnabled) {
            logger.debug(" \u7c7b\u76ee\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiQryCommodityCatalogReqBO.toString());
        }
        RspPageBO rsp = new RspPageBO();
        try {
            Page page = new Page(busiQryCommodityCatalogReqBO.getCurrent(), busiQryCommodityCatalogReqBO.getPageSize());
            List<CommodityGuideCatalogPO> commodityCatalogList = this.commodityGuideCatalogDAO.getListbyBusiCatReqBO(busiQryCommodityCatalogReqBO, (Page<Map<String, Object>>)page);
            ArrayList<BusiQryCommodityCatalogRspBO> commodityCatalogBOList = new ArrayList<BusiQryCommodityCatalogRspBO>();
            for (int i = 0; i < commodityCatalogList.size(); ++i) {
                BusiQryCommodityCatalogRspBO busiQryCommodityCatalogRspBO = new BusiQryCommodityCatalogRspBO();
                BeanUtils.copyProperties((Object)commodityCatalogList.get(i), (Object)busiQryCommodityCatalogRspBO);
                commodityCatalogBOList.add(busiQryCommodityCatalogRspBO);
            }
            rsp.setRows(commodityCatalogBOList);
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u6210\u529f");
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setTotal(page.getTotalPages());
        }
        catch (Exception e) {
            logger.error(" \u7c7b\u76ee\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", " \u7c7b\u76ee\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }
}

