/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.BusiQryCommodityCatalogReqBO;
import com.tydic.newretail.bo.BusiQryCommodityCatalogRspBO;
import com.tydic.newretail.bo.QryOthLevelCommodityCatalogRspBO;
import com.tydic.newretail.bo.RspPageBO;
import com.tydic.newretail.busi.service.QryOthLevelCommodityCatalogService;
import com.tydic.newretail.dao.CommodityGuideCatalogDAO;
import com.tydic.newretail.dao.po.CatalogInfoPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class QryOthLevelCommodityCatalogServiceImpl
implements QryOthLevelCommodityCatalogService {
    private static final Logger logger = LoggerFactory.getLogger(QryOthLevelCommodityCatalogServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private CommodityGuideCatalogDAO commodityGuideCatalogDAO;
    @Value(value="${catalog.cache.enabled:1}")
    private int cacheEnabled;
    private static Map<String, RspPageBO<QryOthLevelCommodityCatalogRspBO>> map = new HashMap<String, RspPageBO<QryOthLevelCommodityCatalogRspBO>>();

    public RspPageBO<QryOthLevelCommodityCatalogRspBO> qryOthLevelBusiCommodityCatalog(BusiQryCommodityCatalogReqBO busiQryCommodityCatalogReqBO) {
        if (this.isDebugEnabled) {
            // empty if block
        }
        RspPageBO rsp = new RspPageBO();
        if (this.cacheEnabled == 1) {
            try {
                RspPageBO value = map.get(busiQryCommodityCatalogReqBO.getChannelId().toString() + "_" + busiQryCommodityCatalogReqBO.getUpperCatalogId().toString());
                value.setRespCode("0000");
                value.setRespDesc("\u6210\u529f");
                rsp = value;
            }
            catch (Exception e) {
                logger.error(" \u7c7b\u76ee\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", " \u7c7b\u76ee\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
            }
        }
        try {
            RspPageBO value = new RspPageBO();
            List<CatalogInfoPO> catalogInfos = this.commodityGuideCatalogDAO.selectByUpperCatalogIdAndChannelId(busiQryCommodityCatalogReqBO.getUpperCatalogId(), busiQryCommodityCatalogReqBO.getChannelId());
            ArrayList<BusiQryCommodityCatalogRspBO> commodityCatalogRspBOS = new ArrayList<BusiQryCommodityCatalogRspBO>();
            for (CatalogInfoPO catalogInfo : catalogInfos) {
                BusiQryCommodityCatalogRspBO busiQryCommodityCatalogRspBO = new BusiQryCommodityCatalogRspBO();
                BeanUtils.copyProperties((Object)catalogInfo, (Object)busiQryCommodityCatalogRspBO);
                commodityCatalogRspBOS.add(busiQryCommodityCatalogRspBO);
            }
            ArrayList<QryOthLevelCommodityCatalogRspBO> qryOthLevelCommodityCatalogRspBOS = new ArrayList<QryOthLevelCommodityCatalogRspBO>();
            QryOthLevelCommodityCatalogRspBO qryOthLevelCommodityCatalogRspBO = new QryOthLevelCommodityCatalogRspBO();
            qryOthLevelCommodityCatalogRspBO.setRows(commodityCatalogRspBOS);
            qryOthLevelCommodityCatalogRspBOS.add(qryOthLevelCommodityCatalogRspBO);
            value.setRows(qryOthLevelCommodityCatalogRspBOS);
            value.setRespCode("0000");
            value.setRespDesc("\u6210\u529f");
            rsp = value;
        }
        catch (Exception e) {
            logger.error(" \u7c7b\u76ee\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", " \u7c7b\u76ee\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    public Map<String, RspPageBO<QryOthLevelCommodityCatalogRspBO>> getMap() {
        return map;
    }

    public void setMap(Map<String, RspPageBO<QryOthLevelCommodityCatalogRspBO>> map) {
        QryOthLevelCommodityCatalogServiceImpl.map = map;
    }
}

