/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.bo.AnswerBO;
import com.tydic.newretail.bo.MemDetailInfoBO;
import com.tydic.newretail.bo.QryQuestionAndAnswerReqBO;
import com.tydic.newretail.bo.QuestionBO;
import com.tydic.newretail.bo.RspPageBO;
import com.tydic.newretail.bo.UmcMemDetailInfoAbilityRspBO;
import com.tydic.newretail.busi.service.QryQuestionAndAnswerService;
import com.tydic.newretail.busi.service.UmcService;
import com.tydic.newretail.dao.CommodityAnswerDAO;
import com.tydic.newretail.dao.CommodityQuestionDAO;
import com.tydic.newretail.dao.po.CommodityAnswerPO;
import com.tydic.newretail.dao.po.CommodityQuestionPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryQuestionAndAnswerServiceImpl
implements QryQuestionAndAnswerService {
    private static final Logger logger = LoggerFactory.getLogger(QryQuestionAndAnswerServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private CommodityAnswerDAO commodityAnswerDAO;
    @Autowired
    private CommodityQuestionDAO commodityQuestionDAO;
    @Autowired
    private UmcService umcService;

    public RspPageBO<QuestionBO> qryQuestionAndAnswer(QryQuestionAndAnswerReqBO qryQuestionAndAnswerReqBO) {
        logger.info("\u5546\u54c1\u95ee\u7b54\u5217\u8868\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)qryQuestionAndAnswerReqBO.toString());
        RspPageBO result = new RspPageBO();
        try {
            if (qryQuestionAndAnswerReqBO.getCommodityId() == null && qryQuestionAndAnswerReqBO.getSkuId() == null) {
                result.setRespCode("8888");
                result.setRespDesc("\u5546\u54c1\u8bc4\u4ef7\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
                logger.error("QryAppraisesService\u5fc5\u586b\u5165\u53c2\u4e3a\u7a7a");
            } else if (qryQuestionAndAnswerReqBO.getSupplierShopId() == null) {
                result.setRespCode("8888");
                result.setRespDesc("\u5546\u54c1\u8bc4\u4ef7\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
                logger.error("QryAppraisesService\u5fc5\u586b\u5165\u53c2\u4e3a\u7a7a");
            } else {
                CommodityQuestionPO commodityQuestionPO = new CommodityQuestionPO();
                commodityQuestionPO.setSupplierShopId(qryQuestionAndAnswerReqBO.getSupplierShopId());
                if (qryQuestionAndAnswerReqBO.getCommodityId() != null) {
                    commodityQuestionPO.setCommodityId(qryQuestionAndAnswerReqBO.getCommodityId());
                } else {
                    commodityQuestionPO.setSkuId(qryQuestionAndAnswerReqBO.getSkuId());
                }
                Page page = new Page();
                page.setLimit(qryQuestionAndAnswerReqBO.getLimit());
                page.setOffset(qryQuestionAndAnswerReqBO.getOffset());
                List<CommodityQuestionPO> commodityQuestionPOs = this.commodityQuestionDAO.selectCommodityQuestions(commodityQuestionPO, (Page<CommodityQuestionPO>)page);
                ArrayList<QuestionBO> questionBOs = new ArrayList<QuestionBO>();
                if (CollectionUtils.isNotEmpty(commodityQuestionPOs)) {
                    for (CommodityQuestionPO commodityQuestionPO1 : commodityQuestionPOs) {
                        QuestionBO questionBO = new QuestionBO();
                        CommodityAnswerPO commodityAnswerPO = new CommodityAnswerPO();
                        commodityAnswerPO.setQuestionId(commodityQuestionPO1.getQuestionId());
                        int countAnswers = this.commodityAnswerDAO.selectCountAnswers(commodityAnswerPO);
                        List<CommodityAnswerPO> CommodityAnswerPOs = this.commodityAnswerDAO.selectCommodityAnswers(commodityAnswerPO);
                        ArrayList<AnswerBO> answerBOs = new ArrayList<AnswerBO>();
                        for (CommodityAnswerPO commodityAnswerPO1 : CommodityAnswerPOs) {
                            AnswerBO answerBO = new AnswerBO();
                            answerBO.setAnswerId(commodityAnswerPO1.getAnswerId());
                            answerBO.setAnswerContent(commodityAnswerPO1.getAnswerContent());
                            MemDetailInfoBO memDetailInfoRspBO = this.getMemDetailByMemId(commodityAnswerPO1.getAnswerPersonnelId());
                            answerBO.setMemDetailInfoRspBO(memDetailInfoRspBO);
                            answerBO.setCreateTime(commodityAnswerPO1.getCreateTime());
                            answerBOs.add(answerBO);
                        }
                        questionBO.setQuestionId(commodityQuestionPO1.getQuestionId());
                        questionBO.setSkuId(commodityQuestionPO1.getSkuId());
                        questionBO.setSupplierShopId(commodityQuestionPO1.getSupplierShopId());
                        questionBO.setCommodityId(commodityQuestionPO1.getCommodityId());
                        MemDetailInfoBO memDetailInfoReqBO = this.getMemDetailByMemId(commodityQuestionPO1.getQuestionVectorId());
                        questionBO.setMemDetailInfoReqBO(memDetailInfoReqBO);
                        questionBO.setQuestionContent(commodityQuestionPO1.getQuestionContent());
                        questionBO.setCreateTime(commodityQuestionPO1.getCreateTime());
                        questionBO.setAnswers(answerBOs);
                        questionBO.setAnswersNum(Integer.valueOf(countAnswers));
                        questionBOs.add(questionBO);
                    }
                }
                result.setRespCode("0000");
                result.setRespDesc("\u6210\u529f");
                result.setTotal(page.getTotalPages());
                result.setRecordsTotal(page.getTotalCount());
                result.setRows(questionBOs);
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u95ee\u7b54\u5217\u8868\u67e5\u8be2\u670d\u52a1\u9519\u8bef" + e);
            result.setRespCode("8888");
            result.setRespDesc("\u5546\u54c1\u95ee\u7b54\u5217\u8868\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u95ee\u7b54\u5217\u8868\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
        }
        return result;
    }

    public MemDetailInfoBO getMemDetailByMemId(Long memId) {
        UmcMemDetailInfoAbilityRspBO umcMemDetailInfoAbilityRspBO = this.umcService.memDetailQuery(memId);
        MemDetailInfoBO memDetailInfoBO = this.UmcMemDetailInfoAbilityBOtomemDetailInfoBO(umcMemDetailInfoAbilityRspBO);
        return memDetailInfoBO;
    }

    public MemDetailInfoBO UmcMemDetailInfoAbilityBOtomemDetailInfoBO(UmcMemDetailInfoAbilityRspBO umcMemDetailInfoAbilityRspBO) {
        MemDetailInfoBO memDetailInfoBO = new MemDetailInfoBO();
        memDetailInfoBO.setHeadUrl(umcMemDetailInfoAbilityRspBO.getHeadUrl());
        memDetailInfoBO.setIsPlus(umcMemDetailInfoAbilityRspBO.getIsPlus());
        memDetailInfoBO.setMemId(umcMemDetailInfoAbilityRspBO.getMemId());
        memDetailInfoBO.setMemLevel(umcMemDetailInfoAbilityRspBO.getMemLevel());
        memDetailInfoBO.setMemName1(umcMemDetailInfoAbilityRspBO.getMemName1());
        memDetailInfoBO.setMemName2(umcMemDetailInfoAbilityRspBO.getMemName2());
        memDetailInfoBO.setMemNickName(umcMemDetailInfoAbilityRspBO.getMemNickName());
        memDetailInfoBO.setMemType(umcMemDetailInfoAbilityRspBO.getMemType());
        memDetailInfoBO.setRegAccount(umcMemDetailInfoAbilityRspBO.getRegAccount());
        memDetailInfoBO.setSex(umcMemDetailInfoAbilityRspBO.getSex());
        memDetailInfoBO.setState(umcMemDetailInfoAbilityRspBO.getState());
        return memDetailInfoBO;
    }
}

