/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.bo.DSkuShareBuyAndSkuBO;
import com.tydic.newretail.bo.QueryMemSkuShareBuyReqBO;
import com.tydic.newretail.bo.QueryMemSkuShareBuyRspBO;
import com.tydic.newretail.bo.QueryXlsEsBySkuIdsServiceReqBO;
import com.tydic.newretail.bo.SearchBarEsRspBO;
import com.tydic.newretail.bo.SearchBarEsRspInfoBO;
import com.tydic.newretail.busi.service.QueryMemSkuShareBuyService;
import com.tydic.newretail.busi.service.QueryXlsEsBySkuIdsService;
import com.tydic.newretail.dao.DSkuShareBuyDAO;
import com.tydic.newretail.dao.po.DSkuShareBuyPO;
import com.tydic.newretail.util.MoneyUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryMemSkuShareBuyServiceImpl
implements QueryMemSkuShareBuyService {
    @Autowired
    private DSkuShareBuyDAO dSkuShareBuyDAO;
    @Autowired
    private QueryXlsEsBySkuIdsService queryXlsEsBySkuIdsService;
    private static final Logger logger = LoggerFactory.getLogger(QueryMemSkuShareBuyServiceImpl.class);

    public QueryMemSkuShareBuyRspBO queryMemSkuShareBuy(QueryMemSkuShareBuyReqBO queryMemSkuShareBuyReqBO) {
        logger.debug("\u6839\u636e\u4f1a\u5458ID\u67e5\u8be2\u4f1a\u5458\u5206\u4eab\u8d2d\u4e70\u8bb0\u5f55\u8be6\u7ec6\u4fe1\u606f\u5165\u53c2=" + queryMemSkuShareBuyReqBO.toString());
        QueryMemSkuShareBuyRspBO queryMemSkuShareBuyRspBO = new QueryMemSkuShareBuyRspBO();
        ArrayList<DSkuShareBuyAndSkuBO> rows = new ArrayList<DSkuShareBuyAndSkuBO>();
        Long memberId = queryMemSkuShareBuyReqBO.getMemberId();
        if (memberId == null) {
            queryMemSkuShareBuyRspBO.setRespCode("7777");
            queryMemSkuShareBuyRspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
            return queryMemSkuShareBuyRspBO;
        }
        String startTime = queryMemSkuShareBuyReqBO.getStartTime();
        String endTime = queryMemSkuShareBuyReqBO.getEndTime();
        Date startTimeed = null;
        Date endTimeed = null;
        if (StringUtils.isNotBlank((String)startTime) && StringUtils.isNotBlank((String)endTime)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                startTimeed = sdf.parse(startTime);
                endTimeed = sdf.parse(endTime);
                Calendar c = Calendar.getInstance();
                c.setTime(endTimeed);
                c.add(5, 1);
                endTimeed = c.getTime();
            }
            catch (ParseException e) {
                e.printStackTrace();
                logger.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u5316\u51fa\u9519");
            }
        }
        logger.debug("startTimeed=" + startTimeed);
        logger.debug("endTimeed=" + endTimeed);
        Page page = new Page();
        page.setLimit(queryMemSkuShareBuyReqBO.getPageSize());
        page.setOffset(queryMemSkuShareBuyReqBO.getOffset());
        ArrayList<Long> skuIds = new ArrayList<Long>();
        try {
            List<DSkuShareBuyPO> dSkuShareBuyPOs = this.dSkuShareBuyDAO.selectBySharer(memberId, startTimeed, endTimeed, queryMemSkuShareBuyReqBO.getIsStaffPush(), (Page<DSkuShareBuyPO>)page);
            if (CollectionUtils.isNotEmpty(dSkuShareBuyPOs)) {
                for (DSkuShareBuyPO dSkuShareBuyPO : dSkuShareBuyPOs) {
                    skuIds.add(dSkuShareBuyPO.getSkuId());
                    DSkuShareBuyAndSkuBO dSkuShareBuyAndSkuBO = new DSkuShareBuyAndSkuBO();
                    BeanUtils.copyProperties((Object)dSkuShareBuyPO, (Object)dSkuShareBuyAndSkuBO);
                    rows.add(dSkuShareBuyAndSkuBO);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6839\u636e\u4f1a\u5458ID\u67e5\u8be2\u4f1a\u5458\u7684\u5206\u4eab\u6210\u4ea4\u8bb0\u5f55\u62a5\u9519");
        }
        try {
            Long sumBusinessPrice = this.dSkuShareBuyDAO.selectOnlySumPriceByMemberId(memberId, startTimeed, endTimeed, queryMemSkuShareBuyReqBO.getIsStaffPush());
            queryMemSkuShareBuyRspBO.setSumBusinessPrice(MoneyUtils.Long2BigDecimal(sumBusinessPrice));
        }
        catch (Exception e1) {
            e1.printStackTrace();
            logger.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u4f1a\u5458\u7684\u603b\u91cf\u4ea4\u6613\u989d\u62a5\u9519");
        }
        HashMap<String, SearchBarEsRspInfoBO> mapSearchBarEsRspBO = new HashMap<String, SearchBarEsRspInfoBO>();
        if (CollectionUtils.isNotEmpty(skuIds)) {
            QueryXlsEsBySkuIdsServiceReqBO queryXlsEsBySkuIdsServiceReqBO = new QueryXlsEsBySkuIdsServiceReqBO();
            queryXlsEsBySkuIdsServiceReqBO.setSkuIds(skuIds);
            try {
                SearchBarEsRspBO searchBarEsRspBO = this.queryXlsEsBySkuIdsService.queryAllXlsEsBySkuIds(queryXlsEsBySkuIdsServiceReqBO);
                List result = searchBarEsRspBO.getResult();
                if (CollectionUtils.isNotEmpty((Collection)result)) {
                    for (SearchBarEsRspInfoBO searchBarEsRspInfo : result) {
                        mapSearchBarEsRspBO.put(searchBarEsRspInfo.getSkuId(), searchBarEsRspInfo);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u6839\u636eskuId\u5217\u8868\u67e5\u8be2es\u670d\u52a1\u62a5\u9519");
            }
        }
        if (CollectionUtils.isNotEmpty(rows)) {
            for (DSkuShareBuyAndSkuBO dSkuShareBuyAndSkuBO : rows) {
                SearchBarEsRspInfoBO searchBarEsRspInfo = (SearchBarEsRspInfoBO)mapSearchBarEsRspBO.get(dSkuShareBuyAndSkuBO.getSkuId().toString());
                dSkuShareBuyAndSkuBO.setSearchBarEsRspInfo(searchBarEsRspInfo);
            }
        }
        queryMemSkuShareBuyRspBO.setRespCode("0000");
        queryMemSkuShareBuyRspBO.setRespDesc("\u6210\u529f");
        queryMemSkuShareBuyRspBO.setRows(rows);
        queryMemSkuShareBuyRspBO.setTotal(page.getTotalPages());
        queryMemSkuShareBuyRspBO.setRecordsTotal(page.getTotalCount());
        return queryMemSkuShareBuyRspBO;
    }
}

