/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.QueryAllPicByDeviceIdRspBO;
import com.tydic.newretail.bo.QueryAllSpecByFodderIdRspBO;
import com.tydic.newretail.bo.QueryMaterialSkuBO;
import com.tydic.newretail.bo.QuerySkuAndFodderReqBO;
import com.tydic.newretail.bo.QuerySkuAndFodderRspBO;
import com.tydic.newretail.bo.QuerySkuFodderRspBO;
import com.tydic.newretail.bo.SkuFodderPicBO;
import com.tydic.newretail.bo.SkuFodderSpecBO;
import com.tydic.newretail.busi.service.QueryAllPicByFodderIdService;
import com.tydic.newretail.busi.service.QueryAllSpecByFodderIdService;
import com.tydic.newretail.busi.service.QuerySkuAndFodderService;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.SkuFodderDAO;
import com.tydic.newretail.dao.SkuFodderRelationDAO;
import com.tydic.newretail.dao.po.SkuFodderPO;
import com.tydic.newretail.dao.po.SkuFodderRelationPO;
import com.tydic.newretail.dao.po.SkuFodderRelationsPO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuerySkuAndFodderServiceImpl
implements QuerySkuAndFodderService {
    @Autowired
    private SkuDAO skuDAO;
    @Autowired
    private SkuFodderDAO skuFodderDAO;
    @Autowired
    private SkuFodderRelationDAO skuFodderRelationDAO;
    @Autowired
    private QueryAllPicByFodderIdService queryAllPicByDeviceIdService;
    @Autowired
    private QueryAllSpecByFodderIdService queryAllSpecByFodderIdService;
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuAndFodderServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();

    public QuerySkuAndFodderRspBO querySkuAndFodder(QuerySkuAndFodderReqBO querySkuAndFodderReqBO) {
        logger.info("\u67e5\u8be2\u5355\u54c1\u7d20\u6750\u548c\u5bf9\u5e94\u5546\u54c1\u670d\u52a1\u5165\u53c2===" + querySkuAndFodderReqBO.toString());
        QuerySkuAndFodderRspBO querySkuAndFodderRspBO = new QuerySkuAndFodderRspBO();
        try {
            SkuFodderRelationsPO skuFodderRelationPO1 = new SkuFodderRelationsPO();
            skuFodderRelationPO1.setFodderId(querySkuAndFodderReqBO.getFodderId());
            if (CollectionUtils.isNotEmpty((Collection)querySkuAndFodderReqBO.getSupplierIds())) {
                skuFodderRelationPO1.setSupplierIds(querySkuAndFodderReqBO.getSupplierIds());
            }
            List<SkuFodderRelationPO> skuFodderRelationPOs = this.skuFodderRelationDAO.selectByFodderIdAndSupplierId(skuFodderRelationPO1);
            ArrayList<QueryMaterialSkuBO> uploadingMaterialSkuBOs = new ArrayList<QueryMaterialSkuBO>();
            if (skuFodderRelationPOs.size() > 0) {
                for (SkuFodderRelationPO skuFodderRelationPO : skuFodderRelationPOs) {
                    SkuPO skuPO;
                    QueryMaterialSkuBO queryMaterialSkuBO = new QueryMaterialSkuBO();
                    if (skuFodderRelationPO.getSkuId() == null || skuFodderRelationPO.getSupplierId() == null || null == (skuPO = this.skuDAO.selectBySkuIdAndSupplier(skuFodderRelationPO.getSkuId()))) continue;
                    queryMaterialSkuBO.setExtSkuId(skuPO.getExtSkuId());
                    queryMaterialSkuBO.setMaterialId(skuPO.getMaterialId());
                    queryMaterialSkuBO.setSkuId(skuPO.getSkuId());
                    queryMaterialSkuBO.setSupplierId(skuPO.getSupplierId());
                    queryMaterialSkuBO.setSupplierName(skuPO.getSupplierName());
                    uploadingMaterialSkuBOs.add(queryMaterialSkuBO);
                }
            }
            SkuFodderPO skuFodderPO = new SkuFodderPO();
            skuFodderPO.setFodderId(querySkuAndFodderReqBO.getFodderId());
            List<SkuFodderPO> skuFodderPOs = this.skuFodderDAO.selectByMany(skuFodderPO);
            SkuFodderPO skuFodderPORsp = skuFodderPOs.get(0);
            QuerySkuFodderRspBO querySkuFodderRspBO = new QuerySkuFodderRspBO();
            BeanUtils.copyProperties((Object)skuFodderPORsp, (Object)querySkuFodderRspBO);
            if (null != skuFodderPORsp.getSkuPrice()) {
                String skuPrice = skuFodderPORsp.getSkuPrice() + "";
                BigDecimal price = new BigDecimal(skuPrice);
                querySkuFodderRspBO.setSkuPrice(price.divide(new BigDecimal("10000")).toString());
            }
            SkuFodderPicBO skuFodderPicBO = new SkuFodderPicBO();
            skuFodderPicBO.setFodderId(skuFodderPORsp.getFodderId());
            QueryAllPicByDeviceIdRspBO queryAllPicByDeviceIdRspBO = this.queryAllPicByDeviceIdService.queryAllPicByDeviceId(skuFodderPicBO);
            if ("0000".equals(queryAllPicByDeviceIdRspBO.getRespCode())) {
                BeanUtils.copyProperties((Object)queryAllPicByDeviceIdRspBO, (Object)querySkuFodderRspBO);
            }
            SkuFodderSpecBO skuFodderSpecBO = new SkuFodderSpecBO();
            skuFodderSpecBO.setFodderId(skuFodderPORsp.getFodderId());
            QueryAllSpecByFodderIdRspBO queryAllSpecByFodderIdRspBO = this.queryAllSpecByFodderIdService.queryAllSpecByFodderId(skuFodderSpecBO);
            if ("0000".equals(queryAllSpecByFodderIdRspBO.getRespCode())) {
                BeanUtils.copyProperties((Object)queryAllSpecByFodderIdRspBO, (Object)querySkuFodderRspBO);
            }
            querySkuFodderRspBO.setHasInteractive(skuFodderPORsp.getHasInteractive());
            querySkuFodderRspBO.setHasWisdom(skuFodderPORsp.getHasWisdom());
            querySkuFodderRspBO.setIsBinding(skuFodderPORsp.getIsBinding());
            querySkuAndFodderRspBO.setRespCode("0000");
            querySkuAndFodderRspBO.setRespDesc("\u6210\u529f");
            querySkuAndFodderRspBO.setQuerySkuFodderRspBO(querySkuFodderRspBO);
            querySkuAndFodderRspBO.setUploadingMaterialSkuBO(uploadingMaterialSkuBOs);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5355\u54c1\u7d20\u6750\u548c\u5bf9\u5e94\u5546\u54c1\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e.getMessage());
            querySkuAndFodderRspBO.setRespCode("8888");
            querySkuAndFodderRspBO.setRespDesc("\u67e5\u8be2\u5355\u54c1\u7d20\u6750\u548c\u5bf9\u5e94\u5546\u54c1\u670d\u52a1-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38");
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u67e5\u8be2\u5355\u54c1\u7d20\u6750\u548c\u5bf9\u5e94\u5546\u54c1\u670d\u52a1-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e.getMessage());
        }
        return querySkuAndFodderRspBO;
    }
}

