/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.tydic.newretail.bo.DSkuBO;
import com.tydic.newretail.bo.PriceBO;
import com.tydic.newretail.bo.ProvGoodsBO;
import com.tydic.newretail.bo.QuerySkuByMaterialIdBO;
import com.tydic.newretail.bo.QuerySkuByMaterialIdReqBO;
import com.tydic.newretail.bo.RspInfoListBO;
import com.tydic.newretail.busi.service.QuerySkuByMaterialIdAndShopListService;
import com.tydic.newretail.dao.ProvGoodsDAO;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.SkuPriceDAO;
import com.tydic.newretail.dao.po.ProvGoodsPO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.dao.po.SkuPricePO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuerySkuByMaterialIdAndShopListServiceImpl
implements QuerySkuByMaterialIdAndShopListService {
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuByMaterialIdAndShopListServiceImpl.class);
    @Autowired
    private SkuDAO skuDAO;
    @Autowired
    private SkuPriceDAO skuPriceDAO;
    @Autowired
    private ProvGoodsDAO provGoodsDAO;

    public RspInfoListBO<DSkuBO> querySkuByMaterialIdAndShopList(QuerySkuByMaterialIdReqBO reqBO) {
        logger.debug("\u8c03\u7528\u901a\u8fc7\u7269\u6599\u7f16\u7801\u95e8\u5e97\u5217\u8868\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5165\u53c2" + reqBO.toString());
        RspInfoListBO result = new RspInfoListBO();
        ArrayList<DSkuBO> boList = new ArrayList<DSkuBO>();
        List querySkuByMaterialIdBOList = reqBO.getQuerySkuByMaterialIdBOList();
        if (CollectionUtils.isEmpty((Collection)querySkuByMaterialIdBOList)) {
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            result.setRows(boList);
            return result;
        }
        ArrayList<SkuPO> record = new ArrayList<SkuPO>();
        SkuPO sku = null;
        for (QuerySkuByMaterialIdBO bo : querySkuByMaterialIdBOList) {
            List shops = bo.getShopIds();
            for (Long l : shops) {
                if (l == null) {
                    result.setRespCode("8888");
                    result.setRespDesc("\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    result.setRows(boList);
                    return result;
                }
                sku = new SkuPO();
                sku.setMaterialId(bo.getMaterialId());
                sku.setSupplierId(l);
                record.add(sku);
            }
        }
        List<Object> poList = new ArrayList();
        try {
            List<ProvGoodsPO> list;
            poList = this.skuDAO.querySkuByMaterialIdAndShopList(record);
            if (CollectionUtils.isEmpty(poList)) {
                result.setRespCode("8888");
                result.setRespDesc("\u5931\u8d25");
                result.setRows(boList);
                return result;
            }
            ArrayList<String> matreialIds = new ArrayList<String>();
            String provinceCode = ((SkuPO)poList.get(0)).getProvinceCode();
            for (SkuPO skuPO : poList) {
                matreialIds.add(skuPO.getMaterialId());
            }
            HashMap<String, ProvGoodsPO> hasseMap = new HashMap<String, ProvGoodsPO>();
            if (CollectionUtils.isNotEmpty(matreialIds) && StringUtils.isNotEmpty((String)provinceCode) && CollectionUtils.isNotEmpty(list = this.provGoodsDAO.selectByMaterials(matreialIds, provinceCode))) {
                for (ProvGoodsPO provGoodsPO : list) {
                    hasseMap.put(provGoodsPO.getMaterialId(), provGoodsPO);
                }
            }
            Object var11_17 = null;
            for (SkuPO skuPO : poList) {
                DSkuBO dSkuBO = new DSkuBO();
                BeanUtils.copyProperties((Object)skuPO, (Object)dSkuBO);
                if (hasseMap.containsKey(skuPO.getMaterialId())) {
                    dSkuBO.setHasSerialNumber(((ProvGoodsPO)hasseMap.get(skuPO.getMaterialId())).getHasSerialNumber());
                }
                boList.add(dSkuBO);
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7269\u6599\u7f16\u7801\u95e8\u5e97\u5217\u8868\u67e5\u8be2\u5355\u54c1\u5217\u8868\u670d\u52a1\u62a5\u9519");
            e.printStackTrace();
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            result.setRows(boList);
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(boList);
        return result;
    }

    public DSkuBO po2bo(SkuPO po) {
        DSkuBO bo = new DSkuBO();
        bo.setAgreementPrice(po.getAgreementPrice());
        bo.setAttachFlag(po.getAttachFlag());
        bo.setAttachType(po.getAttachType());
        bo.setBrandId(po.getBrandId());
        bo.setBrandIds(po.getBrandIds());
        bo.setBrandName(po.getBrandName());
        bo.setCatalogId(po.getCatalogId());
        bo.setCgType(po.getCgType());
        bo.setCommodityId(po.getCommodityId());
        bo.setCommodityIds(po.getCommodityIds());
        bo.setCommodityTypeId(po.getCommodityTypeId());
        bo.setCommodityTypeIds(po.getCommodityTypeIds());
        bo.setCreateLoginId(po.getCreateLoginId());
        bo.setCreateTime(po.getCreateTime());
        bo.setDiscountRate(po.getDiscountRate());
        bo.setDistribution(po.getDistribution());
        bo.setErpLongName(po.getErpLongName());
        bo.setErpType(po.getErpType());
        bo.setExtSkuId(po.getExtSkuId());
        bo.setHasInteractive(po.getHasInteractive());
        bo.setHasInteractiveStr(po.getHasInteractiveStr());
        bo.setHasWisdom(po.getHasWisdom());
        bo.setHasWisdomStr(po.getHasWisdomStr());
        bo.setIsBindCommodity(po.getIsBindCommodity());
        bo.setIsDelete(po.getIsDelete());
        bo.setIsSupplierAgreement(po.getIsSupplierAgreement());
        return bo;
    }

    public RspInfoListBO<DSkuBO> querySkuByMaterialIdsAndShopId(QuerySkuByMaterialIdReqBO reqBO) {
        logger.debug("\u8c03\u7528\u901a\u8fc7\u7269\u6599\u7f16\u7801\u95e8\u5e97\u5217\u8868\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5165\u53c2" + reqBO.toString());
        RspInfoListBO result = new RspInfoListBO();
        ArrayList<DSkuBO> boList = new ArrayList<DSkuBO>();
        if (CollectionUtils.isEmpty((Collection)reqBO.getMaterialIds())) {
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            result.setRows(boList);
            return result;
        }
        ArrayList<SkuPO> record = new ArrayList<SkuPO>();
        SkuPO sku = null;
        for (String material : reqBO.getMaterialIds()) {
            sku = new SkuPO();
            sku.setMaterialId(material);
            sku.setSupplierId(reqBO.getShopId());
            record.add(sku);
        }
        List<Object> poList = new ArrayList();
        try {
            poList = this.skuDAO.querySkuByMaterialIdAndShopList(record);
            if (CollectionUtils.isEmpty(poList)) {
                result.setRespCode("8888");
                result.setRespDesc("\u5931\u8d25");
                result.setRows(boList);
                return result;
            }
            DSkuBO bo = null;
            for (SkuPO skuPO : poList) {
                bo = new DSkuBO();
                BeanUtils.copyProperties((Object)skuPO, (Object)bo);
                boList.add(bo);
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7269\u6599\u7f16\u7801\u95e8\u5e97\u5217\u8868\u67e5\u8be2\u5355\u54c1\u5217\u8868\u670d\u52a1\u62a5\u9519");
            e.printStackTrace();
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            result.setRows(boList);
            return result;
        }
        logger.debug("\u67e5\u8be2\u7ed3\u679c");
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(boList);
        return result;
    }

    public RspInfoListBO<DSkuBO> querySkuAndPriceByMaterialIdAndShopList(QuerySkuByMaterialIdReqBO reqBO) {
        RspInfoListBO result = new RspInfoListBO();
        ArrayList<DSkuBO> rows = new ArrayList<DSkuBO>();
        logger.debug("\u6839\u636e\u7269\u6599+\u95e8\u5e97\u5217\u8868\u67e5\u8be2sku\u53ca\u4ef7\u683c\u4fe1\u606f");
        if (CollectionUtils.isEmpty((Collection)reqBO.getShopIds())) {
            throw new BusinessException("9999", "\u95e8\u5e97\u5217\u8868\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getMaterialId())) {
            throw new BusinessException("9999", "\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
        }
        try {
            List<SkuPO> skuList = this.skuDAO.queryXlsSkuByMaterialAndShopList(reqBO.getShopIds(), reqBO.getMaterialId());
            ArrayList<Long> skuIds = new ArrayList<Long>();
            ArrayList<Long> provGoodsId = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(skuList)) {
                for (SkuPO sku : skuList) {
                    skuIds.add(sku.getSkuId());
                    provGoodsId.add(sku.getProvGoodsId());
                }
            }
            Map<Long, PriceBO> priceMap = this.getPrice(skuIds);
            Map<Object, Object> provGoodsMap = new HashMap();
            if (!CollectionUtils.isEmpty(provGoodsId)) {
                provGoodsMap = this.getProvGoods(provGoodsId);
            }
            for (SkuPO sku : skuList) {
                DSkuBO bo = new DSkuBO();
                BeanUtils.copyProperties((Object)sku, (Object)bo);
                bo.setPrice(priceMap.get(sku.getSkuId()));
                bo.setProvGoods((ProvGoodsBO)provGoodsMap.get(sku.getProvGoodsId()));
                rows.add(bo);
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7269\u6599\u7f16\u7801\u95e8\u5e97\u5217\u8868\u67e5\u8be2\u5355\u54c1\u5217\u8868\u670d\u52a1\u62a5\u9519");
            e.printStackTrace();
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            result.setRows(rows);
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public Map<Long, ProvGoodsBO> getProvGoods(List<Long> provGoodsId) {
        HashMap<Long, ProvGoodsBO> map = new HashMap<Long, ProvGoodsBO>();
        List<ProvGoodsPO> poList = this.provGoodsDAO.selectByProvGoodsIds(provGoodsId);
        if (!CollectionUtils.isEmpty(poList)) {
            for (ProvGoodsPO po : poList) {
                if (map.containsKey(po.getProvGoodsId())) continue;
                ProvGoodsBO bo = new ProvGoodsBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                map.put(po.getProvGoodsId(), bo);
            }
        }
        return map;
    }

    public Map<Long, PriceBO> getPrice(List<Long> skuIds) {
        HashMap<Long, PriceBO> map = new HashMap<Long, PriceBO>();
        List<SkuPricePO> skuPrices = this.skuPriceDAO.selectBySkuIds(skuIds);
        if (CollectionUtils.isNotEmpty(skuPrices)) {
            for (SkuPricePO price : skuPrices) {
                if (map.containsKey(price.getSkuId())) continue;
                PriceBO priceBO = new PriceBO();
                BeanUtils.copyProperties((Object)price, (Object)priceBO);
                map.put(price.getSkuId(), priceBO);
            }
        }
        return map;
    }
}

