/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.tydic.newretail.bo.QuerySkuListByCommodityIdReqBO;
import com.tydic.newretail.bo.QuerySkuListByCommodityIdRspBO;
import com.tydic.newretail.bo.RspInfoListBO;
import com.tydic.newretail.busi.service.QuerySkuListByCommodityIdService;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.SkuSpecDAO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.dao.po.SkuSpecPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuerySkuListByCommodityIdServiceImpl
implements QuerySkuListByCommodityIdService {
    @Autowired
    private SkuDAO xlsSkuMapper;
    @Autowired
    private SkuSpecDAO skuSpecMapper;
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuListByCommodityIdServiceImpl.class);

    public RspInfoListBO<QuerySkuListByCommodityIdRspBO> querySkuListByCommodityId(QuerySkuListByCommodityIdReqBO querySkuListByCommodityIdReqBO) {
        logger.info("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5355\u54c1\u5217\u8868\u53ca\u5355\u54c1\u7684\u7ef4\u5ea6\u4fe1\u606f\u5165\u53c2=" + querySkuListByCommodityIdReqBO.toString());
        RspInfoListBO result = new RspInfoListBO();
        ArrayList<QuerySkuListByCommodityIdRspBO> querySkuListByCommodityIdRspBOs = new ArrayList<QuerySkuListByCommodityIdRspBO>();
        SkuPO sku = new SkuPO();
        sku.setCommodityId(querySkuListByCommodityIdReqBO.getCommodityId());
        sku.setMaterialId(querySkuListByCommodityIdReqBO.getMaterialId());
        List<SkuPO> skus = null;
        try {
            skus = this.xlsSkuMapper.selectByCommodityId(sku.getCommodityId());
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5355\u54c1\u5217\u8868\u670d\u52a1\u62a5\u9519");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(skus)) {
            result.setRespCode("0000");
            result.setRespDesc("\u6210\u529f");
            return result;
        }
        ArrayList<SkuSpecPO> skuSpecs = new ArrayList<SkuSpecPO>();
        for (SkuPO sku1 : skus) {
            SkuSpecPO skuSpec = new SkuSpecPO();
            skuSpec.setSupplierId(sku1.getSupplierId());
            skuSpec.setSkuId(sku1.getSkuId());
            skuSpecs.add(skuSpec);
        }
        List<SkuSpecPO> skuSpecList = null;
        try {
            skuSpecList = this.skuSpecMapper.selectBySkuIdAndSupplierIds(skuSpecs);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5355\u54c1\u5217\u8868\u670d\u52a1\u62a5\u9519");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
        }
        HashMap<Long, ArrayList<SkuSpecPO>> mapListSkuSpec = new HashMap<Long, ArrayList<SkuSpecPO>>();
        if (CollectionUtils.isNotEmpty(skuSpecList)) {
            for (SkuSpecPO skuSpec : skuSpecList) {
                ArrayList<SkuSpecPO> skuSpecs1 = (ArrayList<SkuSpecPO>)mapListSkuSpec.get(skuSpec.getSkuId());
                if (CollectionUtils.isEmpty((Collection)skuSpecs1)) {
                    skuSpecs1 = new ArrayList<SkuSpecPO>();
                    skuSpecs1.add(skuSpec);
                    mapListSkuSpec.put(skuSpec.getSkuId(), skuSpecs1);
                    continue;
                }
                skuSpecs1.add(skuSpec);
            }
        }
        logger.debug("mapListSkuSpec=" + ((Object)mapListSkuSpec).toString());
        for (SkuPO sku1 : skus) {
            QuerySkuListByCommodityIdRspBO querySkuListByCommodityIdRspBO = new QuerySkuListByCommodityIdRspBO();
            BeanUtils.copyProperties((Object)sku1, (Object)querySkuListByCommodityIdRspBO);
            if (null != sku1.getSkuPrice()) {
                String skuPrice = sku1.getSkuPrice() + "";
                BigDecimal price = new BigDecimal(skuPrice);
                querySkuListByCommodityIdRspBO.setPrice(price.divide(new BigDecimal("10000")).toString());
            }
            List skuSpecs1 = (List)mapListSkuSpec.get(sku1.getSkuId());
            String dimension = "";
            if (CollectionUtils.isNotEmpty((Collection)skuSpecs1)) {
                for (SkuSpecPO skuSpec1 : skuSpecs1) {
                    if (skuSpec1.getCommodityPropGrpId() == 900991231L) {
                        querySkuListByCommodityIdRspBO.setPp(skuSpec1.getPropValue());
                        continue;
                    }
                    if (skuSpec1.getCommodityPropGrpId() == 900991232L) {
                        querySkuListByCommodityIdRspBO.setXh(skuSpec1.getPropValue());
                        continue;
                    }
                    if (skuSpec1.getCommodityPropGrpId() == 900991233L) {
                        querySkuListByCommodityIdRspBO.setYs(skuSpec1.getPropValue());
                        continue;
                    }
                    if (skuSpec1.getCommodityPropGrpId() == 900991234L) {
                        querySkuListByCommodityIdRspBO.setNc(skuSpec1.getPropValue());
                        continue;
                    }
                    dimension = dimension + skuSpec1.getPropValue() + "+";
                }
                if (StringUtils.isNotEmpty((String)dimension)) {
                    dimension = dimension.substring(0, dimension.length() - 1);
                }
                querySkuListByCommodityIdRspBO.setDimension(dimension);
            }
            querySkuListByCommodityIdRspBOs.add(querySkuListByCommodityIdRspBO);
        }
        result.setRows(querySkuListByCommodityIdRspBOs);
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }
}

