/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.DSkuSpecBO;
import com.tydic.newretail.bo.QuerySkuListByMaterialsAndShopIdReqBO;
import com.tydic.newretail.bo.QuerySkuListByMaterialsAndShopIdResBO;
import com.tydic.newretail.bo.QuerySkuListByMaterialsResBO;
import com.tydic.newretail.bo.SkuAndPriceAndSpecBO;
import com.tydic.newretail.bo.SkuAndPriceBO;
import com.tydic.newretail.busi.service.QuerySkuListByMaterialsAndShopIdService;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.SkuSpecDAO;
import com.tydic.newretail.dao.po.SkuAndPricePO;
import com.tydic.newretail.dao.po.SkuSpecPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuerySkuListByMaterialsAndShopIdServiceImpl
implements QuerySkuListByMaterialsAndShopIdService {
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuListByMaterialsAndShopIdServiceImpl.class);
    @Autowired
    private SkuDAO skuDAO;
    @Autowired
    private SkuSpecDAO skuSpecDAO;

    public QuerySkuListByMaterialsResBO querySkuListByMaterials(QuerySkuListByMaterialsAndShopIdReqBO reqBO) {
        QuerySkuListByMaterialsResBO result = new QuerySkuListByMaterialsResBO();
        ArrayList<SkuAndPriceAndSpecBO> rows = new ArrayList<SkuAndPriceAndSpecBO>();
        logger.debug("\u901a\u8fc7\u7269\u6599\u7f16\u7801\u5217\u8868\u67e5\u8be2\u5546\u54c1\u53ca\u89c4\u683c");
        if (CollectionUtils.isEmpty((Collection)reqBO.getMaterialIds())) {
            result.setRespCode("9999");
            result.setRespDesc("\u5165\u53c2\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            result.setRows(rows);
            return result;
        }
        logger.debug("\u67e5\u8be2sku");
        try {
            List<SkuAndPricePO> skus = this.skuDAO.querySkuByMaterialIds(reqBO.getMaterialIds());
            if (!CollectionUtils.isEmpty(skus)) {
                ArrayList<Long> skuIds = new ArrayList<Long>();
                for (SkuAndPricePO po : skus) {
                    skuIds.add(po.getSkuId());
                }
                List<SkuSpecPO> spec = this.skuSpecDAO.selectSpecBySkuIds(skuIds);
                HashMap specMap = new HashMap();
                if (!CollectionUtils.isEmpty(spec)) {
                    for (SkuSpecPO sp : spec) {
                        if (specMap.containsKey(sp.getSkuId())) {
                            ((List)specMap.get(sp.getSkuId())).add(sp);
                            continue;
                        }
                        ArrayList<SkuSpecPO> a = new ArrayList<SkuSpecPO>();
                        a.add(sp);
                        specMap.put(sp.getSkuId(), a);
                    }
                }
                SkuAndPriceAndSpecBO bo = null;
                for (SkuAndPricePO po : skus) {
                    bo = new SkuAndPriceAndSpecBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    if (!specMap.isEmpty()) {
                        List spe = (List)specMap.get(po.getSkuId());
                        for (SkuSpecPO s : spe) {
                            if (s.getCommodityPropGrpId() == 900991231L) {
                                bo.setBrand(s.getPropValue());
                            }
                            if (s.getCommodityPropGrpId() == 900991232L) {
                                bo.setXh(s.getPropValue());
                            }
                            if (s.getCommodityPropGrpId() == 900991233L) {
                                bo.setColor(s.getPropValue());
                            }
                            if (s.getCommodityPropGrpId() != 900991234L) continue;
                            bo.setNc(s.getPropValue());
                        }
                    }
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2sku\u5217\u8868\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2sku\u5217\u8868\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public QuerySkuListByMaterialsAndShopIdResBO querySkuListByMaterialsAndShopId(QuerySkuListByMaterialsAndShopIdReqBO reqBO) {
        QuerySkuListByMaterialsAndShopIdResBO result = new QuerySkuListByMaterialsAndShopIdResBO();
        ArrayList<SkuAndPriceBO> rows = new ArrayList<SkuAndPriceBO>();
        logger.debug("\u8c03\u7528\u901a\u8fc7\u7269\u6599\u7f16\u7801\u5217\u8868\u67e5\u8be2sku\u670d\u52a1");
        if (CollectionUtils.isEmpty((Collection)reqBO.getMaterialIds())) {
            result.setRespCode("9999");
            result.setRespDesc("\u5165\u53c2\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            result.setRows(rows);
            return result;
        }
        if (reqBO.getSupplierId() == null) {
            result.setRespCode("9999");
            result.setRespDesc("\u5165\u53c2\u95e8\u5e97Id\u4e3a\u7a7a");
            result.setRows(rows);
            return result;
        }
        logger.debug("\u67e5\u8be2sku");
        try {
            ArrayList<Long> skuId = new ArrayList<Long>();
            List<SkuAndPricePO> skus = this.skuDAO.querySkuByMaterialIdsAndShop(reqBO.getSupplierId(), reqBO.getMaterialIds());
            HashMap dimidionMap = new HashMap();
            if (!CollectionUtils.isEmpty(skus)) {
                for (SkuAndPricePO skuAndPricePO : skus) {
                    skuId.add(skuAndPricePO.getSkuId());
                }
                List<SkuSpecPO> spec = this.skuSpecDAO.selectDimision(skuId);
                if (!CollectionUtils.isEmpty(spec)) {
                    for (SkuSpecPO sp : spec) {
                        if (dimidionMap.containsKey(sp.getSkuId())) {
                            DSkuSpecBO bo = new DSkuSpecBO();
                            BeanUtils.copyProperties((Object)sp, (Object)bo);
                            ((List)dimidionMap.get(sp.getSkuId())).add(bo);
                            continue;
                        }
                        ArrayList<DSkuSpecBO> list = new ArrayList<DSkuSpecBO>();
                        DSkuSpecBO bo = new DSkuSpecBO();
                        BeanUtils.copyProperties((Object)sp, (Object)bo);
                        list.add(bo);
                        dimidionMap.put(sp.getSkuId(), list);
                    }
                }
                Object var8_12 = null;
                for (SkuAndPricePO po : skus) {
                    skuId.add(po.getSkuId());
                    SkuAndPriceBO skuAndPriceBO = new SkuAndPriceBO();
                    BeanUtils.copyProperties((Object)po, (Object)skuAndPriceBO);
                    skuAndPriceBO.setSpec((List)dimidionMap.get(po.getSkuId()));
                    rows.add(skuAndPriceBO);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2sku\u5217\u8868\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2sku\u5217\u8868\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }
}

