/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.bo.QuerySkuDetailRspBO;
import com.tydic.newretail.bo.QuerySkuDetailRspListBO;
import com.tydic.newretail.bo.QuerySkuListForBackgroundReqBO;
import com.tydic.newretail.bo.RspPageBO;
import com.tydic.newretail.bo.SkuPriceRspBO;
import com.tydic.newretail.bo.SkuSpecBO;
import com.tydic.newretail.busi.service.QuerySkuListForBackgroundService;
import com.tydic.newretail.busi.service.SysParamTransferBusiService;
import com.tydic.newretail.dao.CommodityTypeDAO;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.SkuPriceDAO;
import com.tydic.newretail.dao.SkuSpecDAO;
import com.tydic.newretail.dao.po.CommodityTypePO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.dao.po.SkuPricePO;
import com.tydic.newretail.dao.po.SkuSpecPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.util.MoneyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuerySkuListForBackgroundServiceImpl
implements QuerySkuListForBackgroundService {
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuListForBackgroundServiceImpl.class);
    @Autowired
    private SkuDAO skuDAO;
    @Autowired
    private SysParamTransferBusiService sysParamTransferBusiService;
    @Autowired
    private CommodityTypeDAO commodityTypeDAO;
    @Autowired
    private SkuPriceDAO skuPriceDAO;
    @Autowired
    private SkuSpecDAO skuSpecDAO;

    public RspPageBO<QuerySkuDetailRspBO> querySkuListForBackground(QuerySkuListForBackgroundReqBO querySkuListForBackgroundReqBO) {
        logger.info("QuerySkuListForBackgroundService\u5165\u53c2\uff1a" + querySkuListForBackgroundReqBO.toString());
        RspPageBO result = new RspPageBO();
        try {
            Page page = new Page();
            page.setPageSize(querySkuListForBackgroundReqBO.getPageSize());
            page.setPageNo(querySkuListForBackgroundReqBO.getCurrent());
            SkuPO skuPO = new SkuPO();
            if (null != querySkuListForBackgroundReqBO.getSupplierId()) {
                skuPO.setSupplierId(querySkuListForBackgroundReqBO.getSupplierId());
            }
            if (null != querySkuListForBackgroundReqBO.getMaterialId()) {
                skuPO.setMaterialId(querySkuListForBackgroundReqBO.getMaterialId());
            }
            if (null != querySkuListForBackgroundReqBO.getExtSkuId()) {
                skuPO.setExtSkuId(querySkuListForBackgroundReqBO.getExtSkuId());
            }
            if (null != querySkuListForBackgroundReqBO.getSkuStatus()) {
                skuPO.setSkuStatus(querySkuListForBackgroundReqBO.getSkuStatus());
            }
            if (null != querySkuListForBackgroundReqBO.getBrandName()) {
                skuPO.setBrandName(querySkuListForBackgroundReqBO.getBrandName());
            }
            if (null != querySkuListForBackgroundReqBO.getCommodityTypeId()) {
                skuPO.setCommodityTypeId(querySkuListForBackgroundReqBO.getCommodityTypeId());
            }
            if (null != querySkuListForBackgroundReqBO.getSkuName()) {
                skuPO.setSkuName(querySkuListForBackgroundReqBO.getSkuName());
            }
            if (StringUtils.isNotEmpty((CharSequence)querySkuListForBackgroundReqBO.getHasInteractive())) {
                skuPO.setHasInteractiveStr(querySkuListForBackgroundReqBO.getHasInteractive());
                skuPO.setHasInteractive(Integer.valueOf(querySkuListForBackgroundReqBO.getHasInteractive()));
            }
            if (StringUtils.isNotEmpty((CharSequence)querySkuListForBackgroundReqBO.getHasWisdom())) {
                skuPO.setHasWisdomStr(querySkuListForBackgroundReqBO.getHasWisdom());
                skuPO.setHasWisdom(Integer.valueOf(querySkuListForBackgroundReqBO.getHasWisdom()));
            }
            if (null != querySkuListForBackgroundReqBO.getMfgSku()) {
                skuPO.setMfgSku(querySkuListForBackgroundReqBO.getMfgSku());
            }
            if (CollectionUtils.isNotEmpty((Collection)querySkuListForBackgroundReqBO.getSkuIds())) {
                skuPO.setSkuIds(querySkuListForBackgroundReqBO.getSkuIds());
            }
            if (CollectionUtils.isNotEmpty((Collection)querySkuListForBackgroundReqBO.getSupplierIds())) {
                skuPO.setSupplierIds(querySkuListForBackgroundReqBO.getSupplierIds());
            }
            logger.info("po\u5165\u53c2\uff1a" + skuPO.toString());
            List<SkuPO> skus = this.skuDAO.selectSkuListProvList(skuPO, (Page<SkuPO>)page);
            ArrayList<QuerySkuDetailRspBO> listSkuDedail = new ArrayList<QuerySkuDetailRspBO>();
            ArrayList<Long> skuIds = new ArrayList<Long>();
            ArrayList<Long> commodityTypeIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(skus)) {
                for (SkuPO sku : skus) {
                    skuIds.add(sku.getSkuId());
                    if (sku.getCommodityTypeId() != null) {
                        commodityTypeIds.add(sku.getCommodityTypeId());
                    }
                    QuerySkuDetailRspBO querySkuDetailRspBO = new QuerySkuDetailRspBO();
                    BeanUtils.copyProperties((Object)sku, (Object)querySkuDetailRspBO);
                    listSkuDedail.add(querySkuDetailRspBO);
                }
            }
            Map<String, String> statusMap = this.selectSkuStatusStr();
            Map<Long, CommodityTypePO> mapCommodityTypePO = this.selectCommodityTypeId(commodityTypeIds);
            Map<Long, SkuPriceRspBO> mapSkuPriceRspBO = this.selectSkuPrice(skuIds);
            if (CollectionUtils.isNotEmpty(listSkuDedail)) {
                for (QuerySkuDetailRspBO querySkuDetailRspBO : listSkuDedail) {
                    CommodityTypePO CommodityTypePO2;
                    if (null != querySkuDetailRspBO.getSkuStatus() && MapUtils.isNotEmpty(statusMap)) {
                        querySkuDetailRspBO.setSkuStatusStr(statusMap.get(String.valueOf(querySkuDetailRspBO.getSkuStatus())));
                    }
                    if (querySkuDetailRspBO.getCommodityTypeId() != null && MapUtils.isNotEmpty(mapCommodityTypePO) && (CommodityTypePO2 = mapCommodityTypePO.get(querySkuDetailRspBO.getCommodityTypeId())) != null) {
                        querySkuDetailRspBO.setCommodityTypeName(CommodityTypePO2.getCommodityTypeName());
                    }
                    if (!MapUtils.isNotEmpty(mapSkuPriceRspBO)) continue;
                    querySkuDetailRspBO.setPrice(mapSkuPriceRspBO.get(querySkuDetailRspBO.getSkuId()));
                }
            }
            result.setRespCode("0000");
            result.setRespDesc("\u6210\u529f");
            result.setRows(listSkuDedail);
            result.setTotal(page.getTotalPages());
            result.setRecordsTotal(page.getTotalCount());
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u670d\u52a1\u9519\u8bef" + e);
            result.setRespCode("8888");
            result.setRespDesc("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u5217\u8868\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
        }
        return result;
    }

    public QuerySkuDetailRspListBO querySkuListForNoPageBackground(QuerySkuListForBackgroundReqBO querySkuListForBackgroundReqBO) {
        logger.info("QuerySkuListForBackgroundService\u5165\u53c2\uff1a" + querySkuListForBackgroundReqBO.toString());
        QuerySkuDetailRspListBO result = new QuerySkuDetailRspListBO();
        try {
            SkuPO skuPO = new SkuPO();
            if (null != querySkuListForBackgroundReqBO.getSupplierId()) {
                skuPO.setSupplierId(querySkuListForBackgroundReqBO.getSupplierId());
            }
            if (null != querySkuListForBackgroundReqBO.getMaterialId()) {
                skuPO.setMaterialId(querySkuListForBackgroundReqBO.getMaterialId());
            }
            if (null != querySkuListForBackgroundReqBO.getExtSkuId()) {
                skuPO.setExtSkuId(querySkuListForBackgroundReqBO.getExtSkuId());
            }
            if (null != querySkuListForBackgroundReqBO.getSkuStatus()) {
                skuPO.setSkuStatus(querySkuListForBackgroundReqBO.getSkuStatus());
            }
            if (null != querySkuListForBackgroundReqBO.getBrandName()) {
                skuPO.setBrandName(querySkuListForBackgroundReqBO.getBrandName());
            }
            if (null != querySkuListForBackgroundReqBO.getCommodityTypeId()) {
                skuPO.setCommodityTypeId(querySkuListForBackgroundReqBO.getCommodityTypeId());
            }
            if (null != querySkuListForBackgroundReqBO.getSkuName()) {
                skuPO.setSkuName(querySkuListForBackgroundReqBO.getSkuName());
            }
            if (StringUtils.isNotEmpty((CharSequence)querySkuListForBackgroundReqBO.getHasInteractive())) {
                skuPO.setHasInteractiveStr(querySkuListForBackgroundReqBO.getHasInteractive());
                skuPO.setHasInteractive(Integer.valueOf(querySkuListForBackgroundReqBO.getHasInteractive()));
            }
            if (StringUtils.isNotEmpty((CharSequence)querySkuListForBackgroundReqBO.getHasWisdom())) {
                skuPO.setHasWisdomStr(querySkuListForBackgroundReqBO.getHasWisdom());
                skuPO.setHasWisdom(Integer.valueOf(querySkuListForBackgroundReqBO.getHasWisdom()));
            }
            if (null != querySkuListForBackgroundReqBO.getMfgSku()) {
                skuPO.setMfgSku(querySkuListForBackgroundReqBO.getMfgSku());
            }
            if (CollectionUtils.isNotEmpty((Collection)querySkuListForBackgroundReqBO.getSkuIds())) {
                skuPO.setSkuIds(querySkuListForBackgroundReqBO.getSkuIds());
            }
            if (CollectionUtils.isNotEmpty((Collection)querySkuListForBackgroundReqBO.getSupplierIds())) {
                skuPO.setSupplierIds(querySkuListForBackgroundReqBO.getSupplierIds());
            }
            if (CollectionUtils.isNotEmpty((Collection)querySkuListForBackgroundReqBO.getMaterialIds())) {
                skuPO.setMaterialIds(querySkuListForBackgroundReqBO.getMaterialIds());
            }
            logger.info("po\u5165\u53c2\uff1a" + skuPO.toString());
            List<SkuPO> skus = this.skuDAO.selectSkuListForBackground(skuPO);
            ArrayList<QuerySkuDetailRspBO> listSkuDedail = new ArrayList<QuerySkuDetailRspBO>();
            ArrayList<Long> skuIds = new ArrayList<Long>();
            ArrayList<Long> commodityTypeIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(skus)) {
                for (SkuPO sku : skus) {
                    skuIds.add(sku.getSkuId());
                    if (sku.getCommodityTypeId() != null) {
                        commodityTypeIds.add(sku.getCommodityTypeId());
                    }
                    QuerySkuDetailRspBO querySkuDetailRspBO = new QuerySkuDetailRspBO();
                    BeanUtils.copyProperties((Object)sku, (Object)querySkuDetailRspBO);
                    listSkuDedail.add(querySkuDetailRspBO);
                }
            }
            Map<String, String> statusMap = this.selectSkuStatusStr();
            Map<Long, CommodityTypePO> mapCommodityTypePO = this.selectCommodityTypeId(commodityTypeIds);
            Map<Long, SkuPriceRspBO> mapSkuPriceRspBO = this.selectSkuPrice(skuIds);
            Map<Long, List<SkuSpecBO>> mapListSkuSpec = this.selectSkuSpecs(skuIds);
            if (CollectionUtils.isNotEmpty(listSkuDedail)) {
                for (QuerySkuDetailRspBO querySkuDetailRspBO : listSkuDedail) {
                    CommodityTypePO CommodityTypePO2;
                    if (null != querySkuDetailRspBO.getSkuStatus() && MapUtils.isNotEmpty(statusMap)) {
                        querySkuDetailRspBO.setSkuStatusStr(statusMap.get(String.valueOf(querySkuDetailRspBO.getSkuStatus())));
                    }
                    if (querySkuDetailRspBO.getCommodityTypeId() != null && MapUtils.isNotEmpty(mapCommodityTypePO) && (CommodityTypePO2 = mapCommodityTypePO.get(querySkuDetailRspBO.getCommodityTypeId())) != null) {
                        querySkuDetailRspBO.setCommodityTypeName(CommodityTypePO2.getCommodityTypeName());
                    }
                    if (MapUtils.isNotEmpty(mapSkuPriceRspBO)) {
                        querySkuDetailRspBO.setPrice(mapSkuPriceRspBO.get(querySkuDetailRspBO.getSkuId()));
                    }
                    if (!MapUtils.isNotEmpty(mapListSkuSpec)) continue;
                    List<SkuSpecBO> skuSpecs1 = mapListSkuSpec.get(querySkuDetailRspBO.getSkuId());
                    querySkuDetailRspBO.setSpecs(skuSpecs1);
                }
            }
            result.setRespCode("0000");
            result.setRespDesc("\u6210\u529f");
            result.setRows(listSkuDedail);
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u670d\u52a1\u9519\u8bef" + e);
            result.setRespCode("8888");
            result.setRespDesc("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u5217\u8868\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
        }
        return result;
    }

    Map<String, String> selectSkuStatusStr() {
        Map statusMap = this.sysParamTransferBusiService.sysParamTransferByParentCode("SYS_SKU_STSTUS");
        return statusMap;
    }

    Map<Long, CommodityTypePO> selectCommodityTypeId(List<Long> commodityTypeIds) {
        List<CommodityTypePO> commodityTypePOs;
        HashMap<Long, CommodityTypePO> mapCommodityTypePO = new HashMap<Long, CommodityTypePO>();
        if (CollectionUtils.isNotEmpty(commodityTypeIds) && CollectionUtils.isNotEmpty(commodityTypePOs = this.commodityTypeDAO.selectByCommodityTypeIds(commodityTypeIds))) {
            for (CommodityTypePO commodityTypePO : commodityTypePOs) {
                mapCommodityTypePO.put(commodityTypePO.getCommodityTypeId(), commodityTypePO);
            }
        }
        return mapCommodityTypePO;
    }

    Map<Long, SkuPriceRspBO> selectSkuPrice(List<Long> skuIds) {
        List<SkuPricePO> skuPrices;
        HashMap<Long, SkuPriceRspBO> mapSkuPriceRspBO = new HashMap<Long, SkuPriceRspBO>();
        if (CollectionUtils.isNotEmpty(skuIds) && CollectionUtils.isNotEmpty(skuPrices = this.skuPriceDAO.selectBySkuIds(skuIds))) {
            for (SkuPricePO skuPrice : skuPrices) {
                SkuPriceRspBO skuPriceRspBO = this.price2skuPriceBO(skuPrice);
                mapSkuPriceRspBO.put(skuPrice.getSkuId(), skuPriceRspBO);
            }
        }
        return mapSkuPriceRspBO;
    }

    Map<Long, List<SkuSpecBO>> selectSkuSpecs(List<Long> skuIds) {
        List<SkuSpecPO> skuSpecs;
        HashMap<Long, List<SkuSpecBO>> mapListSkuSpec = new HashMap<Long, List<SkuSpecBO>>();
        if (CollectionUtils.isNotEmpty(skuIds) && CollectionUtils.isNotEmpty(skuSpecs = this.skuSpecDAO.selectSpecBySkuIds(skuIds))) {
            for (SkuSpecPO skuSpec : skuSpecs) {
                SkuSpecBO skuSpecBO = new SkuSpecBO();
                BeanUtils.copyProperties((Object)skuSpec, (Object)skuSpecBO);
                ArrayList<SkuSpecBO> skuSpecs1 = (ArrayList<SkuSpecBO>)mapListSkuSpec.get(skuSpec.getSkuId());
                if (CollectionUtils.isNotEmpty((Collection)skuSpecs1)) {
                    skuSpecs1.add(skuSpecBO);
                    continue;
                }
                skuSpecs1 = new ArrayList<SkuSpecBO>();
                skuSpecs1.add(skuSpecBO);
                mapListSkuSpec.put(skuSpec.getSkuId(), skuSpecs1);
            }
        }
        return mapListSkuSpec;
    }

    SkuPriceRspBO price2skuPriceBO(SkuPricePO price) {
        SkuPriceRspBO skuPriceRspBO = new SkuPriceRspBO();
        BeanUtils.copyProperties((Object)price, (Object)skuPriceRspBO);
        try {
            if (price.getMarketPrice() != null) {
                skuPriceRspBO.setMarketPrice(MoneyUtils.Long2BigDecimal(price.getMarketPrice()));
            }
            if (price.getAgreementPrice() != null) {
                skuPriceRspBO.setAgreementPrice(MoneyUtils.Long2BigDecimal(price.getAgreementPrice()));
            }
            if (price.getMemberPrice() != null) {
                skuPriceRspBO.setMemberPrice(MoneyUtils.Long2BigDecimal(price.getMemberPrice()));
            }
            if (price.getSalePrice() != null) {
                skuPriceRspBO.setSalePriceL(price.getSalePrice());
                skuPriceRspBO.setSalePrice(MoneyUtils.Long2BigDecimal(price.getSalePrice()));
            }
            if (price.getSparePrice1() != null) {
                skuPriceRspBO.setSparePrice1(MoneyUtils.Long2BigDecimal(price.getSparePrice1()));
            }
            if (price.getSparePrice2() != null) {
                skuPriceRspBO.setSparePrice2(MoneyUtils.Long2BigDecimal(price.getSparePrice2()));
            }
            if (price.getAssessmentPrice() != null) {
                skuPriceRspBO.setAssessmentPrice(MoneyUtils.Long2BigDecimal(price.getAssessmentPrice()));
            }
            if (price.getPurchasePrice() != null) {
                skuPriceRspBO.setPurchasePriceL(price.getPurchasePrice());
                skuPriceRspBO.setPurchasePrice(MoneyUtils.Long2BigDecimal(price.getPurchasePrice()));
            }
            if (price.getMemberLadderPrice1() != null) {
                skuPriceRspBO.setMemberLadderPrice1(MoneyUtils.Long2BigDecimal(price.getMemberLadderPrice1()));
            }
            if (price.getMemberLadderPrice2() != null) {
                skuPriceRspBO.setMemberLadderPrice2(MoneyUtils.Long2BigDecimal(price.getMemberLadderPrice2()));
            }
            if (price.getMemberLadderPrice3() != null) {
                skuPriceRspBO.setMemberLadderPrice3(MoneyUtils.Long2BigDecimal(price.getMemberLadderPrice3()));
            }
            if (price.getMemberLadderPrice4() != null) {
                skuPriceRspBO.setMemberLadderPrice4(MoneyUtils.Long2BigDecimal(price.getMemberLadderPrice4()));
            }
            if (price.getMemberLadderPrice5() != null) {
                skuPriceRspBO.setMemberLadderPrice5(MoneyUtils.Long2BigDecimal(price.getMemberLadderPrice5()));
            }
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
        }
        return skuPriceRspBO;
    }
}

