/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.bo.BatchQuerySkuPriceReqBO;
import com.tydic.newretail.bo.BatchQuerySkuPriceRspBO;
import com.tydic.newretail.bo.QueryAllPicByDeviceIdRspBO;
import com.tydic.newretail.bo.QueryCommodityTypeRspBO;
import com.tydic.newretail.bo.QueryListCommodityTypeReqBO;
import com.tydic.newretail.bo.QueryListCommodityTypeRspBO;
import com.tydic.newretail.bo.QuerySkuDetailBO;
import com.tydic.newretail.bo.QuerySkuDetailReqBO;
import com.tydic.newretail.bo.QuerySkuListForBindReqBO;
import com.tydic.newretail.bo.QuerySkuListForBindRspBO;
import com.tydic.newretail.bo.QuerySkuSpecReqBO;
import com.tydic.newretail.bo.QuerySkuSpecRspBO;
import com.tydic.newretail.bo.SelectXlsCommodityDetailBO;
import com.tydic.newretail.bo.SelectXlsCommodityDetailForUpBO;
import com.tydic.newretail.bo.SkuFodderPicBO;
import com.tydic.newretail.bo.SkuPriceRspBO;
import com.tydic.newretail.bo.SkuSpecBO;
import com.tydic.newretail.busi.service.BatchQuerySkuPriceBusiService;
import com.tydic.newretail.busi.service.QueryAllPicByFodderIdService;
import com.tydic.newretail.busi.service.QueryCommodityTypeService;
import com.tydic.newretail.busi.service.QuerySkuListForBindService;
import com.tydic.newretail.busi.service.QuerySkuSpecBusiService;
import com.tydic.newretail.busi.service.SelectXlsCommodityDetailService;
import com.tydic.newretail.busi.service.SysParamTransferBusiService;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.SkuFodderRelationDAO;
import com.tydic.newretail.dao.po.SkuFodderRelationPO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuerySkuListForBindServiceImpl
implements QuerySkuListForBindService {
    @Autowired
    private SkuDAO xlsSkuMapper;
    @Autowired
    private SysParamTransferBusiService sysParamTransferBusiService;
    @Autowired
    private QueryCommodityTypeService queryCommodityTypeService;
    @Autowired
    private BatchQuerySkuPriceBusiService batchQuerySkuPriceBusiService;
    @Autowired
    private QuerySkuSpecBusiService querySkuSpecBusiService;
    @Autowired
    private SelectXlsCommodityDetailService selectXlsCommodityDetailService;
    @Autowired
    private SkuFodderRelationDAO skuFodderRelationDAO;
    @Autowired
    private QueryAllPicByFodderIdService queryAllPicByDeviceIdService;
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuListForBindServiceImpl.class);

    public RspPageBaseBO<QuerySkuListForBindRspBO> querySkuListForBind(QuerySkuListForBindReqBO querySkuListForBindReqBO) {
        logger.info("\u67e5\u8be2\u5546\u54c1\u5217\u8868\u4e3a\u4e86\u7ed1\u5b9a\u5165\u53c2=" + querySkuListForBindReqBO.toString());
        RspPageBaseBO result = new RspPageBaseBO();
        Page page = new Page();
        page.setLimit(querySkuListForBindReqBO.getPageSize());
        page.setOffset(querySkuListForBindReqBO.getOffset());
        SkuPO skuPO = new SkuPO();
        if (null != querySkuListForBindReqBO.getSupplierId()) {
            skuPO.setSupplierId(querySkuListForBindReqBO.getSupplierId());
        }
        if (null != querySkuListForBindReqBO.getMaterialId()) {
            skuPO.setMaterialId(querySkuListForBindReqBO.getMaterialId());
        }
        if (null != querySkuListForBindReqBO.getExtSkuId()) {
            skuPO.setExtSkuId(querySkuListForBindReqBO.getExtSkuId());
        }
        if (null != querySkuListForBindReqBO.getBrandName()) {
            skuPO.setBrandName(querySkuListForBindReqBO.getBrandName());
        }
        if (null != querySkuListForBindReqBO.getSkuName()) {
            skuPO.setSkuName(querySkuListForBindReqBO.getSkuName());
        }
        skuPO.setIsBindCommodity(querySkuListForBindReqBO.getIsBindCommodity());
        if (CollectionUtils.isNotEmpty((Collection)querySkuListForBindReqBO.getSupplierIds())) {
            skuPO.setSupplierIds(querySkuListForBindReqBO.getSupplierIds());
        }
        skuPO.setProvinceCode(querySkuListForBindReqBO.getProvinceCode());
        skuPO.setProvGoodsId(querySkuListForBindReqBO.getProvGoodsId());
        skuPO.setCityCode(querySkuListForBindReqBO.getCityCode());
        skuPO.setGoodsSource(querySkuListForBindReqBO.getGoodsSource());
        skuPO.setCountyCode(querySkuListForBindReqBO.getCountyCode());
        List<SkuPO> skus = this.xlsSkuMapper.selectSkuListForBackground(skuPO, (Page<SkuPO>)page);
        Map statusMap = this.sysParamTransferBusiService.sysParamTransferByParentCode("SYS_SKU_STSTUS");
        ArrayList<QuerySkuListForBindRspBO> querySkuListForBindRspBOs = new ArrayList<QuerySkuListForBindRspBO>();
        if (CollectionUtils.isNotEmpty(skus)) {
            for (SkuPO sku : skus) {
                QuerySkuListForBindRspBO querySkuListForBindRspBO = new QuerySkuListForBindRspBO();
                BeanUtils.copyProperties((Object)sku, (Object)querySkuListForBindRspBO);
                if (null != sku.getSkuStatus()) {
                    logger.info("\u72b6\u6001map:" + statusMap);
                    if (MapUtils.isNotEmpty((Map)statusMap)) {
                        querySkuListForBindRspBO.setSkuStatusStr((String)statusMap.get(String.valueOf(sku.getSkuStatus())));
                    }
                }
                QueryListCommodityTypeReqBO queryListCommodityTypeReqBO = new QueryListCommodityTypeReqBO();
                queryListCommodityTypeReqBO.setCommodityTypeId(sku.getCommodityTypeId());
                try {
                    QueryListCommodityTypeRspBO QueryListCommodityTypeRspBO2 = this.queryCommodityTypeService.queryCommodityType(queryListCommodityTypeReqBO);
                    if (QueryListCommodityTypeRspBO2.getQueryCommodityTypeRspBOs().size() != 0) {
                        logger.info("\u67e5\u8be2\u7684\u5546\u54c1\u7c7b\u578b\u5bf9\u8c61\u4e0d\u4e3a\u7a7a");
                        querySkuListForBindRspBO.setCommodityTypeName(((QueryCommodityTypeRspBO)QueryListCommodityTypeRspBO2.getQueryCommodityTypeRspBOs().get(0)).getCommodityTypeName());
                    }
                }
                catch (Exception e) {
                    logger.error("\u6839\u636e\u7c7b\u578bId\u67e5\u8be2\u7c7b\u578b\u670d\u52a1\u62a5\u9519");
                    throw new BusinessException("9999", "\u6839\u636e\u7c7b\u578bId\u67e5\u8be2\u7c7b\u578b\u670d\u52a1\u62a5\u9519" + e.getMessage());
                }
                BatchQuerySkuPriceReqBO batchQuerySkuPriceReqBO = new BatchQuerySkuPriceReqBO();
                batchQuerySkuPriceReqBO.setSkuIds(Arrays.asList(sku.getSkuId()));
                batchQuerySkuPriceReqBO.setSupplierId(sku.getSupplierId());
                try {
                    BatchQuerySkuPriceRspBO batchQuerySkuPriceRspBO = this.batchQuerySkuPriceBusiService.batchQuerySkuPrice(batchQuerySkuPriceReqBO);
                    if (batchQuerySkuPriceRspBO.getPrices().size() > 0) {
                        querySkuListForBindRspBO.setPrice((SkuPriceRspBO)batchQuerySkuPriceRspBO.getPrices().get(0));
                    }
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u4ef7\u683c\u670d\u52a1\u62a5\u9519");
                    throw new BusinessException("9999", "\u67e5\u8be2\u4ef7\u683c\u670d\u52a1\u62a5\u9519" + e.getMessage());
                }
                QuerySkuSpecReqBO querySkuSpecReqBO = new QuerySkuSpecReqBO();
                querySkuSpecReqBO.setSkuId(sku.getSkuId());
                querySkuSpecReqBO.setSupplierId(sku.getSupplierId());
                try {
                    QuerySkuSpecRspBO querySkuSpecRspBO = this.querySkuSpecBusiService.querySkuSpec(querySkuSpecReqBO);
                    List specs = querySkuSpecRspBO.getSpecs();
                    ArrayList<SkuSpecBO> specs1 = new ArrayList<SkuSpecBO>();
                    if (CollectionUtils.isNotEmpty((Collection)specs)) {
                        for (SkuSpecBO skuSpecBO : specs) {
                            if (skuSpecBO.getCommodityPropGrpId() == 900991231L) {
                                querySkuListForBindRspBO.setPp(skuSpecBO.getPropValue());
                                continue;
                            }
                            if (skuSpecBO.getCommodityPropGrpId() == 900991232L) {
                                querySkuListForBindRspBO.setXh(skuSpecBO.getPropValue());
                                continue;
                            }
                            if (skuSpecBO.getCommodityPropGrpId() == 900991233L) {
                                querySkuListForBindRspBO.setYs(skuSpecBO.getPropValue());
                                continue;
                            }
                            if (skuSpecBO.getCommodityPropGrpId() == 900991234L) {
                                querySkuListForBindRspBO.setNc(skuSpecBO.getPropValue());
                                continue;
                            }
                            specs1.add(skuSpecBO);
                        }
                    }
                    querySkuListForBindRspBO.setSpecs(specs1);
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u5355\u54c1\u89c4\u683c\u670d\u52a1\u62a5\u9519");
                    throw new BusinessException("9999", "\u67e5\u8be2\u5355\u54c1\u89c4\u683c\u670d\u52a1\u62a5\u9519" + e.getMessage());
                }
                querySkuListForBindRspBOs.add(querySkuListForBindRspBO);
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(querySkuListForBindRspBOs);
        result.setTotal(page.getTotalPages());
        result.setRecordsTotal(page.getTotalCount());
        return result;
    }

    public QuerySkuDetailBO querySkuDetail(QuerySkuDetailReqBO querySkuDetailReqBO) {
        QuerySkuDetailBO querySkuDetailBO = new QuerySkuDetailBO();
        logger.info("\u67e5\u8be2\u5355\u54c1\u8be6\u60c5\u670d\u52a1\u5165\u53c2=" + querySkuDetailReqBO.toString());
        if (querySkuDetailReqBO.getSkuId() == null || querySkuDetailReqBO.getSupplierId() == null) {
            querySkuDetailBO.setRespCode("7777");
            querySkuDetailBO.setRespDesc("\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a");
            return querySkuDetailBO;
        }
        SkuPO sku1 = new SkuPO();
        sku1.setSkuId(querySkuDetailReqBO.getSkuId());
        sku1.setSupplierId(querySkuDetailReqBO.getSupplierId());
        SkuPO sku = this.xlsSkuMapper.selectBySkuIdAndSupplierAndstatus(sku1);
        BeanUtils.copyProperties((Object)sku, (Object)querySkuDetailBO);
        if (null != sku.getSkuPrice()) {
            String skuPrice = sku.getSkuPrice() + "";
            BigDecimal price = new BigDecimal(skuPrice);
            querySkuDetailBO.setPrice(price.divide(new BigDecimal("10000")).toString());
        }
        SelectXlsCommodityDetailBO selectXlsCommodityDetailBO = new SelectXlsCommodityDetailBO();
        selectXlsCommodityDetailBO.setCommodityId(sku.getCommodityId());
        try {
            SelectXlsCommodityDetailForUpBO selectXlsCommodityDetailForUpBO = this.selectXlsCommodityDetailService.selectXlsCommodityDetailForUp(selectXlsCommodityDetailBO);
            querySkuDetailBO.setXlsCommodityBO(selectXlsCommodityDetailForUpBO.getCommodityBO());
            querySkuDetailBO.setRcommodityPropDefAndValueBOs(selectXlsCommodityDetailForUpBO.getRcommodityPropDefAndValueBOs());
            querySkuDetailBO.setRcommodityPropDefAndValueListBOs(selectXlsCommodityDetailForUpBO.getRcommodityPropDefAndValueListBOs());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u5546\u54c1\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        QuerySkuSpecReqBO querySkuSpecReqBO = new QuerySkuSpecReqBO();
        querySkuSpecReqBO.setSkuId(sku.getSkuId());
        querySkuSpecReqBO.setSupplierId(sku.getSupplierId());
        try {
            QuerySkuSpecRspBO querySkuSpecRspBO = this.querySkuSpecBusiService.querySkuSpec(querySkuSpecReqBO);
            List specs = querySkuSpecRspBO.getSpecs();
            ArrayList<SkuSpecBO> specs1 = new ArrayList<SkuSpecBO>();
            if (CollectionUtils.isNotEmpty((Collection)specs)) {
                for (SkuSpecBO skuSpecBO : specs) {
                    if (skuSpecBO.getCommodityPropGrpId() == 900991231L) {
                        querySkuDetailBO.setPp(skuSpecBO.getPropValue());
                        continue;
                    }
                    if (skuSpecBO.getCommodityPropGrpId() == 900991232L) {
                        querySkuDetailBO.setXh(skuSpecBO.getPropValue());
                        continue;
                    }
                    if (skuSpecBO.getCommodityPropGrpId() == 900991233L) {
                        querySkuDetailBO.setYs(skuSpecBO.getPropValue());
                        continue;
                    }
                    if (skuSpecBO.getCommodityPropGrpId() == 900991234L) {
                        querySkuDetailBO.setNc(skuSpecBO.getPropValue());
                        continue;
                    }
                    specs1.add(skuSpecBO);
                }
            }
            querySkuDetailBO.setSpecs(specs1);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5355\u54c1\u89c4\u683c\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u5355\u54c1\u89c4\u683c\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        Long fodderId = null;
        try {
            SkuFodderRelationPO skuFodderRelationPO = this.skuFodderRelationDAO.selectBySkuId(querySkuDetailReqBO.getSkuId());
            if (skuFodderRelationPO != null) {
                fodderId = skuFodderRelationPO.getFodderId();
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5355\u54c1\u7d20\u6750\u5173\u7cfb\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u5355\u54c1\u7d20\u6750\u5173\u7cfb\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        if (fodderId != null) {
            SkuFodderPicBO skuFodderPicBO = new SkuFodderPicBO();
            skuFodderPicBO.setFodderId(fodderId);
            try {
                QueryAllPicByDeviceIdRspBO queryAllPicByDeviceIdRspBO = this.queryAllPicByDeviceIdService.queryAllPicByDeviceId(skuFodderPicBO);
                querySkuDetailBO.setQueryAllPicByDeviceIdRspBO(queryAllPicByDeviceIdRspBO);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5355\u54c1\u7d20\u6750\u56fe\u7247\u670d\u52a1\u62a5\u9519");
                throw new BusinessException("9999", "\u67e5\u8be2\u5355\u54c1\u7d20\u6750\u56fe\u7247\u670d\u52a1\u62a5\u9519" + e.getMessage());
            }
        }
        querySkuDetailBO.setRespCode("0000");
        querySkuDetailBO.setRespDesc("\u6210\u529f");
        return querySkuDetailBO;
    }
}

